/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.IBgWorkTemplate;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BgNWorkPaperHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudgetBgNWorkPaperHelper");
    public static final String RESOURCE = "com.kingdee.eas.ma.nbudget.BgNWorkPaperResource";
    public static final String SINGLE_ORG_ID = "WORK_PAPER_SINGLE_ORG_ID";
    public static final String SINGLE_ORG_NUMBER = "WORK_PAPER_SINGLE_ORG_NUMBER";
    public static final String SINGLE_ORG_NAME = "WORK_PAPER_SINGLE_ORG_NAME";
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    public static final int WORK_TEMPLATE_SELECT_DEFAULT = 0;
    public static final int WORK_TEMPLATE_SELECT_MEASURE_UNIT = 1;
    public static final int WORK_TEMPLATE_SELECT_BOOK = 2;
    public static final String WORK_PAPER_ITEM_POINTS = "WORK_PAPER_ITEM_POINTS";
    public static final String WORK_PAPER_COL_POINTS = "WORK_PAPER_COL_POINTS";
    public static final String WORK_PAPER_FORMULAS = "WORK_PAPER_FORMULAS";
    public static final String WORK_PAPER_MANULELIM = "WORK_PAPER_MANULELIM";
    private static final String BGFORMULA = "bgformula";
    private static final String BGACTUALS = "bgactuals";
    private static final String BGBALANCE = "bgbal";

    public static boolean checkNumber(String number) {
        boolean isVerify = true;
        isVerify = StringUtils.isEmpty((String)number) ? false : number.matches("[^\\*\\/\\_\\|\\%]+");
        return isVerify;
    }

    public static String getWorkPaperMsg(String key) {
        if (key != null) {
            return EASResource.getString((String)RESOURCE, (String)key);
        }
        return null;
    }

    public static String getCommonMsg(String key) {
        if (key != null) {
            return EASResource.getString((String)RES_PATH, (String)key);
        }
        return null;
    }

    public static SelectorItemCollection getWorkTemplateSel(int selectType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        if ((selectType & 1) == 1) {
            sic.add("defaultMeasureUnit.id");
            sic.add("defaultMeasureUnit.number");
            sic.add("defaultMeasureUnit.name");
            sic.add("defaultMeasureUnit.coefficient");
            sic.add("bgMeasureUnit.*");
            sic.add("bgMeasureUnit.bgElement.id");
            sic.add("bgMeasureUnit.bgElement.number");
            sic.add("bgMeasureUnit.bgElement.name");
            sic.add("bgMeasureUnit.measureUnit.id");
            sic.add("bgMeasureUnit.measureUnit.number");
            sic.add("bgMeasureUnit.measureUnit.name");
            sic.add("bgMeasureUnit.measureUnit.coefficient");
        }
        if ((selectType & 2) == 2) {
            sic.add("data");
        }
        return sic;
    }

    public static BgWorkTemplateInfo getWorkTemplate(Object obj, int selectType, Context ctx) throws Exception {
        BgWorkTemplateInfo info = null;
        ObjectStringPK id = null;
        if (obj instanceof String) {
            id = new ObjectStringPK((String)obj);
        } else if (obj instanceof BgWorkTemplateInfo) {
            id = new ObjectUuidPK(((BgWorkTemplateInfo)obj).getId());
        } else if (obj instanceof BOSUuid) {
            id = new ObjectUuidPK((BOSUuid)obj);
        }
        if (id != null) {
            info = BgNWorkPaperHelper.getBgWorkTemplateInstance(ctx).getBgWorkTemplateInfo((IObjectPK)id, BgNWorkPaperHelper.getWorkTemplateSel(selectType));
        }
        return info;
    }

    public static boolean isSingleCol(Column col) {
        boolean isSingle = false;
        if (String.valueOf(1).equals(BgNWorkPaperHelper.getSrcType(col))) {
            return true;
        }
        return isSingle;
    }

    public static boolean isConSolidCol(Column col) {
        return String.valueOf(4).equals(BgNWorkPaperHelper.getSrcType(col));
    }

    public static Map getDataColMap(Column col) {
        if (col != null && col.getUserObjectValue("WORK_COL_DATA") instanceof Map) {
            return (Map)col.getUserObjectValue("WORK_COL_DATA");
        }
        return null;
    }

    public static String getItemNumber(Row row) {
        String number = null;
        if (row != null && row.getUserObjectValue("WORK_ROW_ITEM") instanceof String) {
            number = (String)row.getUserObjectValue("WORK_ROW_ITEM");
        }
        return number;
    }

    public static Map getSubMap(Map parent, String key) {
        if (parent == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        HashMap r = new HashMap();
        parent.put(key, r);
        return r;
    }

    public static Map getItemFormulas(Sheet sheet) {
        HashMap<String, Cloneable> resMap = new HashMap<String, Cloneable>();
        ArrayList<String> formulas = new ArrayList<String>();
        HashMap<String, Integer> itemPoints = new HashMap<String, Integer>();
        HashMap<String, Integer> colPoints = new HashMap<String, Integer>();
        HashMap<String[], Object> manulElim = new HashMap<String[], Object>();
        resMap.put(WORK_PAPER_ITEM_POINTS, itemPoints);
        resMap.put(WORK_PAPER_COL_POINTS, colPoints);
        resMap.put(WORK_PAPER_FORMULAS, formulas);
        resMap.put(WORK_PAPER_MANULELIM, manulElim);
        if (sheet != null) {
            ItemFormula curFormula = null;
            Cell cell = null;
            String itemNumber = null;
            Column col = null;
            String colKey = null;
            String elementNumber = null;
            String[] params = null;
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                col = sheet.getColumn(colIndex, false);
                if (col == null || StringUtils.isEmpty((String)(colKey = BgNWorkPaperHelper.getColKey(BgNWorkPaperHelper.getElementNumber(col), BgNWorkPaperHelper.getSrcType(col), BgNWorkPaperHelper.getSingleOrgId(col))))) continue;
                colPoints.put(colKey, new Integer(colIndex));
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                itemNumber = BgNWorkPaperHelper.getItemNumber(sheet.getRow(rowIndex, false));
                if (StringUtils.isEmpty((String)itemNumber)) continue;
                itemPoints.put(itemNumber, new Integer(rowIndex));
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    if (!colPoints.containsValue(new Integer(colIndex)) || (cell = sheet.getCell(rowIndex, colIndex, false)) == null) continue;
                    if (cell.getUserObjectValue("ITEM") instanceof ItemFormula) {
                        curFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
                        if (!curFormula.isValidity()) continue;
                        formulas.add(curFormula.getFormula());
                        continue;
                    }
                    col = sheet.getColumn(colIndex, false);
                    if (!String.valueOf(5).equals(BgNWorkPaperHelper.getSrcType(col)) || StringUtils.isEmpty((String)(elementNumber = BgNWorkPaperHelper.getElementNumber(col))) || !(cell.getValue().getValue() instanceof BigDecimal)) continue;
                    params = new String[]{itemNumber, elementNumber};
                    manulElim.put(params, cell.getValue().getValue());
                }
            }
        }
        return resMap;
    }

    public static String getColKey(String eleNumber, String srcType, String orgId) {
        if (StringUtils.isEmpty((String)eleNumber) || StringUtils.isEmpty((String)srcType)) {
            return null;
        }
        if (String.valueOf(1).equals(srcType)) {
            if (StringUtils.isEmpty((String)orgId)) {
                return null;
            }
            return eleNumber + "_" + srcType + "_" + orgId;
        }
        return eleNumber + "_" + srcType;
    }

    public static void insertCol(Sheet sheet, int colIndex, List orgList, boolean isCopyCol, Map elementMap) {
        if (sheet != null && orgList != null && !orgList.isEmpty() && colIndex >= 0) {
            int colCount = orgList.size() - 1;
            if (colCount > 0) {
                Range r = sheet.getColRange(colIndex, colIndex + colCount - 1);
                r.setIgnoreProtected(true);
                r.insert(false, InsertType.FLLOW_DOWN_STYLE);
            }
            if (isCopyCol) {
                int sourceColCount = colIndex + colCount;
                Column sourceCol = sheet.getColumn(sourceColCount, false);
                HashMap basePosition = BgEliminationHelper.getBasePosition(sheet);
                if (basePosition == null || basePosition.isEmpty() || sourceCol == null) {
                    return;
                }
                int top = (Integer)basePosition.get("top");
                String elementName = BgNWorkPaperHelper.getElementName(sourceCol, elementMap);
                if (StringUtils.isEmpty((String)elementName)) {
                    return;
                }
                Cell sourceCell = null;
                Cell targetCell = null;
                boolean isTitleRow = false;
                sourceCol = sheet.getColumn(sourceColCount, false);
                Object r = null;
                Column targetCol = null;
                for (int c = colIndex; c < sourceColCount; ++c) {
                    targetCol = sheet.getColumn(c, true);
                    BgNWorkPaperHelper.copyUserObjects(sourceCol, targetCol);
                    BgNWorkPaperHelper.getDataColMap(targetCol).put(SINGLE_ORG_ID, ((OrgUnitInfo)orgList.get(c - colIndex)).getId().toString());
                }
                BgNWorkPaperHelper.getDataColMap(sourceCol).put(SINGLE_ORG_ID, ((OrgUnitInfo)orgList.get(colCount)).getId().toString());
                for (int rI = 0; rI <= sheet.getMaxRowIndex(); ++rI) {
                    sourceCell = sheet.getCell(rI, sourceColCount, false);
                    String orgName = null;
                    if (sourceCell == null) continue;
                    isTitleRow = BgNWorkPaperHelper.hasTitle(sourceCell, top);
                    for (int c = colIndex; c < sourceColCount; ++c) {
                        targetCell = sheet.getCell(rI, c, true);
                        BgNWorkPaperHelper.copyExperss(sourceCell, targetCell);
                        if (!isTitleRow) continue;
                        orgName = ((OrgUnitInfo)orgList.get(c - colIndex)).getName();
                        targetCell.setValue(new Variant((Object)(orgName + "(" + elementName + ")")));
                    }
                    if (!isTitleRow) continue;
                    orgName = ((OrgUnitInfo)orgList.get(colCount)).getName();
                    sourceCell.setValue(new Variant((Object)(orgName + "(" + elementName + ")")));
                }
            }
        }
    }

    public static void copyExperss(Cell source, Cell target) {
        if (source == null || !source.hasFormula() || target == null) {
            return;
        }
        String exp = source.getFormula();
        if (StringUtils.isEmpty((String)exp)) {
            return;
        }
        String tag = "=+-/*";
        StringBuffer newExp = null;
        newExp = new StringBuffer();
        boolean hasRef = false;
        StringTokenizer temp = new StringTokenizer(exp, "+-*/", false);
        while (temp.hasMoreElements()) {
            String t = temp.nextToken();
            if (!TableToolkit.isCellRef((String)t.replaceAll("=", "").replaceAll("\\(", "").replaceAll("\\)", ""))) continue;
            hasRef = true;
            break;
        }
        if (hasRef) {
            StringTokenizer token = new StringTokenizer(exp, tag, true);
            while (token.hasMoreTokens()) {
                String s;
                String entry = token.nextToken();
                if (tag.indexOf(entry) >= 0) {
                    newExp.append(entry);
                    continue;
                }
                String[] items = entry.split("!");
                if (items.length > 1) {
                    newExp.append(items[0]).append("!");
                }
                String string = s = items.length > 1 ? items[1] : items[0];
                if (!TableToolkit.isCellRef((String)s.replaceAll("\\)", "").replaceAll("\\(", ""))) {
                    newExp.append(s);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(s, "\\(:\\)", true);
                while (st.hasMoreTokens()) {
                    String item = st.nextToken();
                    if (!TableToolkit.isCellRef((String)item)) {
                        newExp.append(item);
                        continue;
                    }
                    int index = -1;
                    for (int k = item.length() - 1; k >= 0; --k) {
                        try {
                            Integer.parseInt(item.substring(k, k + 1));
                            continue;
                        }
                        catch (Exception exc) {
                            index = k;
                            break;
                        }
                    }
                    String s1 = item.substring(0, index + 1);
                    String s2 = item.substring(index + 1, item.length());
                    if (target.getCol() != source.getCol()) {
                        s1 = TableToolkit.int2pos((int)(TableToolkit.pos2int((String)s1) + target.getCol() - source.getCol()));
                    }
                    if (target.getRow() != source.getRow()) {
                        try {
                            s2 = String.valueOf(Integer.valueOf(s2) + target.getRow() - source.getRow());
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                    newExp.append(s1).append(s2);
                }
            }
        } else {
            newExp.append(exp);
        }
        if (newExp.length() > 1) {
            target.setFormula(newExp.toString());
        }
    }

    public static boolean hasTitle(Cell cell, int top) {
        return cell != null && cell.getRow() == top;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyUserObjects(Column source, Column target) {
        if (source == null || target == null) return;
        SortedUserObjectArray objs = source.getUserObjects();
        HashMap value = null;
        if (objs == null) return;
        if (objs.isEmpty()) return;
        for (int i = 0; i < objs.size(); ++i) {
            block3: {
                try {
                    value = objs.getUserObject(i).getValue();
                    value = ObjectUtils.createCopy((Object)value);
                }
                catch (CloneNotSupportedException e) {
                    if (!(value instanceof Map)) break block3;
                    value = new HashMap(value);
                }
            }
            target.setUserObject(objs.getUserObject(i).getKey(), value);
        }
    }

    public static String getElementName(Column col, Map elementMap) {
        String name = null;
        Object obj = null;
        if (BgNWorkPaperHelper.getDataColMap(col) != null) {
            Object v = BgNWorkPaperHelper.getDataColMap(col).get("BG_ELEMENT");
            obj = v;
            if (v != null) {
                if (obj instanceof BgElementInfo) {
                    name = ((BgElementInfo)obj).getName();
                } else if (obj instanceof String && elementMap != null) {
                    if (elementMap.get(obj) instanceof BgElementInfo) {
                        name = ((BgElementInfo)elementMap.get(obj)).getName();
                    } else if (elementMap.get(obj) instanceof String) {
                        name = (String)elementMap.get(obj);
                    }
                }
            }
        }
        return name;
    }

    public static String getElementNumber(Column col) {
        return BgNWorkPaperHelper.getElementNumber(BgNWorkPaperHelper.getDataColMap(col));
    }

    public static String getElementNumber(Map colData) {
        String number = null;
        if (colData != null && colData.get("BG_ELEMENT") instanceof String) {
            number = (String)colData.get("BG_ELEMENT");
        }
        return number;
    }

    public static String getSrcType(Column col) {
        return BgNWorkPaperHelper.getSrcType(BgNWorkPaperHelper.getDataColMap(col));
    }

    public static String getSrcType(Map colData) {
        String srcType = null;
        if (colData != null && colData.get("WORK_DATA_SRC_TYPE") instanceof String) {
            srcType = (String)colData.get("WORK_DATA_SRC_TYPE");
        }
        return srcType;
    }

    public static String getSingleOrgId(Column col) {
        String orgId = null;
        if (BgNWorkPaperHelper.getDataColMap(col) != null && BgNWorkPaperHelper.getDataColMap(col).get(SINGLE_ORG_ID) instanceof String) {
            orgId = (String)BgNWorkPaperHelper.getDataColMap(col).get(SINGLE_ORG_ID);
        }
        return orgId;
    }

    public static IBgWorkTemplate getBgWorkTemplateInstance(Context ctx) throws Exception {
        if (ctx == null) {
            return BgWorkTemplateFactory.getRemoteInstance();
        }
        return BgWorkTemplateFactory.getLocalInstance(ctx);
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), BgNWorkPaperHelper.getCompanySelectors());
        }
        OrgUnitInfo parent = BgNWorkPaperHelper.getOrgFacadeInterface(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgNWorkPaperHelper.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static ICompanyOrgUnit getCompanyInterface(Context ctx) throws Exception {
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance();
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    private static INewOrgViewFacade getOrgFacadeInterface(Context ctx) throws Exception {
        return NewOrgViewFacadeFactory.getRemoteInstance();
    }

    public static SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    public static void requestObjectLock(Context ctx, String objId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)objId)) {
            return;
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (!mutexServiceControl.requestObjIDForUpdate(objId, ctx.getUserName(), ctx.getAIS())) {
            throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
        }
    }

    public static void releaseObjectLock(Context ctx, String objId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)objId)) {
            return;
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexServiceControl.releaseObjIDForUpdate(objId);
    }

    public static String[] getExpressElementCurrency(Cell cell) {
        String[] elementCurrency = null;
        if (cell != null && cell.hasFormula()) {
            try {
                Expression expression = ExcelFormulaPaserHelper.parse((String)cell.getFormula());
                elementCurrency = BgNWorkPaperHelper.getExpressElementCurrency(expression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return elementCurrency;
    }

    public static String[] getExpressElementCurrency(Expression expression) {
        String[] elementCurrency = null;
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if (BGFORMULA.equalsIgnoreCase(_funcionName) || BGACTUALS.equalsIgnoreCase(_funcionName) || BGBALANCE.equalsIgnoreCase(_funcionName)) {
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                StringExpr _currency = (StringExpr)((FunctionExpr)expression).parameters.get(4);
                elementCurrency = new String[]{_bgelement.value, _currency.value};
            }
        } else if (expression instanceof BinaryOperationExpr && (elementCurrency = BgNWorkPaperHelper.getExpressElementCurrency(((BinaryOperationExpr)expression).left)) == null) {
            elementCurrency = BgNWorkPaperHelper.getExpressElementCurrency(((BinaryOperationExpr)expression).right);
        }
        return elementCurrency;
    }

    public static void checkExpression(Cell cell, BgWorkPaperInfo info, String costCenterNumber, String companyNumber) {
        String _expression;
        if (cell == null || info == null) {
            return;
        }
        String expression = BgNFSHelper.getExpression(cell);
        if (!StringUtils.isEmpty((String)expression) && (_expression = BgNExpressionHelper.checkExpression(cell, expression, (IObjectValue)info, costCenterNumber, companyNumber)) != null && !expression.equalsIgnoreCase(_expression.replaceAll(" ", ""))) {
            cell.setFormula(_expression);
            cell.setValue(cell.getValue());
        }
    }

    public static List getSheetOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgSHelper.isProtectionRowAndCol()) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(65536));
        return sheetOperation;
    }
}

