/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import java.util.Map;

public class BgScriptHelper {
    public static final String ScriptBeginCell = "ScriptBeginCell";
    public static final String ScriptEndCell = "ScriptEndCell";
    public static final String ScriptCell = "ScriptCell";
    public static final String Compart = "!!";
    public static final int onlyScript = 3;
    public static final int hadOther = 2;
    public static final int noScript = 1;

    public static int[] getCellRowAndCol(Sheet sheet) {
        int[] cellRowAndCol = new int[]{-1, -1};
        String scriptStr = BgScriptHelper.getScriptWithSheet(sheet);
        if (scriptStr == null) {
            return null;
        }
        String[] scriptRowAndCol = scriptStr.split(Compart);
        if (scriptRowAndCol == null || scriptRowAndCol.length != 2 || scriptRowAndCol[0] == null || scriptRowAndCol[1] == null) {
            return null;
        }
        Map rowsMap = null;
        Map colsMap = null;
        rowsMap = BgNFSHelper.getRowIDMapInfo(sheet);
        colsMap = BgNFSHelper.getColIDMapInfo(sheet);
        if (rowsMap.get(scriptRowAndCol[0]) != null && colsMap.get(scriptRowAndCol[1]) != null) {
            cellRowAndCol[0] = (Integer)rowsMap.get(scriptRowAndCol[0]);
            cellRowAndCol[1] = (Integer)colsMap.get(scriptRowAndCol[1]);
        }
        return cellRowAndCol;
    }

    private static String getScriptWithSheet(Sheet sheet) {
        UserObject obj = sheet.getUserObject(ScriptCell);
        if (obj != null) {
            return (String)obj.getValue();
        }
        return null;
    }

    public static boolean removeScriptForSheet(Cell cell) {
        if (cell == null || cell.getUserObject(ScriptBeginCell) == null) {
            return false;
        }
        BgScriptHelper.removeScriptTag(cell.getSheet(), cell);
        return true;
    }

    private static void removeScriptTag(Sheet sheet, Cell cell) {
        cell.removeUserObject(ScriptBeginCell);
        sheet.removeUserObject(ScriptCell);
    }
}

