/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisDataTypeEnum;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisWayEnum;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.nbudget.BgPredictDataSourceTypeEnum;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionFactory;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.IBgPredictExpression;
import com.kingdee.eas.ma.nbudget.IBgWorkTemplate;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSimulatePredictFilterParams
implements Serializable {
    private static final Logger logger = Logger.getLogger(BgSimulatePredictFilterParams.class);
    private static final long serialVersionUID = -8037516240566788566L;
    public static final String SEPARATED_SIGN = "@";
    public static final String MAP_EACH_VALUE_SEPARATED_SIGN = "GStar";
    public static final String MAP_VALUE_SEPARATED_SIGN = ",";
    public static final String ORG_UNIT_KEY = "OrgUnitKey";
    public static final String BG_FORM_ID = "BgFormID";
    public static final String BG_SCHEME_ID = "BgSchemeID";
    public static final String OrgTreeInfo_ID = "OrgTreeInfoId";
    public static final String BG_WORKTEMPLATE_ID = "BgWorkTemplateId";
    public static final String CURRENCY_ID = "CurrencyID";
    public static final String BG_BEGIN_PERIOD_ID = "BeginPeriodID";
    public static final String BG_END_PERIOD_ID = "EndPeriodID";
    public static final String IS_DISPLAY_ZERO = "isDisplayZero";
    public static final String IS_SUM = "IsSum";
    public static final String IsDisplayZero = "IsDisplayZero";
    public static final String BG_ANALYSIS_COL_KEY = "BgAnalysisColKey";
    public static final String BG_TITLE_COL_KEY = "BgTitleColKey";
    public static final String BG_MEASURE_UNIT_KEY = "BgMeasureUnitKey";
    public static final String ANALYSIS_ELEMENT = "BgSimpleAnalysisElement";
    public static final String ANALYSIS_DATA_TYPE = "AnalysisDataType";
    public static final String ANALYSIS_DATA_WAY = "AnalysisDataWay";
    public static final String SELECTED_BGITEM_LIST = "SelectedBgItemList";

    public static String getCostCenterUnitIDs(CostCenterOrgUnitInfo[] costOrgAry) {
        String orgUnitID = "";
        int num = costOrgAry.length;
        for (int i = 0; i < num; ++i) {
            CostCenterOrgUnitInfo info = costOrgAry[i];
            orgUnitID = orgUnitID + info.getId();
            if (i == num - 1) continue;
            orgUnitID = orgUnitID + SEPARATED_SIGN;
        }
        return orgUnitID;
    }

    public static String getElementDs(BgElementInfo[] costOrgAry) {
        String orgUnitID = "";
        int num = costOrgAry.length;
        for (int i = 0; i < num; ++i) {
            BgElementInfo info = costOrgAry[i];
            orgUnitID = orgUnitID + info.getId();
            if (i == num - 1) continue;
            orgUnitID = orgUnitID + SEPARATED_SIGN;
        }
        return orgUnitID;
    }

    public static String getFullUnitIDs(FullOrgUnitInfo[] costOrgAry) {
        String orgUnitID = "";
        int num = costOrgAry.length;
        for (int i = 0; i < num; ++i) {
            FullOrgUnitInfo info = costOrgAry[i];
            orgUnitID = orgUnitID + info.getId();
            if (i == num - 1) continue;
            orgUnitID = orgUnitID + SEPARATED_SIGN;
        }
        return orgUnitID;
    }

    public static CostCenterOrgUnitInfo[] decodeCostCenterOrgUnit(String orgUnitID) {
        if (orgUnitID == null || "".equals(orgUnitID)) {
            return null;
        }
        ICostCenterOrgUnit iCostCenterOrgUnit = null;
        try {
            iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String[] idAry = orgUnitID.split(SEPARATED_SIGN);
        int num = idAry.length;
        CostCenterOrgUnitInfo[] infoAry = new CostCenterOrgUnitInfo[num];
        for (int i = 0; i < num; ++i) {
            try {
                infoAry[i] = iCostCenterOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(idAry[i]));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return infoAry;
    }

    public static BgElementInfo[] decodeElement(String orgUnitID) {
        if (orgUnitID == null || "".equals(orgUnitID)) {
            return null;
        }
        IBgElement iBgElement = null;
        try {
            iBgElement = BgElementFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String[] idAry = orgUnitID.split(SEPARATED_SIGN);
        int num = idAry.length;
        BgElementInfo[] infoAry = new BgElementInfo[num];
        for (int i = 0; i < num; ++i) {
            try {
                infoAry[i] = iBgElement.getBgElementInfo((IObjectPK)new ObjectUuidPK(idAry[i]));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return infoAry;
    }

    public static FullOrgUnitInfo[] decodeFullOrgUnit(String orgUnitID) {
        if (orgUnitID == null || "".equals(orgUnitID)) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = null;
        try {
            iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String[] idAry = orgUnitID.split(SEPARATED_SIGN);
        int num = idAry.length;
        FullOrgUnitInfo[] infoAry = new FullOrgUnitInfo[num];
        for (int i = 0; i < num; ++i) {
            try {
                infoAry[i] = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(idAry[i]));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return infoAry;
    }

    public static BgSchemeInfo decodeBgSchemeInfo(String bgSchemeID) {
        if (bgSchemeID == null || "".equals(bgSchemeID)) {
            return null;
        }
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgSchemeInfo info = null;
        try {
            info = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeID));
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }

    public static OrgTreeInfo decodeOrgTreeInfo(String orgTreeInfoId) {
        if (orgTreeInfoId == null || "".equals(orgTreeInfoId)) {
            return null;
        }
        IOrgTree iOrgTree = null;
        try {
            iOrgTree = OrgTreeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        OrgTreeInfo info = null;
        try {
            info = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeInfoId));
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }

    public static BgWorkTemplateInfo decodeBgWorkTemplateInfo(String bgWorkTemplateId) {
        if (bgWorkTemplateId == null || "".equals(bgWorkTemplateId)) {
            return null;
        }
        IBgWorkTemplate iBgWorkTemplate = null;
        try {
            iBgWorkTemplate = BgWorkTemplateFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgWorkTemplateInfo info = null;
        try {
            info = iBgWorkTemplate.getBgWorkTemplateInfo((IObjectPK)new ObjectUuidPK(bgWorkTemplateId));
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }

    public static CurrencyInfo decodeCurrencyInfo(String currencyID) {
        if (currencyID == null || "".equals(currencyID)) {
            return null;
        }
        ICurrency iCurrency = null;
        try {
            iCurrency = CurrencyFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        CurrencyInfo info = null;
        try {
            info = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }

    public static BgPeriodInfo decodeBgPeriodInfo(String bgPeriodID) {
        if (bgPeriodID == null || "".equals(bgPeriodID)) {
            return null;
        }
        IBgPeriod iPeriod = null;
        try {
            iPeriod = BgPeriodFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgPeriodInfo info = null;
        try {
            info = iPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodID));
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }

    public static String getAnalysisOrTitleColKey(Map map) {
        String val = "";
        if (map == null || map.size() == 0) {
            return val;
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            String key = keyList.get(i).toString();
            String keyVal = BgSimulatePredictFilterParams.getVal(map.get(key));
            val = val + key + SEPARATED_SIGN + keyVal;
            if (i == num - 1) continue;
            val = val + MAP_EACH_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    private static String getVal(Object val) {
        if (val == null) {
            return "";
        }
        List list = (List)val;
        String rtnVal = "";
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            String tempVal = list.get(i).toString();
            rtnVal = rtnVal + tempVal;
            if (i == num - 1) continue;
            rtnVal = rtnVal + MAP_VALUE_SEPARATED_SIGN;
        }
        return rtnVal;
    }

    public static Map decodeAnalysisAndTitleColKey(String analysisOrTitleColKey) {
        HashMap map = new HashMap();
        if (analysisOrTitleColKey == null || "".equals(analysisOrTitleColKey)) {
            return map;
        }
        for (String eachVal : analysisOrTitleColKey.split(MAP_EACH_VALUE_SEPARATED_SIGN)) {
            String[] eachValAry = eachVal.split(SEPARATED_SIGN);
            String key = eachValAry[0];
            String val = eachValAry[1];
            String[] cols = val.split(MAP_VALUE_SEPARATED_SIGN);
            ArrayList<Integer> colList = new ArrayList<Integer>();
            int jNum = cols.length;
            for (int j = 0; j < jNum; ++j) {
                colList.add(Integer.valueOf(cols[j]));
            }
            map.put(key, colList);
        }
        return map;
    }

    public static String getMeasureUnit(Map map) {
        String val = "";
        if (map == null || map.size() == 0) {
            return val;
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            BgElementInfo elementInfo = (BgElementInfo)keyList.get(i);
            MeasureUnitInfo measureInfo = (MeasureUnitInfo)map.get(elementInfo);
            val = val + elementInfo.getId() + SEPARATED_SIGN + measureInfo.getId();
            if (i == num - 1) continue;
            val = val + MAP_EACH_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    public static String getMethoder(Map map) throws EASBizException, BOSException, UuidException {
        String val = "";
        if (map == null || map.size() == 0) {
            return val;
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            String uuid = (String)keyList.get(i);
            String uuid2 = uuid.substring(0, uuid.indexOf(SEPARATED_SIGN));
            BgPredictDataSourceTypeEnum measureInfo = (BgPredictDataSourceTypeEnum)((Object)map.get(uuid));
            val = val + uuid2 + SEPARATED_SIGN + measureInfo.getName();
            if (i == num - 1) continue;
            val = val + MAP_EACH_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    public static String getItemForm(Map map) {
        String val = "";
        if (map == null || map.size() == 0) {
            return val;
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)keyList.get(i);
            String bgItemInfo = (String)map.get(bgItemGroupInfo);
            if (bgItemGroupInfo == null) continue;
            val = val + bgItemGroupInfo.getId() + SEPARATED_SIGN + bgItemInfo;
            if (i == num - 1) continue;
            val = val + MAP_EACH_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    public static String getItemFromForm(Map map) {
        String val = "";
        if (map == null || map.size() == 0) {
            return val;
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            String bgItemGroupInfo = (String)keyList.get(i);
            String bgItemInfo = (String)map.get(bgItemGroupInfo);
            val = val + bgItemGroupInfo + SEPARATED_SIGN + bgItemInfo;
            if (i == num - 1) continue;
            val = val + MAP_EACH_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    public static Map decodeMeasureUnit(String measureUnit) {
        if (measureUnit == null || "".equals(measureUnit)) {
            return null;
        }
        IBgElement iElement = null;
        IMeasureUnit iMeasure = null;
        try {
            iElement = BgElementFactory.getRemoteInstance();
            iMeasure = MeasureUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        HashMap<BgElementInfo, MeasureUnitInfo> map = new HashMap<BgElementInfo, MeasureUnitInfo>();
        for (String eachVal : measureUnit.split(MAP_EACH_VALUE_SEPARATED_SIGN)) {
            String[] tempAry = eachVal.split(SEPARATED_SIGN);
            BgElementInfo eInfo = null;
            MeasureUnitInfo mInfo = null;
            try {
                eInfo = iElement.getBgElementInfo((IObjectPK)new ObjectUuidPK(tempAry[0]));
                mInfo = iMeasure.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(tempAry[1]));
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            map.put(eInfo, mInfo);
        }
        return map;
    }

    public static Map decodeMethoder(String measureUnit) {
        if (measureUnit == null || "".equals(measureUnit)) {
            return null;
        }
        IBgPredictExpression iElement = null;
        IMeasureUnit iMeasure = null;
        try {
            iElement = BgPredictExpressionFactory.getRemoteInstance();
            iMeasure = MeasureUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        HashMap<String, BgPredictDataSourceTypeEnum> map = new HashMap<String, BgPredictDataSourceTypeEnum>();
        String[] measureUnitAry = measureUnit.split(MAP_EACH_VALUE_SEPARATED_SIGN);
        int num = measureUnitAry.length;
        for (int i = 0; i < num; ++i) {
            String eachVal = measureUnitAry[i];
            String[] tempAry = eachVal.split(SEPARATED_SIGN);
            String eInfo = tempAry[0];
            BgPredictDataSourceTypeEnum mInfo = null;
            mInfo = BgPredictDataSourceTypeEnum.getEnum(tempAry[1]);
            map.put(eInfo + SEPARATED_SIGN + i, mInfo);
        }
        return map;
    }

    public static Map decodeItem(String measureUnit) {
        if (measureUnit == null || "".equals(measureUnit)) {
            return null;
        }
        IBgItemGroup iElement = null;
        try {
            iElement = BgItemGroupFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        HashMap<BgItemGroupInfo, String> map = new HashMap<BgItemGroupInfo, String>();
        for (String eachVal : measureUnit.split(MAP_EACH_VALUE_SEPARATED_SIGN)) {
            String[] tempAry = eachVal.split(SEPARATED_SIGN);
            BgItemGroupInfo eInfo = null;
            String mInfo = null;
            try {
                eInfo = iElement.getBgItemGroupInfo((IObjectPK)new ObjectUuidPK(tempAry[0]));
                mInfo = tempAry[1];
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            map.put(eInfo, mInfo);
        }
        return map;
    }

    public static Map decodeItemForm(String measureUnit) {
        if (measureUnit == null || "".equals(measureUnit)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String eachVal : measureUnit.split(MAP_EACH_VALUE_SEPARATED_SIGN)) {
            String[] tempAry = eachVal.split(SEPARATED_SIGN);
            String eInfo = null;
            String mInfo = null;
            try {
                eInfo = tempAry[0];
                mInfo = tempAry[1];
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            map.put(eInfo, mInfo);
        }
        return map;
    }

    public static String getAnalysisElement(List list) {
        String val = "";
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            String colKey = list.get(i).toString();
            val = val + colKey;
            if (i == num - 1) continue;
            val = val + MAP_VALUE_SEPARATED_SIGN;
        }
        return val;
    }

    public static List decodeAnalysisElement(String analysisEle) {
        ArrayList<String> list = new ArrayList<String>();
        if (analysisEle == null || "".equals(analysisEle)) {
            return list;
        }
        String[] analysisEleAry = analysisEle.split(MAP_VALUE_SEPARATED_SIGN);
        int num = analysisEleAry.length;
        for (int i = 0; i < num; ++i) {
            list.add(analysisEleAry[i]);
        }
        return list;
    }

    public static BgTendencyAnalysisDataTypeEnum decodeAnalysisDataType(String dataType) {
        return BgTendencyAnalysisDataTypeEnum.getEnum((String)dataType);
    }

    public static BgTendencyAnalysisWayEnum decodeAnalysisDataWay(String dataWay) {
        return BgTendencyAnalysisWayEnum.getEnum((String)dataWay);
    }

    public static String getSelectedBgItemList(List bgItemList) {
        StringBuffer rtnVal = new StringBuffer();
        int num = bgItemList.size();
        for (int i = 0; i < num; ++i) {
            String tempVal = bgItemList.get(i).toString();
            rtnVal.append(tempVal);
            if (i == num - 1) continue;
            rtnVal.append(SEPARATED_SIGN);
        }
        return rtnVal.toString();
    }

    public static List decodeSelectedBgItemList(String bgItemListStr) {
        ArrayList<String> list = new ArrayList<String>();
        if (bgItemListStr == null || "".equals(bgItemListStr)) {
            return list;
        }
        String[] array = bgItemListStr.split(SEPARATED_SIGN);
        int num = array.length;
        for (int i = 0; i < num; ++i) {
            list.add(array[i]);
        }
        return list;
    }
}

