/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgItemMappingObject;
import com.kingdee.eas.ma.budget.BgRefBgCurrencyInfo;
import com.kingdee.eas.ma.budget.BgRefBgItemCombinInfo;
import com.kingdee.eas.ma.budget.BgRefBgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.CreateBgTemFromRptException;
import com.kingdee.eas.ma.nbudget.BgImportFromRptHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgTemplateFacade {
    public static final String TAGE = "~!~";
    private static final Logger logger = Logger.getLogger(BgTemplateFacade.class);

    public static final void clearRefBgItem(Connection conn, BOSUuid bgTemplateId) throws EASBizException {
        if (conn == null || bgTemplateId == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgItemCombin WHERE FBgTemplateID = ?");
            pstmt.setString(1, bgTemplateId.toString());
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgItem(Connection conn, BOSUuid bgFormId, Map refBgItemMap, List delBgItemList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgItemMap == null || refBgItemMap.isEmpty() || delBgItemList == null || delBgItemList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgItemKey2 = null;
        String bgItemId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgItemSet = new HashSet<String>();
        for (String bgItemKey2 : delBgItemList) {
            delBgItemSet.add(bgItemKey2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgItemCombin WHERE FBgTemplateID = ? AND FBgItemCombinId = ?");
            for (String bgItemKey2 : delBgItemSet) {
                bgItemId = (String)refBgItemMap.get(bgItemKey2);
                if (!StringUtils.isEmpty((String)bgItemId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, bgItemId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgItemKey2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgPeriod(Connection conn, BOSUuid bgTemplateId) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgPeriod WHERE FBgTemplateID = ?");
            pstmt.setString(1, bgTemplateId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgPeriod(Connection conn, BOSUuid bgFormId, Map refBgPeriodMap, List delBgPeriodList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgPeriodMap == null || refBgPeriodMap.isEmpty() || delBgPeriodList == null || delBgPeriodList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgPeriodNum2 = null;
        String bgPeriodId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgPeriodSet = new HashSet<String>();
        for (String bgPeriodNum2 : delBgPeriodList) {
            delBgPeriodSet.add(bgPeriodNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgPeriod WHERE FBgTemplateID = ? AND FBgPeriodID = ?");
            for (String bgPeriodNum2 : delBgPeriodSet) {
                bgPeriodId = (String)refBgPeriodMap.get(bgPeriodNum2);
                if (StringUtils.isEmpty((String)bgPeriodId)) continue;
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, bgPeriodId);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgElement(Connection conn, BOSUuid bgTemplateId) throws EASBizException {
        if (conn == null || bgTemplateId == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgElement WHERE FBgTemplateID = ?");
            pstmt.setString(1, bgTemplateId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgElement(Connection conn, BOSUuid bgFormId, Map refBgElementMap, List delBgElementList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgElementMap == null || refBgElementMap.isEmpty() || delBgElementList == null || delBgElementList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgElementNum2 = null;
        String bgElementId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgElementSet = new HashSet<String>();
        for (String bgElementNum2 : delBgElementList) {
            delBgElementSet.add(bgElementNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefBgElement WHERE FBgTemplateID = ? AND FBgElementID = ?");
            for (String bgElementNum2 : delBgElementSet) {
                bgElementId = (String)refBgElementMap.get(bgElementNum2);
                if (!StringUtils.isEmpty((String)bgElementId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, bgElementId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgElementNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefCurrency(Connection conn, BOSUuid bgTemplateId) throws EASBizException {
        if (conn == null || bgTemplateId == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefCurrency WHERE FBgTemplateID = ?");
            pstmt.setString(1, bgTemplateId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefCurrency(Connection conn, BOSUuid bgFormId, Map refCurrencyMap, List delCurrencyList) throws EASBizException {
        if (conn == null || bgFormId == null || refCurrencyMap == null || refCurrencyMap.isEmpty() || delCurrencyList == null || delCurrencyList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String currencyNum2 = null;
        String currencyId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delCurrencySet = new HashSet<String>();
        for (String currencyNum2 : delCurrencyList) {
            delCurrencySet.add(currencyNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgTemRefCurrency WHERE FBgTemplateID = ? AND FCurrencyID = ?");
            for (String currencyNum2 : delCurrencySet) {
                currencyId = (String)refCurrencyMap.get(currencyNum2);
                if (!StringUtils.isEmpty((String)currencyId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, currencyId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{currencyNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgItem(Connection conn, BOSUuid bgTemplateId, Set refBgItemSet, Map refBgItemMap) throws EASBizException {
        if (conn == null || bgTemplateId == null || refBgItemSet == null || refBgItemSet.isEmpty() || refBgItemMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgItemKey2 = null;
        String bgItemId = null;
        String _bgFormId = bgTemplateId.toString();
        BgRefBgItemCombinInfo bgRefItemInfo = new BgRefBgItemCombinInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgTemRefBgItemCombin(FID, FBgTemplateID, FBgItemCombinId) VALUES (?, ?, ?)");
            for (String bgItemKey2 : refBgItemSet) {
                if (refBgItemMap.containsKey(bgItemKey2)) {
                    bgItemId = (String)refBgItemMap.get(bgItemKey2);
                    if (!StringUtils.isEmpty((String)bgItemId)) {
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefItemInfo.getBOSType()).toString());
                        pstmt.setString(2, _bgFormId);
                        pstmt.setString(3, bgItemId);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                        continue;
                    }
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgItemKey2});
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgItemKey2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgPeriod(Connection conn, BOSUuid bgTemplateID, Set refBgPeriodSet, Map refBgPeriodMap) throws EASBizException {
        if (conn == null || bgTemplateID == null || refBgPeriodSet == null || refBgPeriodSet.isEmpty() || refBgPeriodMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgPeriodNumbr2 = null;
        String bgPeriodId = null;
        String _bgFormId = bgTemplateID.toString();
        BgRefBgPeriodInfo bgRefPeriodInfo = new BgRefBgPeriodInfo();
        PreparedStatement pstmt = null;
        boolean isRelativePeriod = false;
        try {
            pstmt = conn.prepareStatement("INSERT INTO t_bg_bgtemRefBgPeriod(FID, FBgTemplateID, FBgPeriodID) VALUES (?, ?, ?)");
            for (String bgPeriodNumbr2 : refBgPeriodSet) {
                isRelativePeriod = false;
                try {
                    Integer.valueOf(bgPeriodNumbr2);
                    isRelativePeriod = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (isRelativePeriod) continue;
                if (refBgPeriodMap.containsKey(bgPeriodNumbr2)) {
                    bgPeriodId = (String)refBgPeriodMap.get(bgPeriodNumbr2);
                    if (!StringUtils.isEmpty((String)bgPeriodId)) {
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefPeriodInfo.getBOSType()).toString());
                        pstmt.setString(2, _bgFormId);
                        pstmt.setString(3, bgPeriodId);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                        continue;
                    }
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodNumbr2});
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodNumbr2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgElement(Connection conn, BOSUuid bgTemplateId, Set refBgElementSet, Map refBgElementMap) throws EASBizException {
        if (conn == null || bgTemplateId == null || refBgElementSet == null || refBgElementSet.isEmpty() || refBgElementMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgElementId = null;
        String bgElementNum2 = null;
        String _bgFormId = bgTemplateId.toString();
        BgRefBgPeriodInfo bgRefElementInfo = new BgRefBgPeriodInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgTemRefBgElement(FID, FBgTemplateID, FBgElementID) VALUES (?,?,?)");
            for (String bgElementNum2 : refBgElementSet) {
                if (refBgElementMap.containsKey(bgElementNum2)) {
                    bgElementId = (String)refBgElementMap.get(bgElementNum2);
                    if (!StringUtils.isEmpty((String)bgElementId)) {
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefElementInfo.getBOSType()).toString());
                        pstmt.setString(2, _bgFormId);
                        pstmt.setString(3, bgElementId);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                        continue;
                    }
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementNum2});
                }
                throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefCurrency(Connection conn, BOSUuid bgTemplateID, Set refCurrencySet, Map refCurrencyMap) throws EASBizException {
        if (conn == null || bgTemplateID == null || refCurrencySet == null || refCurrencySet.isEmpty() || refCurrencyMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String currencyId = null;
        String currencyNum2 = null;
        String _bgFormId = bgTemplateID.toString();
        BgRefBgCurrencyInfo bgRefCurrencyInfo = new BgRefBgCurrencyInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgTemRefCurrency(FID, FBgTemplateID, FCurrencyID) VALUES (?, ?, ?)");
            for (String currencyNum2 : refCurrencySet) {
                if (refCurrencyMap.containsKey(currencyNum2)) {
                    currencyId = (String)refCurrencyMap.get(currencyNum2);
                    if (!StringUtils.isEmpty((String)currencyId)) {
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefCurrencyInfo.getBOSType()).toString());
                        pstmt.setString(2, _bgFormId);
                        pstmt.setString(3, currencyId);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                        continue;
                    }
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyNum2});
                }
                throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgItemCombin(Connection conn) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("delete from T_BG_BgItemCombination where FID not in (select distinct FBgItemCombinId from T_BG_BgRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgTemRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgControlItemMap)");
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static Book[] synchronizationSeparateFormulaBook(Book book) {
        return BgTemplateFacade.synchronizationSeparateFormulaBook(book, null);
    }

    public static Book[] synchronizationSeparateFormulaBook(Book book, Set filterSheet) {
        boolean isBySheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isBySheet = true;
        }
        Book bookActualFormula = Book.Manager.getNewBook((String)book.getName(), (int)0);
        BgNFSHelper.disableUndo(bookActualFormula);
        BgNFSHelper.disableCal(bookActualFormula);
        Book bookActualAddFormula = Book.Manager.getNewBook((String)book.getName(), (int)0);
        BgNFSHelper.disableUndo(bookActualAddFormula);
        BgNFSHelper.disableCal(bookActualAddFormula);
        Sheet sheet = null;
        Sheet sheetActualFormul = null;
        Sheet sheetActualAdd = null;
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sheet = book.getSheet(i);
            if (isBySheet) {
                if (filterSheet.contains(BgNFSHelper.getSheetSign(sheet))) {
                    sheetActualFormul = new Sheet(bookActualFormula, sheet.getSheetName());
                    sheetActualAdd = new Sheet(bookActualAddFormula, sheet.getSheetName());
                    sheetActualFormul.setID(sheet.getID());
                    sheetActualAdd.setID(sheet.getID());
                    bookActualFormula.addSheet(sheetActualFormul);
                    bookActualAddFormula.addSheet(sheetActualAdd);
                    BgTemplateFacade.synchronizationSeparateFormulaSheet(sheet, sheetActualFormul, "BG_ACTUAL_EXPRESSIONS", true);
                    BgTemplateFacade.synchronizationSeparateFormulaSheet(sheet, sheetActualAdd, "BG_ADD_EXPRESSIONS", false);
                    continue;
                }
                bookActualFormula.addSheet(sheet);
                bookActualAddFormula.addSheet(sheet);
                continue;
            }
            sheetActualFormul = new Sheet(bookActualFormula, sheet.getSheetName());
            sheetActualAdd = new Sheet(bookActualAddFormula, sheet.getSheetName());
            sheetActualFormul.setID(sheet.getID());
            sheetActualAdd.setID(sheet.getID());
            bookActualFormula.addSheet(sheetActualFormul);
            bookActualAddFormula.addSheet(sheetActualAdd);
            BgTemplateFacade.synchronizationSeparateFormulaSheet(sheet, sheetActualFormul, "BG_ACTUAL_EXPRESSIONS", true);
            BgTemplateFacade.synchronizationSeparateFormulaSheet(sheet, sheetActualAdd, "BG_ADD_EXPRESSIONS", false);
        }
        Book[] bookReturn = new Book[]{book, bookActualFormula, bookActualAddFormula};
        return bookReturn;
    }

    private static void synchronizationSeparateFormulaSheet(Sheet sheet, Sheet sheetTo, String formulaType, boolean isSyschBugdetFormul) {
        Row rowSheet = null;
        Row rowSheetTo = null;
        Cell cellSheet = null;
        Cell cellSheetTo = null;
        String formula = null;
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            rowSheet = sheet.getRow(i, false);
            if (rowSheet == null) continue;
            rowSheetTo = sheetTo.getRow(i, true);
            int maxColIndex = sheet.getMaxColIndex() + 1;
            for (int j = 0; j < maxColIndex; ++j) {
                cellSheet = rowSheet.getCell(j, false);
                if (cellSheet == null) continue;
                if (formulaType.equalsIgnoreCase("BG_ACTUAL_EXPRESSIONS")) {
                    formula = BgNTemplateHelper.getAuctualFormula(cellSheet);
                } else if (formulaType.equalsIgnoreCase("BG_ADD_EXPRESSIONS")) {
                    formula = BgNTemplateHelper.getAuctualAddFormula(cellSheet);
                }
                if (isSyschBugdetFormul && !StringUtils.isEmpty((String)(formula = BgNTemplateHelper.getBudgetFormula(cellSheet)))) {
                    BgNFSHelper.setExpression(cellSheet, formula);
                }
                if (StringUtils.isEmpty((String)formula)) continue;
                cellSheetTo = rowSheetTo.getCell(j, true);
                BgNFSHelper.setExpression(cellSheetTo, formula);
            }
        }
    }

    public static Book synchronizationFormulaCombineBook(Book[] bookArray) {
        return BgTemplateFacade.synchronizationFormulaCombineBook(bookArray, null);
    }

    public static Book synchronizationFormulaCombineBook(Book[] bookArray, Set fiterSheet) {
        boolean isBySheet = false;
        if (fiterSheet != null && !fiterSheet.isEmpty()) {
            isBySheet = true;
        }
        Book book = bookArray[0];
        Book bookActualFormula = bookArray[1];
        Book bookActualAddFormula = bookArray[2];
        Sheet sheet = null;
        Sheet sheetActualFormul = null;
        Sheet sheetActualAdd = null;
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sheet = book.getSheet(i);
            if (isBySheet && !fiterSheet.contains(BgNFSHelper.getSheetSign(sheet))) continue;
            sheetActualFormul = bookActualFormula.getSheet(i);
            sheetActualAdd = bookActualAddFormula.getSheet(i);
            BgTemplateFacade.synchronizationFormulaCombineSheet(sheet, sheetActualFormul, "BG_ACTUAL_EXPRESSIONS", true);
            BgTemplateFacade.synchronizationFormulaCombineSheet(sheet, sheetActualAdd, "BG_ADD_EXPRESSIONS", false);
        }
        return book;
    }

    private static void synchronizationFormulaCombineSheet(Sheet sheet, Sheet sheetTo, String formulaType, boolean isConbineBudgetExp) {
        Row rowSheet = null;
        Row rowSheetTo = null;
        Cell cellSheet = null;
        Cell cellSheetTo = null;
        int maxColIndex = sheet.getMaxColIndex() + 1;
        String formula = null;
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            rowSheet = sheet.getRow(i, false);
            rowSheetTo = sheetTo.getRow(i, true);
            if (rowSheet == null && rowSheetTo == null) continue;
            if (rowSheet == null) {
                rowSheet = sheet.getRow(i, true);
            }
            if (rowSheetTo == null) {
                rowSheetTo = sheetTo.getRow(i, true);
            }
            for (int j = 0; j < maxColIndex; ++j) {
                cellSheet = rowSheet.getCell(j, false);
                cellSheetTo = rowSheetTo.getCell(j, false);
                if (cellSheet == null && cellSheetTo == null) continue;
                if (cellSheet == null) {
                    cellSheet = rowSheet.getCell(j, true);
                }
                if (cellSheetTo == null) {
                    cellSheetTo = rowSheetTo.getCell(j, true);
                }
                if (formulaType.equalsIgnoreCase("BG_ACTUAL_EXPRESSIONS")) {
                    if (cellSheetTo.hasFormula()) {
                        formula = cellSheetTo.getFormula();
                        BgNTemplateHelper.setBgDataValue(cellSheet, "BG_ACTUAL_EXPRESSIONS", formula, false);
                    } else {
                        BgNTemplateHelper.removeDataValue(cellSheet, "BG_ACTUAL_EXPRESSIONS", false);
                    }
                } else if (formulaType.equalsIgnoreCase("BG_ADD_EXPRESSIONS")) {
                    if (cellSheetTo.hasFormula()) {
                        formula = cellSheetTo.getFormula();
                        BgNTemplateHelper.setBgDataValue(cellSheet, "BG_ADD_EXPRESSIONS", formula, false);
                    } else {
                        BgNTemplateHelper.removeDataValue(cellSheet, "BG_ADD_EXPRESSIONS", false);
                    }
                }
                if (!isConbineBudgetExp) continue;
                if (cellSheet.hasFormula()) {
                    formula = cellSheet.getFormula();
                    BgNTemplateHelper.setBgDataValue(cellSheet, "BG_BUDGET_EXPRESSIONS", formula, false);
                    continue;
                }
                BgNTemplateHelper.removeDataValue(cellSheet, "BG_BUDGET_EXPRESSIONS", false);
            }
        }
    }

    public static void convertReportBookToTemplate(Context ctx, TemplateInfo reportTem, BgTemplateInfo templateInfo, StringBuffer msg) throws EASBizException, BOSException {
        if (msg == null) {
            msg = new StringBuffer();
        }
        templateInfo.setName(reportTem.getName());
        templateInfo.setNumber(reportTem.getNumber());
        MeasureUnitCollection col = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection("where measureUnitGroup.number='BUDGET' and isBaseUnit = 1");
        if (col == null || col.isEmpty()) {
            throw new CreateBgTemFromRptException(CreateBgTemFromRptException.BGBASEMEAUSREUNITNOTEXIT);
        }
        templateInfo.setDefaultMeasureUnit(col.get(0));
        Book bookrpt = null;
        try {
            bookrpt = reportTem.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        Book bookBg = BgTemplateFacade.convertReportBookToTemplate(ctx, bookrpt, msg, templateInfo.getNumber());
        try {
            templateInfo.setBook(bookBg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
    }

    public static Book convertReportBookToTemplate(Context ctx, Book reportBook, StringBuffer msg, String bgTemplateNumber) throws EASBizException, BOSException {
        if (reportBook == null) {
            return null;
        }
        HashMap getReportDataTypeDataValueToBgElementMap = new HashMap();
        HashMap bgPeriodMap = new HashMap();
        HashMap bgItemMap = new HashMap();
        Book templateBook = Book.Manager.getNewBook((String)reportBook.getName(), (int)reportBook.getSheetCount());
        Sheet reportSheet = null;
        Sheet templateSheet = null;
        Row reportRow = null;
        Row templateRow = null;
        Cell reportCell = null;
        Cell templateCell = null;
        boolean hasItemFormulal = false;
        String formula = null;
        Object value = null;
        ItemFormula itemformual = null;
        ItemFormula itemformualBgTem = null;
        templateBook.setCalculate(false);
        int sheetCount = reportBook.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            reportSheet = reportBook.getSheet(i);
            templateSheet = templateBook.getSheet(i);
            templateSheet.copySheetFrom(reportSheet);
            templateSheet.setName(reportSheet.getSheetName());
            int maxRowIndex = reportSheet.getMaxRowIndex() + 1;
            for (int j = 0; j < maxRowIndex; ++j) {
                reportRow = reportSheet.getRow(j, false);
                if (reportRow == null) continue;
                templateRow = templateSheet.getRow(j, true);
                int maxColIndex = reportSheet.getMaxColIndex() + 1;
                for (int k = 0; k < maxColIndex; ++k) {
                    StyleAttributes sa1;
                    StyleAttributes sa2;
                    reportCell = reportRow.getCell(k, false);
                    if (reportCell == null) continue;
                    templateCell = templateRow.getCell(k, true);
                    hasItemFormulal = BgNFSHelper.checkHasFormulaOfCell(reportCell);
                    if (hasItemFormulal) {
                        itemformual = BgNFSHelper.getItemFormula(reportCell);
                        itemformualBgTem = BgTemplateFacade.convertReportItemFormulaToTemplate(itemformual, templateCell, getReportDataTypeDataValueToBgElementMap, bgPeriodMap, bgItemMap);
                        BgNFSHelper.setItemFormula(templateCell, itemformualBgTem);
                    }
                    if (reportCell.hasFormula()) {
                        formula = BgNFSHelper.getExpression(reportCell);
                        if (!hasItemFormulal) {
                            BgNTemplateHelper.setBgDataValue(templateCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                        } else {
                            BgNTemplateHelper.setBgDataValue(templateCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                            BgNTemplateHelper.setBgDataValue(templateCell, "BG_ACTUAL_EXPRESSIONS", formula, false);
                            BgNTemplateHelper.setBgDataValue(templateCell, "BG_ADD_EXPRESSIONS", formula, false);
                        }
                        value = BgNFSHelper.getValue(reportCell);
                        BgNFSHelper.setValue(templateCell, value);
                        if ("".equals(reportCell.getStyle().getNumberFormat()) || reportCell.getStyle().getNumberFormat() == null || BgNConstants.routineStr.equals(reportCell.getStyle().getNumberFormat())) {
                            BgNFSHelper.setNumberFormat(templateCell, "@");
                            continue;
                        }
                        sa1 = sa2 = Styles.getEmptySA();
                        reportCell.getSheet().getRange(reportCell).getStyle(sa1, sa2);
                        sa1.setDirty(ShareStyleAttributes.getAllBits());
                        sa2.setDirty(ShareStyleAttributes.getAllBits());
                        templateCell.getSheet().getRange(templateCell).setStyle(sa1, sa2);
                        continue;
                    }
                    value = BgNFSHelper.getValue(reportCell);
                    BgNFSHelper.setValue(templateCell, value);
                    if ("".equals(reportCell.getStyle().getNumberFormat()) || reportCell.getStyle().getNumberFormat() == null || BgNConstants.routineStr.equals(reportCell.getStyle().getNumberFormat())) {
                        BgNFSHelper.setNumberFormat(templateCell, "@");
                        continue;
                    }
                    sa1 = sa2 = Styles.getEmptySA();
                    reportCell.getSheet().getRange(reportCell).getStyle(sa1, sa2);
                    sa1.setDirty(ShareStyleAttributes.getAllBits());
                    sa2.setDirty(ShareStyleAttributes.getAllBits());
                    templateCell.getSheet().getRange(templateCell).setStyle(sa1, sa2);
                }
            }
        }
        HashMap mapTemPeriod = new HashMap();
        HashMap mapTemItem = new HashMap();
        BgTemplateFacade.checkAllExit(ctx, bgPeriodMap, "t_bg_Bgperiod", mapTemPeriod, msg);
        BgTemplateFacade.checkAndConvertMappingBgItem(ctx, bgItemMap);
        BgTemplateFacade.checkAllBgItemExit(ctx, bgItemMap, "T_Bg_BgItemEntry", mapTemItem, msg);
        BgTemplateFacade.convertMappingBgItemByName(ctx, bgItemMap, templateBook);
        HashMap temMapElement = new HashMap();
        BgTemplateFacade.checkAllElementExit(ctx, getReportDataTypeDataValueToBgElementMap, temMapElement, msg, bgTemplateNumber);
        BgTemplateFacade.reBuildBgItemFormula(bgPeriodMap, msg, "t_bg_Bgperiod", mapTemPeriod);
        BgTemplateFacade.reBuildBgItemFormula(bgItemMap, msg, "t_bg_BgItem", mapTemItem);
        BgTemplateFacade.reBuildBgItemFormula(getReportDataTypeDataValueToBgElementMap, msg, "t_Bg_bgelement", temMapElement);
        return templateBook;
    }

    private static void reBuildBgItemFormula(Map temMapCell, StringBuffer msg, String table, HashMap mapTemTrueValue) {
        if (temMapCell == null || temMapCell.isEmpty()) {
            return;
        }
        Set keySet = temMapCell.keySet();
        String strTem2 = null;
        String formula = null;
        Vector vecCell = null;
        Cell cell2 = null;
        HashMap mapFormulaMap = new HashMap();
        String[] param = null;
        String elementNumRpt = null;
        for (String strTem2 : keySet) {
            if (table.equalsIgnoreCase("t_Bg_bgelement") && (strTem2 == null || strTem2.trim().length() < 1) || (vecCell = (Vector)temMapCell.get(strTem2)) == null || vecCell.isEmpty()) continue;
            for (Cell cell2 : vecCell) {
                formula = BgNFSHelper.getFormulaOfCell(cell2);
                if (StringUtils.isEmpty((String)formula)) continue;
                if (table.equalsIgnoreCase("t_Bg_bgelement")) {
                    elementNumRpt = BgNFSHelper.getExtValue(cell2, TAGE);
                    if (StringUtils.isEmpty((String)elementNumRpt)) {
                        BgNFSHelper.clearFormulaOfCell(cell2);
                        continue;
                    }
                    param = BgNFSHelper.parseFormulaPara(mapFormulaMap, formula);
                    if (mapTemTrueValue.containsKey(elementNumRpt)) {
                        param[2] = (String)mapTemTrueValue.get(elementNumRpt);
                        if (StringUtils.isEmpty((String)param[2])) {
                            BgNFSHelper.clearFormulaOfCell(cell2);
                            continue;
                        }
                        formula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                        BgNFSHelper.setFormulaOfCell(cell2, formula);
                        continue;
                    }
                    BgNFSHelper.clearFormulaOfCell(cell2);
                    continue;
                }
                if (table.equalsIgnoreCase("t_bg_Bgperiod")) {
                    param = BgNFSHelper.parseFormulaPara(mapFormulaMap, formula);
                    formula = "=BgItem(\"" + param[0] + "\",\"\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                    BgNFSHelper.setFormulaOfCell(cell2, formula);
                    continue;
                }
                if (!table.equalsIgnoreCase("t_bg_BgItem")) continue;
                BgNFSHelper.clearFormulaOfCell(cell2);
            }
        }
    }

    private static void checkAllExit(Context ctx, HashMap bgItemMap, String tableName, HashMap mapTemPeriod, StringBuffer msg) throws EASBizException, BOSException {
        if (bgItemMap == null || bgItemMap.isEmpty()) {
            return;
        }
        StringBuffer str = new StringBuffer("select distinct fid,fnumber from " + tableName + " ");
        boolean isfirst = true;
        Iterator iter = bgItemMap.keySet().iterator();
        while (iter.hasNext()) {
            if (isfirst) {
                isfirst = false;
                str.append(" where fnumber='" + iter.next() + "' ");
                continue;
            }
            str.append(" or fnumber='" + iter.next() + "' ");
        }
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (row.next()) {
                mapTemPeriod.put(row.getString("fnumber"), row.getString("fid"));
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)sqlE);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqlE);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String number2 = null;
        if (msg == null) {
            msg = new StringBuffer();
        }
        for (String number2 : bgItemMap.keySet()) {
            if (mapTemPeriod.get(number2) == null || mapTemPeriod.get(number2).toString().length() < 0) {
                if (tableName.equalsIgnoreCase("t_bg_Bgperiod")) {
                    msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGPERIODNOTEXIT, (Object[])new String[]{number2}).getMessage() + "\n\r");
                    continue;
                }
                if (!tableName.equalsIgnoreCase("t_bg_Bgitem")) continue;
                msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGITEMNOTEXIT, (Object[])new String[]{number2}).getMessage() + "\n\r");
                continue;
            }
            if (tableName.equalsIgnoreCase("t_bg_Bgperiod")) {
                if (!bgItemMap.containsKey(number2) || bgItemMap.get(number2) == null) continue;
                bgItemMap.put(number2, null);
                continue;
            }
            if (!tableName.equalsIgnoreCase("t_bg_Bgitem") || !bgItemMap.containsKey(number2) || bgItemMap.get(number2) == null) continue;
            bgItemMap.put(number2, null);
        }
    }

    private static void convertMappingBgItemByName(Context ctx, HashMap bgItemMap, Book book) throws EASBizException, BOSException {
        StringBuffer query = new StringBuffer();
        query.append("(");
        Iterator it = bgItemMap.keySet().iterator();
        while (it.hasNext()) {
            query.append("'" + it.next() + "',");
        }
        query.delete(query.length() - 1, query.length());
        query.append(")");
        List mappingList = BgTemplateFacade.getItemMappingList(ctx, query.toString());
        HashMap<String, String> itemMap = new HashMap<String, String>();
        for (int i = 0; i < mappingList.size(); ++i) {
            BgItemMappingObject obj = (BgItemMappingObject)mappingList.get(i);
            itemMap.put(obj.getRptName(), obj.getBgName());
        }
        Sheet sheet = null;
        Object row = null;
        Cell cell = null;
        int maxRow = 0;
        int maxCol = 0;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            maxRow = sheet.getMaxRowIndex();
            maxCol = sheet.getMaxColIndex();
            for (int j = 0; j <= maxRow; ++j) {
                for (int k = 0; k <= maxCol; ++k) {
                    cell = sheet.getCell(j, k, true);
                    if (cell.getValue() == null || itemMap.get(cell.getValue().getValue()) == null) continue;
                    cell.setValue(new Variant(itemMap.get(cell.getValue().getValue())));
                }
            }
        }
    }

    private static void checkAndConvertMappingBgItem(Context ctx, HashMap bgItemMap) throws EASBizException, BOSException {
        StringBuffer query = new StringBuffer();
        query.append("(");
        Vector cellVec = null;
        Cell cell2 = null;
        String formula = null;
        String[] param = null;
        HashMap mapFormulaMap = new HashMap();
        Iterator it = bgItemMap.keySet().iterator();
        while (it.hasNext()) {
            query.append("'" + it.next() + "',");
        }
        query.delete(query.length() - 1, query.length());
        query.append(")");
        List mappingList = BgTemplateFacade.getItemMappingList(ctx, query.toString());
        for (int i = 0; i < mappingList.size(); ++i) {
            BgItemMappingObject obj = (BgItemMappingObject)mappingList.get(i);
            if (obj == null || !bgItemMap.containsKey(obj.getRptNumber())) continue;
            cellVec = (Vector)bgItemMap.get(obj.getRptNumber());
            for (Cell cell2 : cellVec) {
                if (!BgNFSHelper.checkHasFormulaOfCell(cell2)) continue;
                formula = BgNFSHelper.getFormulaOfCell(cell2);
                param = BgNFSHelper.parseFormulaPara(mapFormulaMap, formula);
                if (param[0].equals(obj.getRptNumber())) {
                    formula = "=BgItem(\"" + obj.getBgNumber() + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                }
                BgNFSHelper.setFormulaOfCell(cell2, formula);
            }
            bgItemMap.put(obj.getRptNumber(), null);
        }
    }

    private static List getItemMappingList(Context ctx, String queryNumbers) throws BOSException, EASBizException {
        Connection conn = null;
        StringBuffer sql = new StringBuffer("select m.FBgName as FBgName,m.FBgNumber as FBgNumber ,m.FRptNumber as FRptNumber,m.FRptName as FRptName,m.FBgItemId as FBgItemId,m.FID as FID  from T_BG_BgItemMapping m ");
        ArrayList<BgItemMappingObject> list = new ArrayList<BgItemMappingObject>();
        if (queryNumbers == null || queryNumbers.trim().length() <= 2) {
            return list;
        }
        sql.append(" where m.FRptNumber in " + queryNumbers + " ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                BgItemMappingObject obj = new BgItemMappingObject();
                obj.setBgFormIdStr(row.getString("FBgItemId"));
                obj.setBgName(row.getString("FBgName"));
                obj.setBgNumber(row.getString("FBgNumber"));
                obj.setRptName(row.getString("FRptName"));
                obj.setRptNumber(row.getString("FRptNumber"));
                list.add(obj);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqle);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
                }
            }
        }
        return list;
    }

    private static void checkAllBgItemExit(Context ctx, HashMap bgItemMap, String tableName, HashMap mapTemPeriod, StringBuffer msg) throws EASBizException, BOSException {
        if (bgItemMap == null || bgItemMap.isEmpty()) {
            return;
        }
        StringBuffer str = new StringBuffer("select distinct fid,fnumber from " + tableName + " ");
        boolean isfirst = true;
        boolean canRepeat = BgSHelper.isBgItemNumberRepeat((Context)ctx);
        Connection conn = null;
        Iterator iter = bgItemMap.keySet().iterator();
        while (iter.hasNext()) {
            if (isfirst) {
                isfirst = false;
                str.append(" where fnumber='" + iter.next() + "' ");
                continue;
            }
            str.append(" or fnumber='" + iter.next() + "' ");
        }
        IRowSet row = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Set orgSet = BgImportFromRptHelper.getOrgUnitIds(conn, ContextUtil.getCurrentCostUnit((Context)ctx).getId(), canRepeat);
            if (orgSet != null && orgSet.size() > 0) {
                str.append(" and FCurOrgUnitId IN (");
                Iterator<Object> iter2 = orgSet.iterator();
                while (iter2.hasNext()) {
                    str.append("'" + iter2.next() + "',");
                }
                str.delete(str.length() - 1, str.length());
                str.append(")");
            }
            row = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (row.next()) {
                mapTemPeriod.put(row.getString("fnumber"), row.getString("fid"));
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)sqlE);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqlE);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String number2 = null;
        if (msg == null) {
            msg = new StringBuffer();
        }
        for (String number2 : bgItemMap.keySet()) {
            if (mapTemPeriod.get(number2) == null || mapTemPeriod.get(number2).toString().length() < 0) {
                msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGITEMNOTEXIT, (Object[])new String[]{number2}).getMessage() + "\n\r");
                continue;
            }
            if (!bgItemMap.containsKey(number2) || bgItemMap.get(number2) == null) continue;
            bgItemMap.put(number2, null);
        }
    }

    private static void checkAllElementExit(Context ctx, HashMap bgElementMap, HashMap temMap, StringBuffer msg, String bgTempNumber) throws EASBizException, BOSException {
        if (bgElementMap == null || bgElementMap.isEmpty()) {
            return;
        }
        if (msg == null) {
            msg = new StringBuffer();
        }
        StringBuffer str = new StringBuffer("select  fid,FElementTypeNumber,FBgElementNumber,FGetDataType from T_BG_ElementMap ");
        boolean isfirst = true;
        String key2 = null;
        String[] param = null;
        int dataType = -1;
        int rptType = 0;
        if (bgTempNumber == null) {
            rptType = -1;
        } else if (bgTempNumber.endsWith("_gb")) {
            rptType = 0;
        } else if (bgTempNumber.endsWith("_hz")) {
            rptType = 20;
        } else if (bgTempNumber.endsWith("_hb")) {
            rptType = 10;
        }
        String getDataTypeNumber = null;
        Iterator iter = bgElementMap.keySet().iterator();
        while (iter.hasNext()) {
            dataType = -1;
            getDataTypeNumber = null;
            key2 = (String)iter.next();
            if (key2 == null || key2.trim().length() < 1 || key2.split(TAGE).length < 2) continue;
            param = key2.split(TAGE);
            dataType = Integer.parseInt(param[1]);
            getDataTypeNumber = param[0];
            if (isfirst) {
                isfirst = false;
                str.append("\n\r\t where (FRptTmpType=" + rptType + " and  FGetDataType = " + dataType + " and FElementTypeNumber ='" + getDataTypeNumber + "') ");
                continue;
            }
            str.append("\n\r\t or (FRptTmpType=" + rptType + " and  FGetDataType = " + dataType + " and FElementTypeNumber ='" + getDataTypeNumber + "') ");
        }
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (row.next()) {
                temMap.put(row.getString("FElementTypeNumber") + TAGE + row.getString("FGetDataType"), row.getString("FBgElementNumber"));
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)sqlE);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqlE);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        for (String key2 : bgElementMap.keySet()) {
            if (temMap.get(key2) != null) continue;
            param = key2.split(TAGE);
            msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGELEMENTNOTEXIT, (Object[])new String[]{key2, param[0], ValueTypeEnum.getEnum((int)Integer.parseInt(param[1])).getAlias()}).getMessage() + "\n\r");
        }
    }

    public static ItemFormula convertReportItemFormulaToTemplate(ItemFormula reportItemFormula, Cell templateCell, HashMap getReportDataTypeDataValueToBgElementMap, HashMap bgPeriodMap, HashMap bgItemMap) {
        Expression exp;
        if (StringUtils.isEmpty((String)reportItemFormula.getFormula())) {
            return null;
        }
        try {
            exp = ExcelFormulaPaserHelper.parse((String)reportItemFormula.getFormula().substring(1));
        }
        catch (Exception e) {
            return null;
        }
        String[] valueString = null;
        if (exp instanceof FunctionExpr) {
            FunctionExpr foo = (FunctionExpr)exp;
            List params = foo.parameters;
            valueString = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                valueString[i] = params.get(i).toString();
            }
        } else {
            return null;
        }
        String yearNum = null;
        String periodNum = null;
        if (valueString == null || valueString.length != 5) {
            return null;
        }
        yearNum = valueString[1];
        periodNum = valueString[2];
        String itemNumberReport = reportItemFormula.getItemNumber();
        String datatypeNumber = reportItemFormula.getDataElementNumber();
        int year = 0;
        int period = 0;
        try {
            year = Integer.valueOf(yearNum);
            period = Integer.valueOf(periodNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int valueType = reportItemFormula.getValueType();
        String bgItemNumber = itemNumberReport;
        if (bgItemMap == null) {
            bgItemMap = new HashMap<String, Vector>();
        }
        Vector cellItemVec = null;
        if (bgItemMap.containsKey(bgItemNumber)) {
            cellItemVec = (Vector)bgItemMap.get(bgItemNumber);
        } else {
            cellItemVec = new Vector();
            bgItemMap.put(bgItemNumber, cellItemVec);
        }
        cellItemVec.add(templateCell);
        String bgPeriodNumber = "";
        if (year >= 1900) {
            if (period > 0) {
                bgPeriodNumber = bgPeriodNumber + year + "Y";
                bgPeriodNumber = bgPeriodNumber + ".";
                if (period < 10) {
                    bgPeriodNumber = bgPeriodNumber + "0";
                }
                bgPeriodNumber = bgPeriodNumber + period + "M";
            } else {
                bgPeriodNumber = period + "";
            }
        } else {
            bgPeriodNumber = period + "";
        }
        if (bgPeriodMap == null) {
            bgPeriodMap = new HashMap<String, Vector>();
        }
        Vector cellPeriodVec = null;
        try {
            Integer.parseInt(bgPeriodNumber);
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e);
            if (bgPeriodMap.containsKey(bgPeriodNumber) && bgPeriodMap.get(bgPeriodNumber) != null) {
                cellPeriodVec = (Vector)bgPeriodMap.get(bgPeriodNumber);
            } else {
                cellPeriodVec = new Vector();
                bgPeriodMap.put(bgPeriodNumber, cellPeriodVec);
            }
            cellPeriodVec.add(templateCell);
        }
        if (getReportDataTypeDataValueToBgElementMap == null) {
            getReportDataTypeDataValueToBgElementMap = new HashMap<String, Vector>();
        }
        String elementNumber = datatypeNumber + TAGE + valueType;
        Vector cellVec = null;
        if (getReportDataTypeDataValueToBgElementMap.containsKey(elementNumber)) {
            cellVec = (Vector)getReportDataTypeDataValueToBgElementMap.get(elementNumber);
        } else {
            cellVec = new Vector();
            getReportDataTypeDataValueToBgElementMap.put(elementNumber, cellVec);
        }
        cellVec.add(templateCell);
        getReportDataTypeDataValueToBgElementMap.put(elementNumber, cellVec);
        String itemFormula = "=BgItem(\"" + bgItemNumber + "\",\"" + bgPeriodNumber + "\",\"\",\"BgData\",true,\"\")";
        ItemFormula item = new ItemFormula(itemFormula);
        item.putExt(TAGE, elementNumber);
        return item;
    }

    public static void setTemplateBook(Context ctx, BgTemplateInfo info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select fnumber from t_bg_Bgitem ");
        ArrayList<String> itemList = new ArrayList<String>();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                itemList.add(row.getString("fnumber"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        sql = new StringBuffer("select fnumber from t_bg_Bgelement ");
        ArrayList<String> elementList = new ArrayList<String>();
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                elementList.add(row.getString("fnumber"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        sql = new StringBuffer("select fnumber from t_bg_Bgperiod ");
        ArrayList<String> periodList = new ArrayList<String>();
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                periodList.add(row.getString("fnumber"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        sql = new StringBuffer("select fnumber from T_BD_Currency ");
        ArrayList<String> currencyList = new ArrayList<String>();
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                currencyList.add(row.getString("fnumber"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        ArrayList<String> itemFormulaList = new ArrayList<String>();
        ArrayList<String> itemFormulaNotInList = new ArrayList<String>();
        ArrayList<ArrayList<String>> listMap = new ArrayList<ArrayList<String>>();
        String itemformul = null;
        int itemSize = 0;
        int isize = currencyList.size();
        for (int i = 0; i < isize; ++i) {
            int jsize = periodList.size();
            for (int j = 0; j < jsize; ++j) {
                int k = 0;
                int ksize = elementList.size();
                while (k < ksize) {
                    int msize = itemList.size();
                    for (int m = 0; m < msize; ++m) {
                        itemformul = "=BgItem(\"" + itemList.get(m) + "\",\"" + periodList.get(j) + "\",\"" + elementList.get(k) + "\",\"BgData\",true,\"" + currencyList.get(i) + "\")";
                        if (itemSize < 10000) {
                            itemFormulaList.add(itemformul);
                        } else {
                            itemFormulaNotInList.add(itemformul);
                        }
                        if (++itemSize > 11000) break;
                    }
                    if (itemSize > 10000) break;
                    ++i;
                }
                if (itemSize > 10000) break;
            }
            if (itemSize > 10000) break;
        }
        listMap.add(itemFormulaList);
        listMap.add(itemFormulaNotInList);
        Book book = null;
        try {
            book = Book.Manager.getNewBook();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        Cell cell = null;
        int itemIndex = 0;
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                cell = book.getSheet(0).getCell(i, j, true);
                if (itemIndex == 9999) break;
                BgNFSHelper.setFormulaOfCell(cell, (String)itemFormulaList.get(itemIndex), true);
            }
            if (itemIndex == 9999) break;
        }
        try {
            info.setBook(book);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        byte[] mapData = null;
        try {
            if (mapData != null) {
                ByteArrayOutputStream bais = new ByteArrayOutputStream();
                ObjectOutputStream ois = new ObjectOutputStream(bais);
                ois.writeObject(itemFormulaNotInList);
                mapData = bais.toByteArray();
                ois.close();
                bais.close();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        info.setMapData(mapData);
        BgTemplateFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
    }

    public static BgTemplateInfo updateTemForTest(Context ctx, BgTemplateInfo info) {
        List itemFormulaNotInList = new ArrayList();
        try {
            byte[] mapData = info.getMapData();
            ByteArrayInputStream in = new ByteArrayInputStream(mapData);
            ObjectInputStream oin = new ObjectInputStream(in);
            Object obj = oin.readObject();
            itemFormulaNotInList = (List)obj;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        int size = 500 > itemFormulaNotInList.size() ? itemFormulaNotInList.size() : 500;
        Book book = null;
        try {
            book = Book.Manager.getNewBook();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        Cell cell = null;
        int itemIndex = 0;
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                cell = book.getSheet(0).getCell(i, j, true);
                if (itemIndex == size) break;
                BgNFSHelper.setFormulaOfCell(cell, (String)itemFormulaNotInList.get(itemIndex), true);
            }
            if (itemIndex == size) break;
        }
        try {
            info.setBook(book);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return info;
    }
}

