/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.nbudget.app.AbstractBgAreaFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAreaFacadeControllerBean
extends AbstractBgAreaFacadeControllerBean {
    private static final long serialVersionUID = 2736797116923884712L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgAreaFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getUnionCollection(Context ctx, BOSUuid orgTreeId) throws BOSException, EASBizException {
        ArrayList<OrgUnitInfo> unionList = new ArrayList<OrgUnitInfo>();
        if (orgTreeId == null) {
            return unionList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        OrgUnitInfo unitInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FUnitID, u.FName_" + ctx.getLocale() + ", u.FNumber, u.FLongNumber, s.FLevel from T_ORG_Structure s left join T_ORG_BaseUnit u on s.FUnitId = u.FID where s.FTreeId = ? and u.fisgrouping = 1 order by s.FLongNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgTreeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                unitInfo = new OrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rst.getString("FUnitID")));
                unitInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                unitInfo.setNumber(rst.getString("FNumber"));
                unitInfo.setLongNumber(rst.getString("FLongNumber"));
                unitInfo.setLevel(rst.getInt("FLevel"));
                unionList.add(unitInfo);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return unionList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _updateArea(Context ctx, List areaList) throws BOSException, EASBizException {
        if (areaList == null) return true;
        if (areaList.isEmpty()) {
            return true;
        }
        int batchIndex = 0;
        int batchSize = 200;
        String _areaId2222222 = null;
        String[] areaInfo = null;
        HashSet<String> areaSet = new HashSet<String>();
        int in = areaList.size();
        for (int i = 0; i < in; ++i) {
            areaInfo = (String[])areaList.get(i);
            areaSet.add(areaInfo[0]);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement("delete from T_BG_BgJCArea where FAreaID = ?");
                for (String _areaId2222222 : areaSet) {
                    pstmt.setString(1, _areaId2222222);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
            try {
                pstmt = conn.prepareStatement("insert into T_BG_BgJCArea(FAreaID, FUnitID, FOrgUnitID) values (?, ?, ?)");
                int jn = areaList.size();
                for (int j = 0; j < jn; ++j) {
                    areaInfo = (String[])areaList.get(j);
                    if (areaInfo[2] == null) continue;
                    pstmt.setString(1, areaInfo[0]);
                    pstmt.setString(2, areaInfo[1]);
                    pstmt.setString(3, areaInfo[2]);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected IObjectCollection _getOrgTreeInfo(Context ctx, IObjectPK userId) throws BOSException, EASBizException {
        OrgTreeCollection _orgTreeeCol = new OrgTreeCollection();
        if (userId == null) {
            userId = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        OrgTreeInfo _orgTreeInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Tree.FID, Tree.FNumber, Tree.FName_").append(ctx.getLocale()).append(", Tree.FStartDate, Tree.FEndDate").append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID ").append(" INNER JOIN T_ORG_Tree Tree ON Tree.FId = Structure.FTreeId ").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ? ").append(" AND OrgRange.FType = ? and (Tree.FStatus = 1 or Tree.FStartDate IS NOT NULL) ORDER BY Tree.FNumber ASC,Tree.FStartDate DESC");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId.toString());
            pstmt.setInt(2, 10);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgTreeInfo = new OrgTreeInfo();
                _orgTreeInfo.setId(BOSUuid.read((String)rst.getString(1)));
                _orgTreeInfo.setNumber(rst.getString(2));
                _orgTreeInfo.setName(rst.getString(3));
                _orgTreeInfo.setStartDate(rst.getTimestamp(4));
                _orgTreeInfo.setEndDate(rst.getTimestamp(5));
                _orgTreeeCol.add(_orgTreeInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _orgTreeeCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getUnionInfo(Context ctx, List AreaIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap<String, CostCenterOrgUnitInfo> resultMap;
        block11: {
            resultMap = new HashMap<String, CostCenterOrgUnitInfo>();
            if (AreaIds == null) return resultMap;
            if (AreaIds.isEmpty()) {
                return resultMap;
            }
            conn = null;
            pstmt = null;
            rst = null;
            String _areaId = null;
            String _unitId = null;
            String _orgUnitId = null;
            String _key2222222 = null;
            HashSet<String> ccorgUnitIdSet = new HashSet<String>();
            HashMap<String, String> _tmpMap = new HashMap<String, String>();
            HashMap<String, CostCenterOrgUnitInfo> ccOrgUnitMap = new HashMap<String, CostCenterOrgUnitInfo>();
            ICostCenterOrgUnit iccOrgUnit = null;
            CostCenterOrgUnitInfo ccOrgUnitInfo2222222 = null;
            CostCenterOrgUnitCollection ccOrgUnitCol = null;
            EntityViewInfo view = null;
            FilterInfo filter = null;
            SelectorItemCollection sic = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select FAreaID, FUnitID, FOrgUnitID from T_BG_BgJCArea where FAreaID in (");
            Iterator iter = AreaIds.iterator();
            while (iter.hasNext()) {
                sql.append("'" + iter.next() + "',");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _areaId = rst.getString("FAreaID");
                    _unitId = rst.getString("FUnitID");
                    _orgUnitId = rst.getString("FOrgUnitID");
                    ccorgUnitIdSet.add(_orgUnitId);
                    _tmpMap.put(_areaId + "_" + _unitId, _orgUnitId);
                }
                if (ccorgUnitIdSet.isEmpty()) break block11;
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", ccorgUnitIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                sic.add("number");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                ccOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(view);
                if (ccOrgUnitCol != null) {
                    for (CostCenterOrgUnitInfo ccOrgUnitInfo2222222 : ccOrgUnitCol) {
                        ccOrgUnitMap.put(ccOrgUnitInfo2222222.getId().toString(), ccOrgUnitInfo2222222);
                    }
                    for (String _key2222222 : _tmpMap.keySet()) {
                        _orgUnitId = (String)_tmpMap.get(_key2222222);
                        if (!ccOrgUnitMap.containsKey(_orgUnitId)) continue;
                        ccOrgUnitInfo2222222 = (CostCenterOrgUnitInfo)ccOrgUnitMap.get(_orgUnitId);
                        resultMap.put(_key2222222, ccOrgUnitInfo2222222);
                    }
                }
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (SQLException ex2) {
                        logger.error((Object)ex2);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return resultMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _getUnionId(Context ctx, String treeId, String unitId) throws BOSException, EASBizException {
        String id = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select funitId from T_BG_BgJCArea where forgunitid  = ? and fareaid = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, unitId);
            pstmt.setString(2, treeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                id = rst.getString("funitId");
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return id;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getMappingInfo(Context ctx, String[] costOrgNumbers) throws BOSException, EASBizException {
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        if (costOrgNumbers == null) return mappingMap;
        if (costOrgNumbers.length == 0) {
            return mappingMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select tree.FNumber as treeNumber,baseUnit.FNumber as baseNumber,cost.FNumber as costNumber from T_BG_BgJCArea area left join T_ORG_Tree tree on area.FAreaID = tree.FID left join T_ORG_BaseUnit baseUnit on area.FUnitID = baseUnit.FID left join T_ORG_CostCenter cost on area.FOrgUnitID = cost.FID where cost.FNumber in (");
        int length = costOrgNumbers.length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        String treeNumber = null;
        String baseNumber = null;
        String costNumber = null;
        String key = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int length2 = costOrgNumbers.length;
            for (int i = 0; i < length2; ++i) {
                pstmt.setString(i + 1, costOrgNumbers[i]);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                treeNumber = rst.getString("treeNumber");
                baseNumber = rst.getString("baseNumber");
                costNumber = rst.getString("costNumber");
                key = treeNumber + "@" + costNumber;
                mappingMap.put(key, baseNumber);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return mappingMap;
    }
}

