/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgExamineCitationCollection;
import com.kingdee.eas.ma.budget.BgExamineCitationInfo;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgExamineInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgUtilsHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.nbudget.BgCslFormExamineResultFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.BgCslTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.IBgCslForm;
import com.kingdee.eas.ma.nbudget.IBgCslTemplate;
import com.kingdee.eas.ma.nbudget.app.AbstractBgCslFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgCslFacadeControllerBean
extends AbstractBgCslFacadeControllerBean {
    private static final long serialVersionUID = -5959099661331660400L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgCslFacadeControllerBean");
    private static final String tmpId = "HGFEDCBA";
    private static int budgetValue = 0;
    private static int actualValue = 1;
    private static final String MATCH_STR = "\\-?\\d+";
    private Calendar calendar = Calendar.getInstance();

    @Override
    protected boolean _canExamine(Context ctx, String[] formIds) throws BOSException, EASBizException {
        if (formIds == null || formIds.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer(" SELECT FBgExamineId FROM T_BG_BgExamineNode WHERE FBgTemplateId IN ");
        sql.append("( SELECT FBgCslTemplateID FROM T_BG_BGCslForm WHERE FID IN " + BgHelper.tranArray2String((String[])formIds) + " ) ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BgException(BgException.DATABASEERROR, (Throwable)e);
        }
        return false;
    }

    protected String[] getBgExamineCheckTableName(Context ctx, Connection conn) throws EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String[] result = new String[2];
        try {
            StringBuffer createSql = new StringBuffer();
            createSql.append("Create Table BgExamineCheck  (FGroupId varChar(44), FSeq int, FOrgUnitId VarChar(44), FBgSchemeId VarChar(44), FBgCslFormId VarChar(44), FFormula nVarchar(200), FValue decimal(21,6), FItemCombinNumber nVarChar(200), FElementNumber nVarChar(80), FBgPeriodNumber nVarChar(80), FCurrencyNumber nVarChar(80))");
            String tabname = pool.createTempTable(createSql.toString());
            pool.createIndex(tabname, "FOrgUnitId, FBgSchemeId, FFormula", false, false);
            pool.createIndex(tabname, "FGroupId, FSeq", false, true);
            result[0] = tabname;
            result[1] = "true";
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            result[0] = "";
            result[1] = "false";
        }
        return result;
    }

    protected boolean createTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        if (tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer cIndex = new StringBuffer();
        StringBuffer index = new StringBuffer();
        sql.append("Create Table " + tableName + " (FGroupId varChar(44), FSeq int, FOrgUnitId VarChar(44), FBgSchemeId VarChar(44), FBgCslFormId VarChar(44), FFormula nVarchar(200), FValue decimal(21,6), FItemCombinNumber nVarChar(200), FElementNumber nVarChar(80), FBgPeriodNumber nVarChar(80), FCurrencyNumber nVarChar(80))");
        cIndex.append("CREATE Clustered INDEX PX_" + tableName + " ON " + tableName + "(FGroupId, FSeq)");
        index.append("CREATE INDEX IX_" + tableName + " ON " + tableName + "(FOrgUnitId, FBgSchemeId, FFormula)");
        try {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(sql.toString());
            SQLUtils.execute((Connection)conn, (String)cIndex.toString());
            SQLUtils.execute((Connection)conn, (String)index.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (BOSException e) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
        }
        return true;
    }

    protected boolean removeTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
        return true;
    }

    protected void clearTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Truncate Table " + tableName);
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected Object[] _examines(Context ctx, BOSUuid[] id, String xNum) throws BOSException, EASBizException {
        if (id == null || id.length == 0) {
            throw new BgExamineException(BgExamineException.BGFORMINFOIDCANTISNULL);
        }
        Map currencyMap = null;
        Map tmpMap = null;
        currencyMap = BgSHelper.getCurrencyInfo((Context)ctx, currencyMap, null);
        Object[] examineCheck = new Object[3];
        examineCheck[0] = Boolean.TRUE;
        examineCheck[2] = currencyMap;
        for (int i = 0; i < id.length; ++i) {
            this._examine(ctx, id[i], examineCheck, xNum);
        }
        if (examineCheck[1] instanceof HashMap) {
            tmpMap = (Map)examineCheck[1];
            examineCheck[1] = BgUtilsHelper.encodeObject((Object)tmpMap);
        }
        examineCheck[2] = null;
        return examineCheck;
    }

    @Override
    protected Object[] _examine(Context ctx, BOSUuid id, Object[] check, String xNum) throws BOSException, EASBizException {
        Object[] examineCheck;
        block12: {
            if (id == null) {
                throw new BgExamineException(BgExamineException.BGFORMINFOIDCANTISNULL);
            }
            Connection conn = null;
            IBgCslForm iForm = BgCslFormFactory.getLocalInstance(ctx);
            IBgCslTemplate iTemplate = BgCslTemplateFactory.getLocalInstance(ctx);
            BgCslFormInfo bgCslFormInfo = null;
            BgExamineInfo bgExamineInfo2 = null;
            BgExamineCollection bgExamineCol = null;
            String tmpTableName = null;
            boolean isCreate = false;
            Map examineMap = null;
            examineCheck = check == null ? new Object[2] : check;
            Object object = examineCheck[0] = examineCheck[0] == null ? Boolean.TRUE : examineCheck[0];
            if (examineCheck[1] == null || !(examineCheck[1] instanceof HashMap)) {
                examineMap = new HashMap();
                examineMap.put("EXAMINE_PASS", new HashMap());
                examineMap.put("EXAMINE_PASS_SET", new HashMap());
                examineMap.put("EXAMINE_NOPASS", new HashMap());
                examineCheck[1] = examineMap;
            } else {
                examineMap = (Map)examineCheck[1];
            }
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                conn = this.getConnection(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                sic.add("number");
                sic.add("orgUnit.id");
                sic.add("bgScheme.id");
                sic.add("bgCslTemplate.id");
                sic.add("bgPeriod.number");
                sic.add("bgPeriod.periodType");
                sic.add("state");
                sic.add("dataType");
                bgCslFormInfo = iForm.getBgCslFormInfo((IObjectPK)pk, sic);
                bgExamineCol = iTemplate.getExamine(bgCslFormInfo.getBgCslTemplate().getId().toString());
                if (bgExamineCol == null || bgExamineCol.isEmpty()) break block12;
                String[] result = this.getBgExamineCheckTableName(ctx, conn);
                tmpTableName = result[0];
                isCreate = Boolean.valueOf(result[1]);
                if (isCreate) {
                    for (BgExamineInfo bgExamineInfo2 : bgExamineCol) {
                        this.checkBgExamine(bgExamineInfo2);
                        this.builderExamineData(ctx, conn, tmpTableName, bgExamineInfo2, bgCslFormInfo, xNum);
                        this.checkBgExamineData(ctx, conn, tmpTableName, examineCheck, examineMap, bgExamineInfo2, bgCslFormInfo, xNum);
                    }
                    break block12;
                }
                throw new BgExamineException(BgExamineException.ERROROFCREATETABLE);
            }
            catch (BOSException ex) {
                throw new BgExamineException(BgExamineException.ERROROFCIAATION);
            }
            catch (EASBizException ex) {
                throw new BgExamineException(BgExamineException.ERROROFCIAATION);
            }
            finally {
                if (isCreate) {
                    this.removeTable(ctx, tmpTableName, conn);
                }
                SQLUtils.cleanup((Connection)conn);
            }
        }
        BgCslFormExamineResultFactory.getLocalInstance(ctx).saveExamineResult(id.toString(), examineCheck);
        return examineCheck;
    }

    protected void checkBgExamine(BgExamineInfo bgExamineInfo) throws EASBizException {
        if (bgExamineInfo == null) {
            return;
        }
        if (bgExamineInfo.getFormula() == null || bgExamineInfo.getFormula().trim().length() == 0 || bgExamineInfo.getFormulaAlias() == null || bgExamineInfo.getFormulaAlias().trim().length() == 0) {
            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
        }
        if (bgExamineInfo.getErrorData() == null) {
            throw new BgExamineException(BgExamineException.ERROROFCONFINE);
        }
        if (bgExamineInfo.getCitation() == null || bgExamineInfo.getCitation().size() == 0) {
            throw new BgExamineException(BgExamineException.ERROROFCIAATION);
        }
        BgExamineCitationInfo bgExamCitaInfo = null;
        int n = bgExamineInfo.getCitation().size();
        for (int i = 0; i < n; ++i) {
            bgExamCitaInfo = bgExamineInfo.getCitation().get(i);
            if (bgExamCitaInfo.getFormula() != null && bgExamCitaInfo.getFormula().trim().length() != 0 && bgExamCitaInfo.getFormulaAlias() != null && bgExamCitaInfo.getFormulaAlias().trim().length() != 0) continue;
            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
        }
    }

    protected void builderExamineData(Context ctx, Connection conn, String tmpTableName, BgExamineInfo bgExamineInfo, BgCslFormInfo bgCslFormInfo, String num) throws BOSException, EASBizException {
        Object formulaMap = null;
        HashMap formulaParMap = new HashMap();
        try {
            this.clearTable(ctx, tmpTableName, conn);
            this.builderTmpFormulaData(ctx, conn, tmpTableName, bgCslFormInfo, bgExamineInfo, num);
            this.builderUpdateFormulaGroupId(conn, tmpTableName, bgExamineInfo);
            this.builderOtherFormulaData(ctx, conn, tmpTableName, bgCslFormInfo, bgExamineInfo, num);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void builderUpdateFormulaGroupId(Connection conn, String tmpTableName, BgExamineInfo bgExamineInfo) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        PreparedStatement pstup = null;
        ResultSet rst = null;
        BgExamineCitationInfo bgExCitInfo = null;
        BgExamineCitationCollection bgExCitColl = null;
        HashSet<String> groupIdSet = new HashSet<String>();
        HashMap<Integer, String> orgUnitMap = new HashMap<Integer, String>();
        HashMap<Integer, String> bgSchemeMap = new HashMap<Integer, String>();
        int batchSize = 250;
        int batchIndex = 0;
        Integer _seq = null;
        String _tmpStr = null;
        String _groupId = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _bgItemNumber = null;
        String _bgEleNumber = null;
        String _bgPerNumber = null;
        String _currNumber = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer upsql = new StringBuffer();
        sql.append("select FGroupId, FOrgUnitId, FBgSchemeId, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber from ").append(tmpTableName).append(" where FSeq = ?");
        upsql.append("update " + tmpTableName + " set FGroupId = ? where FOrgUnitId = ? and FBgSchemeId = ? and ").append("FItemCombinNumber = ? and FElementNumber = ? and FBgPeriodNumber = ? and FCurrencyNumber = ?");
        bgExCitColl = bgExamineInfo.getCitation();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstup = conn.prepareStatement(upsql.toString());
            int in = bgExCitColl.size();
            for (int i = 1; i <= in; ++i) {
                pstmt.setInt(1, i);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _groupId = rst.getString(1);
                    _orgUnitId = rst.getString(2);
                    _bgSchemeId = rst.getString(3);
                    _bgItemNumber = rst.getString(4);
                    _bgEleNumber = rst.getString(5);
                    _bgPerNumber = rst.getString(6);
                    _currNumber = rst.getString(7);
                    if (groupIdSet.contains(_groupId)) continue;
                    groupIdSet.add(_groupId);
                    for (int j = i + 1; j < in; ++j) {
                        _seq = new Integer(j);
                        bgExCitInfo = bgExCitColl.get(j);
                        pstup.setString(1, BOSUuid.read((String)_groupId).toString());
                        if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                            pstup.setString(2, BOSUuid.read((String)_orgUnitId).toString());
                            pstup.setString(3, BOSUuid.read((String)_bgSchemeId).toString());
                        } else {
                            if (orgUnitMap.containsKey(_seq)) {
                                _tmpStr = bgExCitInfo.getOrgUnit().getId().toString();
                                orgUnitMap.put(_seq, _tmpStr);
                            } else {
                                _tmpStr = (String)orgUnitMap.get(_seq);
                            }
                            pstup.setString(2, BOSUuid.read((String)_tmpStr).toString());
                            if (bgSchemeMap.containsKey(_seq)) {
                                _tmpStr = bgExCitInfo.getBgScheme().getId().toString();
                                bgSchemeMap.put(_seq, _tmpStr);
                            } else {
                                _tmpStr = (String)bgSchemeMap.get(_seq);
                            }
                            pstup.setString(3, BOSUuid.read((String)_tmpStr).toString());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgItemCombinNumber())) {
                            pstup.setString(4, _bgItemNumber);
                        } else {
                            pstup.setString(4, bgExCitInfo.getBgItemCombinNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgElementNumber())) {
                            pstup.setString(5, _bgEleNumber);
                        } else {
                            pstup.setString(5, bgExCitInfo.getBgElementNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgPeriodNumber())) {
                            pstup.setString(6, _bgPerNumber);
                        } else {
                            pstup.setString(6, bgExCitInfo.getBgPeriodNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getCurrencyNumber())) {
                            pstup.setString(7, _currNumber);
                        } else {
                            pstup.setString(7, bgExCitInfo.getCurrencyNumber());
                        }
                        pstup.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstup.executeBatch();
                        batchIndex = 0;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (batchIndex < 0) continue;
                pstup.executeBatch();
            }
            if (batchIndex >= 0) {
                pstup.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                SQLUtils.cleanup(pstup);
                groupIdSet.clear();
                orgUnitMap.clear();
                bgSchemeMap.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)pstup);
        groupIdSet.clear();
        orgUnitMap.clear();
        bgSchemeMap.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void builderTmpFormulaData(Context ctx, Connection conn, String tmpTableName, BgCslFormInfo bgCslFormInfo, BgExamineInfo bgExamineInfo, String num) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        int bgPeriodType = 0;
        StringBuffer sql = null;
        StringBuffer sql1 = null;
        StringBuffer other = null;
        BgExamineCitationInfo bgExCitInfo2 = null;
        this.updateBgExamineCitation(ctx, conn, bgExamineInfo, num, bgCslFormInfo);
        try {
            for (BgExamineCitationInfo bgExCitInfo2 : bgExamineInfo.getCitation()) {
                ArrayList<Object> _tmpList = new ArrayList<Object>();
                bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(bgExCitInfo2.getBgPeriodNumber());
                sql = new StringBuffer();
                sql1 = new StringBuffer();
                other = new StringBuffer();
                sql.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgCslFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) ");
                sql.append("Select newbosid('HGFEDCBA'), ");
                sql1.append(", t.FOrgGroupID, t.FBgSchemeId, t.FBgCslFormId, t.FFormula, t.FConsolidAmount, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgCslData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where t.FOrgGroupID = ? and t.FBgSchemeId = ? and t.FDataType = ? and t.FFormula like ?");
                other.append(", t.FOrgGroupID, t.FBgSchemeId, t.FBgCslFormId, t.FFormula, t.FConsolidAmount, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgCslData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where ");
                if (bgPeriodType == 0) {
                    if (bgExCitInfo2.getOrgUnit() == null || bgExCitInfo2.getBgScheme() == null) {
                        sql.append(String.valueOf(bgExCitInfo2.getSeq()));
                        sql.append(sql1);
                        sql.append(" and t.FFormula in (Select FFormula from T_BG_BGCslData where FBgCslFormId = ?)");
                        _tmpList.add(bgCslFormInfo.getOrgUnit().getId().toString());
                        _tmpList.add(bgCslFormInfo.getBgScheme().getId().toString());
                        _tmpList.add(new Integer(bgCslFormInfo.getDataType().getValue()));
                        _tmpList.add(bgExCitInfo2.getFormula());
                        _tmpList.add(bgCslFormInfo.getId().toString());
                    } else {
                        sql.append(String.valueOf(bgExCitInfo2.getSeq()));
                        sql.append(other);
                        sql.append(" t.FOrgGroupID = ? and t.FBgSchemeId = ? and t.FFormula like ? and t.FFormula in (Select FFormula from T_BG_BGCslData where FBgCslFormId = ?)");
                        _tmpList.add(bgExCitInfo2.getOrgUnit().getId().toString());
                        _tmpList.add(bgExCitInfo2.getBgScheme().getId().toString());
                        _tmpList.add(bgExCitInfo2.getFormula());
                        _tmpList.add(bgCslFormInfo.getId().toString());
                    }
                } else if (bgExCitInfo2.getOrgUnit() == null || bgExCitInfo2.getBgScheme() == null) {
                    sql.append(String.valueOf(bgExCitInfo2.getSeq()));
                    sql.append(sql1);
                    sql.append(" and t.FFormula in (Select FFormula from T_BG_BGCslData where FBgCslFormId = ? and p.FPeriodType = ?");
                    _tmpList.add(bgCslFormInfo.getOrgUnit().getId().toString());
                    _tmpList.add(bgCslFormInfo.getBgScheme().getId().toString());
                    _tmpList.add(new Integer(bgCslFormInfo.getDataType().getValue()));
                    _tmpList.add(bgExCitInfo2.getFormula());
                    _tmpList.add(bgCslFormInfo.getId().toString());
                    _tmpList.add(new Integer(bgPeriodType));
                } else {
                    sql.append(String.valueOf(bgExCitInfo2.getSeq()));
                    sql.append(other);
                    sql.append(" t.FOrgGroupID = ? and t.FBgSchemeId = ? and t.FFormula like ? and t.FFormula in (Select FFormula from T_BG_BGCslData where FBgCslFormId = ?)");
                    sql.append(" and p.FPeriodType = ?");
                    _tmpList.add(bgExCitInfo2.getOrgUnit().getId().toString());
                    _tmpList.add(bgExCitInfo2.getBgScheme().getId().toString());
                    _tmpList.add(bgExCitInfo2.getFormula());
                    _tmpList.add(bgCslFormInfo.getId().toString());
                    _tmpList.add(new Integer(bgPeriodType));
                }
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    BgNSQLHelper.setParams(pstmt, _tmpList);
                    pstmt.executeUpdate();
                }
                catch (SQLException ex) {
                    try {
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt);
                        throw throwable;
                        return;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
    }

    protected void builderOtherFormulaData(Context ctx, Connection conn, String tmpTableName, BgCslFormInfo bgCslFormInfo, BgExamineInfo bgExamineInfo, String num) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        block26: {
            pstmt = null;
            rst = null;
            int batchSize = 250;
            int batchIndex = 0;
            int bgExCitSize = bgExamineInfo.getCitation().size();
            String groupId = null;
            String seqStr = null;
            String builderPeriod = null;
            String formulaString = null;
            String key = null;
            String[] formulaInfo = null;
            Map.Entry entry2 = null;
            List<String[]> formulaList = new ArrayList();
            HashMap groupIdsMap = new HashMap();
            Map<String, String[]> groupIdMap = null;
            HashMap<Integer, BgExamineCitationInfo> bgExamineMap = new HashMap<Integer, BgExamineCitationInfo>();
            HashMap<String, String> bgFormIdsMap = new HashMap<String, String>();
            BgExamineCitationInfo bgExCitInfo2 = null;
            for (BgExamineCitationInfo bgExCitInfo2 : bgExamineInfo.getCitation()) {
                bgExamineMap.put(new Integer(bgExCitInfo2.getSeq()), bgExCitInfo2);
            }
            StringBuffer datasql = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            datasql.append("select * from ").append(tmpTableName).append(" where FGroupId in (").append("select distinct FGroupId from ").append(tmpTableName).append(" group by FGroupId ").append("having count(fseq) < ?)");
            sql.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgCslFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) values (?,?,?,?,?,?,?,?,?,?,?)");
            try {
                String[] tmpFormula;
                try {
                    pstmt = conn.prepareStatement(datasql.toString());
                    pstmt.setInt(1, bgExamineInfo.getCitation().size());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        groupId = rst.getString("FGroupId");
                        seqStr = String.valueOf(rst.getInt("FSeq"));
                        if (groupIdsMap.containsKey(groupId)) {
                            groupIdMap = (Map)groupIdsMap.get(groupId);
                        } else {
                            groupIdMap = new HashMap();
                            groupIdsMap.put(groupId, groupIdMap);
                        }
                        formulaInfo = new String[11];
                        formulaInfo[0] = rst.getString("FGroupId");
                        formulaInfo[1] = seqStr;
                        formulaInfo[2] = rst.getString("FOrgUnitId");
                        formulaInfo[3] = rst.getString("FBgSchemeId");
                        formulaInfo[5] = rst.getString("FFormula");
                        formulaInfo[6] = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)rst.getBigDecimal("FValue"));
                        formulaInfo[7] = rst.getString("FItemCombinNumber");
                        formulaInfo[8] = rst.getString("FElementNumber");
                        formulaInfo[9] = rst.getString("FBgPeriodNumber");
                        formulaInfo[10] = rst.getString("FCurrencyNumber");
                        if ((formulaInfo[7] == null || formulaInfo[7].length() == 0) && formulaInfo[5] != null && formulaInfo[5].length() > 0) {
                            String[] paramter = BgNFSHelper.parseFormulaPara(null, formulaInfo[5]);
                            formulaInfo[7] = paramter[BgSHelper.paraItem];
                        }
                        groupIdMap.put(seqStr, formulaInfo);
                        key = new StringBuffer(formulaInfo[2]).append("_").append(formulaInfo[3]).append("_").append(formulaInfo[5]).toString();
                        if (bgFormIdsMap.containsKey(key)) continue;
                        bgFormIdsMap.put(key, formulaInfo[3]);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                String seqS = null;
                if (groupIdsMap.isEmpty()) break block26;
                for (Map.Entry entry2 : groupIdsMap.entrySet()) {
                    int index;
                    groupId = (String)entry2.getKey();
                    groupIdMap = (Map)entry2.getValue();
                    for (index = 1; index <= bgExCitSize; ++index) {
                        seqStr = String.valueOf(index);
                        if (!groupIdMap.containsKey(seqStr)) continue;
                        formulaInfo = (String[])groupIdMap.get(seqStr);
                        break;
                    }
                    for (index = 1; index <= bgExCitSize; ++index) {
                        seqStr = String.valueOf(index);
                        if (groupIdMap.containsKey(seqStr) || formulaInfo == null) continue;
                        bgExCitInfo2 = (BgExamineCitationInfo)bgExamineMap.get(new Integer(index));
                        builderPeriod = this.parseBgPeriodNumber(formulaInfo[9], bgExCitInfo2.getBgPeriodNumber(), ctx);
                        formulaString = this.builderFormula(bgExCitInfo2, formulaInfo, builderPeriod);
                        tmpFormula = new String[12];
                        tmpFormula[0] = groupId;
                        tmpFormula[1] = String.valueOf(index);
                        tmpFormula[2] = bgExCitInfo2.getOrgUnit() != null ? bgExCitInfo2.getOrgUnit().getId().toString() : bgCslFormInfo.getOrgUnit().getId().toString();
                        tmpFormula[3] = bgExCitInfo2.getBgScheme() != null ? bgExCitInfo2.getBgScheme().getId().toString() : bgCslFormInfo.getBgScheme().getId().toString();
                        tmpFormula[4] = null;
                        tmpFormula[5] = formulaString;
                        tmpFormula[6] = null;
                        seqS = ((Integer)bgExCitInfo2.get("valueType")).toString();
                        key = new StringBuffer(formulaInfo[2]).append("_").append(formulaInfo[3]).append("_").append(formulaInfo[5]).append(seqS).toString();
                        if (bgFormIdsMap.containsKey(key)) {
                            tmpFormula[4] = bgFormIdsMap.get(key).toString();
                        }
                        tmpFormula[7] = !StringUtils.isEmpty((String)bgExCitInfo2.getBgItemCombinNumber()) && !bgExCitInfo2.getBgItemCombinNumber().trim().equals("%") ? bgExCitInfo2.getBgItemCombinNumber() : formulaInfo[7];
                        tmpFormula[8] = !StringUtils.isEmpty((String)bgExCitInfo2.getBgElementNumber()) && !bgExCitInfo2.getBgElementNumber().trim().equals("%") ? bgExCitInfo2.getBgElementNumber() : formulaInfo[8];
                        tmpFormula[9] = builderPeriod;
                        tmpFormula[10] = !StringUtils.isEmpty((String)bgExCitInfo2.getCurrencyNumber()) && !bgExCitInfo2.getCurrencyNumber().trim().equals("%") ? bgExCitInfo2.getCurrencyNumber() : formulaInfo[10];
                        tmpFormula[11] = seqS.toString();
                        formulaList.add(tmpFormula);
                    }
                }
                if (formulaList.isEmpty()) break block26;
                batchIndex = 0;
                formulaList = this.getData(conn, formulaList, bgExamineMap);
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    int n = formulaList.size();
                    for (int i = 0; i < n; ++i) {
                        tmpFormula = (String[])formulaList.get(i);
                        pstmt.setString(1, tmpFormula[0]);
                        pstmt.setInt(2, Integer.valueOf(tmpFormula[1]));
                        pstmt.setString(3, tmpFormula[2]);
                        pstmt.setString(4, tmpFormula[3]);
                        pstmt.setString(5, tmpFormula[4]);
                        pstmt.setString(6, tmpFormula[5]);
                        try {
                            pstmt.setBigDecimal(7, new BigDecimal(tmpFormula[6]));
                        }
                        catch (Exception ex) {
                            pstmt.setBigDecimal(7, BgConstants.BIGZERO);
                        }
                        pstmt.setString(8, tmpFormula[7]);
                        pstmt.setString(9, tmpFormula[8]);
                        pstmt.setString(10, tmpFormula[9]);
                        pstmt.setString(11, tmpFormula[10]);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    protected void updateBgExamineCitation(Context ctx, Connection conn, BgExamineInfo bgExamineInfo, String num, BgCslFormInfo bgCslFormInfo) throws BgException {
        Expression expression = null;
        Expression expr2 = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector<String> orgunitid = new Vector<String>();
        Vector<String> schemeid = new Vector<String>();
        Vector formulas = new Vector();
        List list = null;
        FullOrgUnitInfo unitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgExamineCitationInfo bgExCionInfo = null;
        BgDataTypeEnum dataType = bgCslFormInfo.getDataType();
        bgExamineInfo.getCitation().clear();
        try {
            expression = ExcelFormulaPaserHelper.parse((String)bgExamineInfo.getFormula());
            expr2 = this.walk(ctx, expression, num, bgCslFormInfo.getBgPeriod().getNumber(), bgCslFormInfo.getBgPeriod().getPeriodType().getValue());
            bgExamineInfo.setFormula(expr2.toString());
            expression = ExcelFormulaPaserHelper.parse((String)bgExamineInfo.getFormula());
            this.walk(formulas, expression);
            for (int n = 0; n < formulas.size(); ++n) {
                String bgItem;
                String[] params;
                String[] newparams;
                FormulaHint hint;
                block44: {
                    String selectschemeid;
                    bgExCionInfo = new BgExamineCitationInfo();
                    orgunitid.clear();
                    schemeid.clear();
                    list = TableToolkit.parseFormula((String)("=" + formulas.elementAt(n).toString()), (boolean)false);
                    if (list == null || list.isEmpty()) continue;
                    hint = (FormulaHint)list.get(0);
                    newparams = new String[4];
                    params = hint.getParams();
                    bgItem = null;
                    bgExCionInfo.put("valueType", (Object)new Integer(budgetValue));
                    if (params.length == 6) {
                        if (dataType != null && dataType.equals((Object)BgDataTypeEnum.BgData)) {
                            bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5] + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                            bgExCionInfo.put("valueType", (Object)new Integer(budgetValue));
                        } else {
                            bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5].replaceAll("X", "x") + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                            bgExCionInfo.put("valueType", (Object)new Integer(actualValue));
                        }
                    }
                    newparams[0] = params[2].equals("%") ? "" : params[2];
                    newparams[1] = params[3].equals("%") ? "" : params[3];
                    newparams[2] = params[4].equals("%") ? "" : params[4];
                    newparams[3] = params[5].equals("%") ? "" : params[5];
                    if (params[0].equals("%")) break block44;
                    String selectorgunitid = "select fid from t_org_baseunit where fnumber = ?";
                    try {
                        pstmt = conn.prepareStatement(selectorgunitid);
                        pstmt.setString(1, params[0]);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            orgunitid.add(rs.getString("fid").toString());
                        }
                    }
                    catch (SQLException ex) {
                        try {
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, (Statement)pstmt);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    if (!params[1].equals("%")) {
                        selectschemeid = "select fid from T_bg_bgscheme where fnumber = ? and forgunitid = (select fid from t_org_baseunit where fnumber = ?)";
                        try {
                            pstmt = conn.prepareStatement(selectschemeid);
                            pstmt.setString(1, params[1]);
                            pstmt.setString(2, params[0]);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                schemeid.add(rs.getString("fid").toString());
                            }
                        }
                        catch (SQLException ex) {
                            throw ex;
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                        }
                    } else {
                        selectschemeid = "select fid from T_bg_bgscheme where fnumber in ( select fnumber from t_bg_bgscheme where fid = ?) and forgunitid in  (select fid from t_org_baseunit where fnumber = ?)";
                        try {
                            pstmt = conn.prepareStatement(selectschemeid);
                            pstmt.setString(1, bgCslFormInfo.getBgScheme().getId().toString());
                            pstmt.setString(2, params[0]);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                schemeid.add(rs.getString("fid").toString());
                            }
                        }
                        catch (SQLException ex) {
                            throw ex;
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                        }
                    }
                }
                orgunitid.add(bgCslFormInfo.getOrgUnit().getId().toString());
                if (!params[1].equals("%")) {
                    String selectschemeid = "select fid from T_bg_bgscheme where fnumber = ? and forgunitid = ?";
                    try {
                        pstmt = conn.prepareStatement(selectschemeid);
                        pstmt.setString(1, params[1]);
                        pstmt.setString(2, bgCslFormInfo.getOrgUnit().getId().toString());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            schemeid.add(rs.getString("fid").toString());
                        }
                    }
                    catch (SQLException ex) {
                        throw ex;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    }
                } else {
                    schemeid.add(bgCslFormInfo.getBgScheme().getId().toString());
                }
                if (orgunitid.isEmpty() && schemeid.isEmpty()) {
                    bgExCionInfo.setId(BOSUuid.create((BOSObjectType)bgExCionInfo.getBOSType()));
                    bgExCionInfo.setExamine(bgExamineInfo);
                    bgExCionInfo.setFormula(bgItem);
                    bgExCionInfo.setFormulaAlias(hint.toString());
                    bgExCionInfo.setSeq(n + 1);
                    bgExCionInfo.setBgItemCombinNumber(newparams[0]);
                    bgExCionInfo.setBgElementNumber(newparams[1]);
                    bgExCionInfo.setBgPeriodNumber(newparams[3]);
                    bgExCionInfo.setCurrencyNumber(newparams[2]);
                    bgExCionInfo.setBgScheme(null);
                    bgExCionInfo.setOrgUnit(null);
                } else if (orgunitid.isEmpty() && !schemeid.isEmpty()) {
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)((String)schemeid.get(0))));
                    bgExCionInfo.setId(BOSUuid.create((BOSObjectType)bgExCionInfo.getBOSType()));
                    bgExCionInfo.setExamine(bgExamineInfo);
                    bgExCionInfo.setFormula(bgItem);
                    bgExCionInfo.setFormulaAlias(hint.toString());
                    bgExCionInfo.setSeq(n + 1);
                    bgExCionInfo.setBgItemCombinNumber(newparams[0]);
                    bgExCionInfo.setBgElementNumber(newparams[1]);
                    bgExCionInfo.setBgPeriodNumber(newparams[3]);
                    bgExCionInfo.setCurrencyNumber(newparams[2]);
                    bgExCionInfo.setBgScheme(bgSchemeInfo);
                    bgExCionInfo.setOrgUnit(null);
                } else if (!orgunitid.isEmpty() && schemeid.isEmpty()) {
                    unitInfo = new FullOrgUnitInfo();
                    unitInfo.setId(BOSUuid.read((String)((String)orgunitid.get(0))));
                    bgExCionInfo.setId(BOSUuid.create((BOSObjectType)bgExCionInfo.getBOSType()));
                    bgExCionInfo.setExamine(bgExamineInfo);
                    bgExCionInfo.setFormula(bgItem);
                    bgExCionInfo.setFormulaAlias(hint.toString());
                    bgExCionInfo.setSeq(n + 1);
                    bgExCionInfo.setBgItemCombinNumber(newparams[0]);
                    bgExCionInfo.setBgElementNumber(newparams[1]);
                    bgExCionInfo.setBgPeriodNumber(newparams[3]);
                    bgExCionInfo.setCurrencyNumber(newparams[2]);
                    bgExCionInfo.setBgScheme(null);
                    bgExCionInfo.setOrgUnit(unitInfo);
                } else if (!orgunitid.isEmpty() && !schemeid.isEmpty()) {
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)((String)schemeid.get(0))));
                    unitInfo = new FullOrgUnitInfo();
                    unitInfo.setId(BOSUuid.read((String)((String)orgunitid.get(0))));
                    bgExCionInfo.setId(BOSUuid.create((BOSObjectType)bgExCionInfo.getBOSType()));
                    bgExCionInfo.setExamine(bgExamineInfo);
                    bgExCionInfo.setFormula(bgItem);
                    bgExCionInfo.setFormulaAlias(hint.toString());
                    bgExCionInfo.setSeq(n + 1);
                    bgExCionInfo.setBgItemCombinNumber(newparams[0]);
                    bgExCionInfo.setBgElementNumber(newparams[1]);
                    bgExCionInfo.setBgPeriodNumber(newparams[3]);
                    bgExCionInfo.setCurrencyNumber(newparams[2]);
                    bgExCionInfo.setBgScheme(bgSchemeInfo);
                    bgExCionInfo.setOrgUnit(unitInfo);
                }
                bgExamineInfo.getCitation().add(bgExCionInfo);
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rs, pstmt);
        }
    }

    private Expression walk(Context ctx, Expression expr, String xNum, String currentPeriod, int periodType) throws Exception {
        if (expr instanceof FunctionExpr) {
            FunctionExpr fun = (FunctionExpr)expr;
            if (!(fun.funcionName.equalsIgnoreCase("BGBAL") || fun.funcionName.equalsIgnoreCase("BGACTUALS") || fun.funcionName.equalsIgnoreCase("BGITEM") || fun.funcionName.equalsIgnoreCase("BGFORMULA"))) {
                for (int i = 0; i < fun.parameters.size(); ++i) {
                    fun.parameters.set(i, this.walk(ctx, (Expression)fun.parameters.get(i), xNum, currentPeriod, periodType));
                }
            }
            Expression p5 = (Expression)fun.parameters.get(5);
            String s5 = ((StringExpr)p5).value;
            s5 = s5.replaceAll("X", "x");
            s5 = this.parseOffsetPeriod(s5, currentPeriod);
            try {
                s5 = BgPeriodNVariableHelper.getBgPeriodByN((String)currentPeriod, (String)s5, (int)periodType);
            }
            catch (BgFormException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 6 && s5.indexOf("x") > -1) {
                Date beginDate = null;
                Date endDate = null;
                beginDate = this.getPerNum(ctx, s5, xNum, true);
                endDate = this.getPerNum(ctx, s5, xNum, false);
                int bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(xNum);
                BgPeriodCollection bgPerCol = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)bgPeriodType);
                String bgPerNum = null;
                bgPerNum = bgPerCol.size() < 1 ? "0000Y" : bgPerCol.get(0).getNumber();
                StringBuffer sb = new StringBuffer();
                FunctionExpr cpFun = BgCslFacadeControllerBean.copy(fun);
                cpFun.parameters.set(5, new StringExpr(bgPerNum));
                cpFun.output(sb);
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 6 && s5.indexOf("x") == -1) {
                StringBuffer sb = new StringBuffer();
                FunctionExpr cpFun = BgCslFacadeControllerBean.copy(fun);
                cpFun.parameters.set(5, new StringExpr(s5));
                cpFun.output(sb);
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 7) {
                StringBuffer sb = new StringBuffer();
                Expression p6 = (Expression)fun.parameters.get(6);
                String s6 = ((StringExpr)p6).value;
                s6 = s6.replaceAll("X", "x");
                s6 = this.parseOffsetPeriod(s6, currentPeriod);
                try {
                    s6 = BgPeriodNVariableHelper.getBgPeriodByN((String)currentPeriod, (String)s6, (int)periodType);
                }
                catch (BgFormException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                Date beginDate = null;
                Date endDate = null;
                int bgPeriodType = 0;
                if (s5.indexOf("x") > -1) {
                    beginDate = this.getPerNum(ctx, s5, xNum, true);
                    bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(xNum);
                } else {
                    beginDate = this.getPerNum(ctx, s5, s5, true);
                    bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(s5);
                }
                if (s6.indexOf("x") > -1) {
                    endDate = this.getPerNum(ctx, s6, xNum, false);
                    bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(xNum);
                } else {
                    endDate = this.getPerNum(ctx, s6, s6, false);
                    bgPeriodType = BgCslFacadeControllerBean.getBgPeriodType(s6);
                }
                BgPeriodCollection bgPerCol = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)bgPeriodType);
                for (int n = 0; n < bgPerCol.size(); ++n) {
                    FunctionExpr cpFun = BgCslFacadeControllerBean.copy(fun);
                    cpFun.parameters.set(5, new StringExpr(bgPerCol.get(n).getNumber()));
                    cpFun.parameters.remove(6);
                    if (sb.indexOf("B") >= 0) {
                        sb.append('+');
                    }
                    cpFun.output(sb);
                }
                if (bgPerCol.size() < 1) {
                    FunctionExpr cpFun = BgCslFacadeControllerBean.copy(fun);
                    cpFun.parameters.set(5, new StringExpr("0000Y"));
                    cpFun.parameters.remove(6);
                    cpFun.output(sb);
                }
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            bin.left = this.walk(ctx, bin.left, xNum, currentPeriod, periodType);
            bin.right = this.walk(ctx, bin.right, xNum, currentPeriod, periodType);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            bin.operand = this.walk(ctx, bin.operand, xNum, currentPeriod, periodType);
        } else if (expr instanceof ReferenceExpr) {
            SysUtil.abort();
        }
        return expr;
    }

    protected List getData(Connection conn, List formulaList, Map bgExamineMap) throws BOSException, EASBizException {
        if (conn == null || formulaList == null || bgExamineMap == null) {
            return formulaList;
        }
        HashMap bformulaMap = new HashMap();
        HashMap aformulaMap = new HashMap();
        HashMap vformulaMap = new HashMap();
        HashMap tmpMap = null;
        Set<String> formulaSet = null;
        int seq = 0;
        String key = null;
        String[] tmpFormula2 = null;
        BgExamineCitationInfo bgExCionInfo = null;
        for (String[] tmpFormula2 : formulaList) {
            seq = Integer.valueOf(tmpFormula2[11]);
            bgExCionInfo = (BgExamineCitationInfo)bgExamineMap.get(new Integer(seq));
            key = new StringBuffer(tmpFormula2[2]).append("_").append(tmpFormula2[3]).toString();
            if (seq == budgetValue) {
                tmpMap = bformulaMap;
            } else if (seq == actualValue) {
                tmpMap = aformulaMap;
            }
            if (tmpMap != null) {
                if (tmpMap.containsKey(key)) {
                    formulaSet = (Set)tmpMap.get(key);
                } else {
                    formulaSet = new HashSet();
                    tmpMap.put(key, formulaSet);
                }
            }
            if (formulaSet == null || formulaSet.contains(tmpFormula2[5])) continue;
            formulaSet.add(tmpFormula2[5]);
        }
        try {
            if (!bformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, bformulaMap, budgetValue);
                this.fillData(formulaList, tmpMap, budgetValue);
            }
            if (!aformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, aformulaMap, actualValue);
                this.fillData(formulaList, tmpMap, actualValue);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return formulaList;
    }

    protected Map getData(Connection conn, Map formulaMap, int valueType) throws SQLException {
        if (conn == null || formulaMap == null) {
            return null;
        }
        Integer type = new Integer(valueType);
        Map.Entry entry2 = null;
        HashMap<String, Object[]> _formulaMap = new HashMap<String, Object[]>();
        Set _formulaSet = null;
        ArrayList _formulaList = new ArrayList();
        int batchSize = 250;
        int size = 0;
        int count = 0;
        int pos = 0;
        BigDecimal _value = null;
        String _key = null;
        String _osKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _bgCslFormId = null;
        String _formulaStr = null;
        String[] _keyStr = null;
        Object[] _objs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FConsolidAmount, FBgCslFormID, FFormula from T_BG_BgCslData where FOrgGroupID = ? and FBgSchemeId = ? and FFormula IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        if (valueType == budgetValue) {
            sql.append(" AND FDataType = 1");
        } else if (valueType == actualValue) {
            sql.append(" AND FDataType = 2");
        }
        PreparedStatement pstmt = null;
        Statement pstmp = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry entry2 : formulaMap.entrySet()) {
                _osKey = (String)entry2.getKey();
                _formulaSet = (Set)entry2.getValue();
                _keyStr = _osKey.split("_");
                _orgUnitId = _keyStr[0];
                _bgSchemeId = _keyStr[1];
                _formulaList.clear();
                Iterator list = _formulaSet.iterator();
                while (list.hasNext()) {
                    _formulaList.add(list.next());
                }
                size = _formulaList.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                pstmt.setString(1, _orgUnitId);
                pstmt.setString(2, _bgSchemeId);
                for (int x = 0; x < count; ++x) {
                    int y = 1;
                    while (y <= batchSize) {
                        if (pos < size) {
                            pstmt.setString(y + 2, _formulaList.get(pos).toString());
                        } else {
                            pstmt.setString(y + 2, "#");
                        }
                        ++y;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        _formulaStr = rst.getString(3);
                        _bgCslFormId = rst.getString(2);
                        _objs = new Object[]{_value, _bgCslFormId};
                        _key = _osKey + "_" + _formulaStr + type.toString();
                        _formulaMap.put(_key, _objs);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            SQLUtils.cleanup(pstmp);
        }
        return _formulaMap;
    }

    protected void fillData(List formulaList, Map formulaMap, int valueType) {
        if (formulaList == null || formulaMap == null) {
            return;
        }
        String key = null;
        String[] tmpFormula = null;
        Object[] objs = null;
        int in = formulaList.size();
        for (int i = 0; i < in; ++i) {
            tmpFormula = (String[])formulaList.get(i);
            key = new StringBuffer(tmpFormula[2]).append("_").append(tmpFormula[3]).append("_").append(tmpFormula[5]).append(tmpFormula[11]).toString();
            if (!formulaMap.containsKey(key)) continue;
            objs = (Object[])formulaMap.get(key);
            tmpFormula[4] = (String)objs[1];
            tmpFormula[6] = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)((BigDecimal)objs[0]));
        }
    }

    protected String builderFormula(BgExamineCitationInfo bgExCitInfo, String[] formulaInfo, String builderBgPeriod) {
        StringBuffer formulaStr = new StringBuffer();
        formulaStr.append("=BgItem(\"" + (bgExCitInfo.getBgItemCombinNumber() != null && bgExCitInfo.getBgItemCombinNumber().trim().length() > 0 && !bgExCitInfo.getBgItemCombinNumber().trim().equals("%") ? bgExCitInfo.getBgItemCombinNumber() : formulaInfo[7].replaceAll("_", ",")) + "\",\"" + builderBgPeriod + "\",\"" + (bgExCitInfo.getBgElementNumber() != null && bgExCitInfo.getBgElementNumber().trim().length() > 0 && !bgExCitInfo.getBgElementNumber().trim().equals("%") ? bgExCitInfo.getBgElementNumber() : formulaInfo[8]) + "\",\"" + BgDataTypeEnum.BgData.getName() + "\"," + Boolean.TRUE.toString() + ",\"" + (bgExCitInfo.getCurrencyNumber() != null && bgExCitInfo.getCurrencyNumber().trim().length() > 0 && !bgExCitInfo.getCurrencyNumber().trim().equals("%") ? bgExCitInfo.getCurrencyNumber() : formulaInfo[10]) + "\")");
        return formulaStr.toString();
    }

    protected String parseBgPeriodNumber(String bgPeriodNumber, String matching, Context ctx) {
        if (StringUtils.isEmpty((String)matching) || matching.trim().equals("%")) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber));
            return bgPeriodNumber;
        }
        if (matching.indexOf("%") == -1) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching));
            return matching;
        }
        String yearCode = null;
        String halfYearCode = null;
        String quarterCode = null;
        String monthCode = null;
        String dayCode = null;
        String monthWeekCode = null;
        String yearWeekCode = null;
        String tenDayCode = null;
        String tmpBgPeriod = null;
        tmpBgPeriod = matching;
        if (Pattern.matches("[\\d]{4}Y[\\w.]*", bgPeriodNumber)) {
            yearCode = bgPeriodNumber.substring(0, 5);
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", bgPeriodNumber)) {
                halfYearCode = bgPeriodNumber.substring(6, 10);
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", bgPeriodNumber)) {
                quarterCode = bgPeriodNumber.substring(6, 9);
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M[\\w.]*", bgPeriodNumber)) {
                monthCode = bgPeriodNumber.substring(6, 9);
                if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", bgPeriodNumber)) {
                    dayCode = bgPeriodNumber.substring(10, 13);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", bgPeriodNumber)) {
                    monthWeekCode = bgPeriodNumber.substring(10, 14);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", bgPeriodNumber)) {
                    tenDayCode = bgPeriodNumber.substring(10, 14);
                }
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}W", bgPeriodNumber)) {
                yearWeekCode = bgPeriodNumber.substring(6, 9);
            }
        }
        if (yearCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%Y", yearCode);
        }
        if (halfYearCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%HY", halfYearCode);
        }
        if (quarterCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%Q", quarterCode);
        }
        if (monthCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%M", monthCode);
        }
        if (dayCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%D", dayCode);
        }
        if (yearWeekCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%W", yearWeekCode);
        }
        if (monthWeekCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%MW", monthWeekCode);
        }
        if (tenDayCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%TD", tenDayCode);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + tmpBgPeriod));
        return tmpBgPeriod;
    }

    private String parseOffsetPeriod(String offsetStr, String currentPeriod) {
        String periodNumber = offsetStr;
        if (Pattern.matches(MATCH_STR, offsetStr)) {
            int _offset = 0;
            try {
                _offset = Integer.parseInt(offsetStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                return offsetStr;
            }
            periodNumber = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(currentPeriod, _offset);
        }
        return periodNumber;
    }

    private static int getBgPeriodType(String bgPeriodStr) {
        if (bgPeriodStr.indexOf("ZDY_") >= 0) {
            return 8;
        }
        if (bgPeriodStr.indexOf("Y") >= 0) {
            if (bgPeriodStr.indexOf("HY") >= 0) {
                return 2;
            }
            if (bgPeriodStr.indexOf("Q") >= 0) {
                return 3;
            }
            if (bgPeriodStr.indexOf("M") >= 0) {
                if (bgPeriodStr.indexOf("TD") >= 0) {
                    return 9;
                }
                if (bgPeriodStr.indexOf("D") >= 0) {
                    return 7;
                }
                if (bgPeriodStr.indexOf("MW") >= 0) {
                    return 6;
                }
                return 4;
            }
            if (bgPeriodStr.indexOf("W") >= 0) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    private Date getPerNum(Context ctx, String xNum, String num, boolean isBegin) throws BOSException {
        IBgPeriod iBgPer = BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodCollection bgPerCol = iBgPer.getBgPeriodCollection("where number = '" + num + "'");
        BgPeriodInfo bgPerInfo = null;
        if (bgPerCol.size() > 0) {
            bgPerInfo = bgPerCol.get(0);
        }
        if (bgPerInfo != null) {
            if (isBegin) {
                this.calendar.setTime(bgPerInfo.getBeginDate());
            } else {
                this.calendar.setTime(bgPerInfo.getEndDate());
            }
        }
        if (xNum.indexOf("+") + xNum.indexOf("-") < 0) {
            return this.calendar.getTime();
        }
        boolean isSum = false;
        if (xNum.indexOf("+") > 0) {
            isSum = true;
        }
        xNum = xNum.replaceAll("x", "");
        xNum = xNum.replaceAll("X", "");
        xNum = xNum.replaceAll(" ", "");
        xNum = xNum.replaceAll("\\+", "");
        xNum = xNum.replaceAll("\\-", "");
        BigDecimal number = new BigDecimal(xNum);
        if (num.indexOf("Y") >= 0) {
            if (num.indexOf("HY") >= 0) {
                if (isSum) {
                    this.calendar.add(2, number.intValue() * 6);
                } else {
                    this.calendar.add(2, -(number.intValue() * 6));
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("Q") >= 0) {
                if (isSum) {
                    this.calendar.add(2, number.intValue() * 3);
                } else {
                    this.calendar.add(2, -(number.intValue() * 3));
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("M") >= 0) {
                if (num.indexOf("TD") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue() * 10);
                    } else {
                        this.calendar.add(5, -number.intValue() * 10);
                    }
                    if (isBegin) {
                        this.calendar.add(5, -(number.intValue() + 1) / 2);
                    } else {
                        this.calendar.add(5, (number.intValue() + 1) / 2);
                    }
                    return this.calendar.getTime();
                }
                if (num.indexOf("D") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue());
                    } else {
                        this.calendar.add(5, -number.intValue());
                    }
                    return this.calendar.getTime();
                }
                if (num.indexOf("MW") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue() * 7);
                    } else {
                        this.calendar.add(5, -number.intValue() * 7);
                    }
                    return this.calendar.getTime();
                }
                if (isSum) {
                    this.calendar.add(2, number.intValue());
                } else {
                    this.calendar.add(2, -number.intValue());
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("W") >= 0) {
                if (isSum) {
                    this.calendar.add(6, number.intValue() * 7);
                } else {
                    this.calendar.add(6, -number.intValue() * 7);
                }
                return this.calendar.getTime();
            }
            if (isSum) {
                this.calendar.add(1, number.intValue());
            } else {
                this.calendar.add(1, -number.intValue());
            }
            return this.calendar.getTime();
        }
        return null;
    }

    private static FunctionExpr copy(FunctionExpr foo) throws Exception {
        FunctionExpr cp = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)foo.toString());
        return cp;
    }

    private void walk(Vector formulas, Expression expr) throws Exception {
        if (expr instanceof FunctionExpr) {
            formulas.addElement(expr.toString());
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            this.walk(formulas, bin.left);
            this.walk(formulas, bin.right);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            this.walk(formulas, bin.operand);
        }
    }

    /*
     * Loose catch block
     */
    protected void checkBgExamineData(Context ctx, Connection conn, String tmpTableName, Object[] examineCheck, Map examineCheckMap, BgExamineInfo bgExamineInfo, BgCslFormInfo bgCslFormInfo, String num) throws BOSException, EASBizException {
        int isPass;
        List _tmpList;
        ArrayList<String> examineList;
        Map _examineItems;
        HashMap<String, Map<String, String>> examineItems;
        Map _examineMap;
        HashMap<String, Object> examineMap;
        Map noPassMap;
        Map passSetMap;
        Map passMap;
        block63: {
            block64: {
                ResultSet rst;
                Statement stmt;
                block62: {
                    DecimalFormatSymbols dfs = BgNationalFormatUIUtil.getDecimalFormatSymbols((Context)ctx);
                    BgExamineCitationInfo citation = null;
                    stmt = null;
                    rst = null;
                    HashMap<Integer, BgExamineCitationInfo> citatMap = new HashMap<Integer, BgExamineCitationInfo>();
                    HashMap postilMap = new HashMap();
                    passMap = null;
                    passSetMap = null;
                    noPassMap = null;
                    examineMap = null;
                    _examineMap = null;
                    examineItems = null;
                    _examineItems = null;
                    Map<String, String> formulaMap = null;
                    Map orgUnitMap = null;
                    Map bgFormMap = null;
                    Map currencyMap = null;
                    HashSet<String> orgUnitSet = new HashSet<String>();
                    HashSet<String> bgFormSet = new HashSet<String>();
                    examineList = new ArrayList<String>();
                    _tmpList = null;
                    String oldNumber = null;
                    String number = null;
                    String key2222222 = null;
                    String seqStr = null;
                    String oldSeq = null;
                    String qualification = null;
                    String bgExamformula = null;
                    String formulaString2222 = null;
                    String bgCiaFormulaString = null;
                    String bgPostialStr = null;
                    String valueString = null;
                    String valueStr = null;
                    String orgUnitId = null;
                    String bgSchemeId = null;
                    String bgFormId = null;
                    String currencyNumber = null;
                    String adjustId = null;
                    BigDecimal value = null;
                    StringBuffer sql = new StringBuffer();
                    StringBuffer select = new StringBuffer();
                    StringBuffer from = new StringBuffer();
                    StringBuffer where = new StringBuffer();
                    int strIndex = 0;
                    isPass = 0;
                    boolean isHasAllPostil = true;
                    boolean isHasPostil = false;
                    if (examineCheck[2] != null && examineCheck[2] instanceof Map) {
                        currencyMap = (Map)examineCheck[2];
                    }
                    passMap = (Map)examineCheckMap.get("EXAMINE_PASS");
                    passSetMap = (Map)examineCheckMap.get("EXAMINE_PASS_SET");
                    noPassMap = (Map)examineCheckMap.get("EXAMINE_NOPASS");
                    examineMap = new HashMap<String, Object>();
                    examineItems = new HashMap<String, Map<String, String>>();
                    examineMap.put("EXAMINE_NUMBER", bgExamineInfo.getNumber());
                    examineMap.put("EXAMINE_NAME", bgExamineInfo.getName());
                    examineMap.put("EXAMINE_FORMULA_ALIAS", bgExamineInfo.getFormula());
                    examineMap.put("EXAMINE_EXPLAIN", bgExamineInfo.getHint() == null ? "" : bgExamineInfo.getHint());
                    examineMap.put("EXAMINE_CITATION_SIZE", new Integer(bgExamineInfo.getCitation().size()));
                    examineMap.put("EXAMINE_CITATION", examineItems);
                    examineMap.put("EXAMINE_CIAATION_FORMULA", examineList);
                    if (bgExamineInfo.getCitation().size() <= 0) break block64;
                    select.append("select DISTINCT ");
                    from.append("from ");
                    where.append("where ");
                    qualification = bgExamineInfo.getFormula().replaceAll(" ", "");
                    formulaString2222 = bgExamineInfo.getFormula().replaceAll(" ", "");
                    int n = bgExamineInfo.getCitation().size();
                    for (int i = 0; i < n; ++i) {
                        citation = bgExamineInfo.getCitation().get(i);
                        citatMap.put(new Integer(citation.getSeq()), citation);
                    }
                    n = bgExamineInfo.getCitation().size();
                    for (int j = 1; j <= n; ++j) {
                        citation = (BgExamineCitationInfo)citatMap.get(new Integer(j));
                        number = String.valueOf(citation.getSeq());
                        seqStr = "t" + number;
                        select.append(seqStr + ".FSeq s" + seqStr + "," + seqStr + ".FOrgUnitId o" + seqStr + "," + seqStr + ".FBgSchemeId bs" + seqStr + "," + seqStr + ".FBgCslFormId bf" + seqStr + "," + seqStr + ".FFormula f" + seqStr + "," + seqStr + ".FValue v" + seqStr + "," + seqStr + ".FCurrencyNumber c" + seqStr + ",");
                        from.append(tmpTableName + " " + seqStr + ", ");
                        if (oldSeq == null) {
                            where.append("");
                        } else {
                            where.append("(" + oldSeq + ".FGroupId = " + seqStr + ".FGroupId and " + oldSeq + ".FSeq = " + oldNumber + " and " + seqStr + ".FSeq = " + number + ") and");
                        }
                        bgExamformula = citation.getFormulaAlias().replaceAll(" ", "");
                        strIndex = qualification.indexOf(bgExamformula);
                        if (strIndex == -1) {
                            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                        }
                        qualification = qualification.substring(0, strIndex) + "v.v" + seqStr + qualification.substring(strIndex + bgExamformula.length());
                        oldSeq = seqStr;
                        oldNumber = number;
                    }
                    select.delete(select.length() - 1, select.length());
                    from.delete(from.length() - 2, from.length());
                    if (where.toString().trim().equals("where")) {
                        where.delete(0, where.length());
                    } else {
                        where.delete(where.length() - 4, where.length());
                    }
                    if (bgExamineInfo.getErrorData().compareTo(BgConstants.BIGZERO) == 0) {
                        switch (bgExamineInfo.getCompareType().getValue()) {
                            case 0: {
                                qualification = qualification.replaceFirst("<>", "=");
                                break;
                            }
                            case 1: {
                                qualification = qualification.replaceFirst("=", "<>");
                                break;
                            }
                            case 2: {
                                qualification = qualification.replaceFirst("<", ">=");
                                break;
                            }
                            case 3: {
                                qualification = qualification.replaceFirst("<=", ">");
                                break;
                            }
                            case 4: {
                                qualification = qualification.replaceFirst(">", "<=");
                                break;
                            }
                            case 5: {
                                qualification = qualification.replaceFirst(">=", "<");
                            }
                        }
                    } else {
                        Pattern p = null;
                        String[] expression = null;
                        switch (bgExamineInfo.getCompareType().getValue()) {
                            case 0: {
                                p = Pattern.compile("<>");
                                expression = p.split(qualification);
                                qualification = "ABS((" + expression[0] + ") - (" + expression[1] + ")) < " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 1: {
                                p = Pattern.compile("=");
                                expression = p.split(qualification);
                                qualification = "ABS((" + expression[0] + ") - (" + expression[1] + ")) > " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 2: {
                                p = Pattern.compile("<");
                                expression = p.split(qualification);
                                qualification = "(" + expression[0] + ") - (" + expression[1] + ") >= " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 3: {
                                p = Pattern.compile("<=");
                                expression = p.split(qualification);
                                qualification = "(" + expression[0] + ") - (" + expression[1] + ") > " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 4: {
                                p = Pattern.compile(">");
                                expression = p.split(qualification);
                                qualification = bgExamineInfo.getErrorData().toString() + " > (" + expression[1] + ") - (" + expression[0] + ")";
                                break;
                            }
                            case 5: {
                                p = Pattern.compile(">=");
                                expression = p.split(qualification);
                                qualification = bgExamineInfo.getErrorData().toString() + " < (" + expression[1] + ") - (" + expression[0] + ")";
                            }
                        }
                    }
                    sql.append("select * from (" + select + " " + from + " " + where + ")v where " + qualification + " order by ft1");
                    try {
                        stmt = conn.createStatement();
                        rst = stmt.executeQuery(sql.toString());
                        while (rst.next()) {
                            formulaMap = new HashMap<String, String>();
                            formulaString2222 = bgExamineInfo.getFormula().replaceAll(" ", "");
                            valueString = new String(formulaString2222);
                            isHasPostil = false;
                            n = bgExamineInfo.getCitation().size();
                            for (int j = 1; j <= n; ++j) {
                                citation = (BgExamineCitationInfo)citatMap.get(new Integer(j));
                                bgExamformula = citation.getFormulaAlias().replaceAll(" ", "");
                                bgCiaFormulaString = rst.getString("ft" + j);
                                orgUnitId = rst.getString("ot" + j);
                                bgSchemeId = rst.getString("bst" + j);
                                bgFormId = rst.getString("bft" + j);
                                value = rst.getBigDecimal("vt" + j);
                                currencyNumber = rst.getString("ct" + j);
                                if (bgFormId != null && (adjustId = BgGatherHelper.getGatherAdjustId((Connection)conn, (BOSUuid)BOSUuid.read((String)bgFormId)).toString()) != null && bgExamineInfo.getNoPass().getValue() == 2 && adjustId != null && this.checkBgExaminePostil(ctx, bgSchemeId, adjustId, bgCiaFormulaString, postilMap)) {
                                    bgPostialStr = this.getBgExaminePostil(postilMap, bgSchemeId, adjustId, bgCiaFormulaString);
                                    formulaMap.put("EXAMINE_CITATION_POSTIAL" + j, bgPostialStr);
                                    isHasPostil = true;
                                }
                                bgCiaFormulaString = bgExamformula.indexOf("BGBAL") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgBal") : (bgExamformula.indexOf("BGACTUALS") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgActuals") : (bgExamformula.indexOf("BGFORMULA") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgFormula") : bgCiaFormulaString.replaceFirst("=BgItem", "BgItem")));
                                DecimalFormat formater = null;
                                if (currencyMap != null && currencyMap.containsKey(currencyNumber)) {
                                    formater = new DecimalFormat("#,##0." + this.getNumberFormat("0", ((CurrencyInfo)currencyMap.get(currencyNumber)).getPrecision()), dfs);
                                    valueStr = formater.format(value.setScale(((CurrencyInfo)currencyMap.get(currencyNumber)).getPrecision(), 4)).toString();
                                } else {
                                    formater = new DecimalFormat("#,##0.00", dfs);
                                    valueStr = formater.format(value).toString();
                                }
                                orgUnitSet.add(orgUnitId);
                                bgFormSet.add(bgFormId);
                                formulaMap.put("EXAMINE_CITATION_ORGUNIT" + j, orgUnitId);
                                formulaMap.put("EXAMINE_CITATION_ORGUNIT_NAME" + j, null);
                                formulaMap.put("EXAMINE_CITATION_SCHEME" + j, bgSchemeId);
                                formulaMap.put("EXAMINE_CITATION_FORM" + j, bgFormId);
                                formulaMap.put("EXAMINE_CITATION_FORM_NAME" + j, null);
                                formulaMap.put("EXAMINE_CIAATION_FORMULA" + j, bgCiaFormulaString);
                                formulaMap.put("EXAMINE_CITATION_VALUE" + j, valueStr);
                                strIndex = formulaString2222.indexOf(bgExamformula);
                                if (strIndex == -1) {
                                    throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                                }
                                formulaString2222 = formulaString2222.substring(0, strIndex) + bgCiaFormulaString + formulaString2222.substring(strIndex + bgExamformula.length());
                                strIndex = valueString.indexOf(bgExamformula);
                                if (strIndex == -1) {
                                    throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                                }
                                valueString = valueString.substring(0, strIndex) + valueStr + valueString.substring(strIndex + bgExamformula.length());
                            }
                            if (!isHasPostil) {
                                isHasAllPostil = false;
                            }
                            formulaMap.put("EXAMINE_FORMULA", formulaString2222);
                            formulaMap.put("EXAMINE_FORMULA_VALUE", valueString);
                            if (examineItems.containsKey(bgCslFormInfo.getId().toString() + "_" + formulaString2222)) continue;
                            examineItems.put(bgCslFormInfo.getId().toString() + "_" + formulaString2222, formulaMap);
                            examineList.add(bgCslFormInfo.getId().toString() + "_" + formulaString2222);
                        }
                        if (examineItems.isEmpty()) {
                            isPass = 0;
                            break block62;
                        }
                        switch (bgExamineInfo.getNoPass().getValue()) {
                            case 1: {
                                isPass = 2;
                                break;
                            }
                            case 2: {
                                if (isHasAllPostil) {
                                    isPass = 1;
                                    break;
                                }
                                isPass = 2;
                                break;
                            }
                            case 3: {
                                isPass = 1;
                                break;
                            }
                            default: {
                                isPass = 2;
                            }
                        }
                        orgUnitMap = this.getOrgUnitInfo(ctx, orgUnitSet);
                        bgFormMap = this.getBgCslFormInfo(ctx, bgFormSet);
                        for (String formulaString2222 : examineItems.keySet()) {
                            formulaMap = (Map)examineItems.get(formulaString2222);
                            for (String key2222222 : formulaMap.keySet()) {
                                if (key2222222.startsWith("EXAMINE_CITATION_ORGUNIT")) {
                                    seqStr = key2222222.replaceFirst("EXAMINE_CITATION_ORGUNIT", "");
                                    orgUnitId = (String)formulaMap.get(key2222222);
                                    if (!orgUnitMap.containsKey(orgUnitId)) continue;
                                    formulaMap.put("EXAMINE_CITATION_ORGUNIT_NAME" + seqStr, ((OrgUnitInfo)orgUnitMap.get(orgUnitId)).getName());
                                    continue;
                                }
                                if (!key2222222.startsWith("EXAMINE_CITATION_FORM")) continue;
                                seqStr = key2222222.replaceFirst("EXAMINE_CITATION_FORM", "");
                                bgFormId = (String)formulaMap.get(key2222222);
                                if (!bgFormMap.containsKey(bgFormId)) continue;
                                formulaMap.put("EXAMINE_CITATION_FORM_NAME" + seqStr, ((BgCslFormInfo)bgFormMap.get(bgFormId)).getName());
                            }
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        if (ex == null || !ex.getSQLState().equals("22012")) {
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        isPass = 0;
                        SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
                        break block63;
                    }
                    catch (EASBizException ex2) {
                        throw ex2;
                        {
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst, (Statement)stmt);
                                throw throwable;
                            }
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
                break block63;
            }
            isPass = 1;
        }
        switch (isPass) {
            case 0: {
                if (examineCheck[0] == null) {
                    examineCheck[0] = Boolean.TRUE;
                }
                if (passMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)passMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    break;
                }
                passMap.put(bgExamineInfo.getId().toString(), examineMap);
                break;
            }
            case 1: {
                if (examineCheck[0] == null) {
                    examineCheck[0] = Boolean.TRUE;
                }
                if (passSetMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)passSetMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    break;
                }
                passSetMap.put(bgExamineInfo.getId().toString(), examineMap);
                break;
            }
            case 2: {
                examineCheck[0] = Boolean.FALSE;
                if (noPassMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)noPassMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    break;
                }
                noPassMap.put(bgExamineInfo.getId().toString(), examineMap);
                break;
            }
            default: {
                examineCheck[0] = Boolean.FALSE;
                if (noPassMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)noPassMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    break;
                }
                noPassMap.put(bgExamineInfo.getId().toString(), examineMap);
            }
        }
    }

    protected boolean checkBgExaminePostil(Context ctx, String bgSchemeId, String bgFormId, String formulaString, Map postilMap) throws BOSException, EASBizException {
        if (bgFormId == null || bgFormId.toString().trim().length() == 0 || formulaString == null) {
            return false;
        }
        HashMap bgSchemeMap = null;
        HashMap<String, String> bgFormMap = null;
        boolean isSearch = false;
        boolean isLoad = false;
        if (postilMap == null) {
            postilMap = new HashMap();
        }
        if (postilMap.containsKey(bgSchemeId)) {
            bgSchemeMap = (HashMap)postilMap.get(bgSchemeId);
            if (bgSchemeMap.containsKey(bgFormId)) {
                bgFormMap = (HashMap<String, String>)bgSchemeMap.get(bgFormId);
                if (bgFormMap.containsKey(formulaString)) {
                    isSearch = true;
                }
            } else {
                isLoad = true;
                bgFormMap = new HashMap<String, String>();
                bgSchemeMap.put(bgFormId, bgFormMap);
            }
        } else {
            isLoad = true;
            bgSchemeMap = new HashMap();
            postilMap.put(bgSchemeId, bgSchemeMap);
            bgFormMap = new HashMap();
            bgSchemeMap.put(bgFormId, bgFormMap);
        }
        if (isLoad) {
            IBgCslForm ibgCslForm = null;
            BgCslFormInfo bgCslFormInfo = null;
            PostilInfo postilInfo2 = null;
            String formulaStr = null;
            String positionStr = null;
            HashMap<String, PostilInfo> bgFormPostils = new HashMap<String, PostilInfo>();
            Book book = null;
            Sheet sheet = null;
            Cell cell = null;
            ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
            try {
                ibgCslForm = BgCslFormFactory.getLocalInstance(ctx);
                if (ibgCslForm.exists((IObjectPK)pk)) {
                    bgCslFormInfo = ibgCslForm.getBgCslFormInfo((IObjectPK)pk, this.getBgCslFormValue());
                    for (PostilInfo postilInfo2 : bgCslFormInfo.getPostils()) {
                        if (postilInfo2.getPostilType().getValue() != 3) continue;
                        bgFormPostils.put(postilInfo2.getSheet().getSheetID() + "_" + postilInfo2.getCellName(), postilInfo2);
                    }
                    if (bgCslFormInfo.getZipData() != null) {
                        book = bgCslFormInfo.getBook();
                        int n = book.getSheetCount();
                        for (int i = 0; i < n; ++i) {
                            sheet = book.getSheet(i);
                            int rowCount = sheet.getMaxRowIndex() + 1;
                            int colCount = sheet.getMaxColIndex() + 1;
                            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                                    cell = sheet.getCell(rowIndex, colIndex, true);
                                    positionStr = TableToolkit.xy2range((int)colIndex, (int)rowIndex);
                                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || !bgFormPostils.containsKey(sheet.getID() + "_" + positionStr)) continue;
                                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                                    postilInfo2 = (PostilInfo)bgFormPostils.get(sheet.getID() + "_" + positionStr);
                                    bgFormMap.put(formulaStr, postilInfo2.getDescription());
                                }
                            }
                        }
                    }
                    isSearch = this.checkBgExaminePostil(ctx, bgSchemeId, bgFormId, formulaString, postilMap);
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BgException(BgException.UNSERIALIZABLEERROR, (Object[])new String[]{ex.getMessage()});
            }
        }
        return isSearch;
    }

    protected String getBgExaminePostil(Map postilMap, String bgSchemeId, String bgFormId, String formulaString) {
        Map bgFormMap;
        Map bgSchemeMap;
        if (postilMap == null || postilMap.isEmpty() || formulaString == null) {
            return null;
        }
        if (postilMap.containsKey(bgSchemeId) && (bgSchemeMap = (Map)postilMap.get(bgSchemeId)).containsKey(bgFormId) && (bgFormMap = (Map)bgSchemeMap.get(bgFormId)).containsKey(formulaString)) {
            return (String)bgFormMap.get(formulaString);
        }
        return null;
    }

    protected SelectorItemCollection getBgCslFormValue() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        return sic;
    }

    /*
     * WARNING - void declaration
     */
    protected Map getOrgUnitInfo(Context ctx, Set orgUnitSet) throws BOSException, EASBizException {
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        if (orgUnitSet == null || orgUnitSet.isEmpty()) {
            return orgUnitMap;
        }
        String orgUnitId22 = null;
        HashSet _orgUnitSet = new HashSet();
        Object var6_6 = null;
        for (String orgUnitId22 : orgUnitSet) {
            void var6_7;
            if (var6_7 == null || var6_7.size() > 50) {
                HashSet hashSet = new HashSet();
                _orgUnitSet.add(hashSet);
            }
            var6_7.add(orgUnitId22);
        }
        IFullOrgUnit iccOrgUnit = null;
        FullOrgUnitInfo ccOrgUnitInfo = null;
        FullOrgUnitCollection ccOrgUnitCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        iccOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        if (iccOrgUnit == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        for (Set set : _orgUnitSet) {
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            ccOrgUnitCol = iccOrgUnit.getFullOrgUnitCollection(view);
            if (ccOrgUnitCol == null || ccOrgUnitCol.isEmpty()) continue;
            int n = ccOrgUnitCol.size();
            for (int i = 0; i < n; ++i) {
                ccOrgUnitInfo = ccOrgUnitCol.get(i);
                if (orgUnitMap.containsKey(ccOrgUnitInfo.getId().toString())) continue;
                orgUnitMap.put(ccOrgUnitInfo.getId().toString(), ccOrgUnitInfo);
            }
            ccOrgUnitCol.clear();
        }
        return orgUnitMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getBgCslFormInfo(Context ctx, Set bgCslFormSet) throws BOSException, EASBizException {
        HashMap<String, BgCslFormInfo> bgFormMap = new HashMap<String, BgCslFormInfo>();
        if (bgCslFormSet == null) return bgFormMap;
        if (bgCslFormSet.isEmpty()) {
            return bgFormMap;
        }
        String bgCslFormId2222222 = null;
        BgCslFormInfo bgCslFormInfo = null;
        ArrayList<String> bgFormList = new ArrayList<String>();
        for (String bgCslFormId2222222 : bgCslFormSet) {
            bgFormList.add(bgCslFormId2222222);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = bgFormList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FName, FNumber from T_BG_BgCslForm WHERE FID IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?, ");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, BOSUuid.read((String)((String)bgFormList.get(pos))).toString());
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgCslFormInfo = new BgCslFormInfo();
                    bgCslFormId2222222 = rst.getString("FID");
                    bgCslFormInfo.setId(BOSUuid.read((String)bgCslFormId2222222));
                    bgCslFormInfo.setName(rst.getString("FName"));
                    bgCslFormInfo.setNumber(rst.getString("FNumber"));
                    bgFormMap.put(bgCslFormId2222222, bgCslFormInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    private String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _examineHadX(Context ctx, BOSUuid[] bgCslfromId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block7: {
            boolean bl;
            block6: {
                String[] ids = new String[bgCslfromId.length];
                for (int i = 0; i < bgCslfromId.length; ++i) {
                    ids[i] = bgCslfromId[i].toString();
                }
                String sql = "select fhadx from t_bg_bgexaminecitation where fexamineid in (select fbgexamineid from t_bg_bgexaminenode where fbgtemplateid in (select fbgcsltemplateid from t_bg_bgCslform where fid in " + BgHelper.tranArray2String((String[])ids) + "))";
                conn = null;
                pstmt = null;
                rst = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        if (rst.getInt(1) != 1) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return false;
    }
}

