/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.BgDataHelper;
import com.kingdee.eas.ma.nbudget.app.IBgDataFacade;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgDataFacadeImpl
implements IBgDataFacade {
    private static final Logger logger = Logger.getLogger(BgDataFacadeImpl.class);
    private BgDataHelper helper = null;

    public BgDataFacadeImpl(BgDataHelper helper) {
        this.helper = helper;
    }

    public void setHelper(BgDataHelper helper) {
        this.helper = helper;
    }

    public BgDataHelper getHelper() {
        return this.helper;
    }

    @Override
    public Object[] compareBgDataInfo(Context ctx, BOSUuid bgFormId, String orgId, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgFormId == null) {
            return null;
        }
        HashMap<String, BgNDataInfo> _newInfo = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _updInfo = new HashMap<String, BgNDataInfo>();
        HashMap _delInfo = new HashMap();
        Object[] _objs = new Object[]{_newInfo, _updInfo, _delInfo};
        Map _dataMap = this.queryBgFormula(ctx, bgFormId);
        Map _schemeDataMap = this.querySchemeData(ctx, orgId, bgSchemeId);
        if (_dataMap != null) {
            HashSet<String> _tmpSet = new HashSet<String>();
            Map.Entry _entry2 = null;
            BgNDataInfo _dataInfo = null;
            BgNDataInfo _tmpInfo = null;
            int in = this.getHelper().getFormulas().size();
            for (int i = 0; i < in; ++i) {
                _dataInfo = (BgNDataInfo)this.getHelper().getFormulas().get(i);
                _tmpSet.add(_dataInfo.getFormula());
                if (_dataMap.containsKey(_dataInfo.getFormula())) {
                    _tmpInfo = (BgNDataInfo)_dataMap.get(_dataInfo.getFormula());
                    if (this.compareBgDataInfo(_dataInfo, _tmpInfo)) continue;
                    _updInfo.put(_dataInfo.getFormula(), _dataInfo);
                    continue;
                }
                if (_schemeDataMap.containsKey(_dataInfo.getFormula())) {
                    _updInfo.put(_dataInfo.getFormula(), _dataInfo);
                    continue;
                }
                _newInfo.put(_dataInfo.getFormula(), _dataInfo);
            }
            for (Map.Entry _entry2 : _dataMap.entrySet()) {
                if (_tmpSet.contains(_entry2.getKey())) continue;
                _delInfo.put(_entry2.getKey(), _entry2.getValue());
            }
        }
        return _objs;
    }

    public Map querySchemeData(Context ctx, String orgId, String bgSchemeId) throws BOSException {
        BgNDataInfo _dataInfo;
        HashMap<String, BgNDataInfo> _dataMap = new HashMap<String, BgNDataInfo>();
        if (ctx == null || orgId == null || bgSchemeId == null || this.getHelper().getFormulas().isEmpty()) {
            return _dataMap;
        }
        HashSet<String> formulas = new HashSet<String>();
        int in = this.getHelper().getFormulas().size();
        for (int i = 0; i < in; ++i) {
            _dataInfo = (BgNDataInfo)this.getHelper().getFormulas().get(i);
            formulas.add(_dataInfo.getFormula());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select bgData.FFormula, bgData.FBgValue, bgData.FBgActual ").append("from T_BG_BgData bgData ").append("join T_Bg_BgForm bgForm on bgForm.FID = bgData.FBgFormId ").append("join T_Bg_BgTemplate bgTemplate on bgTemplate.FID = bgForm.FBgTemplateId ").append("where bgTemplate.FFormType = ").append(4).append(" ").append("and bgData.FOrgUnitId = ? ").append("and bgData.FBgSchemeId = ? ").append("and bgData.FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = formulas.toArray();
            int count = (params.length - 1) / 200 + 1;
            for (int i = 0; i < count; ++i) {
                pstmt.setString(1, orgId);
                pstmt.setString(2, bgSchemeId);
                BgNSQLHelper.setParam4Batch(pstmt, 3, i, 200, params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _dataInfo = new BgNDataInfo();
                    _dataInfo.setFormula(rst.getString("FFormula"));
                    _dataInfo.setBudgetValue(rst.getBigDecimal("FBgValue"));
                    _dataInfo.setActualValue(rst.getBigDecimal("FBgActual"));
                    _dataMap.put(_dataInfo.getFormula(), _dataInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    private Map queryBgFormula(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        HashMap<String, BgNDataInfo> _dataMap = new HashMap<String, BgNDataInfo>();
        if (ctx == null || bgFormId == null) {
            return _dataMap;
        }
        BgNDataInfo _dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FFormula, FBgValue, FBgActual from T_BG_BgData where FBgFormId = ?");
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _dataInfo = new BgNDataInfo();
                _dataInfo.setFormula(rst.getString("FFormula"));
                _dataInfo.setBudgetValue(rst.getBigDecimal("FBgValue"));
                _dataInfo.setActualValue(rst.getBigDecimal("FBgActual"));
                _dataMap.put(_dataInfo.getFormula(), _dataInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    private boolean compareBgDataInfo(BgNDataInfo info1, BgNDataInfo info2) {
        if (info1 == null || info2 == null || info1 == info2) {
            return true;
        }
        return info1.getBudgetValue().compareTo(info2.getBudgetValue()) == 0 && info1.getActualValue().compareTo(info2.getActualValue()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFormulaIsEctype(Context ctx, BgFormInfo model, Object[] objs) throws BOSException, EASBizException {
        if (ctx == null || model == null || objs == null) {
            return;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin Check bgData!");
        Map _tmpMap = (Map)objs[0];
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList _formula = new ArrayList();
        String _formulaStr = null;
        String _bgFormId = null;
        _formula.addAll(_tmpMap.keySet());
        int index = 0;
        int batchSize = 200;
        int size = _formula.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer(1024);
        StringBuffer tmpsql = new StringBuffer(1024);
        sql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
        tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
            tmpsql.append("?,");
        }
        sql.append("?)");
        tmpsql.append("?)");
        sql.append(" and (FBgFormId <> ?)");
        tmpsql.append(" and (FBgFormId <> ?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, model.getOrgUnit().getId().toString());
                pstmt.setString(2, model.getBgScheme().getId().toString());
                int x = 3;
                while (x < batchSize + 3) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_formula.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                pstmt.setString(batchSize + 3, model.getId().toString());
                try {
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        _formulaStr = rst.getString(1);
                        _bgFormId = rst.getString(2);
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
                if (_bgFormId != null) break;
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (_formulaStr != null && _bgFormId != null) {
                BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(_bgFormId), false);
                if (tmpInfo != null) {
                    BgNDataInfo _info = (BgNDataInfo)_tmpMap.get(_formulaStr);
                    throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{TableToolkit.xy2range((int)_info.getCol(), (int)_info.getRow()), _formulaStr.replaceAll(",\"BgData\",true", ""), tmpInfo.getName()});
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            pos = 0;
            pstmt = conn.prepareStatement(tmpsql.toString());
            _formulaStr = null;
            _bgFormId = null;
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, model.getOrgUnit().getId().toString());
                pstmt.setString(2, model.getBgScheme().getId().toString());
                int y = 3;
                while (y < batchSize + 3) {
                    if (pos < size) {
                        pstmt.setString(y, (String)_formula.get(pos));
                    } else {
                        pstmt.setString(y, "#");
                    }
                    ++y;
                    ++pos;
                }
                pstmt.setString(batchSize + 3, model.getId().toString());
                try {
                    rst = pstmt.executeQuery();
                    if (!rst.next()) continue;
                    _formulaStr = rst.getString(1);
                    _bgFormId = rst.getString(2);
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (_formulaStr != null && _bgFormId != null) {
                BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(_bgFormId), false);
                if (tmpInfo != null) {
                    BgNDataInfo _info = (BgNDataInfo)_tmpMap.get(_formulaStr);
                    throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{TableToolkit.xy2range((int)_info.getCol(), (int)_info.getRow()), _formulaStr.replaceAll(",\"BgData\",true", ""), tmpInfo.getName()});
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end Check bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFormulaIsEctypeFromTmpTable(Context ctx, BgFormInfo model, Object[] objs) throws Exception {
        long _endTime;
        long _beginTime;
        long _startTime;
        block20: {
            if (ctx == null || model == null || objs == null) {
                return;
            }
            _startTime = 0L;
            _beginTime = 0L;
            _endTime = 0L;
            _beginTime = _startTime = System.currentTimeMillis();
            _endTime = _startTime;
            logger.info((Object)"invoke begin Check bgData from TmpTable!");
            Map _tmpMap = (Map)objs[0];
            if (_tmpMap == null || _tmpMap.isEmpty()) {
                return;
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            ArrayList _formula = new ArrayList();
            _formula.addAll(_tmpMap.keySet());
            String _tmpTableName = null;
            String _create = new String("Create Table TMP_Table_Name (FFormula nVarchar(200))");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                _tmpTableName = pool.createTempTable(_create);
                if (StringUtils.isEmpty((String)_tmpTableName)) break block20;
                pool.createIndex(_tmpTableName, "FFormula", true, false);
                String _insert = new String("Insert Into " + _tmpTableName + "(FFormula) values (?)");
                String _id = model.getId().toString();
                String _orgUnitId = model.getOrgUnit().getId().toString();
                String _bgSchemeId = model.getBgScheme().getId().toString();
                String _formulaStr = null;
                String _bgFormId = null;
                int batchSize = 200;
                int batchIndex = 0;
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(_insert);
                int in = _formula.size();
                for (int i = 0; i < in; ++i) {
                    _formulaStr = (String)_formula.get(i);
                    pstmt.setString(1, _formulaStr);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                _endTime = System.currentTimeMillis();
                logger.info((Object)"invoke end Insert bgData to TmpTable!");
                logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
                _formulaStr = null;
                try {
                    pstmt = conn.prepareStatement("Select TOP 1 d.FBgFormId, d.FFormula From " + _tmpTableName + " t join T_BG_BgData d on t.FFormula = d.FFormula join T_BG_BgForm bgForm on bgForm.FID = d.FBgFormId join T_BG_BgTemplate bgTemplate on bgTemplate.FID = bgForm.FBgTemplateId where bgTemplate.FFormType <> " + 4 + " and d.FOrgUnitId = ? and d.FBgSchemeId = ? and FBgFormId <> ?");
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    pstmt.setString(3, _id);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        _bgFormId = rst.getString(1);
                        _formulaStr = rst.getString(2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (_formulaStr != null && _bgFormId != null) {
                    BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read((String)_bgFormId), false);
                    if (tmpInfo != null) {
                        BgNDataInfo _info = (BgNDataInfo)_tmpMap.get(_formulaStr);
                        throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{TableToolkit.xy2range((int)_info.getCol(), (int)_info.getRow()), _formulaStr.replaceAll(",\"BgData\",true", ""), tmpInfo.getName()});
                    }
                    throw new BgFormException(BgFormException.NOBGFORMINFO);
                }
                try {
                    pstmt = conn.prepareStatement("Select TOP 1 d.FBgFormId, d.FFormula From " + _tmpTableName + " t join T_BG_BgTmpData d on t.FFormula = d.FFormula where d.FOrgUnitId = ? and d.FBgSchemeId = ? and FBgFormId <> ? ");
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    pstmt.setString(3, _id);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        _bgFormId = rst.getString(1);
                        _formulaStr = rst.getString(2);
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                if (_formulaStr != null && _bgFormId != null) {
                    BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read((String)_bgFormId), false);
                    if (tmpInfo != null) {
                        BgNDataInfo _info = (BgNDataInfo)_tmpMap.get(_formulaStr);
                        throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{TableToolkit.xy2range((int)_info.getCol(), (int)_info.getRow()), _formulaStr.replaceAll(",\"BgData\",true", ""), tmpInfo.getName()});
                    }
                    throw new BgFormException(BgFormException.NOBGFORMINFO);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, pstmt, conn);
            }
        }
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end Check bgData from TmpTable!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    @Override
    public void disposeBgDataValue(Context ctx, BgFormInfo model, Object[] objs) throws BOSException, EASBizException {
        if (ctx == null || objs == null) {
            return;
        }
        this.addNewBgDataValue(ctx, model, objs[0]);
        this.updateBgDataValue(ctx, model, objs[1]);
        this.removeBgDataValue(ctx, model, objs[2]);
    }

    @Override
    public void addNewBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        if (BgNSHelper.isMSSQL(ctx)) {
            this.addNewBgDataValueBySQL(ctx, model, obj);
        } else {
            this.addNewBgDataValueByDefault(ctx, model, obj);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewBgDataValueByDefault(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (model == null) return;
        if (obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null) return;
        if (_tmpMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchSize = 200;
        int batchIndex = 0;
        BOSObjectType type = new BgDataInfo().getBOSType();
        String _id = null;
        String _bgFormId = model.getId().toString();
        String _orgUnitId = model.getOrgUnit().getId().toString();
        String _bgSchemeId = model.getBgScheme().getId().toString();
        String _bgTemplateId = model.getBgTemplate().getId().toString();
        String _userId = model.getLastUpdateUser() == null ? model.getCreator().getId().toString() : model.getLastUpdateUser().getId().toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BgNDataInfo _info2222222 = null;
        ArrayList<String> _bgItem = new ArrayList<String>();
        ArrayList<String> _bgPeriod = new ArrayList<String>();
        ArrayList<String> _bgElement = new ArrayList<String>();
        ArrayList<String> _currency = new ArrayList<String>();
        for (BgNDataInfo _info2222222 : _tmpMap.values()) {
            _bgItem.add(_info2222222.getBgItemNumber());
            _bgPeriod.add(_info2222222.getBgPeriodNumber());
            _bgElement.add(_info2222222.getBgElementNumber());
            _currency.add(_info2222222.getCurrencyNumber());
        }
        Map _bgItemMap = this.getBgItemMap(ctx, _bgItem);
        _bgItemMap = this.createBgItemMap(ctx, _bgItemMap, _bgItem, model.getOrgUnit().getId().toString());
        Map _bgPeriodMap = this.getBgPeriodMap(ctx, _bgPeriod);
        Map _bgElementMap = this.getBgElementMap(ctx, _bgElement);
        Map _currencyMap = this.getCurrencyMap(ctx, _currency);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("Insert Into T_BG_BgData (FID, FBgValue, FBgActual,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FSheetName, FCreatorId, FCreateTime, FLastupdateUserId, FlastupdateTime, FIsAllowAccess, FIsFromSuper, FIsCtrlAllowChange, FCtrlModeFrom , FDataState) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
            for (BgNDataInfo _info2222222 : _tmpMap.values()) {
                bValue = _info2222222.getBudgetValue();
                aValue = _info2222222.getActualValue();
                if (bValue.scale() < 0) {
                    bValue = bValue.setScale(0);
                }
                if (aValue.scale() < 0) {
                    aValue = aValue.setScale(0);
                }
                if (_info2222222 instanceof BgNViewDataInfo) {
                    pstmt.setString(1, ((BgNViewDataInfo)_info2222222).getId());
                } else {
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                }
                pstmt.setBigDecimal(2, bValue.setScale(8, 4));
                pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                pstmt.setBigDecimal(4, aValue.setScale(8, 4));
                pstmt.setBigDecimal(5, BgNConstants.ZERO);
                pstmt.setString(6, _info2222222.getFormula());
                _id = (String)_bgPeriodMap.get(_info2222222.getBgPeriodNumber());
                if (_id == null) {
                    logger.debug((Object)("bgPeriod number error:" + _info2222222.getBgPeriodNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{_info2222222.getBgPeriodNumber()});
                }
                pstmt.setString(7, BOSUuid.read((String)_id).toString());
                pstmt.setString(8, BOSUuid.read((String)_bgFormId).toString());
                _id = (String)_bgElementMap.get(_info2222222.getBgElementNumber());
                if (_id == null) {
                    logger.debug((Object)("bgElement number error:" + _info2222222.getBgElementNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{_info2222222.getBgElementNumber()});
                }
                pstmt.setString(9, BOSUuid.read((String)_id).toString());
                _id = (String)_currencyMap.get(_info2222222.getCurrencyNumber());
                if (_id == null) {
                    logger.debug((Object)("currency number error:" + _info2222222.getCurrencyNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{_info2222222.getCurrencyNumber()});
                }
                pstmt.setString(10, BOSUuid.read((String)_id).toString());
                pstmt.setString(11, BOSUuid.read((String)_orgUnitId).toString());
                pstmt.setString(12, BOSUuid.read((String)_bgSchemeId).toString());
                pstmt.setString(13, BOSUuid.read((String)_bgTemplateId).toString());
                _id = (String)_bgItemMap.get(_info2222222.getBgItemNumber());
                if (_id == null) {
                    logger.debug((Object)("bgItem number error:" + _info2222222.getBgItemNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{_info2222222.getBgItemNumber()});
                }
                pstmt.setString(14, _id);
                pstmt.setInt(15, _info2222222.isControl() ? 1 : 0);
                pstmt.setInt(16, _info2222222.isFlexible() ? 1 : 0);
                pstmt.setBigDecimal(17, _info2222222.getFlexParam());
                pstmt.setInt(18, _info2222222.getControlType());
                pstmt.setInt(19, _info2222222.isGroupCtrl() ? 1 : 0);
                pstmt.setString(20, _info2222222.getGroupNo());
                pstmt.setString(21, _info2222222.getSheetName());
                pstmt.setString(22, BOSUuid.read((String)_userId).toString());
                pstmt.setTimestamp(23, _time);
                pstmt.setString(24, BOSUuid.read((String)_userId).toString());
                pstmt.setTimestamp(25, _time);
                pstmt.setInt(26, _info2222222.isAllowAccess() ? 1 : 0);
                pstmt.setInt(27, _info2222222.isFromSuper() ? 1 : 0);
                pstmt.setInt(28, _info2222222.isChange() ? 1 : 0);
                pstmt.setInt(29, _info2222222.getCtrlMode());
                pstmt.setInt(30, 1);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            HashSet<String> _bgItemSet = new HashSet<String>();
            _bgItemSet.addAll(_bgItem);
            HashSet<String> _bgPeriodSet = new HashSet<String>();
            _bgPeriodSet.addAll(_bgPeriod);
            HashSet<String> _bgElementSet = new HashSet<String>();
            _bgElementSet.addAll(_bgElement);
            HashSet<String> _currencySet = new HashSet<String>();
            _currencySet.addAll(_currency);
            BgFacadeHelper.dealRefBgItem(ctx, model.getId(), _bgItemSet, _bgItemMap);
            BgFacadeHelper.dealRefBgPeriod(ctx, model.getId(), _bgPeriodSet, _bgPeriodMap);
            BgFacadeHelper.dealRefBgElement(ctx, model.getId(), _bgElementSet, _bgElementMap);
            BgFacadeHelper.dealRefCurrency(ctx, model.getId(), _currencySet, _currencyMap);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgData addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewBgDataValueBySQL(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        long _endTime;
        long _beginTime;
        long _startTime;
        block24: {
            if (ctx == null || model == null || obj == null) {
                return;
            }
            Map _tmpMap = (Map)obj;
            if (_tmpMap == null || _tmpMap.isEmpty()) {
                return;
            }
            _startTime = 0L;
            _beginTime = 0L;
            _endTime = 0L;
            _beginTime = _startTime = System.currentTimeMillis();
            _endTime = _startTime;
            logger.info((Object)"invoke begin add bgData!");
            conn = null;
            pstmt = null;
            int batchSize = 100;
            int batchIndex = 0;
            BOSObjectType type = new BgDataInfo().getBOSType();
            String _id = null;
            String _bgFormId = model.getId().toString();
            String _orgUnitId = model.getOrgUnit().getId().toString();
            String _bgSchemeId = model.getBgScheme().getId().toString();
            String _bgTemplateId = model.getBgTemplate().getId().toString();
            String _userId = model.getLastUpdateUser() == null ? model.getCreator().getId().toString() : model.getLastUpdateUser().getId().toString();
            Timestamp _time = new Timestamp(System.currentTimeMillis());
            BigDecimal bValue = null;
            BigDecimal aValue = null;
            BgNDataInfo _info2222222 = null;
            ArrayList<String> _bgItem = new ArrayList<String>();
            ArrayList<String> _bgPeriod = new ArrayList<String>();
            ArrayList<String> _bgElement = new ArrayList<String>();
            ArrayList<String> _currency = new ArrayList<String>();
            for (BgNDataInfo _info2222222 : _tmpMap.values()) {
                _bgItem.add(_info2222222.getBgItemNumber());
                _bgPeriod.add(_info2222222.getBgPeriodNumber());
                _bgElement.add(_info2222222.getBgElementNumber());
                _currency.add(_info2222222.getCurrencyNumber());
            }
            Map _bgItemMap = this.getBgItemMap(ctx, _bgItem);
            _bgItemMap = this.createBgItemMap(ctx, _bgItemMap, _bgItem, model.getOrgUnit().getId().toString());
            Map _bgPeriodMap = this.getBgPeriodMap(ctx, _bgPeriod);
            Map _bgElementMap = this.getBgElementMap(ctx, _bgElement);
            Map _currencyMap = this.getCurrencyMap(ctx, _currency);
            TempTablePool pool = null;
            String _tableName = null;
            String _createSql = "Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FBgValue NUMERIC(21,8) NOT NULL DEFAULT 0, FBgActual NUMERIC(21,8) NOT NULL DEFAULT 0, FBizActual NUMERIC(21,8) NOT NULL DEFAULT 0, FBgBalance NUMERIC(21,8) NOT NULL DEFAULT 0, FFormula VARCHAR(200) NOT NULL, FBgPeriodId VARCHAR(44) NOT NULL, FBgFormId VARCHAR(44) NOT NULL, FBgElementId VARCHAR(44) NOT NULL, FCurrencyId VARCHAR(44) NOT NULL, FOrgUnitId VARCHAR(44) NOT NULL, FBgSchemeId VARCHAR(44) NOT NULL, FBgTemplateId VARCHAR(44) NOT NULL, FBgItemCombinId VARCHAR(44) NOT NULL, FIsControl INT DEFAULT 0 NOT NULL, FIsFlexible INT DEFAULT 0, FFlexParam NUMERIC(21,8), FCtrlType INT DEFAULT -1 NOT NULL, FIsGroupCtrl INT DEFAULT 0 NOT NULL, FGroupNo NVARCHAR(80), FSheetName NVARCHAR(80), FCreatorID VARCHAR(44), FCreateTime DateTime, FLastUpdateUserID VARCHAR(44), FLastUpdateTime DateTime, FIsAllowAccess INT DEFAULT 1 NOT NULL, FIsFromSuper INT DEFAULT 0, FIsCtrlAllowChange INT DEFAULT 1, FDataState INT DEFAULT 1, FCtrlModeFrom INT DEFAULT 0)";
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                _tableName = pool.createDBSystemTempTable(_createSql, conn);
                pstmt = conn.prepareStatement("Insert Into " + _tableName + " (FID, FBgValue, FBgActual,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FSheetName, FCreatorId, FCreateTime, FLastupdateUserId, FlastupdateTime, FIsAllowAccess, FIsFromSuper, FIsCtrlAllowChange, FCtrlModeFrom ,FDataState) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
                for (BgNDataInfo _info2222222 : _tmpMap.values()) {
                    bValue = _info2222222.getBudgetValue();
                    aValue = _info2222222.getActualValue();
                    if (bValue.scale() < 0) {
                        bValue = bValue.setScale(0);
                    }
                    if (aValue.scale() < 0) {
                        aValue = aValue.setScale(0);
                    }
                    if (_info2222222 instanceof BgNViewDataInfo) {
                        pstmt.setString(1, ((BgNViewDataInfo)_info2222222).getId());
                    } else {
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    }
                    pstmt.setBigDecimal(2, bValue.setScale(8, 4));
                    pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                    pstmt.setBigDecimal(4, aValue.setScale(8, 4));
                    pstmt.setBigDecimal(5, BgNConstants.ZERO);
                    pstmt.setString(6, _info2222222.getFormula());
                    _id = (String)_bgPeriodMap.get(_info2222222.getBgPeriodNumber());
                    if (_id == null) {
                        logger.debug((Object)("bgPeriod number error:" + _info2222222.getBgPeriodNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{_info2222222.getBgPeriodNumber()});
                    }
                    pstmt.setString(7, BOSUuid.read((String)_id).toString());
                    pstmt.setString(8, BOSUuid.read((String)_bgFormId).toString());
                    _id = (String)_bgElementMap.get(_info2222222.getBgElementNumber());
                    if (_id == null) {
                        logger.debug((Object)("bgElement number error:" + _info2222222.getBgElementNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{_info2222222.getBgElementNumber()});
                    }
                    pstmt.setString(9, BOSUuid.read((String)_id).toString());
                    _id = (String)_currencyMap.get(_info2222222.getCurrencyNumber());
                    if (_id == null) {
                        logger.debug((Object)("currency number error:" + _info2222222.getCurrencyNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{_info2222222.getCurrencyNumber()});
                    }
                    pstmt.setString(10, BOSUuid.read((String)_id).toString());
                    pstmt.setString(11, BOSUuid.read((String)_orgUnitId).toString());
                    pstmt.setString(12, BOSUuid.read((String)_bgSchemeId).toString());
                    pstmt.setString(13, BOSUuid.read((String)_bgTemplateId).toString());
                    _id = (String)_bgItemMap.get(_info2222222.getBgItemNumber());
                    if (_id == null) {
                        logger.debug((Object)("bgItem number error:" + _info2222222.getBgItemNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{_info2222222.getBgItemNumber()});
                    }
                    pstmt.setString(14, _id);
                    pstmt.setInt(15, _info2222222.isControl() ? 1 : 0);
                    pstmt.setInt(16, _info2222222.isFlexible() ? 1 : 0);
                    pstmt.setBigDecimal(17, _info2222222.getFlexParam());
                    pstmt.setInt(18, _info2222222.getControlType());
                    pstmt.setInt(19, _info2222222.isGroupCtrl() ? 1 : 0);
                    pstmt.setString(20, _info2222222.getGroupNo());
                    pstmt.setString(21, _info2222222.getSheetName());
                    pstmt.setString(22, BOSUuid.read((String)_userId).toString());
                    pstmt.setTimestamp(23, _time);
                    pstmt.setString(24, BOSUuid.read((String)_userId).toString());
                    pstmt.setTimestamp(25, _time);
                    pstmt.setInt(26, _info2222222.isAllowAccess() ? 1 : 0);
                    pstmt.setInt(27, _info2222222.isFromSuper() ? 1 : 0);
                    pstmt.setInt(28, _info2222222.isChange() ? 1 : 0);
                    pstmt.setInt(29, _info2222222.getCtrlMode());
                    pstmt.setInt(30, 1);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                String _tmpSql = "Insert Into T_BG_BgData (FID, FBgValue, FBgActual,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FSheetName, FCreatorId, FCreateTime, FLastupdateUserId, FlastupdateTime, FIsAllowAccess, FIsFromSuper, FIsCtrlAllowChange, FCtrlModeFrom ,FDataState) Select FID, FBgValue, FBgActual,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FSheetName, FCreatorId, FCreateTime, FLastupdateUserId, FlastupdateTime, FIsAllowAccess, FIsFromSuper, FIsCtrlAllowChange, FCtrlModeFrom ,FDataState  from " + _tableName;
                pstmt = conn.prepareStatement(_tmpSql);
                pstmt.executeUpdate();
                HashSet<String> _bgItemSet = new HashSet<String>();
                _bgItemSet.addAll(_bgItem);
                HashSet<String> _bgPeriodSet = new HashSet<String>();
                _bgPeriodSet.addAll(_bgPeriod);
                HashSet<String> _bgElementSet = new HashSet<String>();
                _bgElementSet.addAll(_bgElement);
                HashSet<String> _currencySet = new HashSet<String>();
                _currencySet.addAll(_currency);
                BgFacadeHelper.dealRefBgItem(ctx, model.getId(), _bgItemSet, _bgItemMap);
                BgFacadeHelper.dealRefBgPeriod(ctx, model.getId(), _bgPeriodSet, _bgPeriodMap);
                BgFacadeHelper.dealRefBgElement(ctx, model.getId(), _bgElementSet, _bgElementMap);
                BgFacadeHelper.dealRefCurrency(ctx, model.getId(), _currencySet, _currencyMap);
                if (pool == null) break block24;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"bgData addNew:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        logger.error((Object)"bgData addNew:", (Throwable)ex3);
                        throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(_tableName, conn);
                        }
                        catch (Exception ex4) {
                            logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex4);
                        }
                    }
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(_tableName, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex);
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end add bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    @Override
    public void updateBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null || model == null || obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String _orgUnitId = model.getOrgUnit().getId().toString();
        String _bgSchemeId = model.getBgScheme().getId().toString();
        String _userId = model.getLastUpdateUser() == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : model.getLastUpdateUser().getId().toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BgNDataInfo _info2 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("Update T_BG_BgData Set FBgValue = ?, FBgActual = ?, FBizActual = ?, FBgBalance= ?, FLastupdateUserId = ?, FlastupdateTime = ?, FBgFormId = ?, FBgTemplateId = ? where FOrgUnitID = ? and FBgSchemeId = ? and FFormula = ?");
            for (BgNDataInfo _info2 : _tmpMap.values()) {
                bValue = _info2.getBudgetValue();
                aValue = _info2.getActualValue();
                if (bValue.scale() < 0) {
                    bValue = bValue.setScale(0);
                }
                if (aValue.scale() < 0) {
                    aValue = aValue.setScale(0);
                }
                pstmt.setBigDecimal(1, bValue.setScale(8, 4));
                pstmt.setBigDecimal(2, aValue.setScale(8, 4));
                pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                pstmt.setBigDecimal(4, BgNConstants.ZERO);
                pstmt.setString(5, _userId);
                pstmt.setTimestamp(6, _time);
                pstmt.setString(7, model.getId().toString());
                pstmt.setString(8, model.getBgTemplate().getId().toString());
                pstmt.setString(9, _orgUnitId);
                pstmt.setString(10, _bgSchemeId);
                pstmt.setString(11, _info2.getFormula());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgData Update:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public void removeBgDataValue(Context ctx, Map bgFormMap, Map deleteMap) throws EASBizException {
        if (bgFormMap == null || bgFormMap.isEmpty() || deleteMap == null || deleteMap.isEmpty()) {
            return;
        }
        BgNDataInfo _info2 = null;
        HashMap formulaMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int i;
            Object[] params;
            Set formulas;
            BgFormInfo bgForm;
            Map<String, String> temp;
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            int fixParamCount = 3;
            sql.append("delete T_Bg_BgDataEntry where FBgFormId = ? AND FBgDataId IN (select FID from T_Bg_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula IN(");
            BgNSQLHelper.addPlaceHolder(sql).append("))");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (String orgId : deleteMap.keySet()) {
                temp = (HashMap)deleteMap.get(orgId);
                bgForm = (BgFormInfo)bgFormMap.get(orgId);
                if (temp == null || temp.isEmpty() || temp.isEmpty()) continue;
                formulas = new HashSet<String>();
                formulaMap.put(orgId, formulas);
                params = null;
                int paramIndex = 0;
                for (BgNDataInfo _info2 : temp.values()) {
                    formulas.add(_info2.getFormula());
                    if (paramIndex == 0) {
                        params = new Object[203];
                        params[0] = bgForm.getId().toString();
                        params[1] = orgId;
                        params[2] = bgForm.getBgScheme().getId().toString();
                        for (i = 3; i < params.length; ++i) {
                            params[i] = "#";
                        }
                        paramList.add(params);
                    }
                    if (params != null) {
                        params[3 + paramIndex] = _info2.getFormula();
                    }
                    if (++paramIndex < 200) continue;
                    paramIndex = 0;
                }
            }
            BgNSQLHelper.executeBatch(conn, sql.toString(), paramList);
            HashMap viewData = new HashMap();
            sql.delete(0, sql.length());
            sql.append("select bgData.FFormula, dataEntry.FBgFormId ").append("from T_Bg_BgDataEntry dataEntry ").append("join T_Bg_BgData bgData on bgData.FID = dataEntry.FBgDataId ").append("where bgData.FOrgUnitId = ? and bgData.FBgSchemeId = ? and bgData.FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (String orgId : formulaMap.keySet()) {
                formulas = (Set)formulaMap.get(orgId);
                bgForm = (BgFormInfo)bgFormMap.get(orgId);
                temp = new HashMap();
                viewData.put(orgId, temp);
                params = formulas.toArray();
                int count = (params.length - 1) / 200 + 1;
                for (i = 0; i < count; ++i) {
                    pstmt.setString(1, bgForm.getOrgUnit().getId().toString());
                    pstmt.setString(2, bgForm.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch(pstmt, 3, i, 200, params);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String formula = rst.getString("FFormula");
                        String bgFormId = rst.getString("FBgFormId");
                        formulas.remove(formula);
                        temp.put(formula, bgFormId);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            paramList.clear();
            for (String orgId : viewData.keySet()) {
                temp = (Map)viewData.get(orgId);
                bgForm = (BgFormInfo)bgFormMap.get(orgId);
                if (bgForm == null || temp == null || temp.isEmpty()) continue;
                Iterator it = temp.keySet().iterator();
                while (it.hasNext()) {
                    params = new Object[4];
                    params[1] = orgId;
                    params[2] = bgForm.getBgScheme().getId().toString();
                    params[3] = it.next();
                    params[0] = temp.get(params[3]);
                    paramList.add(params);
                }
            }
            BgNSQLHelper.executeBatch(conn, "update T_Bg_BgData set FBgFormId = ? where FOrgUnitID = ? and FBgSchemeId = ? and FFormula = ?", paramList);
            paramList.clear();
            for (String orgId : formulaMap.keySet()) {
                bgForm = (BgFormInfo)bgFormMap.get(orgId);
                formulas = (Set)formulaMap.get(orgId);
                if (bgForm == null || formulas == null || formulas.isEmpty()) continue;
                Iterator iter = formulas.iterator();
                while (iter.hasNext()) {
                    params = new Object[]{orgId, bgForm.getBgScheme().getId().toString(), iter.next()};
                    paramList.add(params);
                }
            }
            BgNSQLHelper.executeBatch(conn, "delete from T_BG_BgData where FOrgUnitID = ? and FBgSchemeId = ? and FFormula = ?", paramList);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgData remove:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    public void removeBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null || model == null || obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        bgFormMap.put(model.getOrgUnit().getId().toString(), model);
        HashMap<String, Map> deleteMap = new HashMap<String, Map>();
        deleteMap.put(model.getOrgUnit().getId().toString(), _tmpMap);
        this.removeBgDataValue(ctx, bgFormMap, deleteMap);
    }

    private Map getBgItemMap(Context ctx, List bgItems) throws BOSException, EASBizException {
        if (ctx == null || bgItems == null || bgItems.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, String> bgItemMap = new HashMap<String, String>();
        HashSet<String> _bgItemSet = new HashSet<String>();
        ArrayList<String> _bgItemList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 100;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgItemId = null;
        String bgItemKey = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FKey from T_BG_BgItemCombination where FKey IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int in = bgItems.size();
        for (int i = 0; i < in; ++i) {
            bgItemKey = (String)bgItems.get(i);
            if (bgItemKey != null) {
                bgItemKey = bgItemKey.replaceAll(",", "_");
            }
            _bgItemSet.add(bgItemKey);
        }
        _bgItemList.addAll(_bgItemSet);
        size = _bgItemList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgItemList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgItemId = rst.getString(1);
                    bgItemKey = rst.getString(2);
                    bgItemMap.put(bgItemKey.replaceAll("_", ","), bgItemId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgItemMap;
    }

    private Map createBgItemMap(Context ctx, Map bgItemMap, List bgItemList, String orgId) throws BOSException, EASBizException {
        if (ctx == null || bgItemMap == null || bgItemList == null) {
            return new HashMap();
        }
        if (bgItemList.isEmpty()) {
            return bgItemMap;
        }
        String _bgItemNumber = null;
        String _bgItemId = null;
        ArrayList createNew = new ArrayList();
        HashSet<String> _bgItemSet = new HashSet<String>();
        Hashtable _bgItemMap = null;
        int count = bgItemList.size();
        for (int index = 0; index < count; ++index) {
            _bgItemNumber = (String)bgItemList.get(index);
            if (bgItemMap.containsKey(_bgItemNumber)) continue;
            _bgItemSet.add(_bgItemNumber);
        }
        createNew.addAll(_bgItemSet);
        IBgTemplate ibgTemplate = null;
        try {
            ibgTemplate = BgTemplateFactory.getLocalInstance((Context)ctx);
            if (ibgTemplate == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            _bgItemMap = ibgTemplate.getItemCombinIds(createNew, orgId);
            if (_bgItemMap != null) {
                Map.Entry entry2 = null;
                for (Map.Entry entry2 : _bgItemMap.entrySet()) {
                    _bgItemNumber = (String)entry2.getKey();
                    _bgItemId = (String)entry2.getValue();
                    if (_bgItemNumber == null) continue;
                    bgItemMap.put(_bgItemNumber.replaceAll("_", ","), _bgItemId);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgItemMap;
    }

    private Map getBgPeriodMap(Context ctx, List bgPeriods) throws EASBizException {
        if (ctx == null || bgPeriods == null || bgPeriods.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, String> bgPeriodMap = new HashMap<String, String>();
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        ArrayList<String> _bgPeriodList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgPeriodId = null;
        String bgPeriodNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgPeriod where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int in = bgPeriods.size();
        for (int i = 0; i < in; ++i) {
            bgPeriodNum = (String)bgPeriods.get(i);
            _bgPeriodSet.add(bgPeriodNum);
        }
        _bgPeriodList.addAll(_bgPeriodSet);
        size = _bgPeriodList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodId = rst.getString(1);
                    bgPeriodNum = rst.getString(2);
                    bgPeriodMap.put(bgPeriodNum, bgPeriodId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgPeriodMap;
    }

    private Map getBgElementMap(Context ctx, List bgElements) throws EASBizException {
        if (ctx == null || bgElements == null || bgElements.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, String> bgElementMap = new HashMap<String, String>();
        HashSet<String> _bgElementSet = new HashSet<String>();
        ArrayList<String> _bgElementList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgElementId = null;
        String bgElementNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgElement where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int in = bgElements.size();
        for (int i = 0; i < in; ++i) {
            bgElementNum = (String)bgElements.get(i);
            _bgElementSet.add(bgElementNum);
        }
        _bgElementList.addAll(_bgElementSet);
        size = _bgElementList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementId = rst.getString(1);
                    bgElementNum = rst.getString(2);
                    bgElementMap.put(bgElementNum, bgElementId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgElementMap;
    }

    private Map getCurrencyMap(Context ctx, List currencys) throws EASBizException {
        if (ctx == null || currencys == null || currencys.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        HashSet<String> _currencySet = new HashSet<String>();
        ArrayList<String> _currencyList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String currencyId = null;
        String currencyNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int in = currencys.size();
        for (int i = 0; i < in; ++i) {
            currencyNum = (String)currencys.get(i);
            _currencySet.add(currencyNum);
        }
        _currencyList.addAll(_currencySet);
        size = _currencyList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_currencyList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyId = rst.getString(1);
                    currencyNum = rst.getString(2);
                    currencyMap.put(currencyNum, currencyId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return currencyMap;
    }

    private String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }
}

