/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgCombinDataFilterParam;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgElimSourceEnum;
import com.kingdee.eas.ma.nbudget.BgElimStatusEnum;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryCollection;
import com.kingdee.eas.ma.nbudget.BgElimTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgEliminationEntryInfo;
import com.kingdee.eas.ma.nbudget.BgEliminationFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationInfo;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckInfo;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckInfoComparator;
import com.kingdee.eas.ma.nbudget.BgInnerFillDiffDataInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgWorkDataInfo;
import com.kingdee.eas.ma.nbudget.BizDirectionEnum;
import com.kingdee.eas.ma.nbudget.IBgElimination;
import com.kingdee.eas.ma.nbudget.app.AbstractBgElimFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElimFacadeControllerBean
extends AbstractBgElimFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgElimFacadeControllerBean");

    @Override
    protected Map _getOrgMapping(Context ctx, List treeIdList) throws BOSException, EASBizException {
        int i;
        HashMap<OrgTreeInfo, FullOrgUnitInfo> map = new HashMap<OrgTreeInfo, FullOrgUnitInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT m.FTreeId, t.FNumber, t.FName_" + ctx.getLocale() + ", ").append(" m.FOrgUnitId, b.FNumber, b.FName_" + ctx.getLocale() + " ").append(" FROM T_BG_BGElimOrgMapping m ").append(" JOIN T_ORG_TREE t ON t.FID = m.FTreeId ").append(" JOIN T_ORG_BaseUnit b ON b.FID = m.FOrgUnitId ");
        if (treeIdList != null && !treeIdList.isEmpty()) {
            sql.append("WHERE m.FTreeId in (");
            for (i = 1; i < treeIdList.size(); ++i) {
                sql.append("?,");
            }
            sql.append("?)");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            if (treeIdList != null && !treeIdList.isEmpty()) {
                for (i = 0; i < treeIdList.size(); ++i) {
                    pstmt.setString(i + 1, (String)treeIdList.get(i));
                }
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)rst.getString(1)));
                treeInfo.setNumber(rst.getString(2));
                treeInfo.setName(rst.getString(3));
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rst.getString(4)));
                orgUnitInfo.setNumber(rst.getString(5));
                orgUnitInfo.setName(rst.getString(6));
                map.put(treeInfo, orgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return map;
    }

    @Override
    protected void _saveOrgMapping(Context ctx, Map map) throws BOSException, EASBizException {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.checkCanSaveOrgMapping(ctx, map);
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sqlDelete = new StringBuffer();
        sqlDelete.append("DELETE FROM T_BG_BGElimOrgMapping WHERE FTreeId = ? ");
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO T_BG_BGElimOrgMapping(FTreeId, FOrgUnitId) VALUES(?, ?)");
        OrgTreeInfo treeInfo2 = null;
        OrgUnitInfo orgUnitInfo = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sqlDelete.toString());
            for (OrgTreeInfo treeInfo2 : map.keySet()) {
                pstmt.setString(1, treeInfo2.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(sqlInsert.toString());
            for (OrgTreeInfo treeInfo2 : map.keySet()) {
                orgUnitInfo = (OrgUnitInfo)map.get(treeInfo2);
                if (treeInfo2 != null && orgUnitInfo != null) {
                    pstmt.setString(1, treeInfo2.getId().toString());
                    pstmt.setString(2, orgUnitInfo.getId().toString());
                    pstmt.addBatch();
                    continue;
                }
                if (treeInfo2 == null || orgUnitInfo != null) continue;
                pstmt.setString(1, treeInfo2.getId().toString());
                pstmt.setString(2, "null");
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void checkCanSaveOrgMapping(Context ctx, Map map) throws BOSException, EASBizException {
        if (map == null || map.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT FTreeId, FOrgUnitId FROM T_BG_BGElimTemplate ");
        String treeId = null;
        String orgUnitId = null;
        OrgTreeInfo treeInfo2 = null;
        OrgUnitInfo orgUnitInfo = null;
        StringBuffer msg = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            block4: while (rst.next()) {
                treeId = rst.getString(1);
                orgUnitId = rst.getString(2);
                for (OrgTreeInfo treeInfo2 : map.keySet()) {
                    orgUnitInfo = (OrgUnitInfo)map.get(treeInfo2);
                    if (!treeInfo2.getId().toString().equals(treeId) || orgUnitInfo != null && orgUnitInfo.getId().toString().equals(orgUnitId)) continue;
                    msg.append(treeInfo2.getName()).append(",");
                    continue block4;
                }
            }
            if (msg.length() > 0) {
                throw new BgElimException(BgElimException.ELIMORGMAPPINGCANNOTMODIFY, new String[]{msg.substring(0, msg.length() - 1)});
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _queryInnerDataCheck(Context ctx, Map param) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap<String, Object> map;
        block43: {
            int i;
            int size;
            map = new HashMap<String, Object>();
            if (param == null || param.isEmpty()) {
                return map;
            }
            ArrayList<BgInnerDataCheckInfo> datas = new ArrayList<BgInnerDataCheckInfo>();
            conn = null;
            pstmt = null;
            rst = null;
            int pos = 1;
            String orgUnit = (String)param.get("ORG_UNIT");
            String[] orgUnitIds = (String[])param.get("ORG_UNIT_RANGE");
            String orgUnitLongNum = (String)param.get("ORG_GROUP");
            String orgTreeId = (String)param.get("ORG_TREE");
            String elimTemplateId = (String)param.get("BG_ELIM_TEMPLATE");
            String bgSchemeId = (String)param.get("BG_SCHEME");
            String bgPeriodId = (String)param.get("BG_PERIOD");
            String bgElementId = (String)param.get("BG_ELEMENT");
            String currencyId = (String)param.get("CURRENCY");
            BgDataTypeEnum dataType = (BgDataTypeEnum)param.get("DATA_TYPE");
            boolean isOrgGroup = orgUnitLongNum != null;
            String oql = "SELECT entries.bgItemNumber, entries.bgItemName, entries.bizDirection where id = '" + elimTemplateId + "'";
            BgElimTemplateInfo elimTemplateInfo = BgElimTemplateFactory.getLocalInstance(ctx).getBgElimTemplateInfo(oql);
            BgElimTemplateEntryCollection entryCol = elimTemplateInfo.getEntries();
            HashMap<String, BizDirectionEnum> bgItemMap = new HashMap<String, BizDirectionEnum>();
            for (int i2 = 0; i2 < entryCol.size(); ++i2) {
                bgItemMap.put(entryCol.get(i2).getBgItemNumber(), entryCol.get(i2).getBizDirection());
            }
            ArrayList bgItemList = new ArrayList();
            bgItemList.add(bgItemMap.keySet());
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT o1.FNumber, o1.FName_" + ctx.getLocale() + ", o2.FNumber, o2.FName_" + ctx.getLocale() + ",");
            sql.append(" e.FBgItemNumber, e.FBgItemName, e.FFillAmount, ");
            sql.append(" e.FAmount, e.FStatus, e.FEliminationId, u.FName_" + ctx.getLocale() + ", e.FConfirmTime, e.ForgUnitId, e.FoppOrgUnitId, e.FID ");
            sql.append(" FROM T_BG_BGInnerFillDataEntry e ");
            sql.append(" JOIN T_Org_BaseUnit o1 ON o1.FID =  e.FOrgUnitID ");
            sql.append(" JOIN T_Org_BaseUnit o2 ON o2.FID =  e.FOppOrgUnitID ");
            sql.append(" LEFT OUTER JOIN T_PM_User u ON u.FID =  e.FAffirmantID ");
            sql.append(" WHERE e.FBgPeriodID = ? ");
            sql.append(" AND e.FBgElementID = ? ");
            sql.append(" AND e.FCurrencyID = ? ");
            sql.append(" AND e.FDataType = ? ");
            sql.append(" AND e.FBgItemNumber IN ('',");
            for (int i3 = 1; i3 < entryCol.size(); ++i3) {
                sql.append("?,");
            }
            sql.append("?)");
            if (!isOrgGroup && orgUnit != null) {
                sql.append(" AND (e.FOrgUnitID = ? OR e.FOppOrgUnitID = ?)");
                if (orgUnitIds != null && orgUnitIds.length > 0) {
                    size = orgUnitIds.length + 1;
                    sql.append(" AND e.FOrgUnitID IN (");
                    for (i = 1; i < size; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                    sql.append(" AND e.FOppOrgUnitID IN (");
                    for (i = 1; i < size; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                }
            } else if (isOrgGroup && orgUnitLongNum != null && orgTreeId != null) {
                sql.append(" AND e.FOrgUnitID IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeID  = ? AND FLongNumber LIKE ?)");
                sql.append(" AND e.FOppOrgUnitID IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeID  = ? AND FLongNumber LIKE ?)");
                if (orgUnitIds != null && orgUnitIds.length > 0) {
                    size = orgUnitIds.length + 1;
                    sql.append(" AND e.FOrgUnitID IN (");
                    for (i = 1; i < size; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                    sql.append(" AND e.FOppOrgUnitID IN (");
                    for (i = 1; i < size; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                }
            }
            String sql2 = " (SELECT FRootId FROM T_BG_BGScheme WHERE FID = ?)";
            String schemeRoodID = null;
            try {
                BgInnerDataCheckInfo info;
                int i4;
                int size2;
                int i5;
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql2);
                pstmt.setString(1, bgSchemeId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    schemeRoodID = rst.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (schemeRoodID != null) {
                    sql.append(" AND e.FBgSchemeID in ( SELECT FID FROM T_BG_BGScheme WHERE FRootId = '" + schemeRoodID + "' )");
                }
                sql.append(" ORDER BY o1.FNumber, o2.FNumber");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(pos++, bgPeriodId);
                pstmt.setString(pos++, bgElementId);
                pstmt.setString(pos++, currencyId);
                pstmt.setInt(pos++, dataType.getValue());
                for (i5 = 0; i5 < entryCol.size(); ++i5) {
                    pstmt.setString(pos++, entryCol.get(i5).getBgItemNumber());
                }
                if (!isOrgGroup && orgUnit != null) {
                    pstmt.setString(pos++, orgUnit);
                    pstmt.setString(pos++, orgUnit);
                    if (orgUnitIds != null && orgUnitIds.length > 0) {
                        size2 = orgUnitIds.length;
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                    }
                } else if (isOrgGroup && orgUnitLongNum != null && orgTreeId != null) {
                    pstmt.setString(pos++, orgTreeId);
                    pstmt.setString(pos++, orgUnitLongNum + "!%");
                    pstmt.setString(pos++, orgTreeId);
                    pstmt.setString(pos++, orgUnitLongNum + "!%");
                    if (orgUnitIds != null && orgUnitIds.length > 0) {
                        size2 = orgUnitIds.length;
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                    }
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    info = new BgInnerDataCheckInfo();
                    info.setOrgUnitNumber(rst.getString(1));
                    info.setOrgUnitName(rst.getString(2));
                    info.setOppOrgUnitNumber(rst.getString(3));
                    info.setOppOrgUnitName(rst.getString(4));
                    info.setBgItemNumber(rst.getString(5));
                    info.setBgItemName(rst.getString(6));
                    info.setBizDirection(((BizDirectionEnum)((Object)bgItemMap.get(info.getBgItemNumber()))).getValue());
                    info.setFillAmount(rst.getBigDecimal(7) == null ? new BigDecimal("0.00") : rst.getBigDecimal(7));
                    info.setAmount(rst.getBigDecimal(8) == null ? new BigDecimal("0.00") : rst.getBigDecimal(8));
                    info.setStatus(rst.getInt(9));
                    info.setHasGenElim(!StringUtils.isEmpty((String)rst.getString(10)));
                    info.setAffirmant(rst.getString(11));
                    if (rst.getDate(12) != null) {
                        info.setConfirmDate(rst.getDate(12));
                    }
                    info.setOrgUnitId(rst.getString(13));
                    info.setOppOrgUnitId(rst.getString(14));
                    info.setId(rst.getString(15));
                    info.setKey(this.genOrgKey(info.getOrgUnitNumber(), info.getOppOrgUnitNumber()));
                    datas.add(info);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement(sql.toString().replaceFirst("T_BG_BGInnerFillDataEntry", "T_BG_BGInnerFillDiffData"));
                pos = 1;
                pstmt.setString(pos++, bgPeriodId);
                pstmt.setString(pos++, bgElementId);
                pstmt.setString(pos++, currencyId);
                pstmt.setInt(pos++, dataType.getValue());
                for (i5 = 0; i5 < entryCol.size(); ++i5) {
                    pstmt.setString(pos++, entryCol.get(i5).getBgItemNumber());
                }
                if (!isOrgGroup && orgUnit != null) {
                    pstmt.setString(pos++, orgUnit);
                    pstmt.setString(pos++, orgUnit);
                    if (orgUnitIds != null && orgUnitIds.length > 0) {
                        size2 = orgUnitIds.length;
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                    }
                } else if (isOrgGroup && orgUnitLongNum != null && orgTreeId != null) {
                    pstmt.setString(pos++, orgTreeId);
                    pstmt.setString(pos++, orgUnitLongNum + "!%");
                    pstmt.setString(pos++, orgTreeId);
                    pstmt.setString(pos++, orgUnitLongNum + "!%");
                    if (orgUnitIds != null && orgUnitIds.length > 0) {
                        size2 = orgUnitIds.length;
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                        pstmt.setString(pos++, orgUnit);
                        for (i4 = 0; i4 < size2; ++i4) {
                            pstmt.setString(pos++, orgUnitIds[i4]);
                        }
                    }
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    info = new BgInnerDataCheckInfo();
                    info.setOrgUnitNumber(rst.getString(1));
                    info.setOrgUnitName(rst.getString(2));
                    info.setOppOrgUnitNumber(rst.getString(3));
                    info.setOppOrgUnitName(rst.getString(4));
                    info.setBgItemNumber(rst.getString(5));
                    info.setBgItemName(rst.getString(6));
                    info.setBizDirection(((BizDirectionEnum)((Object)bgItemMap.get(info.getBgItemNumber()))).getValue());
                    info.setFillAmount(rst.getBigDecimal(7) == null ? new BigDecimal("0.00") : rst.getBigDecimal(7));
                    info.setAmount(rst.getBigDecimal(8) == null ? new BigDecimal("0.00") : rst.getBigDecimal(8));
                    info.setStatus(rst.getInt(9));
                    info.setHasGenElim(!StringUtils.isEmpty((String)rst.getString(10)));
                    info.setAffirmant(rst.getString(11));
                    if (rst.getDate(12) != null) {
                        info.setConfirmDate(rst.getDate(12));
                    }
                    info.setOrgUnitId(rst.getString(13));
                    info.setOppOrgUnitId(rst.getString(14));
                    info.setId(rst.getString(15));
                    info.setKey(this.genOrgKey(info.getOrgUnitNumber(), info.getOppOrgUnitNumber()));
                    datas.add(info);
                }
                Collections.sort(datas, new BgInnerDataCheckInfoComparator());
                if (datas.size() > 200) {
                    map.put("datas", this.pack(datas));
                    break block43;
                }
                map.put("datas", datas);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"error", (Throwable)e);
                    throw new BgException(BgException.DATABASEERROR, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return map;
    }

    private String genOrgKey(String num1, String num2) {
        if (num1 == null || num2 == null) {
            return null;
        }
        if (num1.compareTo(num2) > 0) {
            return num1 + "|" + num2;
        }
        return num2 + "|" + num1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pack(Object o) {
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(o);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
        return Base64.encodeBytes(objByte);
    }

    @Override
    protected boolean _confirmInnerData(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.isEmpty()) {
            return true;
        }
        List datas = (List)param.get("datas");
        BgInnerDataCheckInfo info = null;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> idListRelease = new ArrayList<String>();
        int size = datas.size();
        int batchSize = 200;
        int index = 0;
        int pos = 1;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Date date = new Date(System.currentTimeMillis());
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_BG_BgInnerFillDataEntry SET FAmount = ?, FStatus = ?, FAffirmantID = ?, FConfirmTime = ? ");
        sql.append(" WHERE FID = ? AND FStatus = 1 ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" DELETE FROM T_BG_BgInnerFillDiffData WHERE FBgSchemeID = ? AND FBgPeriodID = ?  ");
        sql2.append(" AND FBgElementID = ? AND FCurrencyID = ? AND FOrgUnitID = ? AND FOppOrgUnitID = ? ");
        sql2.append(" AND FDataType = ? AND FBgItemNumber = ? ");
        StringBuffer sql3 = new StringBuffer();
        sql3.append(" INSERT INTO T_BG_BgInnerFillDiffData (FID, FBgSchemeID, FBgPeriodID, FBgElementID, FCurrencyID,");
        sql3.append(" FOrgUnitID, FOppOrgUnitID, FDataType, FBgItemId, FBgItemNumber, FBgItemName, FAmount, ");
        sql3.append(" FStatus, FAffirmantId, FConfirmTime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sql4 = new StringBuffer();
        sql4.append(" SELECT DISTINCT FBgInnerFillDataID FROM T_BG_BgInnerFillDataEntry WHERE FID IN (");
        for (int i = 1; i < datas.size(); ++i) {
            sql4.append("?,");
        }
        sql4.append("?)");
        ArrayList<BgInnerDataCheckInfo> diffDealData = new ArrayList<BgInnerDataCheckInfo>();
        try {
            int i;
            conn = this.getConnection(ctx);
            pstmt4 = conn.prepareStatement(sql4.toString());
            for (i = 0; i < datas.size(); ++i) {
                pstmt4.setString(pos++, ((BgInnerDataCheckInfo)datas.get(i)).getId());
            }
            rst = pstmt4.executeQuery();
            while (rst.next()) {
                idList.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst);
            for (i = 0; i < idList.size(); ++i) {
                if (!iMC.requestBizObjIDForUpdate((String)idList.get(i))) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, (Object[])new String[]{"\u8be5\u5bf9\u8c61\u5df2\u88ab\u9501\u5b9a\uff01"});
                }
                idListRelease.add((String)idList.get(i));
            }
            pstmt = conn.prepareStatement(sql.toString());
            size = datas.size();
            for (i = 0; i < size; ++i) {
                info = (BgInnerDataCheckInfo)datas.get(i);
                if (info.getId() == null) {
                    diffDealData.add(info);
                    continue;
                }
                pstmt.setBigDecimal(1, info.getAmount());
                pstmt.setInt(2, 2);
                pstmt.setString(3, userId);
                pstmt.setDate(4, date);
                pstmt.setString(5, info.getId());
                pstmt.addBatch();
                if (++index < batchSize) continue;
                pstmt.executeUpdate();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
            if (!diffDealData.isEmpty()) {
                pstmt2 = conn.prepareStatement(sql2.toString());
                pstmt3 = conn.prepareStatement(sql3.toString());
                String bgSchemeId = (String)param.get("BG_SCHEME");
                String bgPeriodId = (String)param.get("BG_PERIOD");
                String bgElementId = (String)param.get("BG_ELEMENT");
                String currencyId = (String)param.get("CURRENCY");
                BgDataTypeEnum dataType = (BgDataTypeEnum)param.get("DATA_TYPE");
                BgInnerFillDiffDataInfo diffDataInfo = new BgInnerFillDiffDataInfo();
                size = diffDealData.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    info = (BgInnerDataCheckInfo)diffDealData.get(i2);
                    pstmt2.setString(1, bgSchemeId);
                    pstmt2.setString(2, bgPeriodId);
                    pstmt2.setString(3, bgElementId);
                    pstmt2.setString(4, currencyId);
                    pstmt2.setString(5, info.getOrgUnitId());
                    pstmt2.setString(6, info.getOppOrgUnitId());
                    pstmt2.setInt(7, dataType.getValue());
                    pstmt2.setString(8, info.getBgItemNumber());
                    pstmt2.addBatch();
                    pstmt3.setString(1, BOSUuid.create((BOSObjectType)diffDataInfo.getBOSType()).toString());
                    pstmt3.setString(2, bgSchemeId);
                    pstmt3.setString(3, bgPeriodId);
                    pstmt3.setString(4, bgElementId);
                    pstmt3.setString(5, currencyId);
                    pstmt3.setString(6, info.getOrgUnitId());
                    pstmt3.setString(7, info.getOppOrgUnitId());
                    pstmt3.setInt(8, dataType.getValue());
                    pstmt3.setString(9, info.getBgItemId());
                    pstmt3.setString(10, info.getBgItemNumber());
                    pstmt3.setString(11, info.getBgItemName());
                    pstmt3.setBigDecimal(12, info.getAmount());
                    pstmt3.setInt(13, 2);
                    pstmt3.setString(14, userId);
                    pstmt3.setDate(15, date);
                    pstmt3.addBatch();
                }
                pstmt2.executeBatch();
                pstmt3.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt2);
                SQLUtils.cleanup(pstmt3, (Connection)conn);
                SQLUtils.cleanup((Statement)pstmt4);
                iMC.batchReleaseObjIDForUpdate(idListRelease);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup(pstmt2);
        SQLUtils.cleanup(pstmt3, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt4);
        iMC.batchReleaseObjIDForUpdate(idListRelease);
        return true;
    }

    @Override
    protected boolean _cancelConfirmInnerData(Context ctx, Map param) throws BOSException, EASBizException {
        int i;
        if (param == null || param.isEmpty()) {
            return true;
        }
        List datas = (List)param.get("datas");
        String bgSchemeId = (String)param.get("BG_SCHEME");
        String bgPeriodId = (String)param.get("BG_PERIOD");
        String bgElementId = (String)param.get("BG_ELEMENT");
        String currencyId = (String)param.get("CURRENCY");
        BgDataTypeEnum dataType = (BgDataTypeEnum)param.get("DATA_TYPE");
        BgInnerDataCheckInfo info = null;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> idListRelease = new ArrayList<String>();
        int size = datas.size();
        int batchSize = 500;
        int index = 0;
        int pos = 1;
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_BG_BgInnerFillDataEntry SET FAmount = ?, FStatus = ?, FAffirmantID = ?, FConfirmTime = ? ");
        sql.append(" WHERE FID = ? AND FStatus = 2 ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" DELETE FROM T_BG_BgInnerFillDiffData WHERE FBgSchemeID = ? AND FBgPeriodID = ?  ");
        sql2.append(" AND FBgElementID = ? AND FCurrencyID = ? AND FOrgUnitID = ? AND FOppOrgUnitID = ? ");
        sql2.append(" AND FDataType = ? AND FBgItemNumber = ? ");
        StringBuffer sql3 = new StringBuffer();
        sql3.append(" SELECT DISTINCT FBgInnerFillDataID FROM T_BG_BgInnerFillDataEntry WHERE FID IN (");
        for (i = 1; i < datas.size(); ++i) {
            sql3.append("?,");
        }
        sql3.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt2 = conn.prepareStatement(sql2.toString());
            pstmt3 = conn.prepareStatement(sql3.toString());
            for (i = 0; i < datas.size(); ++i) {
                pstmt3.setString(pos++, ((BgInnerDataCheckInfo)datas.get(i)).getId());
            }
            rst = pstmt3.executeQuery();
            while (rst.next()) {
                idList.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst);
            for (i = 0; i < idList.size(); ++i) {
                if (!iMC.requestBizObjIDForUpdate((String)idList.get(i))) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, (Object[])new String[]{"\u8be5\u5bf9\u8c61\u5df2\u88ab\u9501\u5b9a\uff01"});
                }
                idListRelease.add((String)idList.get(i));
            }
            size = datas.size();
            for (i = 0; i < size; ++i) {
                info = (BgInnerDataCheckInfo)datas.get(i);
                pstmt.setBigDecimal(1, BgNConstants.ZERO);
                pstmt.setInt(2, 1);
                pstmt.setString(3, null);
                pstmt.setDate(4, null);
                pstmt.setString(5, info.getId());
                pstmt.addBatch();
                ++index;
                pstmt2.setString(1, bgSchemeId);
                pstmt2.setString(2, bgPeriodId);
                pstmt2.setString(3, bgElementId);
                pstmt2.setString(4, currencyId);
                pstmt2.setString(5, info.getOrgUnitId());
                pstmt2.setString(6, info.getOppOrgUnitId());
                pstmt2.setInt(7, dataType.getValue());
                pstmt2.setString(8, info.getBgItemNumber());
                pstmt2.addBatch();
                if (index < batchSize) continue;
                pstmt.executeBatch();
                pstmt2.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
                pstmt2.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(pstmt2, (Connection)conn);
                SQLUtils.cleanup(rst, pstmt3);
                iMC.batchReleaseObjIDForUpdate(idListRelease);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt2, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt3);
        iMC.batchReleaseObjIDForUpdate(idListRelease);
        return true;
    }

    @Override
    protected boolean _genElimination(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null || dataMap.isEmpty()) {
            return false;
        }
        boolean hasCode = false;
        ICodingRuleManager codingRuleManager = null;
        codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        IBgElimination iBgElimination = BgEliminationFactory.getLocalInstance(ctx);
        HashMap<String, ArrayList<String>> updateMap = new HashMap<String, ArrayList<String>>();
        IObjectPK pk = null;
        BgEliminationInfo eliminationInfo = null;
        BgEliminationEntryInfo entryInfo = null;
        HashMap<String, BgEliminationInfo> bgElimMap = new HashMap<String, BgEliminationInfo>();
        List datas = null;
        ArrayList<String> orgIds = new ArrayList<String>();
        HashMap<String, String> orgLongNums = new HashMap<String, String>();
        HashMap<String, String> orgIdMap = new HashMap<String, String>();
        HashMap<String, String> itemCommentMap = new HashMap<String, String>();
        String orgUnitId2 = null;
        BgInnerDataCheckInfo info = null;
        String orgKey2 = null;
        ArrayList<String> orgKeyList = new ArrayList<String>();
        String treeId = (String)dataMap.get("ORG_TREE");
        String bgElimTemplateId = (String)dataMap.get("BG_ELIM_TEMPLATE");
        String bgSchemeId = (String)dataMap.get("BG_SCHEME");
        String bgPeriodId = (String)dataMap.get("BG_PERIOD");
        String bgElementId = (String)dataMap.get("BG_ELEMENT");
        String currencyId = (String)dataMap.get("CURRENCY");
        BgDataTypeEnum dataType = (BgDataTypeEnum)dataMap.get("DATA_TYPE");
        BgElimTypeEnum elimType = (BgElimTypeEnum)((Object)dataMap.get("ELIM_TYPE"));
        OrgTreeInfo treeInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgElementInfo bgElementInfo = null;
        CurrencyInfo currencyInfo = null;
        dataMap.remove("ORG_TREE");
        dataMap.remove("BG_ELIM_TEMPLATE");
        dataMap.remove("BG_SCHEME");
        dataMap.remove("BG_PERIOD");
        dataMap.remove("BG_ELEMENT");
        dataMap.remove("CURRENCY");
        dataMap.remove("DATA_TYPE");
        dataMap.remove("ELIM_TYPE");
        for (String orgKey2 : dataMap.keySet()) {
            if (orgKey2.indexOf("|") == -1) continue;
            orgKeyList.add(orgKey2);
            datas = (List)dataMap.get(orgKey2);
            if (datas == null || datas.isEmpty()) continue;
            info = (BgInnerDataCheckInfo)datas.get(0);
            orgIds.add(info.getOrgUnitId());
        }
        Collections.sort(orgKeyList);
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT o.FID, o.FNumber, s.FLongNumber FROM T_ORG_STRUCTURE s ");
        sql.append(" JOIN T_ORG_BaseUnit o ON o.FID = s.FUnitId WHERE FTreeId = ? ");
        StringBuffer sql1 = new StringBuffer();
        sql1.append(" SELECT FBgItemNumber, FComment FROM T_BG_BGElimTemplateEntry WHERE FElimTemplateId = ? ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" UPDATE T_BG_BGInnerFillDataEntry SET FEliminationId = ?, FStatus = ? WHERE FID = ? ");
        StringBuffer sql3 = new StringBuffer();
        sql3.append(" UPDATE T_BG_BGInnerFillDiffData SET FEliminationId = ?, FStatus = ? WHERE FID = ? ");
        int pos = 1;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt1 = conn.prepareStatement(sql1.toString());
            pstmt2 = conn.prepareStatement(sql2.toString());
            pstmt3 = conn.prepareStatement(sql3.toString());
            pstmt.setString(pos++, treeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgLongNums.put(rst.getString(2), rst.getString(3));
                orgIdMap.put(rst.getString(3), rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst);
            pstmt1.setString(1, bgElimTemplateId);
            rst = pstmt1.executeQuery();
            while (rst.next()) {
                itemCommentMap.put(rst.getString(1), rst.getString(2));
            }
            SQLUtils.cleanup((ResultSet)rst);
            for (String orgKey2 : orgKeyList) {
                if (orgKey2.indexOf("|") == -1 || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)(orgUnitId2 = this.getElimOrgUnitId(orgKey2, orgLongNums, orgIdMap)))) continue;
                if (bgElimMap.containsKey(orgUnitId2)) {
                    eliminationInfo = (BgEliminationInfo)bgElimMap.get(orgUnitId2);
                } else {
                    eliminationInfo = new BgEliminationInfo();
                    bgElimMap.put(orgUnitId2, eliminationInfo);
                    treeInfo = new OrgTreeInfo();
                    treeInfo.setId(BOSUuid.read((String)treeId));
                    eliminationInfo.setOrgTree(treeInfo);
                    FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgUnitId2));
                    eliminationInfo.setOrgUnit(orgUnitInfo);
                    eliminationInfo.setElimTemplateId(bgElimTemplateId);
                    eliminationInfo.setElimType(elimType);
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)bgSchemeId));
                    eliminationInfo.setBgScheme(bgSchemeInfo);
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)bgPeriodId));
                    eliminationInfo.setBgPeriod(bgPeriodInfo);
                    bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)bgElementId));
                    eliminationInfo.setBgElement(bgElementInfo);
                    currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)currencyId));
                    eliminationInfo.setCurrency(currencyInfo);
                    eliminationInfo.setSource(BgElimSourceEnum.innerDataGen);
                    eliminationInfo.setStatus(BgElimStatusEnum.UnAudit);
                    eliminationInfo.setDataType(dataType);
                }
                datas = (List)dataMap.get(orgKey2);
                for (int i = 0; i < datas.size(); ++i) {
                    info = (BgInnerDataCheckInfo)datas.get(i);
                    if (!(info.getAmount() instanceof BigDecimal) || info.getAmount().compareTo(BgNConstants.ZERO) == 0) continue;
                    entryInfo = new BgEliminationEntryInfo();
                    entryInfo.setBgElimination(eliminationInfo);
                    entryInfo.setBgItemId(info.getBgItemId());
                    entryInfo.setBgItemNumber(info.getBgItemNumber());
                    entryInfo.setBgItemName(info.getBgItemName());
                    entryInfo.setSummary((String)itemCommentMap.get(info.getBgItemNumber()));
                    if (info.getOrgUnitId() != null) {
                        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                        orgUnit.setId(BOSUuid.read((String)info.getOrgUnitId()));
                        entryInfo.setOrgUnit(orgUnit);
                    }
                    if (0 == info.getBizDirection() && info.getAmount() instanceof BigDecimal && info.getAmount().compareTo(BgNConstants.ZERO) != 0) {
                        entryInfo.setDebitAmount(info.getAmount());
                    } else if (1 == info.getBizDirection() && info.getAmount() instanceof BigDecimal && info.getAmount().compareTo(BgNConstants.ZERO) != 0) {
                        entryInfo.setCreditAmount(info.getAmount());
                    }
                    eliminationInfo.getEntries().add(entryInfo);
                    ArrayList<String> dataIds = (ArrayList<String>)updateMap.get(orgUnitId2);
                    if (dataIds == null) {
                        dataIds = new ArrayList<String>();
                        updateMap.put(orgUnitId2, dataIds);
                    }
                    dataIds.add(info.getId());
                }
            }
            for (String orgUnitId2 : bgElimMap.keySet()) {
                eliminationInfo = (BgEliminationInfo)bgElimMap.get(orgUnitId2);
                if (eliminationInfo.getEntries().size() <= 0) continue;
                hasCode = codingRuleManager.isExist((IObjectValue)eliminationInfo, orgUnitId2);
                if (!hasCode) {
                    this.setEliminationNumber(ctx, eliminationInfo);
                }
                pk = iBgElimination.addnew(eliminationInfo);
                List dataIds = (List)updateMap.get(orgUnitId2);
                if (pk == null || dataIds == null) continue;
                for (int i = 0; i < dataIds.size(); ++i) {
                    pstmt2.setString(1, pk.toString());
                    pstmt2.setInt(2, 4);
                    pstmt2.setString(3, (String)dataIds.get(i));
                    pstmt2.addBatch();
                    pstmt3.setString(1, pk.toString());
                    pstmt3.setInt(2, 4);
                    pstmt3.setString(3, (String)dataIds.get(i));
                    pstmt3.addBatch();
                }
                pstmt2.executeBatch();
                pstmt3.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt1);
                SQLUtils.cleanup(pstmt2);
                SQLUtils.cleanup(pstmt3);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt1);
        SQLUtils.cleanup((Statement)pstmt2);
        SQLUtils.cleanup((Statement)pstmt3);
        return true;
    }

    private void setEliminationNumber(Context ctx, BgEliminationInfo info) throws BOSException, EASBizException {
        if (info == null || info.getOrgUnit() == null) {
            return;
        }
        String number = "";
        try {
            IRowSet rs;
            for (int i = 1; i < 1000 && (rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_BG_BGElimination WHERE FNumber = ? AND FOrgUnitID = ? ", (Object[])new String[]{number = "DZPT-000" + i, info.getOrgUnit().getId().toString()})).next(); ++i) {
            }
            if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
                info.setNumber(number);
            } else {
                info.setNumber("DZPT-" + System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BgException(BgException.DATABASEERROR, (Throwable)e);
        }
    }

    private String getElimOrgUnitId(String orgKey, Map orgLongNums, Map orgIds) {
        if (orgKey == null || orgKey.indexOf("|") == -1 || orgLongNums == null || orgIds == null) {
            return null;
        }
        String[] orgNumbers = orgKey.split("\\|");
        String longNum1 = (String)orgLongNums.get(orgNumbers[0]);
        String longNum2 = (String)orgLongNums.get(orgNumbers[1]);
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)longNum1) && !com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)longNum2)) {
            String[] nums2;
            String[] nums1 = longNum1.split("\\!");
            int length = nums1.length <= (nums2 = longNum2.split("\\!")).length ? nums1.length : nums2.length;
            StringBuffer orgLongNum = new StringBuffer();
            for (int i = 0; i < length - 1 && nums1[i].equals(nums2[i]); ++i) {
                orgLongNum.append(nums1[i]).append("!");
            }
            if (orgLongNum.length() > 0) {
                String longNumStr = orgLongNum.substring(0, orgLongNum.length() - 1);
                return (String)orgIds.get(longNumStr);
            }
        }
        return null;
    }

    @Override
    protected Map _queryWorkData(Context ctx, Object filterParam) throws BOSException, EASBizException {
        HashMap dataMap = new HashMap();
        if (filterParam == null || !(filterParam instanceof BgCombinDataFilterParam)) {
            return dataMap;
        }
        String _orgUnitId = null;
        String _bgItemNumber = null;
        String _bgItemName = null;
        String _bgElementNumber = null;
        String _key = null;
        String _elementName = null;
        BigDecimal _bValue = null;
        int _dataType = 0;
        List<BgWorkDataInfo> tmpList = null;
        ArrayList<String> _tmpParam = new ArrayList<String>();
        Map bgDataMap = null;
        FullOrgUnitInfo unitInfo2 = null;
        FullOrgUnitInfo[] unitInfos = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgWorkDataInfo info = null;
        BgCombinDataFilterParam Param1 = (BgCombinDataFilterParam)((Object)filterParam);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpStr = null;
        sql.append("select x.*,y.FName_L2,y.FNumber from ");
        sql.append("(select a.FBgItemNumber, a.FBgItemName, a.FOrgGroupID, a.FBgElementID, sum(a.FConsolidAmount) FConsolidAmount, a.FDataType ");
        sql.append(" from t_bg_bgworkdata a ");
        sql.append(" where ");
        sql.append("a.FOrgGroupID IN (");
        unitInfos = Param1.getFullOrgUnitInfoAry();
        if (unitInfos != null && unitInfos.length > 0) {
            for (FullOrgUnitInfo unitInfo2 : unitInfos) {
                sql.append("?,");
                _tmpParam.add(unitInfo2.getId().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        } else {
            sql.append("'#')");
        }
        if (Param1.getBgSchemeInfo() != null) {
            sql.append(" and a.FBgSchemeID = ? ");
            _tmpParam.add(Param1.getBgSchemeInfo().getId().toString());
        }
        if (Param1.getBgWorkTemplateInfo() != null) {
            sql.append(" and a.FBgWorkPaperID in (select fid from t_bg_bgworkpaper where fbgworktemplateid = ? ) ");
            _tmpParam.add(Param1.getBgWorkTemplateInfo().getId().toString());
        }
        if (Param1.getBeginPeriod() != null && Param1.getEndPeriod() != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo((Context)ctx, (java.util.Date)Param1.getBeginPeriod().getBeginDate(), (java.util.Date)Param1.getEndPeriod().getEndDate(), (int)Param1.getBeginPeriod().getPeriodType().getValue())) != null) {
            sql.append(" and a.FBgPeriodID In (");
            tmpStr = new StringBuffer();
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpStr.append("?,");
                _tmpParam.add(bgPeriodInfo.getId().toString());
            }
            if (tmpStr.length() > 0) {
                tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
            }
            sql.append(tmpStr).append(")");
        }
        if (Param1.getCurrencyInfo() != null) {
            sql.append(" and a.FCurrencyID = ?");
            _tmpParam.add(Param1.getCurrencyInfo().getId().toString());
        }
        if (Param1.getMeasureUnitInfoMap() != null && Param1.getMeasureUnitInfoMap().size() > 0) {
            Map measureUnitInfoMap = Param1.getMeasureUnitInfoMap();
            sql.append(" and a.FBgElementID In (");
            tmpStr = new StringBuffer();
            String elementId = "";
            Iterator iter = measureUnitInfoMap.keySet().iterator();
            while (iter.hasNext()) {
                elementId = ((BgElementInfo)iter.next()).getId().toString();
                tmpStr.append("?,");
                _tmpParam.add(elementId);
            }
            if (tmpStr.length() > 0) {
                tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
            }
            sql.append(tmpStr).append(")");
        }
        sql.append(" group by a.FBgItemNumber, a.FBgItemName, a.FOrgGroupID, a.FBgElementID, a.FDataType  ) x ");
        sql.append(" left join T_BG_BgElement y on x.FBgElementID = y.FID order by FOrgGroupID, FBgItemNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpParam);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString("FOrgGroupID");
                _bgItemNumber = rst.getString("FBgItemNumber");
                _bgItemName = rst.getString("FBgItemName");
                _bValue = rst.getBigDecimal("FConsolidAmount");
                _dataType = rst.getInt("FDataType");
                _bgElementNumber = rst.getString("FBgElementID");
                _elementName = rst.getString("FName_L2");
                String _elementNumber = rst.getString("FNumber");
                if (dataMap.containsKey(_orgUnitId)) {
                    bgDataMap = (Map)dataMap.get(_orgUnitId);
                } else {
                    bgDataMap = new LinkedHashMap();
                    dataMap.put(_orgUnitId, bgDataMap);
                }
                _key = _bgItemNumber;
                if (bgDataMap.containsKey(_key)) {
                    tmpList = (List)bgDataMap.get(_key);
                } else {
                    tmpList = new ArrayList();
                    bgDataMap.put(_key, tmpList);
                }
                info = new BgWorkDataInfo();
                BgElementInfo bgElementInfo = new BgElementInfo();
                bgElementInfo.setId(BOSUuid.read((String)_bgElementNumber));
                bgElementInfo.setName(_elementName);
                bgElementInfo.setNumber(_elementNumber);
                info.setBgItemName(_bgItemName);
                info.setBgElement(bgElementInfo);
                info.setDataType(BgDataTypeEnum.getEnum((int)_dataType));
                info.setConsolidAmount(_bValue);
                tmpList.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryWorkData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dataMap;
    }

    @Override
    protected Map _queryElementUnitMap(Context ctx, Object filterParam) throws BOSException, EASBizException {
        LinkedHashMap<BgElementInfo, String> map = new LinkedHashMap<BgElementInfo, String>();
        FullOrgUnitInfo[] unitInfos = null;
        FullOrgUnitInfo unitInfo2 = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgCombinDataFilterParam Param1 = (BgCombinDataFilterParam)((Object)filterParam);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpStr = null;
        String _elementId = null;
        String _elementName = null;
        String _fcoefficient = null;
        sql.append("select x.FBgElementID,y.FName_L2,w.FCoefficient dfc, z.FCoefficient fc from(select m.FBgElementID,n.FDefaultMeasureUnitID,j.FMeasureUnitID from (select distinct a.FBgElementID, b.FBgWorkTemplateID from  t_bg_bgworkdata a inner join t_bg_bgworkpaper b  on a.FBgWorkPaperID=b.FID where ");
        sql.append("a.FOrgGroupID IN (");
        unitInfos = Param1.getFullOrgUnitInfoAry();
        if (unitInfos != null && unitInfos.length > 0) {
            for (FullOrgUnitInfo unitInfo2 : unitInfos) {
                sql.append("?,");
                _tmpList.add(unitInfo2.getId().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        } else {
            sql.append("'')");
        }
        if (Param1.getBgSchemeInfo() != null) {
            sql.append(" and a.FBgSchemeID = ? ");
            _tmpList.add(Param1.getBgSchemeInfo().getId().toString());
        }
        if (Param1.getBgWorkTemplateInfo() != null) {
            sql.append(" and a.FBgWorkPaperID in (select fid from t_bg_bgworkpaper where fbgworktemplateid = ? ) ");
            _tmpList.add(Param1.getBgWorkTemplateInfo().getId().toString());
        }
        if (Param1.getBeginPeriod() != null && Param1.getEndPeriod() != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo((Context)ctx, (java.util.Date)Param1.getBeginPeriod().getBeginDate(), (java.util.Date)Param1.getEndPeriod().getEndDate(), (int)Param1.getBeginPeriod().getPeriodType().getValue())) != null) {
            sql.append(" and a.FBgPeriodID In (");
            tmpStr = new StringBuffer();
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpStr.append("?,");
                _tmpList.add(bgPeriodInfo.getId().toString());
            }
            if (tmpStr.length() > 0) {
                tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
            }
            sql.append(tmpStr).append(")");
        }
        if (Param1.getCurrencyInfo() != null) {
            sql.append(" and a.FCurrencyID = ?");
            _tmpList.add(Param1.getCurrencyInfo().getId().toString());
        }
        sql.append(" ) m left join t_bg_bgworktemplate n on m.FBgWorkTemplateID= n.FID  left join t_bg_bgWorkTemMeasureUnit j on m.FBgElementID=j.FBgElementID  and m.FBgWorkTemplateID=j.FBgWorkTemplateID) x left join  T_BG_BgElement y on x.FBgElementID = y.FID  left join T_BD_MeasureUnit w on x.FDefaultMeasureUnitID=w.FID  left join T_BD_MeasureUnit z on x.FMeasureUnitID=z.FID  order by y.fnumber ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String _defaultfcoefficient = rst.getString("dfc");
                _fcoefficient = rst.getString("fc");
                _elementId = rst.getString("FBgElementID");
                _elementName = rst.getString("FName_L2");
                BgElementInfo bgElementInfo = new BgElementInfo();
                bgElementInfo.setId(BOSUuid.read((String)_elementId));
                bgElementInfo.setName(_elementName);
                if (_fcoefficient == null) {
                    map.put(bgElementInfo, _defaultfcoefficient);
                    continue;
                }
                map.put(bgElementInfo, _fcoefficient);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryElementUnitMap: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return map;
    }
}

