/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNActualRecordFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgNActualRecordFacadeControllerBean
extends AbstractBgNActualRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNActualRecordFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getCollectFormulaValue(Context ctx, Map schemeMap, List orgList, Map formulaMap, String bgPeriodLongNumber) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (schemeMap == null) return result;
        if (schemeMap.isEmpty()) {
            return result;
        }
        int paramSize = 50;
        String sql = null;
        String paramSql = this.getParamSql(paramSize);
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)"select fperiodType, fbegindate, fenddate   from t_bg_bgperiod where flongnumber = ? ", (Object[])new String[]{bgPeriodLongNumber});
        int periodType = -1;
        Date beginDate = new Date();
        Date endDate = new Date();
        try {
            if (rs1.next()) {
                periodType = rs1.getInt(1);
                beginDate = rs1.getDate(2);
                endDate = rs1.getDate(3);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (periodType == 8) {
            int year1 = beginDate.getYear() + 1900;
            int year2 = endDate.getYear() + 1900;
            String periodLongStr = "('" + bgPeriodLongNumber + "' ";
            for (int i = year1; i <= year2; ++i) {
                periodLongStr = periodLongStr + " , '" + i + "Y'";
            }
            periodLongStr = periodLongStr + ")";
            sql = "select sum(a.FBizActual) cnt ,a.FFormula  from t_bg_bgactualdata a , t_bg_bgactualrecord b ,t_bg_bgperiod c  where b.fid = a.fbgactualrecordid and b.fbgperiodid = c.fid and  b.fstate=2 and a.FFormula in " + paramSql + " and ( c.flongnumber in " + periodLongStr + " )";
        } else {
            sql = "select sum(a.FBizActual) cnt ,a.FFormula  from t_bg_bgactualdata a , t_bg_bgactualrecord b ,t_bg_bgperiod c  where b.fid = a.fbgactualrecordid and b.fbgperiodid = c.fid and  b.fstate=2 and a.FFormula in " + paramSql + " and ( c.flongnumber = '" + bgPeriodLongNumber + "' or c.flongnumber like '" + bgPeriodLongNumber + "!%' )";
        }
        int index = 0;
        for (String orgId : schemeMap.keySet()) {
            String schemeId = (String)schemeMap.get(orgId);
            sql = index == 0 ? sql + " and ( ( a.FOrgUnitId = '" + orgId + "' and a.FBgSchemeId = '" + schemeId + "' )" : sql + " or ( a.FOrgUnitId = '" + orgId + "' and a.FBgSchemeId = '" + schemeId + "' )";
            ++index;
        }
        if (schemeMap != null && !schemeMap.isEmpty()) {
            sql = sql + " ) ";
        }
        sql = sql + " group by a.FFormula having sum(a.FBizActual) != 0";
        BigDecimal zero = new BigDecimal("0.00");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlBgElement = " select fnumber from t_bg_bgelement where FApportionable = 1";
        HashMap<String, Object> bgElenmentMapCanCollect = new HashMap<String, Object>();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlBgElement);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgElenmentMapCanCollect.put(rs.getString(1), null);
            }
            SQLUtils.cleanup((ResultSet)rs);
            ps = conn.prepareStatement(sql);
            Vector keysVec = this.getFormulaParamVec(formulaMap, paramSize);
            for (int i = 0; i < keysVec.size(); ++i) {
                Vector vec = (Vector)keysVec.get(i);
                for (int n = 0; n < paramSize; ++n) {
                    String key = (String)vec.get(n);
                    ps.setString(n + 1, key);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    result.put(rs.getString(2), rs.getBigDecimal(1) == null ? zero : rs.getBigDecimal(1));
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    private Vector getFormulaParamVec(Map formulaMap, int paramSize) {
        int h = 0;
        String noFind = "#";
        Vector keysVec = new Vector();
        Vector<String> keyVec = null;
        Iterator it = formulaMap.keySet().iterator();
        while (it.hasNext()) {
            if (h == 0) {
                keyVec = new Vector<String>();
            }
            String key = (String)it.next();
            if (keyVec != null) {
                keyVec.add(key);
            }
            if (++h != paramSize) continue;
            h = 0;
            keysVec.add(keyVec);
        }
        if (keyVec != null && keyVec.size() != paramSize) {
            for (int i = keyVec.size(); i < paramSize; ++i) {
                keyVec.add(noFind);
            }
            keysVec.add(keyVec);
        }
        return keysVec;
    }

    private String getParamSql(int paramSize) {
        String sql = " ( ";
        if (paramSize <= 0) {
            return "";
        }
        for (int i = 0; i < paramSize; ++i) {
            sql = sql + " ? ,";
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + " ) ";
        return sql;
    }
}

