/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNEditUIHandler;
import com.kingdee.eas.ma.nbudget.utils.BgCodeRuleNUtils;
import java.util.HashSet;

public class BgNEditUIHandler
extends AbstractBgNEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        OrgUnitInfo unitInfo = (OrgUnitInfo)request.get("ORGUNIT_INFO");
        if (unitInfo == null) {
            return;
        }
        String orgUnitId = unitInfo.getId().toString();
        String userId = (String)request.get("USER_ID");
        if ("ADDNEW".equals(request.getState())) {
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
            BgCodeRuleNUtils ruleRule = new BgCodeRuleNUtils(context, true);
            ruleRule.applyNumber((IObjectValue)bgFormInfo, orgUnitId, "sourceType", null);
            ruleRule.applyNumber((IObjectValue)bgFormInfo, orgUnitId, "sourceType", "name");
            this.getCompanyByOrgUnit(context, unitInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        if (BgSHelper.isBgPermissionUsed((Context)context)) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitId);
            filter = BgPermissionHelper.addBgSchemePermission(context, userId, orgSet, filter);
        }
        IBgScheme ibgScheme = BgSchemeFactory.getLocalInstance((Context)context);
        ibgScheme.getBgSchemeCollection(view);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        CurrencyFactory.getLocalInstance((Context)context).getCurrencyCollection(view, true);
        this.getBaseCurrency(context, BOSUuid.read((String)orgUnitId));
        view = new EntityViewInfo();
        filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sic.add(sort);
        view.setSorter(sic);
        IBgElement ibgElement = BgElementFactory.getLocalInstance((Context)context);
        ibgElement.getBgElementCollection(view);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("coefficient"));
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)context);
        iMeasureUnit.getMeasureUnitCollection(view);
    }

    private CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    private SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    private void getBaseCurrency(Context ctx, BOSUuid orgUnitId) {
        if (ctx == null || orgUnitId == null) {
            return;
        }
        ObjectUuidPK pk = null;
        IFullOrgUnit iFullOrgUnit = null;
        try {
            iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            if (iFullOrgUnit == null) {
                return;
            }
            pk = new ObjectUuidPK(orgUnitId);
            FullOrgUnitInfo orgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)pk);
            if (orgUnitInfo != null && orgUnitInfo.isIsCompanyOrgUnit()) {
                this.getOrgBaseCurrency(ctx, orgUnitInfo.getId());
            } else {
                this.getBaseCurrency(ctx, orgUnitInfo.getParent().getId());
            }
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }

    private void getOrgBaseCurrency(Context ctx, BOSUuid orgUnitId) {
        if (ctx == null || orgUnitId == null) {
            return;
        }
        ObjectUuidPK pk = null;
        ICompanyOrgUnit iCompany = null;
        try {
            iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            if (iCompany == null) {
                return;
            }
            pk = new ObjectUuidPK(orgUnitId);
            iCompany.getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }
}

