/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNWorkPaperFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNWorkPaperFacadeControllerBean
extends AbstractBgNWorkPaperFacadeControllerBean {
    private static final String COST_CENTER = "COST_CENTER";
    private static final String UNION_DEPT = "UNION_DEPT";
    private static final long serialVersionUID = 7972880074844593241L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNWorkPaperFacadeControllerBean");

    @Override
    protected Map _audit(Context ctx, List workPaperIds) throws BOSException, EASBizException {
        if (workPaperIds == null || workPaperIds.isEmpty()) {
            return null;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String currId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("update t_bg_bgworkpaper set FAuditedTime = ? ,FAuditorID = ?, fstate =").append(2).append(" where fstate = ").append(1).append(" and fid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = 200;
            for (int i = 0; i < workPaperIds.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                }
                pstmt.setTimestamp(1, now);
                pstmt.setString(2, currId);
                pstmt.setObject(3, workPaperIds.get(i));
                pstmt.addBatch();
            }
            if (workPaperIds.size() > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected Map _unAudit(Context ctx, List workPaperIds) throws BOSException, EASBizException {
        if (workPaperIds == null || workPaperIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("update t_bg_bgworkpaper set FAuditedTime = null ,FAuditorID = null, fstate =").append(1).append(" where fstate = ").append(2).append(" and fid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = 200;
            for (int i = 0; i < workPaperIds.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                }
                pstmt.setObject(1, workPaperIds.get(i));
                pstmt.addBatch();
            }
            if (workPaperIds.size() > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected Map _calculate(Context ctx, String currMapOrgId, String groupId, String bgSchemeId, int dataType, Map formulas, List orgIds) throws BOSException, EASBizException {
        if (formulas == null || formulas.isEmpty() || orgIds == null || orgIds.isEmpty() || bgSchemeId == null) {
            return null;
        }
        String bgSchemeRootId = this.getBgSchemeRootId(ctx, bgSchemeId);
        Map resMap = null;
        Map orgMap = this.getOrgInfo(ctx, orgIds);
        List costCenterIds = (List)orgMap.get(COST_CENTER);
        List groupIds = (List)orgMap.get(UNION_DEPT);
        resMap = this.calSingleCostData(ctx, resMap, bgSchemeRootId, dataType, costCenterIds, formulas);
        resMap = this.calSingleGroupData(ctx, resMap, bgSchemeId, dataType, groupIds, formulas);
        resMap = this.calElimData(ctx, currMapOrgId, groupId, dataType, bgSchemeId, resMap, orgIds, formulas);
        resMap = this.calSumData(ctx, resMap);
        resMap = this.calConSolidData(ctx, resMap);
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBgSchemeRootId(Context ctx, String bgSchemeId) throws BOSException {
        ResultSet res;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            String string;
            if (bgSchemeId == null) {
                return null;
            }
            String sql = "Select frootid from t_bg_bgscheme where fid = ?";
            conn = null;
            pstmt = null;
            res = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, bgSchemeId);
                res = pstmt.executeQuery();
                if (!res.next()) break block5;
                string = res.getString("frootid");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return null;
    }

    private Map calSingleCostData(Context ctx, Map resMap, String bgSchemeRootId, int dataType, List costCenterIds, Map formulas) throws BOSException, EASBizException {
        if (resMap == null) {
            resMap = new HashMap();
        }
        if (StringUtils.isEmpty((String)bgSchemeRootId) || costCenterIds == null || costCenterIds.isEmpty() || formulas == null || formulas.isEmpty()) {
            return resMap;
        }
        StringBuffer sql = new StringBuffer("select bgdata.").append(dataType == 1 ? "FBgValue" : "FBizActual").append(" bgdata_FValue ,bgdata.FOrgUnitId bgdata_FOrgUnitId, bgdata.FFormula bgdata_FFormula  FROM T_Bg_BgData bgdata \n").append("LEFT JOIN T_Bg_BgForm bgform ON bgform.FID = bgdata.FBgFormID \n").append("LEFT JOIN T_Bg_BgScheme bgscheme ON bgscheme.FID = bgdata.FBgSchemeID \n").append("WHERE bgscheme.FRootID = ? AND bgform.FState in(").append(2).append(",").append(4).append(",").append(20).append(",").append(43).append(",").append(35).append(") \n").append("AND bgdata.FFormula = ? AND bgdata.FOrgUnitID in (");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        Object[] orgIds = costCenterIds.toArray();
        int batCount = (orgIds.length - 1) / 200 + 1;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String sheetId2 = null;
        String formula2 = null;
        Map resFormula = null;
        Map resSrc = null;
        Map resSingle = null;
        List subFormula = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String sheetId2 : formulas.keySet()) {
                subFormula = (List)formulas.get(sheetId2);
                resFormula = this.getFormulaMap(resMap, sheetId2);
                for (String formula2 : subFormula) {
                    resSrc = this.getSrcMap(resFormula, formula2);
                    resSingle = this.getSingleMap(resSrc);
                    for (int i = 0; i < batCount; ++i) {
                        pstmt.setString(1, BOSUuid.read((String)bgSchemeRootId).toString());
                        pstmt.setString(2, formula2);
                        BgNSQLHelper.setParam4Batch(pstmt, 3, i, 200, orgIds);
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            resSingle.put(res.getString("bgdata_FOrgUnitId"), res.getBigDecimal("bgdata_FValue"));
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return resMap;
    }

    private Map calSingleGroupData(Context ctx, Map resMap, String bgSchemeId, int dataType, List groupIds, Map formulas) throws BOSException, EASBizException {
        if (resMap == null) {
            resMap = new HashMap();
        }
        if (StringUtils.isEmpty((String)bgSchemeId) || groupIds == null || groupIds.isEmpty() || formulas == null || formulas.isEmpty()) {
            return resMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT pData.FOrgGroupId pData_FOrgGroupId, pData.FConSolidAmount pData_FConSolidAmount FROM T_Bg_BgWorkData pData \n").append(" LEFT JOIN T_Bg_BgWorkPaper wPaper ON wPaper.FID = pData.FBgWorkPaperId \n").append(" WHERE wPaper.FState = ").append(2).append(" ").append(" AND pData.FDataType = ? AND pData.FFormula = ? AND pData.FBgSchemeId = ? AND pData.FOrgGroupId in (");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT pData.FOrgGroupId pData_FOrgGroupId, pData.FConSolidAmount pData_FConSolidAmount FROM T_BG_BGCslData pData \n").append(" LEFT JOIN T_BG_BgCslForm wPaper ON wPaper.FID = pData.fbgcslformid \n").append(" WHERE wPaper.FState = ").append(2).append(" ").append(" AND pData.FDataType = ? AND pData.FFormula = ? AND pData.FBgSchemeId = ? AND pData.FOrgGroupId in (");
        BgNSQLHelper.addPlaceHolder(sql2, 200).append(")");
        Object[] orgIds = groupIds.toArray();
        int batCount = (orgIds.length - 1) / 200 + 1;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet res = null;
        String sheetId2 = null;
        String formula2 = null;
        Map resFormula = null;
        Map resSrc = null;
        Map resSingle = null;
        List subFormula = null;
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (Object orgId : orgIds) {
            orgUnitIds.add((String)orgId);
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt2 = conn.prepareStatement(sql2.toString());
            for (String sheetId2 : formulas.keySet()) {
                subFormula = (List)formulas.get(sheetId2);
                resFormula = this.getFormulaMap(resMap, sheetId2);
                for (String formula2 : subFormula) {
                    resSrc = this.getSrcMap(resFormula, formula2);
                    resSingle = this.getSingleMap(resSrc);
                    for (int i = 0; i < batCount; ++i) {
                        pstmt.setInt(1, dataType);
                        pstmt.setString(2, formula2);
                        pstmt.setString(3, bgSchemeId);
                        BgNSQLHelper.setParam4Batch(pstmt, 4, i, 200, orgIds);
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            resSingle.put(res.getString("pData_FOrgGroupId"), res.getBigDecimal("pData_FConSolidAmount"));
                        }
                        Iterator ite = resSingle.keySet().iterator();
                        String key = null;
                        while (ite.hasNext()) {
                            key = (String)ite.next();
                            if (!orgUnitIds.contains(key)) continue;
                            orgUnitIds.remove(key);
                        }
                        if (!orgUnitIds.isEmpty()) {
                            pstmt2.setInt(1, dataType);
                            pstmt2.setString(2, formula2);
                            pstmt2.setString(3, bgSchemeId);
                            BgNSQLHelper.setParam4Batch(pstmt2, 4, i, 200, orgUnitIds.toArray());
                            res = pstmt2.executeQuery();
                            while (res.next()) {
                                resSingle.put(res.getString("pData_FOrgGroupId"), res.getBigDecimal("pData_FConSolidAmount"));
                            }
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                SQLUtils.cleanup(res, pstmt2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup(res, (Statement)pstmt2, (Connection)conn);
        return resMap;
    }

    private Map getSingleMap(Map resSrc) {
        return BgNWorkPaperHelper.getSubMap(resSrc, String.valueOf(1));
    }

    private Map getSrcMap(Map formulaMap, String formula) {
        return BgNWorkPaperHelper.getSubMap(formulaMap, formula);
    }

    private Map getFormulaMap(Map resMap, String sheetId) {
        return BgNWorkPaperHelper.getSubMap(resMap, sheetId);
    }

    private Map calSumData(Context ctx, Map resMap) throws BOSException, EASBizException {
        if (resMap == null) {
            resMap = new HashMap();
        }
        Object temp222 = null;
        BigDecimal sumValue = null;
        BigDecimal elimValue = null;
        BigDecimal conValue = null;
        Map formulas = null;
        Map srcData = null;
        Map single = null;
        for (Object temp222 : resMap.values()) {
            if (!(temp222 instanceof Map)) continue;
            formulas = temp222;
            for (Object temp222 : formulas.values()) {
                if (!(temp222 instanceof Map)) continue;
                srcData = temp222;
                sumValue = null;
                elimValue = null;
                conValue = null;
                if (srcData.get(String.valueOf(1)) instanceof Map && !(single = (Map)srcData.get(String.valueOf(1))).isEmpty()) {
                    for (Object temp222 : single.values()) {
                        if (!(temp222 instanceof BigDecimal)) continue;
                        if (sumValue == null) {
                            sumValue = temp222;
                            continue;
                        }
                        sumValue = sumValue.add(temp222);
                    }
                }
                if (sumValue != null) {
                    srcData.put(String.valueOf(2), sumValue);
                }
                if (srcData.get(String.valueOf(3)) instanceof BigDecimal) {
                    elimValue = (BigDecimal)srcData.get(String.valueOf(3));
                }
                if (sumValue != null || elimValue != null) {
                    conValue = sumValue == null ? elimValue : (elimValue == null ? sumValue : elimValue.add(sumValue));
                }
                if (conValue == null) continue;
                srcData.put(String.valueOf(4), conValue);
            }
        }
        return resMap;
    }

    private Map calElimData(Context ctx, String currMapOrgId, String groupId, int dataType, String bgSchemeId, Map resMap, List orgIds, Map formulas) throws BOSException, EASBizException {
        if (resMap == null) {
            resMap = new HashMap();
        }
        try {
            if (!BgSHelper.isBgItemIsolate((Context)ctx)) {
                currMapOrgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (StringUtils.isEmpty((String)currMapOrgId) || formulas == null || formulas.isEmpty()) {
            return resMap;
        }
        String FORMULA_KEY = "FORMULA";
        String SHEETID_KEY = "SHEETID";
        String BGITEM_KEY = "BGITEM";
        HashMap map = new HashMap();
        Map temMap = null;
        Map.Entry entry2222 = null;
        String sheetId2 = null;
        String formula2 = null;
        String currencyNumber = null;
        String periodNumber = null;
        String elementNumber = null;
        String itemNumber = null;
        List subFormula = null;
        String[] params = null;
        for (String sheetId2 : formulas.keySet()) {
            subFormula = (List)formulas.get(sheetId2);
            if (subFormula == null) continue;
            for (String formula2 : subFormula) {
                currencyNumber = null;
                periodNumber = null;
                elementNumber = null;
                itemNumber = null;
                params = BgNFSHelper.parseFormulaPara(formula2);
                if (params == null) continue;
                if (params.length == 6) {
                    currencyNumber = params[5];
                    periodNumber = params[1];
                    elementNumber = params[2];
                    itemNumber = params[0];
                } else if (params.length == 4) {
                    currencyNumber = params[3];
                    periodNumber = params[1];
                    elementNumber = params[2];
                    itemNumber = params[0];
                }
                if (StringUtils.isEmpty((String)currencyNumber) || StringUtils.isEmpty((String)periodNumber) || StringUtils.isEmpty((String)elementNumber) || StringUtils.isEmpty(itemNumber)) continue;
                temMap = BgNWorkPaperHelper.getSubMap(map, currencyNumber);
                temMap = BgNWorkPaperHelper.getSubMap(temMap, periodNumber);
                temMap = BgNWorkPaperHelper.getSubMap(temMap, elementNumber);
                temMap = BgNWorkPaperHelper.getSubMap(temMap, itemNumber);
                temMap.put("FORMULA", formula2);
                temMap.put("SHEETID", sheetId2);
                temMap.put("BGITEM", itemNumber);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bgitem.FDataRela item_FDataRela, entry.FDebitAmount entry_FDebitAmount, entry.FCreditAmount entry_FCreditAmount \n").append(" FROM T_BG_BgItem bgitem \n").append(" INNER JOIN T_BG_BgEliminationEntry entry ON bgitem.FNumber = entry.FBgItemNumber \n").append(" INNER JOIN T_BG_BgElimination bill ON bill.FID = entry.FBgEliminationID \n").append(" INNER JOIN T_BD_Currency currency ON currency.FID = bill.FCurrencyID \n").append(" INNER JOIN T_Bg_BgPeriod period ON period.FID = bill.FBgPeriodID \n").append(" INNER JOIN T_Bg_BgElement element ON element.FID = bill.FBgElementID \n").append(" WHERE bgitem.FOrgUnitId = ? AND (bgitem.FLongNumber = ? OR bgitem.FLongNumber LIKE ?) \n").append(" AND bill.FOrgUnitID = ? AND bill.FStatus = 2 AND bill.FBgSchemeId = ? AND bill.FDataType = ? \n").append(" AND period.FNumber = ? AND currency.FNumber = ? AND element.FNumber = ?");
        String longNumberSQL = "SELECT FLongNumber FROM T_Bg_BgItem WHERE FNumber = ? AND FOrgUnitId = ?";
        Connection conn = null;
        PreparedStatement pstmtSQL = null;
        PreparedStatement pstmtLong = null;
        ResultSet resSQL = null;
        ResultSet resLong = null;
        BigDecimal value = null;
        BigDecimal debitAdd = null;
        BigDecimal debitMinus = null;
        int dataRel = -1;
        try {
            conn = this.getConnection(ctx);
            pstmtSQL = conn.prepareStatement(sql.toString());
            pstmtLong = conn.prepareStatement(longNumberSQL);
            for (Map.Entry entry2222 : map.entrySet()) {
                currencyNumber = (String)entry2222.getKey();
                temMap = (Map)entry2222.getValue();
                if (temMap == null) continue;
                for (Map.Entry entry2222 : temMap.entrySet()) {
                    periodNumber = (String)entry2222.getKey();
                    temMap = (Map)entry2222.getValue();
                    if (temMap == null) continue;
                    for (Map.Entry entry2222 : temMap.entrySet()) {
                        elementNumber = (String)entry2222.getKey();
                        temMap = (Map)entry2222.getValue();
                        if (temMap == null) continue;
                        for (Map.Entry entry2222 : temMap.entrySet()) {
                            itemNumber = (String)entry2222.getKey();
                            temMap = (Map)entry2222.getValue();
                            if (temMap == null || !(temMap.get("SHEETID") instanceof String) || !(temMap.get("FORMULA") instanceof String)) continue;
                            sheetId2 = (String)temMap.get("SHEETID");
                            formula2 = (String)temMap.get("FORMULA");
                            pstmtLong.setString(1, itemNumber);
                            pstmtLong.setString(2, currMapOrgId);
                            itemNumber = null;
                            value = null;
                            resLong = pstmtLong.executeQuery();
                            if (resLong.next()) {
                                itemNumber = resLong.getString("FLongNumber");
                            }
                            SQLUtils.cleanup((ResultSet)resLong);
                            if (!StringUtils.isEmpty((String)itemNumber)) {
                                pstmtSQL.setString(1, currMapOrgId);
                                pstmtSQL.setString(2, itemNumber);
                                pstmtSQL.setString(3, itemNumber + "!%");
                                pstmtSQL.setString(4, groupId);
                                pstmtSQL.setInt(6, dataType);
                                pstmtSQL.setString(5, bgSchemeId);
                                pstmtSQL.setString(7, periodNumber);
                                pstmtSQL.setString(8, currencyNumber);
                                pstmtSQL.setString(9, elementNumber);
                                resSQL = pstmtSQL.executeQuery();
                                while (resSQL.next()) {
                                    dataRel = resSQL.getInt("item_FDataRela");
                                    debitAdd = resSQL.getBigDecimal("entry_FDebitAmount");
                                    debitMinus = resSQL.getBigDecimal("entry_FCreditAmount");
                                    if (dataRel == 0) {
                                        value = this.add(value, debitAdd);
                                        value = this.sub(value, debitMinus);
                                        continue;
                                    }
                                    if (dataRel != 1) continue;
                                    value = this.sub(value, debitAdd);
                                    value = this.add(value, debitMinus);
                                }
                                SQLUtils.cleanup((ResultSet)resSQL);
                            }
                            if (value == null) continue;
                            temMap = BgNWorkPaperHelper.getSubMap(resMap, sheetId2);
                            temMap = BgNWorkPaperHelper.getSubMap(temMap, formula2);
                            temMap.put(String.valueOf(3), value);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resLong, pstmtLong);
                SQLUtils.cleanup(resSQL, (Statement)pstmtSQL, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(resLong, (Statement)pstmtLong);
        SQLUtils.cleanup(resSQL, (Statement)pstmtSQL, (Connection)conn);
        return resMap;
    }

    private BigDecimal add(BigDecimal value, BigDecimal value2) {
        if (value == null && value2 == null) {
            return null;
        }
        if (value == null) {
            return value2;
        }
        if (value2 == null) {
            return value;
        }
        return value.add(value2);
    }

    private BigDecimal sub(BigDecimal value, BigDecimal value2) {
        if (value2 == null) {
            return this.add(value, value2);
        }
        return this.add(value, value2.negate());
    }

    private Map calConSolidData(Context ctx, Map resMap) throws BOSException, EASBizException {
        if (resMap == null) {
            resMap = new HashMap();
        }
        return resMap;
    }

    private Map getOrgInfo(Context ctx, List orgIds) throws BOSException, EASBizException {
        HashMap resMap = new HashMap();
        ArrayList<String> costCenters = new ArrayList<String>();
        ArrayList<String> unions = new ArrayList<String>();
        resMap.put(COST_CENTER, costCenters);
        resMap.put(UNION_DEPT, unions);
        if (orgIds != null && !orgIds.isEmpty()) {
            StringBuffer sql = new StringBuffer("SELECT FID, FISUNION, FISCOSTORGUNIT FROM T_ORG_BASEUNIT WHERE FID IN(");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            String orgId = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                Object[] orgArray = orgIds.toArray();
                int batCount = (orgArray.length - 1) / 200 + 1;
                for (int i = 0; i < batCount; ++i) {
                    BgNSQLHelper.setParam4Batch(pstmt, i, 200, orgArray);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        orgId = res.getString("FID");
                        if (res.getBoolean("FISUNION")) {
                            if (unions.contains(orgId)) continue;
                            unions.add(orgId);
                            continue;
                        }
                        if (!res.getBoolean("FISCOSTORGUNIT") || costCenters.contains(orgId)) continue;
                        costCenters.add(orgId);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        return resMap;
    }
}

