/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgReqAdjustBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BgReqAdjustBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillCollection;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillException;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillFactory;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillInfo;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetBillStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.IBgRequestAdjustBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBillEntry;
import com.kingdee.eas.ma.nbudget.app.AbstractBgRequestAdjustBillControllerBean;
import com.kingdee.eas.scm.sm.pur.IPur4budgetFacade;
import com.kingdee.eas.scm.sm.pur.Pur4budgetFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.PurObjectEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurObjectType;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgRequestAdjustBillControllerBean
extends AbstractBgRequestAdjustBillControllerBean {
    private static final long serialVersionUID = 2176935686887693003L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgRequestAdjustBillControllerBean");
    private final String resourse = "com.kingdee.eas.ma.nbudget.BudgetRequestBillResource";

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("reqDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("reqOrgUnit.id"));
        sic.add(new SelectorItemInfo("reqOrgUnit.name"));
        sic.add(new SelectorItemInfo("reqOrgUnit.number"));
        sic.add(new SelectorItemInfo("bgRequestBill.id"));
        sic.add(new SelectorItemInfo("bgRequestBill.number"));
        sic.add(new SelectorItemInfo("entry.bgItemId"));
        sic.add(new SelectorItemInfo("entry.adjustBefore"));
        sic.add(new SelectorItemInfo("entry.adjustApply"));
        sic.add(new SelectorItemInfo("entry.adjustPass"));
        sic.add(new SelectorItemInfo("entry.adjustAfter"));
        sic.add(new SelectorItemInfo("entry.adjustGroup"));
        sic.add(new SelectorItemInfo("entry.adjustCause"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.number"));
        sic.add(new SelectorItemInfo("entry.adjustType"));
        sic.add(new SelectorItemInfo("entry.orgUnit.id"));
        sic.add(new SelectorItemInfo("entry.orgUnit.name"));
        sic.add(new SelectorItemInfo("entry.orgUnit.number"));
        sic.add(new SelectorItemInfo("entry.currency.id"));
        sic.add(new SelectorItemInfo("entry.currency.name"));
        sic.add(new SelectorItemInfo("entry.currency.number"));
        sic.add(new SelectorItemInfo("entry.currency.precision"));
        sic.add(new SelectorItemInfo("entry.requestBillApply"));
        sic.add(new SelectorItemInfo("entry.reqBillEntryId"));
        return sic;
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map paramValue = BgNSHelper.getAllParamValue(ctx);
        resultMap.put("paramValue", paramValue);
        if (params.get("bgReqAdjustBillId") instanceof String) {
            boolean inProInst = false;
            ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(params.get("bgReqAdjustBillId").toString());
            for (int i = 0; i < procInsts.length; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                inProInst = true;
                break;
            }
            resultMap.put("inProInst", inProInst);
        }
        if (params.get("billInfo") instanceof BgRequestAdjustBillInfo && params.get("cuid") instanceof String) {
            BgRequestAdjustBillInfo billInfo = (BgRequestAdjustBillInfo)params.get("billInfo");
            String cuid = params.get("cuid").toString();
            boolean hasCodeRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)billInfo, cuid);
            resultMap.put("hasCodeRule", hasCodeRule);
        }
        return resultMap;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgRequestAdjustBillInfo info = (BgRequestAdjustBillInfo)model;
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (info.getNumber() == null || info.getNumber().trim().length() == 0) {
            BgHelper.setSNumber((Context)ctx, (String)info.getOrgUnit().getId().toString(), (CoreBaseInfo)info);
        }
        if (info.getNumber() == null || info.getNumber().length() == 0) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NUMBERISNULL);
        }
        this.checkBillNumber(ctx, info);
        BOSUuid bgReqBillId = info.getBgRequestBill().getId();
        IBudgetRequestBill ibgReqBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK reqBillpk = new ObjectUuidPK(bgReqBillId.toString());
        if (ibgReqBill.exists((IObjectPK)reqBillpk)) {
            BudgetRequestBillInfo billInfo = ibgReqBill.getBudgetRequestBillInfo((IObjectPK)reqBillpk);
            if (billInfo.getState().equals((Object)BudgetBillStateEnum.adjusting)) {
                throw new BgRequestAdjustBillException(BgRequestAdjustBillException.ISREQBILLINADJUSTING);
            }
            ibgReqBill.updateAdjustingState(bgReqBillId);
        }
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgRequestAdjustBillInfo billInfo = null;
        if (this._exists(ctx, pk)) {
            billInfo = (BgRequestAdjustBillInfo)super._getValue(ctx, pk);
            BOSUuid bgReqBillId = billInfo.getBgRequestBill().getId();
            BudgetRequestBillFactory.getLocalInstance(ctx).updateAuditedState(bgReqBillId);
        }
        super._delete(ctx, pk);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        BgRequestAdjustBillInfo info = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            info = (BgRequestAdjustBillInfo)this._getValue(ctx, pk, sic);
            if (1 != info.getState().getValue()) {
                throw new CanNotDeleteException((Object)((Object)info.getState()) + ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"reqAdjustBillStateErrorDel", (Locale)ctx.getLocale()));
            }
        }
        catch (Exception e) {
            throw new CanNotDeleteException(e.getMessage());
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof BgRequestAdjustBillInfo) {
            BOSUuid newReqBill;
            BgRequestAdjustBillInfo oldAdjustBill = (BgRequestAdjustBillInfo)super._getValue(ctx, pk);
            BgRequestAdjustBillInfo newAdjustBill = (BgRequestAdjustBillInfo)model;
            BOSUuid oldReqBill = oldAdjustBill.getBgRequestBill().getId();
            if (!oldReqBill.equals((Object)(newReqBill = newAdjustBill.getBgRequestBill().getId()))) {
                BudgetRequestBillFactory.getLocalInstance(ctx).updateAuditedState(oldReqBill);
                BudgetRequestBillFactory.getLocalInstance(ctx).updateAdjustingState(newReqBill);
            }
        }
        super._update(ctx, pk, model);
    }

    protected void checkBillNumber(Context ctx, BgRequestAdjustBillInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("number", (Object)model.getNumber(), CompareType.EQUALS));
        if (model.getId() != null) {
            item.add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 AND #1");
        } else {
            filter.setMaskString("#0");
        }
        IBgRequestAdjustBill ibgAdjust = BgRequestAdjustBillFactory.getLocalInstance(ctx);
        if (ibgAdjust.exists(filter)) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NUMBERREPEAT, new String[]{model.getNumber()});
        }
    }

    @Override
    protected BigDecimal _getAdjustValue(Context ctx, BOSUuid bgReqBillId, BOSUuid reqBillEntryId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        BigDecimal totalResult = new BigDecimal(0);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("state", (Object)new Integer(9), CompareType.EQUALS));
        fic.add(new FilterItemInfo("bgRequestBill.id", (Object)bgReqBillId.toString(), CompareType.EQUALS));
        fic.add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId.toString(), CompareType.EQUALS));
        view.getSelector().add(new SelectorItemInfo("entry.adjustBefore"));
        view.getSelector().add(new SelectorItemInfo("entry.reqBillEntryId"));
        BgRequestAdjustBillCollection coll = this.getBgRequestAdjustBillCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgRequestAdjustBillInfo billInfo = coll.get(i);
                BgReqAdjustBillEntryCollection entryColl = billInfo.getEntry();
                for (int j = 0; j < entryColl.size(); ++j) {
                    BgReqAdjustBillEntryInfo entryInfo = entryColl.get(j);
                    if (!entryInfo.getReqBillEntryId().equals((Object)reqBillEntryId)) continue;
                    totalResult = totalResult.add(entryInfo.getAdjustBefore());
                }
            }
        }
        return totalResult;
    }

    @Override
    protected boolean _auditBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return false;
        }
        BgRequestAdjustBillInfo billInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (this._exists(ctx, (IObjectPK)pk)) {
            billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk, this.getSelectors());
            BigDecimal adjustValue = new BigDecimal(0);
            BgReqAdjustBillEntryCollection reqAdjsutEntryColl = billInfo.getEntry();
            BgReqAdjustBillEntryInfo reqAdjustBillEntryInfo = null;
            BudgetRequestBillEntryInfo reqBillEntryInfo = null;
            ObjectUuidPK reqBillEntryPK = null;
            IBudgetRequestBillEntry reqBillEntryInterface = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
            BOSUuid reqBillId = null;
            HashSet<String> reqBillEntrySet = new HashSet<String>();
            for (int i = 0; i < reqAdjsutEntryColl.size(); ++i) {
                reqAdjustBillEntryInfo = reqAdjsutEntryColl.get(i);
                reqBillEntryPK = new ObjectUuidPK(reqAdjustBillEntryInfo.getReqBillEntryId().toString());
                reqBillEntryInfo = reqBillEntryInterface.getBudgetRequestBillEntryInfo((IObjectPK)reqBillEntryPK);
                adjustValue = reqAdjustBillEntryInfo.getAdjustPass();
                reqBillEntryInfo.setApplyValue(reqBillEntryInfo.getApplyValue().add(adjustValue));
                reqBillEntryInfo.setCheckValue(adjustValue);
                reqBillEntryInterface.update((IObjectPK)reqBillEntryPK, reqBillEntryInfo);
                reqBillId = reqBillEntryInfo.getBgBill().getId();
                reqBillEntrySet.add(reqBillEntryPK.toString());
            }
            if (reqBillId != null) {
                IBudgetRequestBill iBudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("bgEnties.id");
                sic.add("bgEnties.checkValue");
                BudgetRequestBillInfo reqBillInfo = iBudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)new ObjectUuidPK(reqBillId.toString()), sic);
                BudgetRequestBillEntryCollection reqBillEntryCol = reqBillInfo.getBgEnties();
                for (int i = 0; i < reqBillEntryCol.size(); ++i) {
                    if (reqBillEntrySet.contains(reqBillEntryCol.get(i).getId().toString())) continue;
                    reqBillEntryCol.get(i).setCheckValue(BigDecimal.ZERO);
                }
                iBudgetRequestBill.updatePartial((CoreBaseInfo)reqBillInfo, sic);
            }
            try {
                BudgetCtrlCaller.requestBudget((Context)ctx, (BOSUuid)billInfo.getBgRequestBill().getId());
            }
            catch (BgCtrlException e) {
                for (int i = 0; i < reqAdjsutEntryColl.size(); ++i) {
                    reqAdjustBillEntryInfo = reqAdjsutEntryColl.get(i);
                    reqBillEntryPK = new ObjectUuidPK(reqAdjustBillEntryInfo.getReqBillEntryId().toString());
                    reqBillEntryInfo = reqBillEntryInterface.getBudgetRequestBillEntryInfo((IObjectPK)reqBillEntryPK);
                    adjustValue = reqAdjustBillEntryInfo.getAdjustPass();
                    reqBillEntryInfo.setApplyValue(reqBillEntryInfo.getApplyValue().subtract(adjustValue));
                    reqBillEntryInfo.setCheckValue(reqBillEntryInfo.getCheckValue().subtract(adjustValue));
                    reqBillEntryInterface.update((IObjectPK)reqBillEntryPK, reqBillEntryInfo);
                }
                throw e;
            }
            billInfo.setState(BgRequestAdjustStateEnum.APPROVED);
            billInfo.setBizDate(new Date());
            billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            super.update(ctx, (IObjectPK)pk, (CoreBaseInfo)billInfo);
            if (reqBillId != null) {
                BudgetRequestBillFactory.getLocalInstance(ctx).updateAuditedState(reqBillId);
            }
        } else {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        return true;
    }

    @Override
    protected boolean _antiAuditBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BOSUuid reqBillId;
        if (billId == null) {
            return false;
        }
        BgRequestAdjustBillInfo billInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (this._exists(ctx, (IObjectPK)pk)) {
            billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk, this.getSelectors());
            if (!ContextUtil.getCurrentUserInfo((Context)ctx).getName().equalsIgnoreCase(billInfo.getAuditor().getName())) {
                throw new BgRequestAdjustBillException(BgRequestAdjustBillException.ANTIMUSTAUTI);
            }
            reqBillId = billInfo.getBgRequestBill().getId();
            BudgetRequestBillInfo reqBill = BudgetRequestBillFactory.getLocalInstance(ctx).getBudgetRequestBillInfo((IObjectPK)new ObjectUuidPK(reqBillId));
            if (reqBill.getState().equals((Object)BudgetBillStateEnum.adjusting)) {
                throw new BgRequestAdjustBillException(BgRequestAdjustBillException.ANTIAUDITWHENADJUSTING);
            }
            billInfo.setState(BgRequestAdjustStateEnum.ADJUST);
            billInfo.setBizDate(null);
            billInfo.setAuditor(null);
            super.update(ctx, (IObjectPK)pk, (CoreBaseInfo)billInfo);
            BudgetCtrlCaller.returnBudget((Context)ctx, (BOSUuid)reqBillId);
            BigDecimal adjustValue = new BigDecimal(0);
            BgReqAdjustBillEntryCollection reqAdjsutEntryColl = billInfo.getEntry();
            BgReqAdjustBillEntryInfo reqAdjustBillEntryInfo = null;
            BudgetRequestBillEntryInfo reqBillEntryInfo = null;
            ObjectUuidPK reqBillEntryPK = null;
            IBudgetRequestBillEntry reqBillEntryInterface = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
            for (int i = 0; i < reqAdjsutEntryColl.size(); ++i) {
                reqAdjustBillEntryInfo = reqAdjsutEntryColl.get(i);
                reqBillEntryPK = new ObjectUuidPK(reqAdjustBillEntryInfo.getReqBillEntryId().toString());
                reqBillEntryInfo = reqBillEntryInterface.getBudgetRequestBillEntryInfo((IObjectPK)reqBillEntryPK);
                adjustValue = reqAdjustBillEntryInfo.getAdjustPass();
                reqBillEntryInfo.setApplyValue(reqBillEntryInfo.getApplyValue().subtract(adjustValue));
                reqBillEntryInfo.setCheckValue(reqBillEntryInfo.getCheckValue().subtract(adjustValue));
                reqBillEntryInterface.update((IObjectPK)reqBillEntryPK, reqBillEntryInfo);
            }
        } else {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        BudgetCtrlCaller.requestBudget((Context)ctx, (BOSUuid)reqBillId);
        BudgetRequestBillFactory.getLocalInstance(ctx).updateAdjustingState(reqBillId);
        return true;
    }

    @Override
    protected boolean _submitRefer(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._updateReferringState(ctx, billId);
        return true;
    }

    @Override
    protected void _updateApprovingState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (!this._exists(ctx, (IObjectPK)pk)) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        BgRequestAdjustBillInfo billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk);
        billInfo.setState(BgRequestAdjustStateEnum.APPROVING);
        billInfo.setBizDate(new Date());
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
    }

    @Override
    protected void _updateEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (!this._exists(ctx, (IObjectPK)pk)) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        BgRequestAdjustBillInfo billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk);
        billInfo.setState(BgRequestAdjustStateEnum.ADJUST);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
    }

    @Override
    protected void _updateApprovedState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (!this._exists(ctx, (IObjectPK)pk)) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        BgRequestAdjustBillInfo billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk);
        billInfo.setState(BgRequestAdjustStateEnum.APPROVED);
        billInfo.setBizDate(new Date());
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
    }

    @Override
    protected void _updateReferringState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (!this._exists(ctx, (IObjectPK)pk)) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.NOMODEL);
        }
        BgRequestAdjustBillInfo billInfo = (BgRequestAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk);
        billInfo.setState(BgRequestAdjustStateEnum.REFERRING);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
    }

    @Override
    protected BigDecimal _getBOTPValue(Context ctx, BOSUuid billId, BOSUuid entryId) throws BOSException, EASBizException {
        if (billId == null) {
            return new BigDecimal(0);
        }
        BigDecimal total = new BigDecimal(0);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        IBudgetRequestBill iBgRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        if (iBgRequestBill.exists((IObjectPK)pk)) {
            BudgetRequestBillInfo billInfo = (BudgetRequestBillInfo)iBgRequestBill.getValue((IObjectPK)pk);
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection botRelationCol = iBTPManager.getDestRelation(billInfo.getId().toString());
            PaymentBillInfo paymentBillInfo = null;
            PaymentBillEntryInfo paymentBillEntryInfo = null;
            PaymentBillEntryCollection paymentEntryColl = null;
            PurObjectType returnValue = null;
            PurObjectEntryType entryType = null;
            int count = botRelationCol.size();
            for (int i = 0; i < count; ++i) {
                List entryList;
                BOTRelationInfo botRelationInfo = botRelationCol.get(i);
                String destObjID = botRelationInfo.getDestObjectID();
                ObjectUuidPK destPK = new ObjectUuidPK(destObjID);
                BOSObjectType type = BgRequestAdjustBillControllerBean.getBOSType(destObjID);
                if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
                    paymentBillInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destPK);
                    if (!paymentBillInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) && !paymentBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || (paymentEntryColl = paymentBillInfo.getEntries()) == null || paymentEntryColl.size() <= 0) continue;
                    for (int j = 0; j < paymentEntryColl.size(); ++j) {
                        paymentBillEntryInfo = paymentEntryColl.get(j);
                        if (paymentBillEntryInfo.getSourceBillEntryId() == null || !paymentBillEntryInfo.getSourceBillEntryId().equals(entryId.toString())) continue;
                        total = total.add(paymentBillEntryInfo.getAmount());
                    }
                    continue;
                }
                IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
                returnValue = purfacade.getPurObjectType(type, (IObjectPK)destPK, false);
                if (returnValue == null || (entryList = returnValue.getEntries()) == null) continue;
                int n = entryList.size();
                for (int j = 0; j < n; ++j) {
                    entryType = (PurObjectEntryType)entryList.get(j);
                    if (entryType.getSourceBillEntryId() == null || !entryId.equals((Object)entryType.getSourceBillEntryId())) continue;
                    total = total.add(entryType.getAmount());
                }
            }
        }
        return total;
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgRequestAdjustBillInfo bgRequestAdjustBillInfo = (BgRequestAdjustBillInfo)super._getValue(ctx, pk);
        return bgRequestAdjustBillInfo.getNumber();
    }

    @Override
    protected void _checkNumber(Context ctx, BgRequestAdjustBillInfo info) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = "select FID from T_BG_BgRequestAdjustBill where FNumber = ? and FOrgUnitID = ? and FID <> ? ;";
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, info.getNumber());
            pstmt.setString(2, info.getOrgUnit().getId().toString());
            pstmt.setString(3, info.getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BOSException();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }
}

