/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgExamineNodeInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgSchemeStateEnum;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgAutoEnurameHelper;
import com.kingdee.eas.ma.nbudget.BgExpressionsItemVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNEnumeraInfo;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgRowColIdObject;
import com.kingdee.eas.ma.nbudget.app.AbstractBgSchemeDispatchFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgNAssignUpdateUtil;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeDispatchFacadeControllerBean
extends AbstractBgSchemeDispatchFacadeControllerBean {
    private static final long serialVersionUID = -6009665423623869603L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgSchemeDispatchFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _dispatch(Context ctx, Map parameter) throws BOSException, EASBizException {
        HashMap<String, String> _reMap = new HashMap<String, String>();
        if (parameter == null || parameter.isEmpty()) {
            _reMap.put("SCHEME_DISPATCH", "defeated.parameter.isnull");
            return _reMap;
        }
        List _orgUnitIds = (List)parameter.get("ORGUNIT_ID");
        String _bgSchemeId = (String)parameter.get("BGSCHEME_ID");
        String _bgTemplateId = (String)parameter.get("BGTEMPLATE_ID");
        if (_orgUnitIds == null || _orgUnitIds.isEmpty() || StringUtils.isEmpty((String)_bgSchemeId) || StringUtils.isEmpty((String)_bgTemplateId)) {
            _reMap.put("SCHEME_DISPATCH", "defeated.parameter.isnull");
            return _reMap;
        }
        BgSchemeInfo schemeInfo = null;
        BgTemplateInfo templateInfo = null;
        Map orgUnitMap = null;
        Map bgSchemeMap = null;
        Map bgTemplateMap = null;
        ArrayList views = new ArrayList();
        try {
            if (!this.getBgSchemeInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgSchemeId)) || !this.getBgTemplateInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgTemplateId))) {
                _reMap.put("SCHEME_DISPATCH", "defeated.object.noexites");
                HashMap<String, String> hashMap = _reMap;
                return hashMap;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("bgType.id");
            sic.add("bgMeasureUnit.id");
            sic.add("bgMeasureUnit.bgTemplate.id");
            sic.add("bgMeasureUnit.bgElement.id");
            sic.add("bgMeasureUnit.bgElement.name");
            sic.add("bgMeasureUnit.bgElement.number");
            sic.add("bgMeasureUnit.measureUnit.id");
            sic.add("bgMeasureUnit.measureUnit.name");
            sic.add("bgMeasureUnit.measureUnit.number");
            sic.add("bgMeasureUnit.measureUnit.coefficient");
            orgUnitMap = this.getOrgUnitInfo(ctx, _orgUnitIds);
            schemeInfo = this.getBgSchemeInterface(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(_bgSchemeId), this.getBgSchemeSelector());
            templateInfo = this.getBgTemplateInterface(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(_bgTemplateId), sic);
            boolean reqScheme = this.getMutexServicInterface(ctx).requestObjIDForUpdate(_bgSchemeId);
            boolean reqTemplate = this.getMutexServicInterface(ctx).requestObjIDForUpdate(_bgTemplateId);
            if (reqScheme && reqTemplate) {
                bgSchemeMap = this.dispatchBgScheme(ctx, schemeInfo, _orgUnitIds, orgUnitMap, _reMap);
                bgTemplateMap = this.dispatchBgTemplate(ctx, templateInfo, schemeInfo, _orgUnitIds, orgUnitMap, bgSchemeMap, _reMap, views);
                this.updateSchemeNode(ctx, schemeInfo, templateInfo, _orgUnitIds, bgSchemeMap, bgTemplateMap);
                BgViewServerHelper.batchAddNewView((Context)ctx, null, views, (boolean)false);
                _reMap.put("SCHEME_DISPATCH", "success");
            } else {
                _reMap.put("SCHEME_DISPATCH", "defeated.mutual");
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        finally {
            this.getMutexServicInterface(ctx).releaseObjIDForUpdate(_bgSchemeId);
            this.getMutexServicInterface(ctx).releaseObjIDForUpdate(_bgTemplateId);
        }
        return _reMap;
    }

    protected IMutexServiceControl getMutexServicInterface(Context ctx) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx);
    }

    protected IFullOrgUnit getOrgUnitInterface(Context ctx) throws BOSException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    protected IBgScheme getBgSchemeInterface(Context ctx) throws BOSException {
        return BgSchemeFactory.getLocalInstance((Context)ctx);
    }

    protected IBgTemplate getBgTemplateInterface(Context ctx) throws BOSException {
        return BgTemplateFactory.getLocalInstance((Context)ctx);
    }

    protected SelectorItemCollection getOrgUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("cu");
        return sic;
    }

    protected SelectorItemCollection getBgSchemeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("period");
        sic.add("parentScheme");
        sic.add("rootId");
        sic.add("isSubmitByScheme");
        sic.add("isReportByScheme");
        sic.add("isFormal");
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getOrgUnitInfo(Context ctx, List orgUnitIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        FullOrgUnitInfo _unitInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = orgUnitIds.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _id = null;
        String _cuId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FControlUnitId from T_ORG_CostCenter where FId IN (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)orgUnitIds.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString("FId");
                    _cuId = rst.getString("FControlUnitId");
                    _unitInfo = new FullOrgUnitInfo();
                    _unitInfo.setId(BOSUuid.read((String)_id));
                    _unitInfo.setCU(new CtrlUnitInfo());
                    _unitInfo.getCU().setId(BOSUuid.read((String)_cuId));
                    orgUnitMap.put(_id, _unitInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"Error - ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error - ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        if (orgUnitIds.size() == orgUnitMap.size()) {
            return orgUnitMap;
        }
        throw new EASBizException(EASBizException.CHECKEXIST);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map dispatchBgScheme(Context ctx, BgSchemeInfo bgSchemeInfo, List orgUnitIds, Map orgUnitMap, Map resMap) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null || orgUnitIds == null || orgUnitIds.isEmpty() || resMap == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        BgSchemeInfo _tmpInfo2222222 = null;
        BgSchemeInfo dispatchInfo = null;
        FullOrgUnitInfo _unitInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = orgUnitIds.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String rootId = bgSchemeInfo.getRootId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FRootID, FOrgUnitId from T_BG_BgScheme where FNumber = ? and FOrgUnitId in (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgSchemeInfo.getNumber());
                for (int k = 2; k <= batchNum + 1; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, BOSUuid.read((String)orgUnitIds.get(pos).toString()).toString());
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgSchemeId = rst.getString("FId");
                    _orgUnitId = rst.getString("FOrgUnitId");
                    if (rootId.equals(rst.getString("FRootID"))) {
                        _tmpInfo2222222 = new BgSchemeInfo();
                        _tmpInfo2222222.setId(BOSUuid.read((String)_bgSchemeId));
                        _tmpInfo2222222.setOrgUnit((FullOrgUnitInfo)orgUnitMap.get(_orgUnitId));
                        _tmpInfo2222222.setIsFormal(false);
                        _tmpInfo2222222.setCU(new CtrlUnitInfo());
                        _tmpInfo2222222.getCU().setId(_tmpInfo2222222.getCU().getId());
                        bgSchemeMap.put(_orgUnitId, _tmpInfo2222222);
                        this.putSchemeResult(resMap, _orgUnitId, "success");
                        continue;
                    }
                    this.putSchemeResult(resMap, _orgUnitId, "fail");
                    this.putTemplateResult(resMap, _orgUnitId, "failTem");
                    orgUnitIds.remove(_orgUnitId);
                    orgUnitMap.remove(_orgUnitId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"Error - ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error - ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        if (!bgSchemeMap.isEmpty()) {
            sql = new StringBuffer();
            sql.append("update T_BG_BgScheme set FDateFrom = ?, FDateTo = ?, FIsFormal = 0, FParentSchemeId = ? where FID = ?");
            int batchIndex = 0;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (BgSchemeInfo _tmpInfo2222222 : bgSchemeMap.values()) {
                    pstmt.setTimestamp(1, new Timestamp(bgSchemeInfo.getDateFrom().getTime()));
                    pstmt.setTimestamp(2, new Timestamp(bgSchemeInfo.getDateTo().getTime()));
                    pstmt.setString(3, bgSchemeInfo.getId().toString());
                    pstmt.setString(4, _tmpInfo2222222.getId().toString());
                    pstmt.addBatch();
                    if (++batchIndex < batchNum) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Error - ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            }
        }
        if (bgSchemeMap.size() != orgUnitIds.size()) {
            IObjectPK pk = null;
            IBgScheme ibgScheme = this.getBgSchemeInterface(ctx);
            int in = orgUnitIds.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitId = (String)orgUnitIds.get(i);
                if (bgSchemeMap.containsKey(_orgUnitId) || !orgUnitMap.containsKey(_orgUnitId)) continue;
                dispatchInfo = bgSchemeInfo.deepClone();
                _unitInfo = (FullOrgUnitInfo)orgUnitMap.get(_orgUnitId);
                dispatchInfo.setOrgUnit(_unitInfo);
                dispatchInfo.setCU(_unitInfo.getCU());
                dispatchInfo.setIsFormal(false);
                dispatchInfo.setState(BgSchemeStateEnum.NOPLAN);
                dispatchInfo.setParentScheme(bgSchemeInfo);
                dispatchInfo.setRootId(bgSchemeInfo.getRootId());
                dispatchInfo.setIsFiling(false);
                if (dispatchInfo.getBgSchemeNodes() != null) {
                    dispatchInfo.getBgSchemeNodes().clear();
                }
                pk = ibgScheme.addnew((CoreBaseInfo)dispatchInfo);
                dispatchInfo.setId(BOSUuid.read((String)pk.toString()));
                bgSchemeMap.put(dispatchInfo.getOrgUnit().getId().toString(), dispatchInfo);
                this.putSchemeResult(resMap, _orgUnitId, "success");
            }
        }
        if (!bgSchemeInfo.isIsFormal() || bgSchemeMap.isEmpty()) return bgSchemeMap;
        try {
            int i;
            conn = this.getConnection(ctx);
            HashSet orgIds = new HashSet(bgSchemeMap.keySet());
            Object[] params = orgIds.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            sql = new StringBuffer("select FOrgUnitID from t_bg_bgscheme \n");
            sql.append(" where FIsFormal = 1 and (").append("   ( datediff(day,FDateFrom,TO_DATE('").append(bgSchemeInfo.getDateFrom()).append("') )>=0 and datediff(day,FDateTo,TO_DATE('").append(bgSchemeInfo.getDateFrom()).append("') )<=0 ) ").append("   or ( datediff(day,FDateFrom,TO_DATE('").append(bgSchemeInfo.getDateFrom()).append("') )<=0 and datediff(day,FDateTo,TO_DATE('").append(bgSchemeInfo.getDateTo()).append("') )>=0 ) ").append("   or ( datediff(day,FDateFrom,TO_DATE('").append(bgSchemeInfo.getDateTo()).append("') )>=0 and datediff(day,FDateTo,TO_DATE('").append(bgSchemeInfo.getDateTo()).append("') )<=0 ) ").append(") and FOrgUnitID in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch(pstmt, i, 200, params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgIds.remove(rst.getString("FOrgUnitID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (orgIds.isEmpty()) return bgSchemeMap;
            params = orgIds.toArray();
            batchCount = (params.length - 1) / 200 + 1;
            sql = new StringBuffer("update t_bg_bgscheme set FIsFormal = 1 where FRootId = ? and FOrgUnitID in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < batchCount; ++i) {
                pstmt.setString(1, rootId);
                BgNSQLHelper.setParam4Batch(pstmt, 2, i, 200, params);
                pstmt.executeUpdate();
            }
            return bgSchemeMap;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map dispatchBgTemplate(Context ctx, BgTemplateInfo bgTemplateInfo, BgSchemeInfo schemeInfo, List orgUnitIds, Map orgUnitMap, Map bgSchemeMap, Map resMap, List views) throws BOSException, EASBizException {
        if (ctx == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty() || resMap == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        boolean isSelfAnalyse = bgTemplateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(bgTemplateInfo.getBgType().getId().toString());
        Map bgTemplateMap = null;
        List bgExamineIds = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        Map bgFormMap = null;
        BgTemplateInfo _dispTemplateInfo = null;
        FullOrgUnitInfo _unitInfo = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String _orgUnitId = null;
        byte[] transbook = null;
        byte[] tempBook = null;
        int updateMode = 0;
        if (bgTemplateInfo.getFormType() != null) {
            updateMode = bgTemplateInfo.getFormType().getValue();
        }
        int oldTemType = 0;
        bgExamineIds = this.queryBgTemplateExamineInfo(ctx, bgTemplateInfo.getId());
        ArrayList<String> failOrgIds = new ArrayList<String>();
        Book superBook = null;
        try {
            superBook = bgTemplateInfo.getBook();
        }
        catch (Exception e1) {
            logger.error((Object)"Error - ", (Throwable)e1);
            superBook = Book.Manager.getNewBook();
        }
        bgTemplateMap = this.checkDispatchBgTemplate(ctx, bgTemplateInfo, orgUnitIds, orgUnitMap, userInfo);
        if (updateMode == 4) {
            bgFormMap = this.queryViewInfo(ctx, schemeInfo.getRootId().toString(), bgTemplateInfo.getRootId().toString());
        }
        Hashtable ctrlModeMap = this.getTemplateCtrlMode(ctx, bgTemplateInfo.getId());
        Hashtable defCtrlModeMap = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).getDefCtrlSetByTemplateID(bgTemplateInfo.getId().toString());
        int in = orgUnitIds.size();
        for (int i = 0; i < in; ++i) {
            _orgUnitId = (String)orgUnitIds.get(i);
            oldTemType = 0;
            boolean isAddNew = false;
            if (bgTemplateMap.containsKey(_orgUnitId)) {
                _dispTemplateInfo = (BgTemplateInfo)bgTemplateMap.get(_orgUnitId);
                oldTemType = _dispTemplateInfo.getFormType().getValue();
                _dispTemplateInfo.setFormType(bgTemplateInfo.getFormType());
            } else {
                _dispTemplateInfo = this.transfromInfo(bgTemplateInfo, userInfo);
                _dispTemplateInfo.setId(BOSUuid.create((BOSObjectType)_dispTemplateInfo.getBOSType()));
                _dispTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                _dispTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)_orgUnitId));
                _unitInfo = (FullOrgUnitInfo)orgUnitMap.get(_orgUnitId);
                _dispTemplateInfo.setCU(new CtrlUnitInfo());
                _dispTemplateInfo.getCU().setId(_unitInfo.getCU().getId());
                isAddNew = true;
            }
            _tmpList.add(_dispTemplateInfo.getId().toString());
            if (_dispTemplateInfo.getLastUpdateTime().compareTo(bgTemplateInfo.getLastUpdateTime()) != 0) {
                String key = BgNFSHelper.getTemplateKey(ctx, _dispTemplateInfo);
                ArrayList subViews = new ArrayList();
                try {
                    if (updateMode != 4) {
                        if (updateMode != 1 || oldTemType != 1) {
                            if (tempBook == null) {
                                try {
                                    tempBook = this.transfromBook(superBook, updateMode);
                                }
                                catch (Exception ex) {
                                    logger.error((Object)"Error - ", (Throwable)ex);
                                    transbook = IOHelper.packBook((Book)Book.Manager.getNewBook());
                                }
                            }
                            transbook = tempBook;
                        } else {
                            Book childBook = this.getBookFromTemplate(ctx, _dispTemplateInfo.getId().toString());
                            if (childBook == null) {
                                if (tempBook == null) {
                                    try {
                                        tempBook = this.transfromBook(superBook, updateMode);
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)"Error - ", (Throwable)ex);
                                        transbook = IOHelper.packBook((Book)Book.Manager.getNewBook());
                                    }
                                }
                                transbook = tempBook;
                            } else {
                                ctx.put((Object)key, (Object)Boolean.TRUE);
                                transbook = this.transEnumerateBook(ctx, (IObjectValue)_dispTemplateInfo, superBook, childBook, updateMode, isSelfAnalyse, _orgUnitId);
                            }
                        }
                        _dispTemplateInfo.setZipData(transbook);
                        Timestamp time = new Timestamp(new Date().getTime());
                        _dispTemplateInfo.setLastUpdateTime(time);
                    }
                    IObjectPK pk = this.getBgTemplateInterface(ctx).submit((CoreBaseInfo)_dispTemplateInfo);
                    if (updateMode == 4) {
                        this.saveDim(ctx, bgTemplateInfo.getId().toString(), pk.toString(), isAddNew);
                    }
                    if (ctrlModeMap == null || ctrlModeMap.isEmpty()) {
                        BgCtrlSetHelper.clearTemplateCtrlSetting((Connection)this.getConnection(ctx), (String)_orgUnitId, (String)pk.toString(), (boolean)true);
                    } else {
                        BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).insertTemplateCtrl(_orgUnitId, pk.toString(), ctrlModeMap);
                    }
                    BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).saveDefCtrlSet(pk.toString(), defCtrlModeMap);
                    bgTemplateMap.put(_orgUnitId, _dispTemplateInfo);
                    views.addAll(subViews);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    if (e instanceof EASBizException) {
                        this.putTemplateResult(resMap, _orgUnitId, "failTem");
                    } else {
                        this.putTemplateResult(resMap, _orgUnitId, "fail_" + e.toString());
                    }
                    bgTemplateMap.remove(_orgUnitId);
                    failOrgIds.add(_orgUnitId);
                    orgUnitMap.remove(_orgUnitId);
                    bgSchemeMap.remove(_orgUnitId);
                    _tmpList.remove(_dispTemplateInfo.getId().toString());
                    continue;
                }
                finally {
                    ctx.remove((Object)key);
                }
            }
            this.putTemplateResult(resMap, _orgUnitId, "success");
        }
        orgUnitIds.removeAll(failOrgIds);
        this.updateTemplateLastUpdateTime(ctx, bgTemplateInfo, bgTemplateMap);
        this.updateBgExamineInfo(ctx, _tmpList, bgExamineIds);
        this.buildSuccessResult(resMap, orgUnitIds);
        transbook = null;
        return bgTemplateMap;
    }

    private void saveDim(Context ctx, String sourceTemplateId, String targetTemlateId, boolean isAddNew) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)sourceTemplateId) || StringUtils.isEmpty((String)targetTemlateId)) {
            return;
        }
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)"insert into T_BG_BgViewDimension select ?, FData, ?, FRollmethod, FRolltype, FRollstep, FRolllength, FOverflow, FFixedlength from T_BG_BgViewDimension where FTemplateID = ?", (Object[])new Object[]{BOSUuid.create((BOSObjectType)new BgViewDimensionInfo().getBOSType()).toString(), targetTemlateId, sourceTemplateId});
        } else {
            DbUtil.execute((Context)ctx, (String)"update T_BG_BgViewDimension set FData = (select viewDim.FData From T_BG_BgViewDimension viewDim where viewDim.FTemplateID = ?) where FTemplateID = ?", (Object[])new Object[]{sourceTemplateId, targetTemlateId});
        }
    }

    private List createViewInfo(Context ctx, BgTemplateInfo dispTemplateInfo, Map bgFormMap, Map bgSchemeMap) throws BOSException, EASBizException {
        ArrayList res = new ArrayList();
        HashSet<String> numbers = new HashSet<String>();
        if (dispTemplateInfo == null || bgFormMap == null || bgFormMap.isEmpty() || bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return res;
        }
        for (String bgPeriodId : bgFormMap.keySet()) {
            Map pMap = (Map)bgFormMap.get(bgPeriodId);
            if (pMap == null || pMap.isEmpty()) continue;
            for (String currencyId : pMap.keySet()) {
                Map cMap = (Map)pMap.get(currencyId);
                if (cMap == null || cMap.isEmpty() || cMap.containsKey(dispTemplateInfo.getOrgUnit().getId().toString())) continue;
                BgFormInfo old = null;
                BgFormInfo newF = null;
                Iterator itF = cMap.values().iterator();
                if (itF.hasNext()) {
                    old = (BgFormInfo)itF.next();
                }
                newF = new BgFormInfo();
                newF.setId(BOSUuid.create((BOSObjectType)newF.getBOSType()));
                if (old != null) {
                    newF.setNumber(old.getNumber());
                    newF.setName(old.getName());
                    newF.setDescription(old.getDescription());
                }
                numbers.add(newF.getNumber());
                newF.setBgPeriod(new BgPeriodInfo());
                newF.getBgPeriod().setId(BOSUuid.read((String)bgPeriodId));
                newF.setCurrency(new CurrencyInfo());
                newF.getCurrency().setId(BOSUuid.read((String)currencyId));
                newF.setBgTemplate(dispTemplateInfo);
                newF.setOrgUnit(dispTemplateInfo.getOrgUnit());
                newF.setCU(dispTemplateInfo.getCU());
                newF.setBgScheme((BgSchemeInfo)bgSchemeMap.get(dispTemplateInfo.getOrgUnit().getId().toString()));
                newF.setTemplateLastUpdateTime(dispTemplateInfo.getLastUpdateTime());
                newF.setBgType(dispTemplateInfo.getBgType());
                newF.setMeasureUnit(dispTemplateInfo.getDefaultMeasureUnit());
            }
        }
        BgViewServerHelper.checkNumber((Context)ctx, null, (String)"FOrgUnitId", (String)dispTemplateInfo.getOrgUnit().getId().toString(), (String)"FNumber", numbers, (boolean)true);
        return res;
    }

    private Map queryViewInfo(Context ctx, String bgSchemeRootId, String bgTemplateRootId) throws BOSException {
        if (StringUtils.isEmpty((String)bgSchemeRootId) || StringUtils.isEmpty((String)bgTemplateRootId)) {
            return null;
        }
        StringBuffer sql = BgViewServerHelper.getQuerySQL();
        sql.append(" where bgScheme.FRootId = ? and bgTemplate.FRootID = ? and bgForm.FID is not null");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        HashMap bgFormMap = new HashMap();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeRootId);
            pstmt.setString(2, bgTemplateRootId);
            res = pstmt.executeQuery();
            while (res.next()) {
                Map temMap;
                BgFormInfo b = BgViewServerHelper.buildBgFormInfo((ResultSet)res);
                String orgId = b.getOrgUnit().getId().toString();
                String bgPeriodId = b.getBgPeriod().getId().toString();
                String currencyId = b.getCurrency().getId().toString();
                if (!bgFormMap.containsKey(bgPeriodId)) {
                    bgFormMap.put(bgPeriodId, new HashMap());
                }
                if (!(temMap = (Map)bgFormMap.get(bgPeriodId)).containsKey(currencyId)) {
                    temMap.put(currencyId, new HashMap());
                }
                ((Map)temMap.get(currencyId)).put(orgId, b);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    private Book getBookFromTemplate(Context ctx, String tempId) throws BOSException, EASBizException {
        Book book = null;
        BgTemplateInfo temp = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateInfo("select id,data where id ='" + tempId + "'");
        if (temp != null) {
            try {
                book = temp.getBook();
            }
            catch (Exception e) {
                logger.error((Object)"Error - ", (Throwable)e);
            }
        }
        return book;
    }

    private void buildSuccessResult(Map resMap, List orgIds) {
        if (resMap == null || orgIds == null || orgIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < orgIds.size(); ++i) {
            this.putTemplateResult(resMap, (String)orgIds.get(i), "success");
        }
    }

    /*
     * Loose catch block
     */
    protected Map checkDispatchBgTemplate(Context ctx, BgTemplateInfo bgTemplateInfo, List orgUnitIds, Map orgUnitMap, UserInfo userInfo) throws BOSException, EASBizException {
        if (ctx == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
        BgTemplateInfo _tmpInfo = null;
        FullOrgUnitInfo _unitInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = orgUnitIds.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _id = null;
        String _orgUnitId = null;
        Timestamp _time = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FOrgUnitId, FFormType, FLastUpdateTime from T_BG_BgTemplate where FRootId = ? and FOrgUnitId in (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgTemplateInfo.getRootId().toString());
                int k = 2;
                while (k <= batchNum + 1) {
                    if (pos < size) {
                        pstmt.setString(k, (String)orgUnitIds.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString("FId");
                    _orgUnitId = rst.getString("FOrgUnitId");
                    _time = rst.getTimestamp("FLastUpdateTime");
                    _tmpInfo = this.transfromInfo(bgTemplateInfo, userInfo);
                    _tmpInfo.setId(BOSUuid.read((String)_id));
                    _tmpInfo.setLastUpdateTime(_time);
                    _tmpInfo.setOrgUnit(new FullOrgUnitInfo());
                    _tmpInfo.getOrgUnit().setId(BOSUuid.read((String)_orgUnitId));
                    _tmpInfo.setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
                    _unitInfo = (FullOrgUnitInfo)orgUnitMap.get(_orgUnitId);
                    _tmpInfo.setCU(new CtrlUnitInfo());
                    _tmpInfo.getCU().setId(_unitInfo.getCU().getId());
                    bgTemplateMap.put(_orgUnitId, _tmpInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"Error - ", (Throwable)ex);
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex2) {
            logger.error((Object)"Error - ", (Throwable)ex2);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateMap;
    }

    protected BgTemplateInfo transfromInfo(BgTemplateInfo bgTemplateInfo, UserInfo userInfo) {
        BgTemplateInfo _tmpInfo = new BgTemplateInfo();
        if (bgTemplateInfo == null) {
            return _tmpInfo;
        }
        _tmpInfo = (BgTemplateInfo)bgTemplateInfo.clone();
        _tmpInfo.setId(null);
        _tmpInfo.setParent(bgTemplateInfo);
        _tmpInfo.setRootId(bgTemplateInfo.getRootId());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        _tmpInfo.setCreateTime(time);
        _tmpInfo.setLastUpdateTime(time);
        _tmpInfo.setLastUpdateUser(userInfo);
        for (RptSheetParamInfo rptSheetParamInfo : _tmpInfo.getSheetParam()) {
            rptSheetParamInfo.setId(null);
        }
        if (_tmpInfo.getBgMeasureUnit() != null) {
            BgTemMeasureUnitInfo measure2 = null;
            for (BgTemMeasureUnitInfo measure2 : _tmpInfo.getBgMeasureUnit()) {
                measure2.remove("id");
                measure2.remove("bgTemplate");
            }
        }
        return _tmpInfo;
    }

    protected byte[] transfromBook(Book book, int updateMode) throws IOException {
        Book _transbook = null;
        if (book == null) {
            _transbook = Book.Manager.getNewBook();
        } else {
            _transbook = Book.Manager.getNewBook((String)book.getName(), (int)book.getSheetCount());
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            BgNFSHelper.disableCal(_transbook);
            BgNFSHelper.disableUndo(_transbook);
            this.transfromBookInfo(book, _transbook, updateMode);
        }
        return IOHelper.packBook((Book)_transbook);
    }

    protected byte[] transEnumerateBook(Context ctx, IObjectValue obj, Book superBook, Book childBook, int updateMode, boolean isSelfAnalyse, String orgUnitId) throws Exception {
        Book _transbook = null;
        if (superBook == null || childBook == null) {
            _transbook = Book.Manager.getNewBook();
        } else {
            _transbook = Book.Manager.getNewBook((String)superBook.getName(), (int)superBook.getSheetCount());
            BgNFSHelper.disableCal(superBook);
            BgNFSHelper.disableUndo(superBook);
            BgNFSHelper.disableCal(_transbook);
            BgNFSHelper.disableUndo(_transbook);
            BgNFSHelper.disableCal(childBook);
            BgNFSHelper.disableUndo(childBook);
            this.transEnumerateBookInfo(ctx, obj, superBook, _transbook, childBook, updateMode, isSelfAnalyse, orgUnitId);
        }
        return IOHelper.packBook((Book)_transbook);
    }

    protected void transfromBookInfo(Book book, Book transBook, int updateMode) {
        if (book == null || transBook == null) {
            return;
        }
        this.transEnumerateSheetName(book, transBook);
        this.stopBookProtection(transBook);
        Sheet _transSheet = null;
        Sheet _sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            _sheet = book.getSheet(i);
            _transSheet = transBook.getSheet(i);
            this.transfromSheetInfo(_sheet, _transSheet, updateMode);
        }
        SortedUserObjectArray list = book.getUserObjects();
        if (list != null) {
            UserObject object = null;
            int in2 = list.size();
            for (int i = 0; i < in2; ++i) {
                object = list.getUserObject(i);
                transBook.setUserObject(object.getKey(), object.getValue());
            }
        }
        this.startBookProtection(transBook);
    }

    private void transEnumerateBookInfo(Context ctx, IObjectValue obj, Book superBook, Book transBook, Book childBook, int updateMode, boolean isSelfAnalyse, String orgUnitId) throws Exception {
        if (superBook == null || transBook == null || childBook == null) {
            return;
        }
        boolean hasVarExpress = false;
        this.transEnumerateSheetName(superBook, transBook);
        this.stopBookProtection(transBook);
        SortedUserObjectArray list = superBook.getUserObjects();
        if (list != null) {
            UserObject object = null;
            int in = list.size();
            for (int i = 0; i < in; ++i) {
                object = list.getUserObject(i);
                transBook.setUserObject(object.getKey(), object.getValue());
            }
        }
        Map enumInfo = BgNAssignUpdateUtil.getEnumerateMap(superBook);
        Sheet _transSheet = null;
        Sheet _superSheet = null;
        Sheet _childSheet = null;
        String sheetSignId = null;
        int in = superBook.getSheetCount();
        for (int i = 0; i < in; ++i) {
            _superSheet = superBook.getSheet(i);
            _transSheet = transBook.getSheet(i);
            sheetSignId = BgNFSHelper.getSheetSign(_superSheet);
            if (StringUtils.isEmpty((String)sheetSignId)) continue;
            try {
                _childSheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId(sheetSignId, childBook);
                if (_childSheet == null) {
                    _childSheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID(_superSheet.getID(), childBook);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            hasVarExpress = _childSheet != null ? this.transEnumerateSheetInfo(ctx, obj, _superSheet, _transSheet, _childSheet, (Map)enumInfo.get(_superSheet.getID()), updateMode) | hasVarExpress : this.transfromSheetInfo(_superSheet, _transSheet, updateMode);
        }
        if (hasVarExpress && updateMode == 1) {
            if (isSelfAnalyse) {
                BgExpressionsItemVariableHelper.batchRebuildExpressions(transBook, orgUnitId, null, ctx);
            } else {
                BgAutoEnurameHelper.batchRebuildExpressions(transBook, null, null, ctx);
            }
        }
        this.startBookProtection(transBook);
    }

    protected boolean transfromSheetInfo(Sheet sheet, Sheet transSheet, int updateMode) {
        SortedUserObjectArray list;
        boolean hasVarExpress = false;
        if (sheet == null || transSheet == null) {
            return hasVarExpress;
        }
        Row _row = null;
        Row _transRow = null;
        Column _column = null;
        Column _transColumn = null;
        Cell _cell = null;
        Cell _transCell = null;
        String _sign = null;
        transSheet.setID(sheet.getID());
        transSheet.setName(sheet.getSheetName());
        transSheet.setHide(sheet.isHide());
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        transSheet.copySheetFrom(sheet);
        transSheet.setPageView(sheet.isPageView());
        if (sheet.isPageView()) {
            transSheet.setRowPaginationPointsSnapshot(sheet.getRowPaginationPointsSnapshot());
            transSheet.setColPaginationPointsSnapshot(sheet.getColPaginationPointsSnapshot());
        }
        this.stopSheetProtection(transSheet);
        int in = rowCount;
        for (int i = 0; i <= in; ++i) {
            _row = sheet.getRow(i, false);
            if (_row != null && !StringUtils.isEmpty((String)(_sign = BgNFSHelper.getRowSign(_row)))) {
                _transRow = transSheet.getRow(i, true);
                BgNFSHelper.setRowSign(_transRow, _sign);
                BgNFSHelper.setRowObject(_transRow, "SIGN_DATA_SOURCE", "DATA_SOURCE_SUPERIOR");
            }
            int jn = colCount;
            for (int j = 0; j <= jn; ++j) {
                if (i == 0 && (_column = sheet.getColumn(j, false)) != null && !StringUtils.isEmpty((String)(_sign = BgNFSHelper.getColSign(_column)))) {
                    _transColumn = transSheet.getColumn(j, true);
                    BgNFSHelper.setColSign(_transColumn, _sign);
                    BgNFSHelper.setColObject(_transColumn, "SIGN_DATA_SOURCE", "DATA_SOURCE_SUPERIOR");
                }
                this.copyStyle(sheet.getRange(i, j), transSheet.getRange(i, j), true);
                _cell = sheet.getCell(i, j, false);
                if (_cell == null) continue;
                if (updateMode == 1 && !hasVarExpress) {
                    hasVarExpress = this.hasVarExpress(_cell);
                }
                _transCell = transSheet.getCell(i, j, true);
                this.transfromCellInfo(_cell, _transCell);
            }
        }
        _sign = BgNFSHelper.getSheetSign(sheet);
        if (!StringUtils.isEmpty((String)_sign)) {
            BgNFSHelper.setSheetSign(transSheet, _sign);
            BgNFSHelper.setSheetObject(transSheet, "SIGN_DATA_SOURCE", "DATA_SOURCE_SUPERIOR");
        }
        if ((list = sheet.getUserObjects()) != null) {
            UserObject object = null;
            int in2 = list.size();
            for (int i = 0; i < in2; ++i) {
                object = list.getUserObject(i);
                transSheet.setUserObject(object.getKey(), object.getValue());
            }
        }
        this.startSheetProtection(transSheet, updateMode);
        transSheet.clearStyleCache();
        sheet.clearStyleCache();
        return hasVarExpress;
    }

    private boolean transEnumerateSheetInfo(Context ctx, IObjectValue obj, Sheet superSheet, Sheet transSheet, Sheet childSheet, Map sheetEnumMap, int updateMode) throws Exception {
        SortedUserObjectArray list;
        if (superSheet == null || transSheet == null || childSheet == null) {
            return false;
        }
        boolean hasVarExpress = false;
        String _sign = null;
        transSheet.copySheetFrom(childSheet);
        transSheet.setID(superSheet.getID());
        transSheet.setName(superSheet.getSheetName());
        transSheet.setHide(superSheet.isHide());
        this.copySheetSingles(transSheet, childSheet);
        this.stopSheetProtection(transSheet);
        transSheet.getBook().setActiveSheet(transSheet);
        _sign = BgNFSHelper.getSheetSign(superSheet);
        if (!StringUtils.isEmpty((String)_sign)) {
            BgNFSHelper.setSheetSign(transSheet, _sign);
            BgNFSHelper.setSheetObject(transSheet, "SIGN_DATA_SOURCE", "DATA_SOURCE_SUPERIOR");
        }
        if ((list = superSheet.getUserObjects()) != null) {
            UserObject object = null;
            int in = list.size();
            for (int i = 0; i < in; ++i) {
                object = list.getUserObject(i);
                transSheet.setUserObject(object.getKey(), object.getValue());
            }
        }
        Map sheetInfo = BgNAssignUpdateUtil.transSheet(childSheet, transSheet, true);
        Map colIds = (Map)sheetInfo.get("col_id_map");
        Map rowIds = (Map)sheetInfo.get("row_id_map");
        Sheet actualSheet = (Sheet)sheetInfo.get("BG_ACTUAL_EXPRESSIONS");
        Sheet actualAddSheet = (Sheet)sheetInfo.get("BG_ADD_EXPRESSIONS");
        Map superInfo = BgNAssignUpdateUtil.transSheet(superSheet, null, false);
        Map superColIds = (Map)superInfo.get("col_id_map");
        Map superRowIds = (Map)superInfo.get("row_id_map");
        Map superEnum = BgNAssignUpdateUtil.getEnumMap(sheetEnumMap);
        BgNAssignUpdateUtil.insertCols(superSheet, transSheet, actualSheet, actualAddSheet, colIds, false);
        this.dealSheetColHide(superSheet, transSheet, actualSheet, actualAddSheet);
        BgNAssignUpdateUtil.insertRows(superSheet, transSheet, actualSheet, actualAddSheet, rowIds, superEnum, false);
        this.dealSheetRowHide(superSheet, transSheet, actualSheet, actualAddSheet);
        BgNAssignUpdateUtil.removerCol(transSheet, actualSheet, actualAddSheet, superColIds, colIds);
        BgNAssignUpdateUtil.removerRows(transSheet, actualSheet, actualAddSheet, superRowIds, rowIds);
        BgNEnumeraInfo sheetEnum = this.getSheetEnumInfo(ctx, sheetEnumMap, rowIds, colIds);
        hasVarExpress = this.updateCells(ctx, obj, superSheet, transSheet, actualSheet, actualAddSheet, rowIds, colIds, sheetEnum) | hasVarExpress;
        this.startSheetProtection(transSheet, updateMode);
        return hasVarExpress;
    }

    private void dealSheetRowHide(Sheet superSheet, Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet) {
        if (superSheet == null || transSheet == null) {
            return;
        }
        Map superMap = BgNFSHelper.getRowIDMapInfo(superSheet);
        Map childMap = BgNFSHelper.getRowIDMapInfo(transSheet);
        Map actualMap = BgNFSHelper.getRowIDMapInfo(actualSheet);
        Map actualAddMap = BgNFSHelper.getRowIDMapInfo(actualAddSheet);
        Row superRow = null;
        Row childRow = null;
        Iterator it = superMap.keySet().iterator();
        while (it.hasNext()) {
            String colId = it.next().toString();
            superRow = superSheet.getRow(new Integer(superMap.get(colId).toString()).intValue(), false);
            if (childMap.containsKey(colId)) {
                childRow = transSheet.getRow(new Integer(childMap.get(colId).toString()).intValue(), false);
                this.setRowHide(superRow, childRow);
            }
            if (actualMap.containsKey(colId)) {
                childRow = transSheet.getRow(new Integer(actualMap.get(colId).toString()).intValue(), false);
                this.setRowHide(superRow, childRow);
            }
            if (!actualAddMap.containsKey(colId)) continue;
            childRow = transSheet.getRow(new Integer(actualAddMap.get(colId).toString()).intValue(), false);
            this.setRowHide(superRow, childRow);
        }
    }

    private void dealSheetColHide(Sheet superSheet, Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet) {
        if (superSheet == null || transSheet == null) {
            return;
        }
        Map superColMap = BgNFSHelper.getColIDMapInfo(superSheet);
        Map childColMap = BgNFSHelper.getColIDMapInfo(transSheet);
        Map actualColMap = BgNFSHelper.getColIDMapInfo(transSheet);
        Map actualAddColMap = BgNFSHelper.getColIDMapInfo(transSheet);
        Column superCol = null;
        Column childCol = null;
        Iterator it = superColMap.keySet().iterator();
        while (it.hasNext()) {
            String colId = it.next().toString();
            superCol = superSheet.getColumn(new Integer(superColMap.get(colId).toString()).intValue(), false);
            if (childColMap.containsKey(colId)) {
                childCol = transSheet.getColumn(new Integer(childColMap.get(colId).toString()).intValue(), false);
                this.setColHide(superCol, childCol);
            }
            if (actualColMap.containsKey(colId)) {
                childCol = transSheet.getColumn(new Integer(actualColMap.get(colId).toString()).intValue(), false);
                this.setColHide(superCol, childCol);
            }
            if (!actualAddColMap.containsKey(colId)) continue;
            childCol = transSheet.getColumn(new Integer(actualAddColMap.get(colId).toString()).intValue(), false);
            this.setColHide(superCol, childCol);
        }
    }

    protected void transfromCellInfo(Cell cell, Cell transCell) {
        if (cell == null || transCell == null) {
            return;
        }
        Object _obj = null;
        String _key = null;
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
            BgNFSHelper.setItemFormula(transCell, itemFormula);
            BgNFSHelper.setFormulaEditOfDisable(transCell);
            BgNFSHelper.setUserObject(transCell, "SIGN_DATA_SOURCE", "DATA_SOURCE_SUPERIOR");
        }
        this.copyStyle(cell.getSheet().getRange(cell), transCell.getSheet().getRange(transCell), true);
        _obj = cell.getUserObjectValue("force_lock_org_longnumber");
        if (_obj != null && _obj instanceof String && !StringUtils.isEmpty((String)(_key = _obj.toString()))) {
            transCell.setUserObject("force_lock_org_longnumber", (Object)_key);
        }
    }

    private void copyStyle(Range source, Range target, boolean isCopyName) {
        if (source == null || target == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        source.setIgnoreProtected(true);
        target.setIgnoreProtected(true);
        source.getStyle(sa, sa);
        sa.setDirty(ShareStyleAttributes.getAllBits());
        target.setStyle(sa, sa);
    }

    /*
     * Loose catch block
     */
    protected void updateTemplateLastUpdateTime(Context ctx, BgTemplateInfo superbgTemplateInfo, Map bgTemplateMap) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block8: {
            if (ctx == null || superbgTemplateInfo == null || bgTemplateMap == null || bgTemplateMap.isEmpty()) {
                return;
            }
            int batchIndex = 0;
            int batchNum = 200;
            BgTemplateInfo _templateInfo2222222222 = null;
            conn = null;
            pstmt = null;
            StringBuffer sql = new StringBuffer();
            sql.append("update T_BG_BgTemplate set FLastUpdateTime = ? where FId = ?");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (BgTemplateInfo _templateInfo2222222222 : bgTemplateMap.values()) {
                    pstmt.setTimestamp(1, superbgTemplateInfo.getLastUpdateTime());
                    pstmt.setString(2, _templateInfo2222222222.getId().toString());
                    pstmt.addBatch();
                    if (++batchIndex < batchNum) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex == 0) break block8;
                pstmt.executeBatch();
            }
            catch (BOSException ex) {
                logger.error((Object)"Error - ", (Throwable)ex);
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException ex2) {
                logger.error((Object)"Error - ", (Throwable)ex2);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     */
    protected void updateSchemeNode(Context ctx, BgSchemeInfo schemeInfo, BgTemplateInfo templateInfo, List orgUnitIds, Map bgSchemeMap, Map bgTemplateMap) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            if (ctx == null || schemeInfo == null || templateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty() || bgSchemeMap == null || bgSchemeMap.isEmpty() || bgTemplateMap == null || bgTemplateMap.isEmpty()) {
                return;
            }
            int batchIndex = 0;
            int batchNum = 200;
            String _orgUnitId = null;
            String _bgSchemeId = null;
            String _bgTemplateId = null;
            String _key = null;
            BgSchemeInfo _bgSchemeInfo = null;
            BgTemplateInfo _bgTemplateInfo = null;
            HashSet<String> _tmpSet = new HashSet<String>();
            conn = null;
            pstmt = null;
            ResultSet rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select n.FBgSchemeId, n.FBgTemplateId from T_BG_BgSchemeNode n left join T_BG_BgScheme s on n.FBgSchemeId = s.FId left join T_BG_BgTemplate t on n.FBgTemplateId = t.FId where s.FRootId = ? and t.FRootId = ?");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, schemeInfo.getRootId().toString());
                pstmt.setString(2, templateInfo.getRootId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgSchemeId = rst.getString("FBgSchemeId");
                    _bgTemplateId = rst.getString("FBgTemplateId");
                    _key = _bgSchemeId + "_" + _bgTemplateId;
                    _tmpSet.add(_key);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                BgSchemeNodeInfo nodeInfo = new BgSchemeNodeInfo();
                BOSObjectType type = nodeInfo.getBOSType();
                sql = new StringBuffer();
                sql.append("INSERT INTO T_BG_BgSchemeNode(FID, FBgSchemeId, FBgTemplateId) values (?, ?, ?)");
                pstmt = conn.prepareStatement(sql.toString());
                int in = orgUnitIds.size();
                for (int i = 0; i < in; ++i) {
                    _orgUnitId = (String)orgUnitIds.get(i);
                    _bgSchemeInfo = (BgSchemeInfo)bgSchemeMap.get(_orgUnitId);
                    _bgTemplateInfo = (BgTemplateInfo)bgTemplateMap.get(_orgUnitId);
                    _key = _bgSchemeInfo.getId().toString() + "_" + _bgTemplateInfo.getId().toString();
                    if (_tmpSet.contains(_key)) continue;
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    pstmt.setString(2, _bgSchemeInfo.getId().toString());
                    pstmt.setString(3, _bgTemplateInfo.getId().toString());
                    pstmt.addBatch();
                    if (++batchIndex < batchNum) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex == 0) break block9;
                pstmt.executeBatch();
            }
            catch (BOSException ex) {
                logger.error((Object)"Error - ", (Throwable)ex);
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException ex2) {
                logger.error((Object)"Error - ", (Throwable)ex2);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void stopBookProtection(Book book) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (pro.isProtected()) {
            pro.stop("");
        }
        if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        pro.deleteOperations();
    }

    protected void startBookProtection(Book book) {
        if (book == null) {
            return;
        }
        this.stopBookProtection(book);
        BookProtection pro = book.getProtection();
        pro.appendOperation(1);
        pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
    }

    protected void stopSheetProtection(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (pro.isProtected()) {
            pro.stop("");
        }
        if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        pro.deleteOperations();
    }

    protected void startSheetProtection(Sheet sheet, int updateMode) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        this.stopSheetProtection(sheet);
        List sheetOperation = this.getSheetOperation(updateMode);
        if (sheetOperation != null) {
            Object _obj2 = null;
            for (Object _obj2 : sheetOperation) {
                if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                pro.appendOperation(((Integer)_obj2).intValue());
            }
        }
        pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
    }

    protected List getSheetOperation(int updateMode) {
        List sheetOperation = null;
        if (updateMode == 0 || updateMode == 3) {
            sheetOperation = this.getFixedSheetOperation();
        } else if (updateMode == 1 || updateMode == 2) {
            sheetOperation = this.getMaxSheetOperation();
        }
        return sheetOperation;
    }

    protected List getFixedSheetOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(128));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(4096));
        return sheetOperation;
    }

    protected List getMaxSheetOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(32));
        sheetOperation.add(new Integer(64));
        sheetOperation.add(new Integer(128));
        sheetOperation.add(new Integer(256));
        sheetOperation.add(new Integer(512));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(4096));
        return sheetOperation;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List queryBgTemplateExamineInfo(Context ctx, BOSUuid bgTemplateId) throws BOSException, EASBizException {
        ArrayList<String> bgExamineIds = new ArrayList<String>();
        if (ctx == null) return bgExamineIds;
        if (bgTemplateId == null) {
            return bgExamineIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBgExamineId from T_BG_BgExamineNode where FBgTemplateId = ?");
            pstmt.setString(1, bgTemplateId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgExamineIds.add(rst.getString("FBgExamineId"));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgExamineIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateBgExamineInfo(Context ctx, List bgTemplateIds, List bgExamineIds) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgTemplateIds == null) return;
        if (bgTemplateIds.isEmpty()) return;
        if (bgExamineIds == null) return;
        if (bgExamineIds.isEmpty()) {
            return;
        }
        String _bgTemplateId = null;
        String _bgExamineId = null;
        BgExamineNodeInfo nodeInfo = new BgExamineNodeInfo();
        String _bosType = nodeInfo.getBOSType().toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgExamineNode where FBgTemplateId = ?");
            int in = bgTemplateIds.size();
            for (i = 0; i < in; ++i) {
                _bgTemplateId = (String)bgTemplateIds.get(i);
                pstmt.setString(1, BOSUuid.read((String)_bgTemplateId).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("Insert Into T_BG_BgExamineNode(FID, FBgTemplateId, FBgExamineId, FIsParent) values (?,?,?,?)");
            in = bgTemplateIds.size();
            for (i = 0; i < in; ++i) {
                _bgTemplateId = (String)bgTemplateIds.get(i);
                int jn = bgExamineIds.size();
                for (int j = 0; j < jn; ++j) {
                    _bgExamineId = (String)bgExamineIds.get(j);
                    pstmt.setString(1, BOSUuid.create((String)_bosType).toString());
                    pstmt.setString(2, BOSUuid.read((String)_bgTemplateId).toString());
                    pstmt.setString(3, BOSUuid.read((String)_bgExamineId).toString());
                    pstmt.setInt(4, 1);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    private void putTemplateResult(Map resMap, String orgUnitId, String result) {
        if (resMap != null && !StringUtils.isEmpty((String)orgUnitId)) {
            Map sub = (Map)resMap.get(orgUnitId);
            if (sub == null) {
                sub = this.putSchemeResult(resMap, orgUnitId, null);
            }
            sub.put("BG_TEMPLATE_RESULT", result);
        }
    }

    private Map putSchemeResult(Map resMap, String orgUnitId, String result) {
        if (resMap != null && !StringUtils.isEmpty((String)orgUnitId)) {
            HashMap<String, String> sub;
            if (result == null) {
                result = "success";
            }
            if ((sub = (HashMap<String, String>)resMap.get(orgUnitId)) == null) {
                sub = new HashMap<String, String>();
                resMap.put(orgUnitId, sub);
            }
            sub.put("ASSING_ISFMALE_STATUS", result);
            return sub;
        }
        return null;
    }

    private boolean isColOrRowHide(Book book) {
        if (book == null) {
            return false;
        }
        Sheet sheet = null;
        Column col = null;
        Row row = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                row = sheet.getRow(rowIndex, true);
                if (!BgNFSHelper.isHided(row)) continue;
                return true;
            }
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                col = sheet.getColumn(colIndex, true);
                if (!BgNFSHelper.isHided(col)) continue;
                return true;
            }
        }
        return false;
    }

    private void setColHide(Column superCol, Column childCol) {
        if (superCol == null || childCol == null) {
            return;
        }
        if (BgNFSHelper.isHided(superCol)) {
            BgNFSHelper.setHided(childCol, true);
        } else {
            BgNFSHelper.setHided(childCol, false);
        }
    }

    private void setRowHide(Row superRow, Row childRow) {
        if (superRow == null || childRow == null) {
            return;
        }
        if (BgNFSHelper.isHided(superRow)) {
            BgNFSHelper.setHided(childRow, true);
        } else {
            BgNFSHelper.setHided(childRow, false);
        }
    }

    private boolean updateCells(Context ctx, IObjectValue obj, Sheet superSheet, Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet, Map rowIds, Map colIds, BgNEnumeraInfo sheetEnum) throws Exception {
        int colIndex;
        int rowIndex;
        boolean hasVarExpress = false;
        Row row = null;
        Column column = null;
        String rowId = null;
        String colId = null;
        int rowCount = superSheet.getMaxRowIndex() + 1;
        int colCount = superSheet.getMaxColIndex() + 1;
        int upRowIndex = -1;
        int upColIndex = -1;
        HashMap formulaMap = new HashMap();
        Map[] itemExpressionMap = new HashMap[3];
        BgNEnumeraInfo.BgOneEnumInfo oneEnum = null;
        BgNEnumeraInfo.BgItemEnumInfo itemEnum = null;
        String[] itemInfo = null;
        Cell transCell = null;
        StringBuffer delCells = new StringBuffer();
        String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, obj);
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = superSheet.getRow(rowIndex, false);
            if (row == null) continue;
            boolean hasItemVariable = BgExpressionsItemVariableHelper.checkRowHasBgItemVariable(superSheet, rowIndex);
            if (BgNFSHelper.getRowSign(row) == null) continue;
            rowId = BgNFSHelper.getRowSign(row);
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                column = superSheet.getColumn(colIndex, false);
                if (column == null || BgNFSHelper.getColSign(column) == null) continue;
                colId = BgNFSHelper.getColSign(column);
                if (!hasVarExpress) {
                    hasVarExpress = this.hasVarExpress(superSheet.getCell(rowIndex, colIndex, false));
                }
                if (!rowIds.containsKey(rowId) || !colIds.containsKey(colId)) continue;
                upRowIndex = ((BgRowColIdObject)rowIds.get(rowId)).getCurrIndex();
                upColIndex = ((BgRowColIdObject)colIds.get(colId)).getCurrIndex();
                BgNAssignUpdateUtil.UpdateTemplateNewCellToFormCell(ctx, rowIndex, colIndex, upRowIndex, upColIndex, formulaMap, itemExpressionMap, true, obj, false, superSheet, transSheet, actualSheet, actualAddSheet, true, BgTemFormTypeEnum.ENUMERATEFORM, false, hasItemVariable, companyNumber);
                transCell = transSheet.getCell(upRowIndex, upColIndex, false);
                if (transCell != null) {
                    if (transCell.hasFormula()) {
                        BgNTemplateHelper.setBgDataValue(transCell, "BG_BUDGET_EXPRESSIONS", transCell.getFormula(), false);
                    } else {
                        BgNTemplateHelper.removeDataValue(transCell, "BG_BUDGET_EXPRESSIONS", false);
                    }
                    Cell upCell = actualSheet.getCell(upRowIndex, upColIndex, false);
                    if (upCell != null && upCell.hasFormula()) {
                        BgNTemplateHelper.setBgDataValue(transCell, "BG_ACTUAL_EXPRESSIONS", upCell.getFormula(), false);
                    } else {
                        BgNTemplateHelper.removeDataValue(transCell, "BG_ACTUAL_EXPRESSIONS", false);
                    }
                    upCell = actualAddSheet.getCell(upRowIndex, upColIndex, false);
                    if (upCell != null && upCell.hasFormula()) {
                        BgNTemplateHelper.setBgDataValue(transCell, "BG_ADD_EXPRESSIONS", upCell.getFormula(), false);
                    } else {
                        BgNTemplateHelper.removeDataValue(transCell, "BG_ADD_EXPRESSIONS", false);
                    }
                }
                this.copyStyle(superSheet.getRange(rowIndex, colIndex), transSheet.getRange(upRowIndex, upColIndex), true);
            }
        }
        itemExpressionMap = null;
        rowCount = transSheet.getMaxRowIndex() + 1;
        colCount = transSheet.getMaxColIndex() + 1;
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            boolean delItem = false;
            if (sheetEnum != null && (oneEnum == null || oneEnum != null && rowIndex > oneEnum.getEndRow())) {
                oneEnum = sheetEnum.getEnumInfo(rowIndex);
            }
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                transCell = transSheet.getCell(rowIndex, colIndex, false);
                if (sheetEnum == null) continue;
                if (oneEnum != null) {
                    if (colIndex < oneEnum.getBeginCol() || colIndex > oneEnum.getEndCol()) continue;
                    if (oneEnum != null && (itemEnum == null || itemEnum != null && colIndex >= itemEnum.getEndCol())) {
                        itemEnum = oneEnum.getBgItemEnumInfo(rowIndex, colIndex);
                    }
                    if (!BgNFSHelper.checkHasBgItemInfo(transCell) || itemEnum == null || itemEnum.isCanFill((itemInfo = BgNFSHelper.getBgItemInfo(transCell))[1])) continue;
                    delItem = true;
                    colIndex = oneEnum.getEndCol();
                    continue;
                }
                if (BgNFSHelper.isLockOfCell(transCell) || !BgNFSHelper.checkCanEditFormulaOfCell(transCell)) continue;
                if (BgNFSHelper.checkHasBgItemInfo(transCell)) {
                    BgNFSHelper.removeBgItemInfo(transCell);
                    BgNFSHelper.setValue(transCell, null);
                    delCells.append("#" + transCell.getName(true, true) + "#");
                    continue;
                }
                if (!BgNFSHelper.checkHasItemFormula(transCell)) continue;
                BgNFSHelper.removeItemFormula(transCell);
                BgNFSHelper.setBudgetValue(transCell, null);
                BgNFSHelper.setValue(transCell, null);
                delCells.append("(" + transCell.getName(true, true) + ")");
                transCell.setFormula(null);
            }
            if (!delItem || oneEnum == null) continue;
            delCells = new StringBuffer();
            for (colIndex = oneEnum.getBeginCol(); colIndex <= oneEnum.getEndCol(); ++colIndex) {
                transCell = transSheet.getCell(rowIndex, colIndex, false);
                if (BgNFSHelper.checkHasBgItemInfo(transCell)) {
                    BgNFSHelper.removeBgItemInfo(transCell);
                    BgNFSHelper.setValue(transCell, null);
                    delCells.append("#").append(transCell.getName(true, true)).append("#");
                    continue;
                }
                if (!BgNFSHelper.checkHasItemFormula(transCell)) continue;
                BgNFSHelper.removeItemFormula(transCell);
                BgNFSHelper.setBudgetValue(transCell, null);
                BgNFSHelper.setValue(transCell, null);
                delCells.append("#").append(transCell.getName(true, true)).append("#");
                transCell.setFormula(null);
            }
            logger.error((Object)(" REMOVE CELL ENUM  " + delCells));
        }
        return hasVarExpress;
    }

    private BgNEnumeraInfo getSheetEnumInfo(final Context ctx, Map sheetEnum, Map rowIds, Map colIds) throws Exception {
        BgNEnumeraInfo.IBgItemEnumFacade bgItem = new BgNEnumeraInfo.IBgItemEnumFacade(){

            @Override
            public Set getNumbers(HashSet numbers) throws Exception {
                if (numbers == null || numbers.isEmpty()) {
                    return null;
                }
                return BgItemFacadeFactory.getLocalInstance((Context)ctx).getBgItemNumber((Object)numbers);
            }

            @Override
            public Set getNumbers(String itemGroupNumber) throws Exception {
                if (itemGroupNumber == null || itemGroupNumber.length() <= 0) {
                    return null;
                }
                BgItemCollection col = BgItemFactory.getLocalInstance((Context)ctx).getBgItemCollection("select number where bgItemGroup.number = '" + itemGroupNumber + "'");
                HashSet<String> numbers = new HashSet<String>();
                if (col != null) {
                    for (int i = 0; i < col.size(); ++i) {
                        numbers.add(col.get(i).getNumber());
                    }
                }
                return numbers;
            }
        };
        return BgNEnumeraInfo.getInstance(bgItem, sheetEnum, rowIds, colIds);
    }

    private boolean hasVarExpress(Cell cell) {
        if (cell != null) {
            return BgExpressionsItemVariableHelper.hasBgItemVariable(cell) || !StringUtils.isEmpty((String)BgAutoEnurameHelper.getBgItemVariable(cell, "BG_BUDGET_EXPRESSIONS")) || !StringUtils.isEmpty((String)BgAutoEnurameHelper.getBgItemVariable(cell, "BG_ACTUAL_EXPRESSIONS")) || !StringUtils.isEmpty((String)BgAutoEnurameHelper.getBgItemVariable(cell, "BG_ADD_EXPRESSIONS"));
        }
        return false;
    }

    private void transEnumerateSheetName(Book superBook, Book transBook) {
        if (superBook == null || transBook == null) {
            return;
        }
        String sheetName = null;
        String oldName = null;
        String tempSheetName = this.getTempSheet(superBook, transBook, new SecureRandom());
        int transIndex = -1;
        for (int i = 0; i < superBook.getSheetCount(); ++i) {
            sheetName = superBook.getSheetName(i);
            transIndex = transBook.getSheetIndexByName(sheetName);
            if (transIndex < 0 || transIndex == i) continue;
            oldName = transBook.getSheetName(i);
            transBook.getSheet(i).setName(tempSheetName);
            transBook.getSheet(transIndex).setName(oldName);
            transBook.getSheet(i).setName(sheetName);
        }
    }

    private String getTempSheet(Book superBook, Book transBook, SecureRandom rand) {
        String sheetName = "Sheet" + (rand.nextInt(Short.MAX_VALUE) + 256);
        if (superBook != null && superBook.getSheetIndexByName(sheetName) >= 0 || transBook != null && transBook.getSheetIndexByName(sheetName) >= 0) {
            return this.getTempSheet(superBook, transBook, rand);
        }
        return sheetName;
    }

    private void copySheetSingles(Sheet transSheet, Sheet childSheet) {
    }

    private Hashtable getTemplateCtrlMode(Context ctx, BOSUuid tempId) throws EASBizException, BOSException {
        if (tempId == null) {
            return new Hashtable();
        }
        Hashtable ctrlModeMap = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).getBgTemplateCtrlModeMap(tempId);
        if (ctrlModeMap != null && ctrlModeMap.size() != 0) {
            Object obj2 = null;
            for (Object obj2 : ctrlModeMap.values()) {
                if (!(obj2 instanceof Map)) continue;
                ((Map)obj2).put("isFromSuper", Boolean.TRUE);
            }
        }
        if (!(ctrlModeMap instanceof Hashtable) && ctrlModeMap != null) {
            ctrlModeMap = new Hashtable(ctrlModeMap);
        }
        return ctrlModeMap;
    }
}

