/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgSchemeUnAssignInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgSchemeUnAssignFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeUnAssignFacadeControllerBean
extends AbstractBgSchemeUnAssignFacadeControllerBean {
    private static final long serialVersionUID = -6138902715394600658L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgSchemeUnAssignFacadeControllerBean");

    @Override
    protected String _chekcHasAssigned(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        ResultSet res;
        PreparedStatement pst;
        Connection conn;
        block6: {
            String string;
            block7: {
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                if (BgSHelper.checkMutex((Context)ctx, (String)bgSchemeId, (String)userId)) {
                    return "bgSchemeLocked";
                }
                String sql = "SELECT bgScheme.FIsFormal isFormal,isAssigned = CASE WHEN EXISTS  (SELECT sub.FID FROM T_Bg_BgScheme sub WHERE sub.FParentSchemeID = bgScheme.FID )  THEN 1 ELSE 0 END FROM T_Bg_BgScheme bgScheme WHERE FID =? ";
                conn = null;
                pst = null;
                res = null;
                conn = this.getConnection(ctx);
                pst = conn.prepareStatement(sql);
                pst.setString(1, bgSchemeId);
                res = pst.executeQuery();
                if (!res.next()) break block6;
                if (res.getInt("isAssigned") != 0) break block7;
                String string2 = "bgSchemeUnAssign";
                SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
                return string2;
            }
            try {
                if (res.getInt("isFormal") == 0) break block6;
                string = "bgSchemeExecuted";
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
        return null;
    }

    @Override
    protected void _unAssignAll(Context ctx, Map unAssignInfoMap) throws BOSException, EASBizException {
        this.dropTemplate(ctx, unAssignInfoMap);
        this.clearTemplateRef(ctx, unAssignInfoMap);
        this.dropScheme(ctx, unAssignInfoMap);
    }

    private void dropTemplate(Context ctx, Map unAssignInfoMap) throws BOSException {
        if (unAssignInfoMap == null || unAssignInfoMap.isEmpty()) {
            return;
        }
        Object key2 = null;
        String[] temNums = null;
        BgSchemeUnAssignInfo.BgTemplateUnAssignInfo template = null;
        BgSchemeUnAssignInfo scheme = null;
        ArrayList<BgSchemeUnAssignInfo.BgTemplateUnAssignInfo> templates = new ArrayList<BgSchemeUnAssignInfo.BgTemplateUnAssignInfo>();
        ArrayList<String> temIds = new ArrayList<String>();
        IMutexServiceControl imsc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String dcName = ctx.getAIS();
        String userName = ctx.getUserName();
        try {
            for (Object key2 : unAssignInfoMap.keySet()) {
                if (!(unAssignInfoMap.get(key2) instanceof BgSchemeUnAssignInfo) || (temNums = (scheme = (BgSchemeUnAssignInfo)unAssignInfoMap.get(key2)).getKeys()) == null || temNums.length <= 0) continue;
                for (int i = 0; i < temNums.length; ++i) {
                    template = scheme.getTemplate(temNums[i]);
                    if (!template.isSelected() || !StringUtils.isEmpty((String)template.getState())) continue;
                    if (imsc.requestObjIDForUpdate(template.getId(), userName, dcName)) {
                        templates.add(template);
                        temIds.add(template.getId());
                        imsc.requestObjIDForUpdate(template.getId(), userName, dcName);
                        continue;
                    }
                    template.setState("locked");
                }
            }
            this.dropExiame(ctx, templates, temIds);
            this.dropDefaultCtrl(ctx, temIds);
            this.dropCtrl(ctx, temIds);
            this.dropTemplate(ctx, templates, temIds);
        }
        catch (Exception e) {
            logger.error((Object)"dropTemplate:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            imsc.batchReleaseObjIDForUpdate(temIds);
        }
    }

    private void dropCtrl(Context ctx, List temIds) throws BOSException {
        if (temIds == null || temIds.isEmpty()) {
            return;
        }
        String sql = "DELETE T_BG_BgTemplateCtrlSetting WHERE FBgTemplateID = ?";
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            for (int i = 0; i < temIds.size(); ++i) {
                pst.setObject(1, temIds.get(i));
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    private void dropDefaultCtrl(Context ctx, List temIds) throws BOSException {
        if (temIds == null || temIds.isEmpty()) {
            return;
        }
        String sql = "DELETE T_BG_BgTemplateDefCtrlSet WHERE FBgTemplateID = ?";
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            for (int i = 0; i < temIds.size(); ++i) {
                pst.setObject(1, temIds.get(i));
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropExiame(Context ctx, List templates, List templateIds) throws Exception {
        Connection conn = null;
        PreparedStatement pst = null;
        String sql = "DELETE T_BG_BgExamineNode WHERE FBgTemplateID=?";
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            for (int i = 0; i < templateIds.size(); ++i) {
                pst.setObject(1, templateIds.get(i));
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pst, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTemplate(Context ctx, List templates, List templateIds) throws Exception {
        Connection conn = null;
        PreparedStatement pst = null;
        String sql = "DELETE T_BG_BgTemplate WHERE FID=?";
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            for (int i = 0; i < templateIds.size(); ++i) {
                pst.setObject(1, templateIds.get(i));
                this.writeLogin(ctx, templateIds.get(i).toString());
                pst.addBatch();
            }
            pst.executeBatch();
            SQLUtils.cleanup((Statement)pst);
            sql = "DELETE T_Bg_BgSchemeNode WHERE FBgTemplateID NOT IN(SELECT FID FROM T_Bg_BgTemplate)";
            pst = conn.prepareStatement(sql);
            pst.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pst, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    private void writeLogin(Context ctx, String templateIds) throws BOSException, SQLException, EASBizException {
        IBgTemplate bgTemplate = BgTemplateFactory.getLocalInstance((Context)ctx);
        BgTemplateInfo templateInfo = null;
        try {
            templateInfo = bgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(templateIds));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        String logName = null;
        if (templateInfo == null) {
            return;
        }
        logName = templateInfo.getNumber() + " " + templateInfo.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"writeLogin", (BOSObjectType)templateInfo.getBOSType(), null, (String)logName, (String)"bgTemplate_remove");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    private void clearTemplateRef(Context ctx, Map unAssignInfoMap) throws BOSException {
        if (unAssignInfoMap == null || unAssignInfoMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        String sql = "DELETE T_Bg_BgSchemeNode WHERE FBgTemplateID = ? AND FBgSchemeID = ?";
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            Object key2 = null;
            String[] temNums = null;
            BgSchemeUnAssignInfo.BgTemplateUnAssignInfo template = null;
            BgSchemeUnAssignInfo scheme = null;
            for (Object key2 : unAssignInfoMap.keySet()) {
                if (!(unAssignInfoMap.get(key2) instanceof BgSchemeUnAssignInfo) || (temNums = (scheme = (BgSchemeUnAssignInfo)unAssignInfoMap.get(key2)).getKeys()) == null || temNums.length <= 0) continue;
                for (int i = 0; i < temNums.length; ++i) {
                    template = scheme.getTemplate(temNums[i]);
                    if (!template.isSelected() || !"refencedByOtherBgScheme".equalsIgnoreCase(template.getState())) continue;
                    pst.setString(1, template.getId());
                    pst.setString(2, scheme.getBgSchemeId());
                    pst.addBatch();
                }
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    private void dropScheme(Context ctx, Map unAssignInfoMap) throws BOSException {
        ArrayList<String> schemeIds;
        ResultSet res;
        PreparedStatement pst;
        Connection conn;
        String sql;
        block8: {
            if (unAssignInfoMap == null || unAssignInfoMap.isEmpty()) {
                return;
            }
            sql = "SELECT FID,FOrgUnitID FROM T_Bg_BgScheme WHERE FID NOT IN(SELECT FBgSchemeID FROM T_Bg_BgSchemeNode)";
            conn = null;
            pst = null;
            res = null;
            schemeIds = new ArrayList<String>();
            String key = null;
            BgSchemeUnAssignInfo scheme = null;
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            res = pst.executeQuery();
            while (res.next()) {
                key = res.getString("FOrgUnitID");
                if (!(unAssignInfoMap.get(key) instanceof BgSchemeUnAssignInfo)) continue;
                scheme = (BgSchemeUnAssignInfo)unAssignInfoMap.get(key);
                if (!res.getString("FID").equals(scheme.getBgSchemeId())) continue;
                scheme.setDeleted(true);
                schemeIds.add(scheme.getBgSchemeId());
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pst);
            if (!schemeIds.isEmpty()) break block8;
            SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
            return;
        }
        try {
            sql = "DELETE T_Bg_BgScheme WHERE FID = ?";
            pst = conn.prepareStatement(sql);
            for (int i = 0; i < schemeIds.size(); ++i) {
                pst.setObject(1, schemeIds.get(i));
                this.writerSchemeLogin(ctx, schemeIds.get(i).toString());
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pst, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
    }

    private void writerSchemeLogin(Context ctx, String schemeID) throws BOSException, EASBizException {
        IBgScheme bgScheme = BgSchemeFactory.getLocalInstance((Context)ctx);
        BgSchemeInfo bgSchemeInfo = bgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeID));
        String logName = null;
        if (bgSchemeInfo == null) {
            return;
        }
        logName = bgSchemeInfo.getNumber() + " " + bgSchemeInfo.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"writerSchemeLogin", (BOSObjectType)bgSchemeInfo.getBOSType(), null, (String)logName, (String)"bgScheme_remove");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    @Override
    protected Map _unAssignByTemplate(Context ctx, Map unAssignInfo) throws BOSException, EASBizException {
        if (unAssignInfo == null || unAssignInfo.isEmpty()) {
            return null;
        }
        Map allDelete = this.processSelect(unAssignInfo);
        if (allDelete.isEmpty()) {
            return null;
        }
        Map subTemp = this.getAllSubTemplates(ctx, allDelete);
        Set canDelete = this.processCanDelete(allDelete, subTemp, null, null, System.currentTimeMillis());
        this.updateSelectState(allDelete, canDelete);
        this.dropTemplate(ctx, unAssignInfo);
        this.clearTemplateRef(ctx, unAssignInfo);
        this.dropScheme(ctx, unAssignInfo);
        return unAssignInfo;
    }

    private void updateSelectState(Map allDelete, Set canDelete) {
        for (BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp : allDelete.values()) {
            if (canDelete.contains(temp.getId()) || !StringUtils.isEmpty((String)temp.getState())) continue;
            temp.setState("refencedByOtherTemplate");
        }
    }

    private Set processCanDelete(Map allDelete, Map subTemp, Set canDelete, Set cannotDelete, long startTime) throws EASBizException {
        if (System.currentTimeMillis() - startTime > 1800000L) {
            throw new BgNTemplateException(BgNTemplateException.LONG_TIME);
        }
        if (allDelete == null || subTemp == null) {
            return null;
        }
        boolean isNeedNext = false;
        if (canDelete == null) {
            canDelete = new HashSet<String>();
        }
        if (cannotDelete == null) {
            cannotDelete = new HashSet();
        }
        BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp2 = null;
        for (BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp2 : allDelete.values()) {
            if (canDelete.contains(temp2.getId()) || cannotDelete.contains(temp2.getId())) continue;
            if (StringUtils.isEmpty((String)temp2.getState())) {
                if (subTemp.get(temp2.getId()) instanceof List) {
                    List sub = (List)subTemp.get(temp2.getId());
                    sub.removeAll(canDelete);
                    if (sub.isEmpty()) {
                        canDelete.add(temp2.getId());
                        continue;
                    }
                    for (int i = 0; i < sub.size(); ++i) {
                        if (cannotDelete.contains(sub.get(i))) continue;
                        if (allDelete.containsKey(sub.get(i))) {
                            isNeedNext = true;
                            continue;
                        }
                        cannotDelete.add(sub.get(i));
                    }
                    continue;
                }
                canDelete.add(temp2.getId());
                continue;
            }
            cannotDelete.add(temp2.getId());
        }
        if (isNeedNext) {
            this.processCanDelete(allDelete, subTemp, canDelete, cannotDelete, startTime);
        }
        return canDelete;
    }

    private Map getAllSubTemplates(Context ctx, Map allDelete) throws SQLDataException, BOSException {
        HashMap subTemp = new HashMap();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet res = null;
        String parentId = null;
        try {
            StringBuffer sql = new StringBuffer("SELECT FParentID,FID FROM T_Bg_BgTemplate WHERE FParentID IN(");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            Object[] params = allDelete.keySet().toArray();
            int count = (params.length - 1) / 200 + 1;
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql.toString());
            for (int i = 0; i < count; ++i) {
                BgNSQLHelper.setParam4Batch(pst, i, 200, params);
                res = pst.executeQuery();
                while (res.next()) {
                    parentId = res.getString("FParentID");
                    List<String> sub = null;
                    if (subTemp.containsKey(parentId)) {
                        sub = (List)subTemp.get(parentId);
                    } else {
                        sub = new ArrayList();
                        subTemp.put(parentId, sub);
                    }
                    sub.add(res.getString("FID"));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"Process SubTemplate:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pst, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pst, (Connection)conn);
        return subTemp;
    }

    private Map processSelect(Map unAssignInfo) {
        Object key2 = null;
        BgSchemeUnAssignInfo scheme = null;
        BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp = null;
        String[] temNums = null;
        HashMap<String, BgSchemeUnAssignInfo.BgTemplateUnAssignInfo> allDelete = new HashMap<String, BgSchemeUnAssignInfo.BgTemplateUnAssignInfo>();
        for (Object key2 : unAssignInfo.keySet()) {
            if (!(unAssignInfo.get(key2) instanceof BgSchemeUnAssignInfo) || (temNums = (scheme = (BgSchemeUnAssignInfo)unAssignInfo.get(key2)).getKeys()) == null || temNums.length <= 0) continue;
            for (int i = 0; i < temNums.length; ++i) {
                temp = scheme.getTemplate(temNums[i]);
                if (StringUtils.isEmpty((String)temp.getId())) {
                    temp.setState("templateUnAssigned");
                    continue;
                }
                if (!temp.isSelected() || StringUtils.isEmpty((String)temp.getId())) continue;
                allDelete.put(temp.getId(), temp);
            }
        }
        return allDelete;
    }

    @Override
    protected Map _checkCanAllUnAssign(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        Map resMap = this.getUnAssignInfo(ctx, bgSchemeId, true);
        BgSchemeUnAssignInfo info = null;
        String[] tNums = null;
        if (((Boolean)resMap.get("CAN_UNASSIGN_ALL")).booleanValue()) {
            Object key2 = null;
            for (Object key2 : resMap.keySet()) {
                if (!(resMap.get(key2) instanceof BgSchemeUnAssignInfo) || (tNums = (info = (BgSchemeUnAssignInfo)resMap.get(key2)).getKeys()) == null || tNums.length <= 0) continue;
                for (int j = 0; j < tNums.length; ++j) {
                    info.getTemplate(tNums[j]).setSelected(true);
                }
            }
        }
        return resMap;
    }

    private Map getUnAssignInfo(Context ctx, String bgSchemeId, boolean isCheckAllUnAssign) throws BOSException {
        HashMap<String, Boolean> resMap = new HashMap<String, Boolean>();
        resMap.put("CAN_UNASSIGN_ALL", Boolean.TRUE);
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pst = this.getPreStatement4BatchQuerySubScheme(conn, ctx);
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(bgSchemeId);
            this.getAllSubScheme(pst, idList, resMap, isCheckAllUnAssign);
            SQLUtils.cleanup((Statement)pst);
            this.getAllSubTemplates(ctx, resMap, conn, isCheckAllUnAssign);
            String sql = "SELECT template.FID templateId,template.FNumber templateNumber,template.FName templateName,template.FCreateTime templateCTime,cUser.FName_" + ctx.getLocale() + " userName FROM T_Bg_BgTemplate template LEFT JOIN T_Bg_BgSchemeNode node ON node.FBgTemplateId=template.FID LEFT JOIN T_Pm_User cUser ON cUser.FID = template.FCreatorId WHERE node.FBgSchemeId=? ORDER BY template.FNumber";
            pst = conn.prepareStatement(sql);
            pst.setString(1, bgSchemeId);
            BgTemplateCollection temCol = new BgTemplateCollection();
            BgTemplateInfo temp = null;
            res = pst.executeQuery();
            while (res.next()) {
                temp = new BgTemplateInfo();
                temp.setId(BOSUuid.read((String)res.getString("templateId")));
                temp.setNumber(res.getString("templateNumber"));
                temp.setName(res.getString("templateName"));
                temp.setCreateTime(res.getTimestamp("templateCTime"));
                temp.setCreator(new UserInfo());
                temp.getCreator().setName(res.getString("userName"));
                temCol.add(temp);
            }
            resMap.put("UA_ALL_SUB_TEMPLATE", (Boolean)temCol);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"_checkCanAllUnAssign:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllSubTemplates(Context ctx, Map resMap, Connection conn, boolean isCheckAllUnAssign) throws SQLException {
        if (resMap == null || resMap.isEmpty()) {
            return;
        }
        HashSet<String> bgSchemeIds = new HashSet<String>();
        BgSchemeUnAssignInfo info = null;
        Object key2 = null;
        for (Object key2 : resMap.keySet()) {
            if (!(resMap.get(key2) instanceof BgSchemeUnAssignInfo) || (info = (BgSchemeUnAssignInfo)resMap.get(key2)) == null || StringUtils.isEmpty((String)info.getBgSchemeId())) continue;
            bgSchemeIds.add(info.getBgSchemeId());
        }
        Object[] params = bgSchemeIds.toArray();
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT template.FID templateId,template.FNumber templateNumber,orgUnit.FID orgUnitId, ").append("state=CASE WHEN (scheme.FIsFormal <> 0) THEN '").append("executed").append("' ").append("WHEN EXISTS(SELECT bgForm.FID FROM T_Bg_BgForm bgForm WHERE bgForm.FBgTemplateID =template.FID AND bgForm.FBgSchemeID = scheme.FID) THEN '").append("refencedByBgFrom").append("' ").append("WHEN  EXISTS(SELECT node1.FID FROM T_Bg_BgSchemeNode node1 WHERE node1.FBgTemplateID=template.FID AND node1.FBgSchemeID <> scheme.FID) THEN '").append("refencedByOtherBgScheme").append("' ").append("ELSE '' END ").append("FROM T_Bg_BgTemplate template LEFT JOIN T_Bg_BgSchemeNode node ON template.FID = node.FBgTemplateID ").append("LEFT JOIN T_Bg_BgScheme scheme ON node.FBgSchemeID = scheme.FID ").append("LEFT JOIN T_Org_BaseUnit orgUnit ON orgUnit.FID = scheme.FOrgUnitID ").append("WHERE scheme.FID IN(");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        int batchCount = (params.length - 1) / 200 + 1;
        PreparedStatement pst = null;
        ResultSet res = null;
        String orgId = null;
        String tempNumber = null;
        String state = null;
        try {
            pst = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch(pst, i, 200, params);
                res = pst.executeQuery();
                while (res.next()) {
                    orgId = res.getString("orgUnitId");
                    tempNumber = res.getString("templateNumber");
                    state = res.getString("state");
                    info = (BgSchemeUnAssignInfo)resMap.get(orgId);
                    if (info != null && info.getTemplate(tempNumber) == null) {
                        info.addTemplate(tempNumber, res.getString("templateId"), state);
                    }
                    if (!isCheckAllUnAssign || StringUtils.isEmpty((String)state) || "refencedByOtherBgScheme".equals(state)) continue;
                    resMap.put("CAN_UNASSIGN_ALL", Boolean.FALSE);
                }
            }
        }
        finally {
            SQLUtils.cleanup(res, (Statement)pst);
        }
    }

    private PreparedStatement getPreStatement4BatchQuerySubScheme(Connection conn, Context ctx) throws SQLException {
        StringBuffer sql = new StringBuffer(" select bgScheme.FID bgSchemeId,bgScheme.FIsFormal isExecuted,bgScheme.FNumber bgSchemeNumber,").append(" orgUnit.FID orgUnitId,orgUnit.FLongNumber orgUnitLongNumber,orgUnit.FName_").append(ctx.getLocale()).append(" orgUnitName FROM T_Bg_BgScheme bgScheme LEFT JOIN T_Org_BaseUnit orgUnit ON bgScheme.FOrgUnitID = orgUnit.FID ").append("WHERE FParentSchemeID IN(");
        BgNSQLHelper.addPlaceHolder(sql, 200);
        sql.append(")");
        return conn.prepareStatement(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllSubScheme(PreparedStatement pst, List bgSchemeIds, Map res, boolean isCheckAllUnAssign) throws SQLException {
        if (bgSchemeIds == null || bgSchemeIds.isEmpty()) {
            return;
        }
        Object[] params = bgSchemeIds.toArray();
        int batCount = (params.length - 1) / 200 + 1;
        ResultSet resSet = null;
        String subId = null;
        boolean isExecuted = false;
        String orgId = null;
        try {
            ArrayList<String> subIds = new ArrayList<String>();
            for (int i = 0; i < batCount; ++i) {
                BgNSQLHelper.setParam4Batch(pst, i, 200, params);
                resSet = pst.executeQuery();
                while (resSet.next()) {
                    subId = resSet.getString("bgSchemeId");
                    orgId = resSet.getString("orgUnitId");
                    subIds.add(subId);
                    boolean bl = isExecuted = resSet.getInt("isExecuted") != 0;
                    if (isExecuted && isCheckAllUnAssign) {
                        res.put("CAN_UNASSIGN_ALL", Boolean.FALSE);
                    }
                    if (res.containsKey(orgId)) continue;
                    res.put(orgId, new BgSchemeUnAssignInfo(orgId, resSet.getString("orgUnitLongNumber"), resSet.getString("orgUnitName"), subId, resSet.getString("bgSchemeNumber"), isExecuted));
                }
                SQLUtils.cleanup((ResultSet)resSet);
            }
            this.getAllSubScheme(pst, subIds, res, isCheckAllUnAssign);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(resSet);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)resSet);
    }

    @Override
    protected Map _getUnAssignInfo(Context ctx, String bgSchemeInfo) throws BOSException {
        return this.getUnAssignInfo(ctx, bgSchemeInfo, false);
    }
}

