/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.nbudget.BudgetData;
import com.kingdee.eas.ma.nbudget.MultiDeminsion.Node;
import com.kingdee.eas.ma.nbudget.MultiDeminsion.Tree;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgTreeData {
    private static final String noFindStr = "#";
    private static final int BATCH_SIZE = 200;
    private static final String BOSTYPE_JobGrade = "67F02330";
    private static final String BOSTYPE_JobLevel = "6830FEDD";
    private static final String BOSTYPE_HRDiploma = "9B3E5DD3";
    private static final String BOSTYPE_BDEmployeeType = "A29E85B3";
    private static final String BOSTYPE_EmployeeFenLei = "5C14FC3A";
    private static final String BOSTYPE_BDTechnicalPost = "8AD80852";
    public static final String BOSTYPE_AdminOrgUnit = "CCE7AED4";
    public static final String BOSTYPE_Job = "75702498";
    public static final String BOSTYPE_Postion = "74AE612E";
    private static String SPLIT_STR = "_";
    private static Logger logger = Logger.getLogger((String)BgTreeData.class.getName());

    private String ListToStringWithQuote(List ListInfo) {
        StringBuffer sql2 = new StringBuffer();
        sql2.delete(0, sql2.capacity());
        String sReturn = "";
        for (int i = 0; i < ListInfo.size(); ++i) {
            sql2.append("'");
            sql2.append(ListInfo.get(i));
            sql2.append("'");
            sql2.append(",");
        }
        sReturn = sql2.toString();
        if (sReturn.length() > 0) {
            sReturn = sReturn.substring(0, sReturn.length() - 1);
        }
        return sReturn;
    }

    public List getBudgetData(Context ctx, List orgIdList, String schemeId, List periodIdList, List salaryList, String salaryType, List mainDimList, String mainDimType, String currencyId, String elementId, String bgFormId) throws EASBizException {
        HashMap<String, BudgetData> tmpMap;
        ResultSet rs;
        PreparedStatement psmt;
        Connection conn;
        Map mainDimMappingMap;
        Map salaryMappingMap;
        ArrayList<Object> dataList;
        block33: {
            int i;
            dataList = new ArrayList<Object>();
            if (orgIdList == null || orgIdList.isEmpty() || periodIdList == null || periodIdList.isEmpty() || salaryList == null || salaryList.isEmpty()) {
                return dataList;
            }
            if (StringUtils.isEmpty((String)schemeId) || StringUtils.isEmpty((String)salaryType) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)elementId) || StringUtils.isEmpty((String)bgFormId)) {
                return dataList;
            }
            boolean isOnlyQuerySalaryBgData = false;
            boolean needAllMainDim = false;
            if (StringUtils.isEmpty((String)mainDimType)) {
                isOnlyQuerySalaryBgData = true;
            } else if (mainDimList == null || mainDimList.isEmpty()) {
                needAllMainDim = true;
            }
            HashMap fnMap = new HashMap();
            salaryMappingMap = this.getBgItemNumber(ctx, salaryList, salaryType, fnMap, true);
            if (salaryMappingMap == null || salaryMappingMap.isEmpty()) {
                return dataList;
            }
            List itemCombineList = null;
            mainDimMappingMap = null;
            if (isOnlyQuerySalaryBgData) {
                itemCombineList = new ArrayList();
                itemCombineList.addAll(salaryMappingMap.keySet());
            } else {
                mainDimMappingMap = this.getBgItemNumber(ctx, mainDimList, mainDimType, fnMap, false);
                if (mainDimMappingMap == null || mainDimMappingMap.isEmpty()) {
                    return dataList;
                }
                itemCombineList = this.getItemCombine(ctx, salaryMappingMap, mainDimMappingMap, fnMap);
            }
            StringBuffer queryData = new StringBuffer("select data.FOrgUnitId,data.FBgPeriodid,combine.FKey,data.FBgValue from t_bg_bgdata data left join T_Bg_Bgitemcombination combine  on data.FBgItemCombinId = combine.FID  left join T_BG_BgForm form on data.FBgFormId = form.FID  where data.FOrgUnitId = ? and data.FCurrencyId = ? and data.FBgElementId = ?  and data.FBgFormId = ?  and data.FBgSchemeId in (\tSELECT fid FROM t_bg_bgscheme WHERE frootid = \t(SELECT top 1 frootid FROM t_bg_bgscheme WHERE fid =? ) )and data.FBgPeriodId In ( ");
            int periodSize = periodIdList.size();
            for (i = 1; i < periodSize; ++i) {
                queryData.append("?,");
            }
            queryData.append("? )");
            queryData.append(" and combine.FKey in (");
            for (i = 1; i < 200; ++i) {
                queryData.append("?,");
            }
            queryData.append("? )");
            conn = null;
            psmt = null;
            rs = null;
            String combineNum = null;
            String[] tempStrs = null;
            BudgetData bgData = null;
            BudgetData bgData1 = null;
            tmpMap = new HashMap<String, BudgetData>();
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                psmt = conn.prepareStatement(queryData.toString());
                int size = itemCombineList.size();
                int count = (size - 1) / 200 + 1;
                int listSize = orgIdList.size();
                for (int i2 = 0; i2 < listSize; ++i2) {
                    int index = 0;
                    int pos = 0;
                    for (index = 0; index < count; ++index) {
                        int x;
                        psmt.setString(1, BOSUuid.read((String)((String)orgIdList.get(i2))).toString());
                        psmt.setString(2, BOSUuid.read((String)currencyId).toString());
                        psmt.setString(3, BOSUuid.read((String)elementId).toString());
                        psmt.setString(4, BOSUuid.read((String)bgFormId).toString());
                        psmt.setString(5, BOSUuid.read((String)schemeId).toString());
                        for (x = 0; x < periodSize; ++x) {
                            psmt.setString(x + 6, BOSUuid.read((String)((String)periodIdList.get(x))).toString());
                        }
                        x = 1;
                        while (x <= 200) {
                            if (pos < size) {
                                psmt.setString(x + 5 + periodSize, (String)itemCombineList.get(pos));
                            } else {
                                psmt.setString(x + 5 + periodSize, noFindStr);
                            }
                            ++x;
                            ++pos;
                        }
                        rs = psmt.executeQuery();
                        while (rs.next()) {
                            bgData = new BudgetData();
                            bgData.setOrgUnitId(rs.getString("FOrgUnitId"));
                            bgData.setPeriodId(rs.getString("FBgPeriodid"));
                            combineNum = rs.getString("FKey");
                            if (combineNum.indexOf(SPLIT_STR) > 0) {
                                tempStrs = combineNum.split(SPLIT_STR);
                                for (x = 0; x < tempStrs.length; ++x) {
                                    if (salaryList != null && salaryList.contains(tempStrs[x]) && StringUtils.isEmpty((String)bgData.getSarlaryNum())) {
                                        bgData.setSarlaryNum(tempStrs[x]);
                                        continue;
                                    }
                                    if (mainDimList == null || !mainDimList.contains(tempStrs[x]) || !StringUtils.isEmpty((String)bgData.getMainDimNum())) continue;
                                    bgData.setMainDimNum(tempStrs[x]);
                                }
                            } else {
                                bgData.setSarlaryNum(combineNum);
                                bgData.setMainDimNum("");
                            }
                            bgData.setBgValue(rs.getBigDecimal("FBgValue"));
                            if (needAllMainDim) {
                                if (tmpMap.containsKey(bgData.getKey())) {
                                    bgData1 = (BudgetData)tmpMap.get(bgData.getKey());
                                    if (bgData1.getDetailMap() == null) {
                                        bgData1.setDetailMap(new HashMap());
                                    }
                                    bgData1.getDetailMap().put(bgData.getMainDimNum(), bgData.getBgValue());
                                    bgData1.setBgValue(bgData1.getBgValue().add(bgData.getBgValue()));
                                    continue;
                                }
                                bgData.setDetailMap(new HashMap());
                                bgData.getDetailMap().put(bgData.getMainDimNum(), bgData.getBgValue());
                                tmpMap.put(bgData.getKey(), bgData);
                                continue;
                            }
                            dataList.add(bgData);
                        }
                        SQLUtils.cleanup((ResultSet)rs);
                    }
                }
                if (!needAllMainDim) break block33;
                dataList.addAll(tmpMap.values());
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, psmt, (Connection)conn);
                    if (salaryMappingMap != null) {
                        salaryMappingMap.clear();
                    }
                    if (mainDimMappingMap != null) {
                        mainDimMappingMap.clear();
                    }
                    tmpMap.clear();
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rs, (Statement)psmt, (Connection)conn);
        if (salaryMappingMap != null) {
            salaryMappingMap.clear();
        }
        if (mainDimMappingMap != null) {
            mainDimMappingMap.clear();
        }
        tmpMap.clear();
        return dataList;
    }

    public List getAllBudgetData(Context ctx, List orgIdList, String schemeId, List periodIdList, String salaryNumber, String salaryType, String currencyId, String elementId, String bgFormId) throws EASBizException {
        int i;
        ArrayList<BudgetData> dataList = new ArrayList<BudgetData>();
        if (orgIdList == null || orgIdList.isEmpty() || periodIdList == null || periodIdList.isEmpty() || StringUtils.isEmpty((String)salaryNumber)) {
            return dataList;
        }
        if (StringUtils.isEmpty((String)schemeId) || StringUtils.isEmpty((String)salaryType) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)elementId) || StringUtils.isEmpty((String)bgFormId)) {
            return dataList;
        }
        HashMap fnMap = new HashMap();
        ArrayList<String> salaryList = new ArrayList<String>();
        salaryList.add(salaryNumber);
        Map salaryMappingMap = this.getBgItemNumber(ctx, salaryList, salaryType, fnMap, true);
        if (salaryMappingMap == null || salaryMappingMap.isEmpty()) {
            return dataList;
        }
        List itemCombineList = null;
        itemCombineList = this.getAllBgItemCombine(ctx, salaryMappingMap, fnMap);
        StringBuffer queryData = new StringBuffer("select data.FOrgUnitId,data.FBgPeriodid,combine.FKey,data.FBgValue from t_bg_bgdata data left join T_Bg_Bgitemcombination combine  on data.FBgItemCombinId = combine.FID  left join T_BG_BgForm form on data.FBgFormId = form.FID  where data.FOrgUnitId = ? and data.FCurrencyId = ? and data.FBgElementId = ?  and data.FBgFormId = ?  and data.FBgSchemeId in (\tSELECT fid FROM t_bg_bgscheme WHERE frootid = \t(SELECT top 1 frootid FROM t_bg_bgscheme WHERE fid =? ) )and data.FBgPeriodId In ( ");
        int periodSize = periodIdList.size();
        for (i = 1; i < periodSize; ++i) {
            queryData.append("?,");
        }
        queryData.append("? )");
        queryData.append(" and combine.FKey in (");
        for (i = 1; i < 200; ++i) {
            queryData.append("?,");
        }
        queryData.append("? )");
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        BudgetData bgData = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psmt = conn.prepareStatement(queryData.toString());
            int size = itemCombineList.size();
            int count = (size - 1) / 200 + 1;
            int listSize = orgIdList.size();
            for (int i2 = 0; i2 < listSize; ++i2) {
                int index = 0;
                int pos = 0;
                for (index = 0; index < count; ++index) {
                    int x;
                    psmt.setString(1, BOSUuid.read((String)((String)orgIdList.get(i2))).toString());
                    psmt.setString(2, BOSUuid.read((String)currencyId).toString());
                    psmt.setString(3, BOSUuid.read((String)elementId).toString());
                    psmt.setString(4, BOSUuid.read((String)bgFormId).toString());
                    psmt.setString(5, BOSUuid.read((String)schemeId).toString());
                    for (x = 0; x < periodSize; ++x) {
                        psmt.setString(x + 6, BOSUuid.read((String)((String)periodIdList.get(x))).toString());
                    }
                    x = 1;
                    while (x <= 200) {
                        if (pos < size) {
                            psmt.setString(x + 5 + periodSize, (String)itemCombineList.get(pos));
                        } else {
                            psmt.setString(x + 5 + periodSize, noFindStr);
                        }
                        ++x;
                        ++pos;
                    }
                    rs = psmt.executeQuery();
                    while (rs.next()) {
                        bgData = new BudgetData();
                        bgData.setOrgUnitId(rs.getString("FOrgUnitId"));
                        bgData.setPeriodId(rs.getString("FBgPeriodid"));
                        bgData.setSarlaryNum(salaryNumber);
                        bgData.setMainDimNum(null);
                        bgData.setDetailMap(null);
                        bgData.setBgValue(rs.getBigDecimal("FBgValue"));
                        dataList.add(bgData);
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)psmt, (Connection)conn);
        return dataList;
    }

    public List getHasBudgetSalaryNumbers(Context ctx, List orgIdList, String schemeId, String bgFormId, String bosType) throws EASBizException {
        ArrayList<String> numberList = new ArrayList<String>();
        if (orgIdList == null || orgIdList.isEmpty()) {
            return numberList;
        }
        if (StringUtils.isEmpty((String)schemeId) || StringUtils.isEmpty((String)bgFormId) || StringUtils.isEmpty((String)bosType)) {
            return numberList;
        }
        StringBuffer queryKey = new StringBuffer(" select  combine.FKey as fnumber from t_bg_bgdata bgdata  left join t_bg_bgitemcombination combine on  bgdata.FBGITEMCOMBINID = combine.FID where  bgdata.FBgTemplateId in  (select fid from t_bg_bgtemplate where frootid in \t(\tselect frootId from t_bg_bgtemplate where fid =\t\t( select top 1 FBgTemplateId from t_bg_bgform where fid = ?)\t) ) and bgdata.FBgSchemeId = ?  ");
        queryKey.append(" and bgdata.FOrgUnitId in (");
        for (int i = 1; i < 200; ++i) {
            queryKey.append("?,");
        }
        queryKey.append("? )");
        StringBuffer queryItem = new StringBuffer(" select distinct FItemNumber from t_bg_bgitem where  FBosType = ?  and FNumber in (");
        for (int i = 1; i < 200; ++i) {
            queryItem.append("?,");
        }
        queryItem.append("? )");
        ArrayList tmpNumList = new ArrayList();
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        HashSet<String> numberSet = new HashSet<String>();
        String[] tmps = null;
        String tmpStr = null;
        try {
            int x;
            conn = EJBFactory.getConnection((Context)ctx);
            psmt = conn.prepareStatement(queryKey.toString());
            int size = orgIdList.size();
            int count = (size - 1) / 200 + 1;
            int index = 0;
            int pos = 0;
            for (index = 0; index < count; ++index) {
                psmt.setString(1, bgFormId);
                psmt.setString(2, schemeId);
                x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        psmt.setString(x + 2, (String)orgIdList.get(pos));
                    } else {
                        psmt.setString(x + 2, noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rs = psmt.executeQuery();
                while (rs.next()) {
                    tmpStr = rs.getString("fnumber");
                    if (tmpStr != null) {
                        tmps = tmpStr.split(SPLIT_STR);
                    }
                    if (tmps == null) continue;
                    int length = tmps.length;
                    for (int i = 0; i < length; ++i) {
                        numberSet.add(tmps[i]);
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            SQLUtils.cleanup((Statement)psmt);
            tmpNumList.addAll(numberSet);
            size = tmpNumList.size();
            count = (size - 1) / 200 + 1;
            index = 0;
            pos = 0;
            psmt = conn.prepareStatement(queryItem.toString());
            for (index = 0; index < count; ++index) {
                psmt.setString(1, bosType);
                x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        psmt.setString(x + 1, (String)tmpNumList.get(pos));
                    } else {
                        psmt.setString(x + 1, noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rs = psmt.executeQuery();
                while (rs.next()) {
                    numberList.add(rs.getString("FItemNumber"));
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psmt, (Connection)conn);
                tmpNumList.clear();
                numberSet.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psmt, (Connection)conn);
        tmpNumList.clear();
        numberSet.clear();
        return numberList;
    }

    private List getItemCombine(Context ctx, Map salaryMappingMap, Map mainDimMappingMap, Map fnMap) throws EASBizException {
        if (salaryMappingMap == null || salaryMappingMap.isEmpty() || mainDimMappingMap == null || mainDimMappingMap.isEmpty() || fnMap == null || fnMap.isEmpty()) {
            return null;
        }
        String sarlaryNumber2 = null;
        String mainDimNumber2 = null;
        String combineNumber = null;
        String saFn = null;
        String mainFn = null;
        ArrayList<String> itemCombineList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        for (String sarlaryNumber2 : salaryMappingMap.keySet()) {
            for (String mainDimNumber2 : mainDimMappingMap.keySet()) {
                saFn = (String)fnMap.get(sarlaryNumber2);
                mainFn = (String)fnMap.get(mainDimNumber2);
                if (StringUtils.isEmpty((String)sarlaryNumber2) || StringUtils.isEmpty((String)mainDimNumber2) || StringUtils.isEmpty((String)saFn) || StringUtils.isEmpty((String)mainFn)) continue;
                sql.append(" (");
                sql.append(saFn).append(" = '").append(sarlaryNumber2).append("' ");
                sql.append(" and ").append(mainFn).append(" = '").append(mainDimNumber2).append("' ");
                sql.append(" )");
                sql.append(" or");
            }
        }
        if (sql.length() > 0) {
            sql.insert(0, "select FKey from T_Bg_Bgitemcombination where ");
            sql.delete(sql.length() - 2, sql.length());
            Connection conn = null;
            PreparedStatement psmt = null;
            ResultSet rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                psmt = conn.prepareStatement(sql.toString());
                rs = psmt.executeQuery();
                while (rs.next()) {
                    combineNumber = rs.getString(1);
                    if (itemCombineList.contains(combineNumber)) continue;
                    itemCombineList.add(combineNumber);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, psmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)psmt, (Connection)conn);
        }
        return itemCombineList;
    }

    private List getAllBgItemCombine(Context ctx, Map salaryMappingMap, Map fnMap) throws EASBizException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (salaryMappingMap == null || salaryMappingMap.isEmpty()) {
            return returnList;
        }
        String fn2 = null;
        String number2 = null;
        HashMap<String, StringBuffer> fnMap2 = new HashMap<String, StringBuffer>();
        StringBuffer sb = null;
        for (String number2 : salaryMappingMap.keySet()) {
            fn2 = (String)fnMap.get(number2);
            if (fnMap2.get(fn2) != null && fnMap2.get(fn2) instanceof StringBuffer) {
                sb = (StringBuffer)fnMap2.get(fn2);
                sb.append("'").append(number2).append("',");
                continue;
            }
            sb = new StringBuffer();
            sb.append("'").append(number2).append("',");
            fnMap2.put(fn2, sb);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FKey from T_Bg_Bgitemcombination ");
        int index = 0;
        for (String fn2 : fnMap2.keySet()) {
            sb = (StringBuffer)fnMap2.get(fn2);
            if (StringUtils.isEmpty((String)fn2) || sb == null || StringUtils.isEmpty((String)sb.toString())) continue;
            if (index == 0) {
                sql.append(" where ").append(fn2).append(" in (").append(sb.toString().substring(0, sb.length() - 1)).append(") ");
            } else {
                sql.append(" or ").append(fn2).append(" in (").append(sb.toString().substring(0, sb.length() - 1)).append(") ");
            }
            ++index;
        }
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psmt = conn.prepareStatement(sql.toString());
            rs = psmt.executeQuery();
            while (rs.next()) {
                number2 = rs.getString(1);
                if (returnList.contains(number2)) continue;
                returnList.add(number2);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psmt, (Connection)conn);
        return returnList;
    }

    private Map getBgItemNumber(Context ctx, List itemNumberList, String bosType, Map fnMap, boolean isDbNumber) throws EASBizException {
        if (StringUtils.isEmpty((String)bosType) || fnMap == null) {
            return null;
        }
        StringBuffer queryNumberSql = new StringBuffer(" select distinct item.FNumber as number,item.FItemNumber as dbNumber ,itemGroup.FRefField as fn  from t_bg_bgitem item left join t_bg_bgitemgroup itemGroup  on itemGroup.fid = item.fbgitemgroupid  where item.FBOSType = ? ");
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        String number = null;
        String dbNumber = null;
        String fn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (itemNumberList != null && !itemNumberList.isEmpty()) {
                if (isDbNumber) {
                    queryNumberSql.append(" and item.FItemNumber in ( ");
                } else {
                    queryNumberSql.append(" and item.FNumber in ( ");
                }
                int index = 0;
                int size = itemNumberList.size();
                int count = (size - 1) / 200 + 1;
                int pos = 0;
                for (index = 1; index < 200; ++index) {
                    queryNumberSql.append("?,");
                }
                queryNumberSql.append("? ) ");
                psmt = conn.prepareStatement(queryNumberSql.toString());
                for (index = 0; index < count; ++index) {
                    psmt.setString(1, bosType);
                    int x = 1;
                    while (x <= 200) {
                        if (pos < size) {
                            psmt.setString(x + 1, (String)itemNumberList.get(pos));
                        } else {
                            psmt.setString(x + 1, noFindStr);
                        }
                        ++x;
                        ++pos;
                    }
                    rs = psmt.executeQuery();
                    while (rs.next()) {
                        number = rs.getString("number");
                        dbNumber = rs.getString("dbNumber");
                        fn = rs.getString("fn");
                        fnMap.put(number, fn);
                        mappingMap.put(number, dbNumber);
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
            } else {
                psmt = conn.prepareStatement(queryNumberSql.toString());
                psmt.setString(1, bosType);
                rs = psmt.executeQuery();
                while (rs.next()) {
                    number = rs.getString("number");
                    dbNumber = rs.getString("dbNumber");
                    fn = rs.getString("fn");
                    fnMap.put(number, fn);
                    mappingMap.put(number, dbNumber);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psmt, (Connection)conn);
        return mappingMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getMainDimTypes(Context ctx, List orgIdList, String schemeId, String bgFormId) throws EASBizException {
        ArrayList<String> bosTypeList = new ArrayList<String>();
        if (orgIdList == null) return bosTypeList;
        if (orgIdList.isEmpty()) return bosTypeList;
        if (StringUtils.isEmpty((String)schemeId)) return bosTypeList;
        if (StringUtils.isEmpty((String)bgFormId)) {
            return bosTypeList;
        }
        StringBuffer queryItemNumber = new StringBuffer("select combine.FKey from t_bg_bgdata data left join T_Bg_Bgitemcombination combine  on data.FBgItemCombinId = combine.FID  left join T_BG_BgForm form on data.FBgFormId = form.FID  where data.FBgFormId = ?  and data.FBgSchemeId in (\tSELECT fid FROM t_bg_bgscheme WHERE frootid = \t(SELECT top 1 frootid FROM t_bg_bgscheme WHERE fid =? ) ) and data.FOrgUnitId in (");
        for (int i = 1; i < 200; ++i) {
            queryItemNumber.append(" ?, ");
        }
        queryItemNumber.append(" ? ) ");
        StringBuffer queryMainDimTypes = new StringBuffer("select distinct FBOSType from t_bg_bgitem where FBosType in ('67F02330','A29E85B3','8AD80852','9B3E5DD3','6830FEDD','CCE7AED4','75702498','74AE612E','5C14FC3A' )  and FNumber in (");
        for (int i = 1; i < 200; ++i) {
            queryMainDimTypes.append(" ?, ");
        }
        queryMainDimTypes.append("? ) ");
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        String combineNum = null;
        HashSet<String> numberSet = new HashSet<String>();
        ArrayList<String> numberList = null;
        String[] tmpStrs = null;
        try {
            int x;
            conn = EJBFactory.getConnection((Context)ctx);
            int index2332 = 0;
            int size = orgIdList.size();
            int count = (size - 1) / 200 + 1;
            int pos = 0;
            psmt = conn.prepareStatement(queryItemNumber.toString());
            for (index2332 = 0; index2332 < count; ++index2332) {
                psmt.setString(1, bgFormId);
                psmt.setString(2, schemeId);
                for (x = 1; x <= 200; ++x, ++pos) {
                    if (pos < size) {
                        psmt.setString(x + 2, (String)orgIdList.get(pos));
                        continue;
                    }
                    psmt.setString(x + 2, noFindStr);
                }
                rs = psmt.executeQuery();
                while (rs.next()) {
                    combineNum = rs.getString("FKey");
                    if (StringUtils.isEmpty((String)combineNum)) continue;
                    tmpStrs = combineNum.split(SPLIT_STR);
                    int length = tmpStrs.length;
                    for (int i = 0; i < length; ++i) {
                        numberSet.add(tmpStrs[i]);
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            SQLUtils.cleanup(rs, (Statement)psmt);
            numberList = new ArrayList<String>();
            numberList.addAll(numberSet);
            index2332 = 0;
            size = numberList.size();
            count = (size - 1) / 200 + 1;
            pos = 0;
            psmt = conn.prepareStatement(queryMainDimTypes.toString());
            for (index2332 = 0; index2332 < count; ++index2332) {
                for (x = 1; x <= 200; ++x, ++pos) {
                    if (pos < size) {
                        psmt.setString(x, (String)numberList.get(pos));
                        continue;
                    }
                    psmt.setString(x, noFindStr);
                }
                rs = psmt.executeQuery();
                while (rs.next()) {
                    bosTypeList.add(rs.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psmt, (Connection)conn);
                try {
                    if (numberList != null) {
                        numberList.clear();
                    }
                    numberSet.clear();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psmt, (Connection)conn);
        try {
            if (numberList != null) {
                numberList.clear();
            }
            numberSet.clear();
            return bosTypeList;
        }
        catch (Exception index2332) {
            return bosTypeList;
        }
    }

    public ResultSet getDeminsionInfo(Context ctx, List orgList, String schemaID, List period, List itemNumber, List maindDimension, String currencyID, String element) throws EASBizException {
        ArrayList<String> conbineNumList;
        String sTempSql;
        String sPeriond;
        String sOrg;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        StringBuffer sql2;
        StringBuffer sql;
        block8: {
            sql = new StringBuffer();
            sql2 = new StringBuffer();
            conn = null;
            pstmt = null;
            rst = null;
            ResultSet rstItem = null;
            String sFID = null;
            sOrg = null;
            sPeriond = null;
            sTempSql = "";
            ArrayList numberList = new ArrayList();
            numberList.addAll(itemNumber);
            numberList.addAll(maindDimension);
            sOrg = this.ListToStringWithQuote(orgList);
            sPeriond = this.ListToStringWithQuote(period);
            sFID = this.ListToStringWithQuote(numberList);
            sql.append("SELECT DISTINCT FNumber,FRefField FROM  T_BG_BgItem WHERE FNumber IN( ");
            sql.append(sFID);
            sql.append(")");
            HashMap<String, String> tempMap = new HashMap<String, String>();
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rstItem = pstmt.executeQuery();
            boolean hasData = false;
            while (rstItem.next()) {
                hasData = true;
                tempMap.put(rstItem.getString(1), rstItem.getString(2).replaceAll("F", ""));
            }
            String number1 = null;
            String number2 = null;
            String combineNumber = null;
            conbineNumList = new ArrayList<String>();
            int f1 = 0;
            int f2 = 0;
            int size = itemNumber.size();
            for (int i = 0; i < size; ++i) {
                number1 = (String)itemNumber.get(i);
                f1 = Integer.valueOf((String)tempMap.get(number1));
                int mainDSize = maindDimension.size();
                for (int j = 0; j < mainDSize; ++j) {
                    number2 = (String)maindDimension.get(i);
                    f2 = Integer.valueOf((String)tempMap.get(number2));
                    combineNumber = f1 > f2 ? number2 + SPLIT_STR + number1 : number1 + SPLIT_STR + number2;
                    conbineNumList.add(combineNumber);
                }
            }
            if (hasData) break block8;
            ResultSet i = null;
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            return i;
        }
        try {
            sTempSql = "(SELECT  Fid from T_Bg_Bgitemcombination where Fkey in(";
            String sFkey = this.ListToStringWithQuote(conbineNumList);
            sql2.append(sTempSql);
            sql2.append(sFkey);
            sql2.append(")) bb ");
            sql.delete(0, sql.capacity());
            sql.append(" SELECT bb.FKey,FField,FBgValue, FBizActual ");
            sql.append(" FROM ");
            sql.append(" T_BG_BGData aa INNER JOIN ");
            sql.append(sql2.toString());
            sql.append(" ON aa.FBgItemCombinId=bb.FID ");
            sql.append(" WHERE ");
            sql.append(" FBgPeriodId in( ");
            sql.append(sPeriond);
            sql.append(")");
            sql.append(" AND FBgElementId= ?");
            sql.append(" AND FCurrencyId= ?");
            sql.append(" AND FOrgUnitId in( ");
            sql.append(sOrg);
            sql.append(")");
            sql.append(" AND FBGSCHEMEID IN(");
            sql.append("SELECT fid FROM t_bg_bgscheme WHERE frootid = (SELECT top 1 frootid FROM t_bg_bgscheme WHERE fid =?");
            sql.append("))");
            pstmt = EJBFactory.getConnection((Context)ctx).prepareStatement(sql.toString());
            pstmt.setString(1, element);
            pstmt.setString(2, currencyID);
            pstmt.setString(3, schemaID);
            rst = pstmt.executeQuery();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rst;
    }

    public ResultSet getDeminsionInfo(Context ctx, List orgList, String schemaID, List period, List itemNumber, String currencyID, String element) throws EASBizException {
        String sTempSql;
        String sPeriond;
        String sOrg;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        StringBuffer sql2;
        StringBuffer sql;
        block6: {
            sql = new StringBuffer();
            sql2 = new StringBuffer();
            conn = null;
            pstmt = null;
            rst = null;
            String sFID = null;
            sOrg = null;
            sPeriond = null;
            sTempSql = "";
            sOrg = this.ListToStringWithQuote(orgList);
            sPeriond = this.ListToStringWithQuote(period);
            sFID = this.ListToStringWithQuote(itemNumber);
            sql.append("SELECT DISTINCT FRefField,FNumber FROM  T_BG_BgItem WHERE FNumber IN( ");
            sql.append(sFID);
            sql.append(")");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            sql2.delete(0, sql2.capacity());
            sql2.append("(");
            boolean hasData = false;
            while (rst.next()) {
                hasData = true;
                sql2.append("SELECT FKey,FID ,");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" AS FField");
                sql2.append(" FROM  T_Bg_Bgitemcombination WHERE ");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" IS NOT NULL AND (");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" LIKE '");
                sql2.append(rst.getString("FNumber"));
                sql2.append("%' AND ");
                sql2.append(" FKey LIKE '%");
                sql2.append(rst.getString("FNumber"));
                sql2.append("%') ");
                sql2.append(" UNION ");
            }
            if (hasData) break block6;
            ResultSet resultSet = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return resultSet;
        }
        try {
            sTempSql = sql2.toString();
            sTempSql = sTempSql.substring(0, sTempSql.lastIndexOf("UNION"));
            sTempSql = sTempSql + ") bb ";
            sql.delete(0, sql.capacity());
            sql.append(" SELECT bb.FKey,FField,FBgValue, FBizActual ");
            sql.append(" FROM ");
            sql.append(" T_BG_BGData aa INNER JOIN ");
            sql.append(sTempSql);
            sql.append(" ON aa.FBgItemCombinId=bb.FID ");
            sql.append(" WHERE ");
            sql.append(" FBgPeriodId in( ");
            sql.append(sPeriond);
            sql.append(")");
            sql.append(" AND FBgElementId= ?");
            sql.append(" AND FCurrencyId= ?");
            sql.append(" AND FOrgUnitId in( ");
            sql.append(sOrg);
            sql.append(")");
            sql.append(" AND FBGSCHEMEID IN(");
            sql.append("SELECT fid FROM t_bg_bgscheme WHERE frootid = (SELECT top 1 frootid FROM t_bg_bgscheme WHERE fid =?");
            sql.append("))");
            pstmt = EJBFactory.getConnection((Context)ctx).prepareStatement(sql.toString());
            pstmt.setString(1, element);
            pstmt.setString(2, currencyID);
            pstmt.setString(3, schemaID);
            rst = pstmt.executeQuery();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rst;
    }

    public Tree getTreeInfo(Context ctx, Object vInfo) throws EASBizException {
        if (!(vInfo instanceof ArrayList)) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Tree tr = null;
        ArrayList vPara = (ArrayList)vInfo;
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        String sFID = vPara.get(1).toString();
        String mainDimension = (String)vPara.get(6);
        int position = sFID.indexOf("~");
        Connection conn = null;
        sql.append("SELECT FRefField,FNumber FROM  T_BG_BgItem WHERE FNumber= ? ");
        if (!mainDimension.equals("")) {
            sFID = mainDimension + sFID.substring(position);
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, sFID);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                sql2.delete(0, sql2.capacity());
                sql2.append("(select FKey,FID ,");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" AS FField");
                sql2.append(" FROM  T_Bg_Bgitemcombination WHERE ");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" IS NOT NULL AND (");
                sql2.append(rst.getString("FRefField"));
                sql2.append(" LIKE '");
                sql2.append(rst.getString("FNumber"));
                sql2.append("%' AND ");
                sql2.append(" FKey LIKE '%");
                sql2.append(rst.getString("FNumber"));
                sql2.append("%')) bb ");
                sql.delete(0, sql.capacity());
                sql.append(" SELECT bb.FKey,FField,FBgValue, FBizActual ");
                sql.append(" FROM ");
                sql.append(" T_BG_BGData aa INNER JOIN ");
                sql.append(sql2.toString());
                sql.append(" ON aa.FBgItemCombinId=bb.FID ");
                sql.append(" WHERE ");
                sql.append(" FBgPeriodId= ?");
                sql.append(" AND FBgElementId= ?");
                sql.append(" AND FCurrencyId= ?");
                sql.append(" AND FOrgUnitId= ?");
                sql.append(" AND FBGSCHEMEID= ?");
                sql.append(" ORDER BY FKey ");
                pstmt = EJBFactory.getConnection((Context)ctx).prepareStatement(sql.toString());
                pstmt.setString(1, (String)vPara.get(2));
                pstmt.setString(2, (String)vPara.get(4));
                pstmt.setString(3, (String)vPara.get(3));
                pstmt.setString(4, (String)vPara.get(5));
                pstmt.setString(5, (String)vPara.get(0));
                rst = pstmt.executeQuery();
                tr = this.constructTreeInfo(rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return tr;
    }

    private Tree constructTreeInfo(ResultSet rst) throws EASBizException {
        HashMap inMap = new HashMap();
        String sFkey = "";
        int maxLevel = 0;
        Node root = null;
        try {
            while (rst.next()) {
                sFkey = rst.getString("FKey");
                Node node = new Node(sFkey);
                node.setBgActValue(rst.getBigDecimal("FBgValue"));
                String[] arr = sFkey.split(SPLIT_STR);
                int level = arr.length;
                String sKeyLevel = String.valueOf(level);
                maxLevel = maxLevel > level ? maxLevel : level;
                node.setLevel(arr.length);
                node.setBgValue(rst.getBigDecimal("FBizActual"));
                if (inMap.containsKey(sKeyLevel)) {
                    Object obj = inMap.get(sKeyLevel);
                    ArrayList aListTemp = (ArrayList)obj;
                    aListTemp.add(node);
                    ((ArrayList)inMap.get(sKeyLevel)).add(node);
                    continue;
                }
                ArrayList<Node> aList = new ArrayList<Node>();
                aList.add(node);
                inMap.put(sKeyLevel, aList);
            }
            ArrayList lstFather = new ArrayList();
            ArrayList lstChild = new ArrayList();
            for (int i = 1; i < maxLevel; ++i) {
                lstFather = (ArrayList)inMap.get(String.valueOf(i));
                if (i == 1) {
                    Object oNode = lstFather.get(0);
                    root = (Node)oNode;
                }
                lstChild = (ArrayList)inMap.get(String.valueOf(i + 1));
                for (int j = 0; j < lstChild.size(); ++j) {
                    for (int k = 0; k < lstFather.size(); ++k) {
                        Node nFather = (Node)lstFather.get(k);
                        Node nChild = (Node)lstChild.get(j);
                        if (nChild.getNumber().indexOf(nFather.getNumber()) < 0) continue;
                        nFather.addChildNode(nChild);
                        Node nTemp = Node.searchNode(nFather.getNumber(), root);
                        if (nTemp == null) {
                            root.addChildNode(nFather);
                            continue;
                        }
                        nTemp.addChildNode(nChild);
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR);
        }
        return new Tree(root);
    }

    static interface ConstantInfo {
        public static final int SCHEMAID = 0;
        public static final int SFID = 1;
        public static final int PERIODID = 2;
        public static final int CURRENCYID = 3;
        public static final int ELEMENT = 4;
        public static final int ORGID = 5;
        public static final int MAINDEMINSION = 6;
    }
}

