/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgUpgradeFacadeControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BgUpgradeFacadeControllerBean
extends AbstractBgUpgradeFacadeControllerBean {
    private static final long serialVersionUID = 8209755433474579623L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgUpgradeFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String[] _getUpgradeIds(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String[] bgUpgradeIds = null;
        ArrayList<String> bgUpgradeIdList = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgTemplate");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgUpgradeIdList.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgUpgradeIdList.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            int batchIndex = 0;
            int batchSize = bgUpgradeIdList.size();
            bgUpgradeIds = new String[batchSize];
            if (!bgUpgradeIdList.isEmpty()) {
                int jn = bgUpgradeIdList.size();
                for (int j = 0; j < jn; ++j) {
                    bgUpgradeIds[batchIndex++] = (String)bgUpgradeIdList.get(j);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgUpgradeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _upgradeModelInfo(Context ctx, String bgUpgradeId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block15: {
            if (StringUtils.isEmpty((String)bgUpgradeId)) {
                return;
            }
            conn = null;
            pstmt = null;
            PreparedStatement pstUp = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer updat = new StringBuffer();
            if (BOSUuid.read((String)bgUpgradeId).getType().toString().equals("FF66566A")) {
                sql.append("select FData from T_BG_BgForm where FID = ?");
                updat.append("update T_BG_BgForm set FData = ? where FID = ?");
            } else {
                sql.append("select FData from T_BG_BgTemplate where FID = ?");
                updat.append("update T_BG_BgTemplate set FData = ? where FID = ?");
            }
            byte[] data = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, BOSUuid.read((String)bgUpgradeId).toString());
                rst = pstmt.executeQuery();
                if (!rst.next() || (data = BgInfoHelper.getBytes(rst, 1)) == null || data.length <= 17) break block15;
                try {
                    String magic_str = new String(data, 0, 17);
                    if (!magic_str.equalsIgnoreCase("###PACKER4.0.1###")) break block15;
                    Book _book = IOHelper.unpackBook((byte[])data);
                    data = IOHelper.packBook((Book)_book);
                    try {
                        pstUp = conn.prepareStatement(updat.toString());
                        pstUp.setBytes(1, data);
                        pstUp.setString(2, BOSUuid.read((String)bgUpgradeId).toString());
                        pstUp.executeUpdate();
                    }
                    catch (SQLException ex00) {
                        try {
                            logger.error((Object)ex00);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(pstUp);
                            throw throwable;
                        }
                        SQLUtils.cleanup((Statement)pstUp);
                        break block15;
                    }
                    SQLUtils.cleanup((Statement)pstUp);
                }
                catch (Exception ex0) {
                    logger.error((Object)ex0);
                }
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (SQLException ex2) {
                        logger.error((Object)ex2);
                        throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                    catch (IOException ex3) {
                        logger.error((Object)ex3);
                        throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _recoverModelInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        String billId = model.get("id").toString();
        byte[] data = model.getBytes("data");
        if (model instanceof BgFormInfo) {
            sql.append("update T_BG_BgForm set FData = ? where FID = ?");
        } else if (model instanceof BgTemplateInfo) {
            sql.append("update T_BG_BgTemplate set FData = ? where FID = ?");
        }
        if (StringUtils.isEmpty((String)billId)) return;
        if (data.length <= 0) return;
        if (sql.length() <= 0) return;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBytes(1, data);
            pstmt.setString(2, billId);
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

