/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperCollection;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateCollection;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgWorkTemplateControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkTemplateControllerBean
extends AbstractBgWorkTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgWorkTemplateControllerBean");

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> rpcDataMap = new HashMap<String, Object>();
        String oprtState = (String)paramMap.get("oprtState");
        IMeasureUnit iM = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (oprtState.equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)"0", CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol1 = iM.getMeasureUnitCollection(muView);
        rpcDataMap.put("muCol1", muCol1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        IBgElement iElement = BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCol = iElement.getBgElementCollection(view);
        rpcDataMap.put("bgElementCol", bgElementCol);
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol2 = iM.getMeasureUnitCollection(muView2);
        rpcDataMap.put("muCol2", muCol2);
        return rpcDataMap;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumber(ctx, model);
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)model;
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgWorkTemplate_add");
        IObjectPK result = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
        return result;
    }

    private void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgWorkTemplateCollection col;
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)model;
        String oql = "where number = '" + info.getNumber() + "'";
        if (info.getId() != null) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
        }
        if ((col = this.getBgWorkTemplateCollection(ctx, oql)) != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.WORKTEMPLATENUMBERDUPLACTED);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)model;
        this.checkNumber(ctx, (IObjectValue)info);
        Book book = null;
        if (info.getData() == null || info.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                info.setBook(book);
            }
            catch (IOException e) {
                throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = info.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, info, book);
        return super._save(ctx, model);
    }

    protected Book transAndCheckBook(Context ctx, BgWorkTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgElementSet = new HashSet<String>();
        HashSet<String> bgItemSet = new HashSet<String>();
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    _tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                    if (_tmpStrs != null && _tmpStrs.length == 4) {
                        formulaStr = this.constructFormula(_tmpStrs[0], _tmpStrs[2], "", "");
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    expression = (String)BgNFSHelper.getCellData(cell, "BG_BUDGET_EXPRESSIONS");
                    if (!StringUtils.isEmpty((String)expression)) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                        }
                    }
                    if (!StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData(cell, "BG_ACTUAL_EXPRESSIONS")))) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                        }
                    }
                    if (StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData(cell, "BG_ADD_EXPRESSIONS")))) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                    }
                }
            }
        }
        try {
            BgNTemplateHelper.checkFormulaIsEctype(checkList, ctx.getLocale());
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
        return book;
    }

    private String constructFormula(String bgItem, String bgElement, String bgPeriod, String currency) {
        if (bgItem == null || bgElement == null) {
            return null;
        }
        String formulaLine = "=BgItem(\"" + bgItem + "\",\"" + bgPeriod + "\",\"" + bgElement + "\",\"BgData\",true,\"" + currency + "\")";
        return formulaLine;
    }

    protected Book createNewBook(Context ctx) {
        Book book = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
            BgNFSHelper.setSheetSign(sheet);
        }
        return book;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String oql = "where bgWorkTemplate.id = '" + pk.toString() + "'";
        BgWorkPaperCollection col = BgWorkPaperFactory.getLocalInstance(ctx).getBgWorkPaperCollection(oql);
        if (col != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.CANTDELETEREFWORKTEMPLATE);
        }
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)super._getValue(ctx, pk);
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgWorkTemplate_remove");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)super._getValue(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }
}

