/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigException;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigStateEnum;
import com.kingdee.eas.ma.nbudget.app.AbstractBudgetRequestConfigControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BudgetRequestConfigControllerBean
extends AbstractBudgetRequestConfigControllerBean {
    private static final long serialVersionUID = -7901686775535595275L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BudgetRequestConfigControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectValue _model = model;
        if (_model != null) {
            _model.setTimestamp("createTime", new Timestamp(System.currentTimeMillis()));
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectValue _model = model;
        if (_model != null) {
            _model.setTimestamp("lastUpdateTime", new Timestamp(System.currentTimeMillis()));
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            IObjectPK[] pks = new IObjectPK[]{pk};
            this.checkIsUserConfig(ctx, pks);
        }
        super._delete(ctx, pk);
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        if (pkArray != null) {
            this.checkIsUserConfig(ctx, pkArray);
        }
        super._deleteBatchData(ctx, pkArray);
    }

    private void checkIsUserConfig(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> configIds = new ArrayList<String>();
        int in = pks.length;
        for (int i = 0; i < in; ++i) {
            configIds.add(pks[i].toString());
        }
        int index = 0;
        int batchNum = 10;
        int size = pks.length;
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select TOP 1 FID from T_BG_BudgetRequestBill where FConfigId in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)configIds.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BudgetRequestConfigException(BudgetRequestConfigException.CHECKISUSECONFIG);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"check Config is Use:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _isExistListConfig(Context ctx) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement prmt;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            prmt = null;
            rs = null;
            String sql = "SELECT FID FROM T_Bg_BudgetRequestConfig WHERE FUi=? ";
            try {
                conn = this.getConnection(ctx);
                prmt = conn.prepareStatement(sql);
                prmt.setInt(1, 0);
                rs = prmt.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, prmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)prmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)prmt, (Connection)conn);
        return false;
    }

    @Override
    protected boolean _closeOrUsing(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        SelectorItemCollection isc = new SelectorItemCollection();
        isc.add("id");
        isc.add("state");
        isc.add("uiType");
        BudgetRequestConfigInfo info = this.getBudgetRequestConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(id), isc);
        if (info.getUiType().getValue() == 0) {
            throw new BudgetRequestConfigException(BudgetRequestConfigException.CHECKISDISABLE);
        }
        if (info.getState().getValue() == 0) {
            info.setState(BudgetRequestConfigStateEnum.closed);
        } else {
            info.setState(BudgetRequestConfigStateEnum.using);
        }
        this._save(ctx, (IObjectValue)info);
        return true;
    }

    @Override
    protected IObjectPK _addNewSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }
}

