/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlAddupCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlCurrPeriodCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlCurrYearCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlFormulaInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlGrossCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.IBgCalculator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class BgAvlBalCalculator
implements IBgCalculator {
    private static final Logger logger = Logger.getLogger(BgAvlBalCalculator.class);
    private CalendarHelper calendar = new CalendarHelper();
    private ICalculateContextProvider provider;
    private Context ctx = null;
    private List bgFormulaList = new ArrayList();
    private Map expressMap = new HashMap();
    private Map orgUnitMap = new HashMap();
    private Map bgSchemeMap = new HashMap();
    private Map bgSchemeKeyMap = new HashMap();
    private Map bgPeriodCacheMap = new HashMap();
    private Map bgDataGroupNoMap = new HashMap();
    private Map formulaMap = new HashMap();
    private List bgCalDataList = new ArrayList();
    private static final int batchSize = 250;
    private static final String MATCH_STR = "\\-?\\d+";
    public static final String _BAD_FUNCTION_ = "#BAD FUNCTION ";

    public BgAvlBalCalculator() {
    }

    public BgAvlBalCalculator(ICalculateContextProvider provider, Context ctx) {
        this.setProvider(provider);
        this.setCtx(ctx);
    }

    public CalendarHelper getCalendar() {
        return this.calendar;
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    public ICalculateContextProvider getProvider() {
        return this.provider;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public List getBgFormulaList() {
        return this.bgFormulaList;
    }

    public List getCalDataList() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.bgCalDataList);
        this.bgCalDataList.clear();
        return temp;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map getBgSchemeMap() {
        return this.bgSchemeMap;
    }

    public Map getBgSchemeKeyMap() {
        return this.bgSchemeKeyMap;
    }

    public Map getBgPeriodCacheMap() {
        return this.bgPeriodCacheMap;
    }

    public Map getBgDataGroupNoMap() {
        return this.bgDataGroupNoMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public static int getBatchSize() {
        return 250;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgAvlBalance start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parserParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initCtrlInfo();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize ctrl info succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgAvlBalance finished!");
    }

    protected void parserParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportVariables rv = this.getProvider().getReportVariables();
        Variant variant = null;
        Parameter _parameter = null;
        Object _obj = null;
        Object[] _objs = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        IReportPropertyAdapter adapter = null;
        int _periodType = 0;
        int _currYear = 0;
        int _currPeriod = 0;
        adapter = this.getProvider().getReportAdapter();
        _obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String _currCurrencyNumber = (String)adapter.getReportProperty("Currency.Number");
        String _currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        String _bgSchemeNumber = (String)adapter.getReportProperty("BG_SCHEME_NUMBER");
        String _bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        if (_obj == null) {
            _periodType = (Integer)adapter.getReportProperty("PeriodType");
            _currYear = (Integer)adapter.getReportProperty("Report.Year");
            _currPeriod = (Integer)adapter.getReportProperty("Report.Period");
        }
        String _orgUnitNumber = null;
        String _schemeNumber = null;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            _objs = _parameter.getArgs();
            _orgUnitNumber = (String)((Variant)_objs[0]).getValue();
            _schemeNumber = (String)((Variant)_objs[1]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _objs[0] = new Variant((Object)_bgOrgNumber);
            }
            if (StringUtils.isEmpty((String)_schemeNumber)) {
                _objs[1] = new Variant((Object)_bgSchemeNumber);
            }
            _objs[4] = this.parserCurrencyParameter((Variant)_objs[4], _currCurrencyNumber);
            if (_obj != null && _obj instanceof Integer && (Integer)_obj != 8 && _objs[5] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[5].toString())) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (_objs[5] instanceof Variant && ((variant = (Variant)_objs[5]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("StartBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()))) {
                _objs[5] = new Variant((Object)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()));
            }
            _objs[5] = _obj != null ? this.parserBgPeriodParameter((Variant)_objs[5], _currPeriodNumber) : this.parserPeriodParameter((Variant)_objs[5], _periodType, _currYear, _currPeriod);
        }
    }

    protected Variant parserCurrencyParameter(Variant currencyNumber, String currCurrencyNumber) {
        if (currencyNumber == null || currencyNumber.getValue() == null) {
            return new Variant((Object)currCurrencyNumber);
        }
        String _currencyNumber = currencyNumber.getValue().toString();
        if (StringUtils.isEmpty((String)_currencyNumber)) {
            return new Variant((Object)currCurrencyNumber);
        }
        return currencyNumber;
    }

    protected Variant parserBgPeriodParameter(Variant bgPeriodNumber, String currBgPeriodNumber) {
        if (bgPeriodNumber == null || bgPeriodNumber.getValue() == null) {
            return new Variant((Object)currBgPeriodNumber);
        }
        String _bgPeriodNumber = bgPeriodNumber.getValue().toString();
        if (StringUtils.isEmpty((String)_bgPeriodNumber) || "0".equals(_bgPeriodNumber)) {
            return new Variant((Object)currBgPeriodNumber);
        }
        if (Pattern.matches(MATCH_STR, _bgPeriodNumber)) {
            int _offset = 0;
            try {
                _offset = Integer.parseInt(_bgPeriodNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer _offsetKey = new Integer(_offset);
            if (this.getBgPeriodCacheMap().containsKey(_offsetKey)) {
                _bgPeriodNumber = (String)this.getBgPeriodCacheMap().get(_offsetKey);
            } else {
                _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(currBgPeriodNumber, _offset);
                this.getBgPeriodCacheMap().put(_offsetKey, _bgPeriodNumber);
            }
        }
        return new Variant((Object)_bgPeriodNumber);
    }

    protected Variant parserPeriodParameter(Variant bgPeriodNumber, int periodType, int currYear, int currPeriod) {
        int _offset = 0;
        String _bgPeriodNumber = null;
        if (bgPeriodNumber != null && bgPeriodNumber.getValue() != null) {
            String _offStr = bgPeriodNumber.getValue().toString();
            if (Pattern.matches(MATCH_STR, _offStr)) {
                try {
                    _offset = Integer.parseInt(_offStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Integer _offsetKey = new Integer(_offset);
                if (this.getBgPeriodCacheMap().containsKey(_offsetKey)) {
                    _bgPeriodNumber = (String)this.getBgPeriodCacheMap().get(_offsetKey);
                } else {
                    _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(periodType, currYear, currPeriod, _offset);
                    this.getBgPeriodCacheMap().put(_offsetKey, _bgPeriodNumber);
                }
            } else if (!StringUtils.isEmpty((String)_offStr)) {
                _bgPeriodNumber = _offStr;
            }
        }
        if (_bgPeriodNumber == null) {
            _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(periodType, currYear, currPeriod, 0);
        }
        return new Variant(_bgPeriodNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _bgPeriodNumber = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Map<String, BgAvlFormulaInfo> _bgFormulaMap = null;
        BgAvlFormulaInfo _bgFormula = null;
        BgSchemeInfo bgSchemeInfo = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            if (_parmeter.getValue() != null && _parmeter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _bgPeriodNumber = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_bgPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgAvlFormulaInfo(this, _parmeter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getBgFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getBgFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgAvlFormulaInfo)this.getBgFormulaList().get(j);
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            if (_orgUnitId == null) {
                _orgUnitId = "000000000000000000000000000=";
            }
            _bgSchemeId = (bgSchemeInfo = (BgSchemeInfo)this.getBgSchemeKeyMap().get(_bgFormula.getOrgAndBgSchemeNumberKey())) == null ? "000000000000000000000000000=" : bgSchemeInfo.getId().toString();
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaMap = (Map)this.getExpressMap().get(_key);
            } else {
                _bgFormulaMap = new HashMap();
                this.getExpressMap().put(_key, _bgFormulaMap);
            }
            _bgFormulaMap.put(_bgFormula.getBgFormula(), _bgFormula);
        }
    }

    protected void getOrgUnitInfo(Set orgUnitNumberSet) throws Exception {
        if (orgUnitNumberSet == null || orgUnitNumberSet.isEmpty()) {
            return;
        }
        ArrayList _orgUnitNumberList = new ArrayList();
        _orgUnitNumberList.addAll(orgUnitNumberSet);
        int size = _orgUnitNumberList.size();
        int count = (size - 1) / BgAvlBalCalculator.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fnumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FNumber FROM T_ORG_CostCenter WHERE FNumber IN (");
        for (int i = 1; i < BgAvlBalCalculator.getBatchSize(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= BgAvlBalCalculator.getBatchSize()) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_orgUnitNumberList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fnumber = rst.getString("FNumber");
                    this.getOrgUnitMap().put(_fnumber, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _orgUnitNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _orgUnitNumberList.clear();
    }

    protected void getBgSchemeInfo(Set bgSchemeNumberSet) throws Exception {
        if (bgSchemeNumberSet == null || bgSchemeNumberSet.isEmpty()) {
            return;
        }
        ArrayList _bgSchemeNumberList = new ArrayList();
        _bgSchemeNumberList.addAll(bgSchemeNumberSet);
        int batchSize = 25;
        int tmp = 0;
        int size = _bgSchemeNumberList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fOrgNumber = null;
        String _fBgSchemeNumber = null;
        String _key = null;
        String[] _tmpStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT S.FID, S.FNumber, S.FOrgUnitId, B.FNumber FOrgUnitNumber, S.FDateFrom, S.FDateTo FROM T_BG_BgScheme S LEFT JOIN T_ORG_CostCenter B ON S.FOrgUnitId = B.FID WHERE ");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("(B.FNumber = ? and S.FNumber = ?) or ");
        }
        sql.append("(B.FNumber = ? and S.FNumber = ?)");
        BgSchemeInfo bgSchemeInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    tmp = x * 2;
                    if (pos < size) {
                        _key = (String)_bgSchemeNumberList.get(pos);
                        _tmpStr = _key.split("!");
                        pstmt.setString(tmp - 1, _tmpStr[0]);
                        pstmt.setString(tmp, _tmpStr[1]);
                    } else {
                        pstmt.setString(tmp - 1, "#");
                        pstmt.setString(tmp, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fOrgNumber = rst.getString("FOrgUnitNumber");
                    _fBgSchemeNumber = rst.getString("FNumber");
                    _key = _fOrgNumber + "!" + _fBgSchemeNumber;
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)_fid));
                    bgSchemeInfo.setNumber(_fBgSchemeNumber);
                    bgSchemeInfo.setDateFrom((Date)rst.getDate("FDateFrom"));
                    bgSchemeInfo.setDateTo((Date)rst.getDate("FDateTo"));
                    this.getBgSchemeMap().put(_fid, bgSchemeInfo);
                    this.getBgSchemeKeyMap().put(_key, bgSchemeInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgSchemeNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _bgSchemeNumberList.clear();
    }

    protected void initCtrlInfo() throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstCtrl = null;
        ResultSet rst = null;
        Map _bgFormulaMap = null;
        Set _bgDataGroupNoSet = null;
        ArrayList<String> _bgFormulaList = new ArrayList<String>();
        ArrayList<String> _bgDataGroupNoList = new ArrayList<String>();
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        Map.Entry _entry2 = null;
        Map.Entry _fEntry2 = null;
        boolean isControl = false;
        boolean isGroupCtrl = false;
        String bgDataGroupCtrlNo = null;
        int ctrlType = 10;
        boolean isFlexible = false;
        BigDecimal flexibleParam = null;
        boolean hasGroupCtrl = false;
        int size = 0;
        int count = 0;
        int pos = 0;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String _osIdKey = null;
        String _osCtrlKey = null;
        String[] _keyStr = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer ctrl = new StringBuffer();
        sql.append("SELECT FFormula, FBgValue, FBizActual, FIsControl, FIsGroupCtrl, FGroupNo, FCtrlType, FIsFlexible, FFlexParam FROM T_BG_BgData ");
        sql.append("where FDatastate <> ").append(1).append(" and FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula IN (");
        ctrl.append("SELECT FFormula, FBgValue, FBizActual, FIsControl,FIsGroupCtrl, FGroupNo, FCtrlType, FIsFlexible, FFlexParam FROM T_BG_BgData ");
        ctrl.append("where FDatastate <> ").append(1).append(" and FOrgUnitId = ? AND FBgSchemeId = ? AND FIsGroupCtrl = 1 AND FGroupNo IN (");
        for (int i = 1; i < BgAvlBalCalculator.getBatchSize(); ++i) {
            sql.append("?, ");
            ctrl.append("?, ");
        }
        sql.append("?)");
        ctrl.append("?)");
        BgAvlFormulaInfo _bgFormula = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstCtrl = conn.prepareStatement(ctrl.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _osIdKey = (String)_entry2.getKey();
                _bgFormulaMap = (Map)_entry2.getValue();
                _bgFormulaList.clear();
                for (Map.Entry _fEntry2 : _bgFormulaMap.entrySet()) {
                    _formulaStr = (String)_fEntry2.getKey();
                    _bgFormula = (BgAvlFormulaInfo)_fEntry2.getValue();
                    _bgFormulaList.add(_formulaStr);
                }
                hasGroupCtrl = false;
                _bgDataGroupNoList.clear();
                _keyStr = _osIdKey.split("!");
                _orgUnitId = _keyStr[0];
                _bgSchemeId = _keyStr[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / BgAvlBalCalculator.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < BgAvlBalCalculator.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _formulaStr = rst.getString("FFormula");
                        bValue = rst.getBigDecimal("FBgValue");
                        aValue = rst.getBigDecimal("FBizActual");
                        isControl = rst.getBoolean("FIsControl");
                        isGroupCtrl = rst.getBoolean("FIsGroupCtrl");
                        bgDataGroupCtrlNo = rst.getString("FGroupNo");
                        ctrlType = rst.getInt("FCtrlType");
                        isFlexible = rst.getBoolean("FIsFlexible");
                        flexibleParam = rst.getBigDecimal("FFlexParam");
                        if (isGroupCtrl) {
                            hasGroupCtrl = true;
                            _osCtrlKey = _osIdKey + "!" + bgDataGroupCtrlNo;
                            if (!this.getBgDataGroupNoMap().containsKey(_osCtrlKey)) {
                                this.getBgDataGroupNoMap().put(_osCtrlKey, new HashSet());
                                _bgDataGroupNoList.add(bgDataGroupCtrlNo);
                            }
                        }
                        _bgFormula = (BgAvlFormulaInfo)_bgFormulaMap.get(_formulaStr);
                        _bgFormula.setBudgetValue(bValue);
                        _bgFormula.setActualValue(aValue);
                        _bgFormula.setControl(isControl);
                        _bgFormula.setGroupCtrl(isGroupCtrl);
                        _bgFormula.setBgDataGroupCtrlNo(bgDataGroupCtrlNo);
                        _bgFormula.setCtrlType(ctrlType);
                        _bgFormula.setFlexible(isFlexible);
                        _bgFormula.setFlexibleParam(flexibleParam);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (!hasGroupCtrl) continue;
                    pos = 0;
                    size = _bgDataGroupNoList.size();
                    count = (size - 1) / BgAvlBalCalculator.getBatchSize() + 1;
                    for (int _index = 0; _index < count; ++_index) {
                        pstCtrl.setString(1, _orgUnitId);
                        pstCtrl.setString(2, _bgSchemeId);
                        int x2 = 3;
                        while (x2 < BgAvlBalCalculator.getBatchSize() + 3) {
                            if (pos < size) {
                                pstCtrl.setString(x2, (String)_bgDataGroupNoList.get(pos));
                            } else {
                                pstCtrl.setString(x2, "#");
                            }
                            ++x2;
                            ++pos;
                        }
                        rst = pstCtrl.executeQuery();
                        while (rst.next()) {
                            _formulaStr = rst.getString("FFormula");
                            bValue = rst.getBigDecimal("FBgValue");
                            aValue = rst.getBigDecimal("FBizActual");
                            isControl = rst.getBoolean("FIsControl");
                            isGroupCtrl = rst.getBoolean("FIsGroupCtrl");
                            bgDataGroupCtrlNo = rst.getString("FGroupNo");
                            ctrlType = rst.getInt("FCtrlType");
                            isFlexible = rst.getBoolean("FIsFlexible");
                            flexibleParam = rst.getBigDecimal("FFlexParam");
                            _bgFormula = new BgAvlFormulaInfo(this, null);
                            _bgFormula.setOrgUnitId(_orgUnitId);
                            _bgFormula.setBgSchemeId(_bgSchemeId);
                            _bgFormula.setBgFormula(_formulaStr);
                            _bgFormula.setBudgetValue(bValue);
                            _bgFormula.setActualValue(aValue);
                            _bgFormula.setControl(isControl);
                            _bgFormula.setGroupCtrl(isGroupCtrl);
                            _bgFormula.setBgDataGroupCtrlNo(bgDataGroupCtrlNo);
                            _bgFormula.setCtrlType(ctrlType);
                            _bgFormula.setFlexible(isFlexible);
                            _bgFormula.setFlexibleParam(flexibleParam);
                            _osCtrlKey = _osIdKey + "!" + bgDataGroupCtrlNo;
                            _bgDataGroupNoSet = (Set)this.getBgDataGroupNoMap().get(_osCtrlKey);
                            _bgDataGroupNoSet.add(_bgFormula);
                            if (_bgFormulaMap.containsKey(_formulaStr)) continue;
                            _bgFormulaMap.put(_formulaStr, _bgFormula);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculate() throws Exception {
        String osIdKey = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String formulaStr = null;
        String[] _tmpStrs = null;
        Map.Entry _entry2 = null;
        Map.Entry _fEntry2 = null;
        Map bgFormulaMap = null;
        HashMap<String, BgAvlFormulaInfo> addupMap = new HashMap<String, BgAvlFormulaInfo>();
        HashMap<String, BgAvlFormulaInfo> grossMap = new HashMap<String, BgAvlFormulaInfo>();
        HashMap<String, BgAvlFormulaInfo> currYearMap = new HashMap<String, BgAvlFormulaInfo>();
        HashMap<String, BgAvlFormulaInfo> currPeriodMap = new HashMap<String, BgAvlFormulaInfo>();
        BgAvlFormulaInfo formula = null;
        BgAvlAddupCalculator addupCalculator = new BgAvlAddupCalculator(this);
        BgAvlCurrPeriodCalculator currPeriodCalculator = new BgAvlCurrPeriodCalculator(this);
        BgAvlCurrYearCalculator currYearCalculator = new BgAvlCurrYearCalculator(this);
        BgAvlGrossCalculator grossCalculator = new BgAvlGrossCalculator(this);
        for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
            osIdKey = (String)_entry2.getKey();
            bgFormulaMap = (Map)_entry2.getValue();
            _tmpStrs = osIdKey.split("!");
            orgUnitId = _tmpStrs[0];
            bgSchemeId = _tmpStrs[1];
            addupMap.clear();
            currPeriodMap.clear();
            currYearMap.clear();
            grossMap.clear();
            for (Map.Entry _fEntry2 : bgFormulaMap.entrySet()) {
                formulaStr = (String)_fEntry2.getKey();
                formula = (BgAvlFormulaInfo)_fEntry2.getValue();
                if (formula.getCtrlType() == 11) {
                    addupMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 10) {
                    currPeriodMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 20) {
                    currYearMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 12) {
                    grossMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() != -1) continue;
                currPeriodMap.put(formulaStr, formula);
            }
            if (!addupMap.isEmpty()) {
                addupCalculator.setOrgUnitId(orgUnitId);
                addupCalculator.setBgSchemeId(bgSchemeId);
                addupCalculator.setFormulaMap(addupMap);
                try {
                    ((BgAvlCalculator)addupCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    addupMap.clear();
                }
            }
            if (!currPeriodMap.isEmpty()) {
                currPeriodCalculator.setOrgUnitId(orgUnitId);
                currPeriodCalculator.setBgSchemeId(bgSchemeId);
                currPeriodCalculator.setFormulaMap(currPeriodMap);
                try {
                    ((BgAvlCalculator)currPeriodCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    currPeriodMap.clear();
                }
            }
            if (!currYearMap.isEmpty()) {
                currYearCalculator.setOrgUnitId(orgUnitId);
                currYearCalculator.setBgSchemeId(bgSchemeId);
                currYearCalculator.setFormulaMap(currYearMap);
                try {
                    ((BgAvlCalculator)currYearCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    currYearMap.clear();
                }
            }
            if (grossMap.isEmpty()) continue;
            grossCalculator.setOrgUnitId(orgUnitId);
            grossCalculator.setBgSchemeId(bgSchemeId);
            grossCalculator.setFormulaMap(grossMap);
            try {
                ((BgAvlCalculator)grossCalculator).calculator();
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            finally {
                grossMap.clear();
            }
        }
    }

    protected void fillValue() {
        BigDecimal _value = null;
        String osIdKey = null;
        String ctrlKey = null;
        Map bgFormulaMap = null;
        Set bgFormulaSet = null;
        BgAvlFormulaInfo _bgFormula = null;
        BgAvlFormulaInfo temp = null;
        int size = this.getBgFormulaList().size();
        for (int index = 0; index < size; ++index) {
            _bgFormula = (BgAvlFormulaInfo)this.getBgFormulaList().get(index);
            osIdKey = _bgFormula.getOrgAndBgSchemeIdKey();
            bgFormulaMap = (Map)this.getExpressMap().get(osIdKey);
            if (bgFormulaMap.get(_bgFormula.getBgFormula()) instanceof BgAvlFormulaInfo) {
                temp = (BgAvlFormulaInfo)bgFormulaMap.get(_bgFormula.getBgFormula());
                _bgFormula.setBalance(temp.getBalance());
                _bgFormula.setActualValue(temp.getActualValue());
                _bgFormula.setBudgetValue(temp.getBudgetValue());
            }
            _value = _bgFormula.getBalance();
            if (_bgFormula.isGroupCtrl()) {
                osIdKey = _bgFormula.getOrgAndBgSchemeIdKey();
                ctrlKey = osIdKey + "!" + _bgFormula.getBgDataGroupCtrlNo();
                if (this.getBgDataGroupNoMap().containsKey(ctrlKey)) {
                    bgFormulaSet = (Set)this.getBgDataGroupNoMap().get(ctrlKey);
                    _value = this.addGroupNoNumerial(_bgFormula, bgFormulaSet, bgFormulaMap);
                }
            }
            if (_bgFormula.getParameter().getValue() != null && _bgFormula.getParameter().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParameter().setValue((Object)_value);
        }
    }

    protected BigDecimal addGroupNoNumerial(BgAvlFormulaInfo bgFormula, Set bgFormulaSet, Map bgFormulaMap) {
        if (bgFormula == null || bgFormulaSet == null || bgFormulaSet.isEmpty()) {
            return BgNConstants.ZERO;
        }
        String[] parameter = null;
        BigDecimal value = null;
        BgAvlFormulaInfo tmpFormula2 = null;
        value = bgFormula.getBalance();
        for (BgAvlFormulaInfo tmpFormula2 : bgFormulaSet) {
            if (bgFormula.getBgFormula().equals(tmpFormula2.getBgFormula())) continue;
            if (bgFormulaMap != null && bgFormulaMap.containsKey(tmpFormula2.getBgFormula())) {
                tmpFormula2 = (BgAvlFormulaInfo)bgFormulaMap.get(tmpFormula2.getBgFormula());
            }
            if (StringUtils.isEmpty((String)tmpFormula2.getBgPeriodNumber()) && (parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), tmpFormula2.getBgFormula())) != null) {
                tmpFormula2.setBgPeriodNumber(parameter[1]);
            }
            if (!bgFormula.getBgPeriodNumber().equals(tmpFormula2.getBgPeriodNumber())) continue;
            value = value.add(tmpFormula2.getBalance());
        }
        if (bgFormula.getCtrlType() == 11 || bgFormula.getCtrlType() == 10 || bgFormula.getCtrlType() == 20 || bgFormula.getCtrlType() == 12 || bgFormula.getCtrlType() == -1) {
            // empty if block
        }
        return value;
    }

    protected void clear() {
        this.bgCalDataList.addAll(this.bgFormulaList);
        this.getBgFormulaList().clear();
        this.getExpressMap().clear();
        this.getOrgUnitMap().clear();
        this.getBgSchemeMap().clear();
        this.getBgSchemeKeyMap().clear();
        this.getBgPeriodCacheMap().clear();
        this.getBgDataGroupNoMap().clear();
        this.getFormulaMap().clear();
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }
}

