/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlFormulaInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgAvlCurrYearCalculator
extends BgAvlCalculator {
    private static Logger logger = Logger.getLogger(BgAvlCurrYearCalculator.class);
    private Map budgetValueMap = new HashMap();
    private Map actualValueMap = new HashMap();

    public BgAvlCurrYearCalculator(BgAvlBalCalculator calculator) {
        super(calculator);
    }

    public Map getBudgetValueMap() {
        return this.budgetValueMap;
    }

    public Map getActualValueMap() {
        return this.actualValueMap;
    }

    @Override
    public void calculator() throws Exception {
        this.calculatorByBudgetValue();
        this.calculatorByActualValue();
        this.calculatorBalanceValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getBudgetValueMap().clear();
        this.getActualValueMap().clear();
    }

    protected void calculatorByBudgetValue() throws Exception {
        this.getBudgetValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        int _bgPeriodType = 0;
        int _year = 0;
        String _bgItemNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(d.FBgValue), i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FYear >= ? and FYear <= ?)) ").append("and d.FDataState =9 ").append("group by i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        Date _beginDate = bgSchemeInfo.getDateFrom();
        Date _endDate = bgSchemeInfo.getDateTo();
        int beginYear = this.getCalendar().getCurrentlyYear(_beginDate);
        int endYear = this.getCalendar().getCurrentlyYear(_endDate);
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setInt(3, beginYear);
            pstmt.setInt(4, endYear);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodType = rst.getInt(3);
                _year = rst.getInt(4);
                _bgElementNumber = rst.getString(5);
                _currencyNumber = rst.getString(6);
                _key = new StringBuffer(_bgItemNumber).append("!").append(_bgPeriodType).append("!").append(_year).append("!").append(_bgElementNumber).append("!").append(_currencyNumber).toString();
                this.getBudgetValueMap().put(_key, _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorByActualValue() throws Exception {
        this.getActualValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer _keyStr = null;
        sql.append("select sum(d.FBizActual), i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append(" from T_BG_BgData d ").append(" left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append(" left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append(" left join T_BG_BgElement e on d.FBgElementId = e.FID ").append(" left join T_BD_Currency c on d.FCurrencyId = c.FID ").append(" left join T_BG_BgForm f on d.FBgFormId = f.FID ").append(" where d.FOrgUnitId = ? and d.FBgSchemeId = ? and d.FBizActual <> 0").append(" and d.FDataState =9").append(" group by i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ");
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _keyStr = new StringBuffer();
                _keyStr.append(rst.getString(2)).append("!").append(rst.getInt(3)).append("!").append(rst.getInt(4)).append("!").append(rst.getString(5)).append("!").append(rst.getString(6));
                this.getActualValueMap().put(_keyStr.toString(), _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorBalanceValue() throws Exception {
        Map.Entry _entry2 = null;
        BgAvlFormulaInfo formula = null;
        HashMap formulaMap = new HashMap();
        int bgPeriodType = 0;
        int year = 0;
        String formulaStr = null;
        String _key = null;
        String[] parameter = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        for (Map.Entry _entry2 : this.getFormulaMap().entrySet()) {
            _bValue = BgNConstants.ZERO;
            formulaStr = (String)_entry2.getKey();
            formula = (BgAvlFormulaInfo)_entry2.getValue();
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
            if (parameter == null) continue;
            bgPeriodType = BgNPeriodHelper.parserBgPeriodType(parameter[1]);
            year = BgNPeriodHelper.parserBgPeriodYear(parameter[1]);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(bgPeriodType).append("!").append(year).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            _bValue = this.getBudgetValueMap().containsKey(_key) ? (BigDecimal)this.getBudgetValueMap().get(_key) : BgNConstants.ZERO;
            formula.setBudgetValue(_bValue);
            _aValue = this.getActualValueMap().containsKey(_key) ? (BigDecimal)this.getActualValueMap().get(_key) : BgNConstants.ZERO;
            formula.setActualValue(_aValue);
            formula.calculator();
        }
    }
}

