/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlFormulaInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgAvlGrossCalculator
extends BgAvlCalculator {
    private static Logger logger = Logger.getLogger(BgAvlGrossCalculator.class);
    private Map budgetValueMap = new HashMap();
    private Map actualValueMap = new HashMap();

    public BgAvlGrossCalculator(BgAvlBalCalculator calculator) {
        super(calculator);
    }

    public Map getBudgetValueMap() {
        return this.budgetValueMap;
    }

    public Map getActualValueMap() {
        return this.actualValueMap;
    }

    @Override
    public void calculator() throws Exception {
        this.calculatorByBudgetValue();
        this.calculatorByActualValue();
        this.calculatorBalanceValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getBudgetValueMap().clear();
        this.getActualValueMap().clear();
    }

    protected void calculatorByBudgetValue() throws Exception {
        this.getBudgetValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        int _bgPeriodType = 0;
        String _bgItemNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(d.FBgValue), i.FKey, p.FPeriodType, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FBeginDate >= ? and FEndDate <= ?)or (FBeginDate <= ? and FEndDate >= ?)or (FBeginDate <= ? and FEndDate >= ?) ) ").append(" and d.FDataState =9").append(" group by i.FKey, p.FPeriodType, e.FNumber, c.FNumber ");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        java.util.Date _beginDate = bgSchemeInfo.getDateFrom();
        java.util.Date _endDate = bgSchemeInfo.getDateTo();
        Date beginDate = new Date(_beginDate.getTime());
        Date endDate = new Date(_endDate.getTime());
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setDate(3, beginDate);
            pstmt.setDate(4, endDate);
            pstmt.setDate(5, beginDate);
            pstmt.setDate(6, beginDate);
            pstmt.setDate(7, endDate);
            pstmt.setDate(8, endDate);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodType = rst.getInt(3);
                _bgElementNumber = rst.getString(4);
                _currencyNumber = rst.getString(5);
                _key = new StringBuffer(_bgItemNumber).append("!").append(_bgPeriodType).append("!").append(_bgElementNumber).append("!").append(_currencyNumber).toString();
                this.getBudgetValueMap().put(_key, _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorByActualValue() throws Exception {
        this.getActualValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        int _bgPeriodType = 0;
        String _bgItemNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(d.FBizActual), i.FKey, p.FPeriodType, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and d.FDataState =9 ").append(" group by i.FKey, p.FPeriodType, e.FNumber, c.FNumber ");
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodType = rst.getInt(3);
                _bgElementNumber = rst.getString(4);
                _currencyNumber = rst.getString(5);
                _key = new StringBuffer(_bgItemNumber).append("!").append(_bgPeriodType).append("!").append(_bgElementNumber).append("!").append(_currencyNumber).toString();
                this.getActualValueMap().put(_key, _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorBalanceValue() throws Exception {
        Map.Entry _entry2 = null;
        BgAvlFormulaInfo formula = null;
        HashMap formulaMap = new HashMap();
        int bgPeriodType = 0;
        String formulaStr = null;
        String _key = null;
        String[] parameter = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        for (Map.Entry _entry2 : this.getFormulaMap().entrySet()) {
            formulaStr = (String)_entry2.getKey();
            formula = (BgAvlFormulaInfo)_entry2.getValue();
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
            if (parameter == null) continue;
            bgPeriodType = BgNPeriodHelper.parserBgPeriodType(parameter[1]);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(bgPeriodType).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            _bValue = this.getBudgetValueMap().containsKey(_key) ? (BigDecimal)this.getBudgetValueMap().get(_key) : BgNConstants.ZERO;
            formula.setBudgetValue(_bValue);
            _aValue = this.getActualValueMap().containsKey(_key) ? (BigDecimal)this.getActualValueMap().get(_key) : BgNConstants.ZERO;
            formula.setActualValue(_aValue);
            formula.calculator();
        }
    }
}

