/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgBalanceCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgBalanceCalculator.class);
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgBalanceCalculator() {
    }

    public BgBalanceCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgAdjust start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate(false);
            this.calculate(true);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgAdjust finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        String[] _formulas = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgFormulaSet = null;
        BgFormulaInfo _bgFormula = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            if (_parmeter.getValue() != null && _parmeter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _beginPeriodNumber = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            _endPeriodNumber = (String)((Variant)_parmeter.getArgs()[6]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgFormulaInfo(this, _parmeter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                this.getExpressMap().put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x]);
            }
        }
    }

    protected void calculate(boolean calTmpData) throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        if (calTmpData) {
            sql.append("SELECT FBgValue, FFormula ").append("FROM T_Bg_BgTmpData ");
        } else {
            sql.append("SELECT FBgValue, FBizActual, FFormula ").append("FROM T_Bg_BgData ");
        }
        sql.append("WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula IN (");
        for (int index = 1; index < this.getBatchSize(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String[] _key = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < this.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        if (calTmpData) {
                            _bValue = rst.getBigDecimal(1);
                            _formulaStr = rst.getString(2);
                        } else {
                            _bValue = rst.getBigDecimal(1);
                            _aValue = rst.getBigDecimal(2);
                            _formulaStr = rst.getString(3);
                        }
                        _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).toString();
                        if (calTmpData) {
                            this.getBgAdjDataMap().put(_tmpKey, _bValue);
                            continue;
                        }
                        this.getBgDataMap().put(_tmpKey, new BgValue(_bValue, _aValue));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            this.updateBgAdjDataMap();
            this.updateBgDataMap();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    public void updateBgDataMap() {
        String _key2 = null;
        BgValue _bgValue = null;
        for (String _key2 : this.getBgFormulaMapFromBook().keySet()) {
            if (!this.getBgDataMap().containsKey(_key2)) continue;
            _bgValue = (BgValue)this.getBgDataMap().get(_key2);
            _bgValue.setBValue((BigDecimal)this.getBgFormulaMapFromBook().get(_key2));
        }
    }

    @Override
    public void updateBgAdjDataMap() {
        String _key2 = null;
        BgValue _bgValue = null;
        for (String _key2 : this.getBgFormulaMapFromBook().keySet()) {
            if (!this.getBgAdjDataMap().containsKey(_key2)) continue;
            _bgValue = (BgValue)this.getBgAdjDataMap().get(_key2);
            _bgValue.setBValue((BigDecimal)this.getBgFormulaMapFromBook().get(_key2));
        }
    }

    protected void fillValue() {
        String _key = null;
        String _orgKey = null;
        String _formulaStr2 = null;
        String[] _formulas = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        BgValue _bgValue = null;
        BgFormulaInfo _bgFormula = null;
        for (Map.Entry _entry2 : this.getBgAdjDataMap().entrySet()) {
            _key = (String)_entry2.getKey();
            _value = (BigDecimal)_entry2.getValue();
            if (!this.getBgDataMap().containsKey(_key)) continue;
            _bgValue = (BgValue)this.getBgDataMap().get(_key);
            _bgValue.setBValue(_value);
        }
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(i);
            _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
            _formulas = _bgFormula.getFormulas();
            _value = BgNConstants.ZERO;
            if (_formulas != null) {
                for (String _formulaStr2 : _formulas) {
                    _key = new StringBuffer(_orgKey).append("!").append(_formulaStr2).toString();
                    if (!this.getBgDataMap().containsKey(_key)) continue;
                    _bgValue = (BgValue)this.getBgDataMap().get(_key);
                    _value = _value.add(_bgValue.getAdjustValue());
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }

    private class BgValue {
        private BigDecimal bValue = null;
        private BigDecimal aValue = null;

        public BgValue(BigDecimal bValue, BigDecimal aValue) {
            this.bValue = bValue != null ? bValue : BgNConstants.ZERO;
            this.aValue = aValue != null ? aValue : BgNConstants.ZERO;
        }

        public BigDecimal getBValue() {
            return this.bValue;
        }

        public void setBValue(BigDecimal value) {
            this.bValue = value;
        }

        public BigDecimal getAValue() {
            return this.aValue;
        }

        public void setAValue(BigDecimal value) {
            this.aValue = value;
        }

        public BigDecimal getAdjustValue() {
            return this.getBValue().subtract(this.getAValue());
        }
    }
}

