/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgActualCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgActualExt;
import com.kingdee.eas.ma.nbudget.app.formula.BgAdjustCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgBalanceCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgCdCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgDifferenceCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgGetDimeDataCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgGetOrgAttrCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgNAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefFormCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefTemplateCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.IProcess;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public final class BgCalculatorProcess
implements IProcess {
    private final Logger logger = CoreUIObject.getLogger((String)BgCalculatorProcess.class.getName());
    private String methodName = null;
    private ICalculateContextProvider provider = null;
    private Context context = null;
    private SortedParameterArray params = null;
    private static String _BAD_FUNCTION_ = "#BAD FUNCTION: ";
    private static String bgFormulaStr = "bgformula";
    private static String bgActualsStr = "bgactuals";
    private static String bgAdjustStr = "bgadjust";
    private static String bgBalanceStr = "bgbal";
    private static String bgAvlBalanceStr = "bgAvlBal";
    private static String bgRefBgFormStr = "bgrefbgform";
    private static String bgRefBgTemplateStr = "bgrefbgtem";
    private static String getOrgAttr = "getorgtypval";
    private static String bgDifferenceStr = "bgdifference";
    private static String bgNAvlBalanceStr = "bgNAvlBal";
    private static String bgExecuteAnalyseStr = "bgExecuteAnalyse";
    private static String bgActualExtStr = "bgactualext";
    private static String bgGetDimeData = "bgGetDimeData";
    private static String bgCdStr = "bgCd";
    private int periodType = 0;
    private int currYear = 0;
    private int currPeriod = 0;
    private int bgPeriodType = 0;
    private String currOrgUnitNumber = null;
    private String currCurrencyNumber = null;
    private String currPeriodNumber = null;
    private String bgSchemeNumber = null;
    private String bgOrgNumber = null;
    private String curOrgTreeNum = "";
    private String curOrgGroupNumber = "";

    public String getCurOrgTreeNum() {
        return this.curOrgTreeNum;
    }

    public void setCurOrgTreeNum(String curOrgTreeNum) {
        this.curOrgTreeNum = curOrgTreeNum;
    }

    public String getCurOrgGroupNumber() {
        return this.curOrgGroupNumber;
    }

    public void setCurOrgGroupNumber(String curOrgGroupNumber) {
        this.curOrgGroupNumber = curOrgGroupNumber;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    public ICalculateContextProvider getProvider() {
        return this.provider;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setParams(SortedParameterArray params) {
        this.params = params;
    }

    public SortedParameterArray getParams() {
        return this.params;
    }

    public int getBgPeriodType() {
        return this.bgPeriodType;
    }

    public void setBgPeriodType(int bgPeriodType) {
        this.bgPeriodType = bgPeriodType;
    }

    public void initialize(String methodName, ICalculateContextProvider provider, Context ctx, SortedParameterArray params) {
        this.setMethodName(methodName);
        this.setProvider(provider);
        this.setContext(ctx);
        this.setParams(params);
    }

    private void checkBgCdParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            String orgTreeNum = null;
            String orgUnionNum = null;
            String schemeNum = null;
            String currencyNum = null;
            String startPeriodNum = null;
            String endPeriodNum = null;
            try {
                orgTreeNum = (String)((Variant)objs[0]).getValue();
                orgUnionNum = (String)((Variant)objs[1]).getValue();
                schemeNum = (String)((Variant)objs[2]).getValue();
                currencyNum = (String)((Variant)objs[5]).getValue();
                startPeriodNum = (String)((Variant)objs[6]).getValue();
                endPeriodNum = (String)((Variant)objs[7]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgTreeNum)) {
                objs[0] = new Variant((Object)this.getCurOrgTreeNum());
            }
            if (StringUtils.isEmpty((String)orgUnionNum)) {
                objs[1] = new Variant((Object)this.getCurOrgGroupNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[2] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[5] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (!StringUtils.isEmpty((String)startPeriodNum)) {
                try {
                    objs[6] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            } else {
                objs[6] = new Variant((Object)this.getCurrPeriodNumber());
            }
            if (!StringUtils.isEmpty((String)endPeriodNum)) {
                try {
                    objs[7] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)endPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
                continue;
            }
            objs[7] = new Variant((Object)this.getCurrPeriodNumber());
        }
    }

    private void initCheckParameter() {
        Object obj = null;
        IReportPropertyAdapter adapter = this.getProvider().getReportAdapter();
        obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String currOrgUnitNumber = (String)adapter.getReportProperty("Company.Number");
        String currCurrencyNumber = (String)adapter.getReportProperty("Currency.Number");
        String currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        String bgSchemeNumber = (String)adapter.getReportProperty("BG_SCHEME_NUMBER");
        String bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        String curOrgTreeNumber = (String)adapter.getReportProperty("CSLReport_OrgTree_Number");
        String curOrgGroupNumber = (String)adapter.getReportProperty("CSLReport_OrgUnit_Group");
        if (obj == null) {
            this.periodType = (Integer)adapter.getReportProperty("PeriodType");
            this.currYear = (Integer)adapter.getReportProperty("Report.Year");
            this.currPeriod = (Integer)adapter.getReportProperty("Report.Period");
        }
        this.setCurrCurrencyNumber(currCurrencyNumber);
        this.setCurrOrgUnitNumber(currOrgUnitNumber);
        this.setCurrPeriodNumber(currPeriodNumber);
        this.setBgOrgNumber(bgOrgNumber);
        this.setBgSchemeNumber(bgSchemeNumber);
        this.setCurOrgTreeNum(curOrgTreeNumber);
        this.setCurOrgGroupNumber(curOrgGroupNumber);
        this.setCurrPeriod(this.currPeriod);
        this.setCurrYear(this.currYear);
        this.setPeriodType(this.periodType);
        if (obj instanceof Integer) {
            int n = new Integer(obj.toString());
            this.setBgPeriodType(n);
        }
    }

    private void checkBgFormulaParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 7 && objs.length != 8) continue;
            String orgNum = null;
            String schemeNum = null;
            String currencyNum = null;
            String startPeriodNum = null;
            String endPeriodNum = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                currencyNum = (String)((Variant)objs[4]).getValue();
                startPeriodNum = (String)((Variant)objs[5]).getValue();
                endPeriodNum = (String)((Variant)objs[6]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[4] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (!StringUtils.isEmpty((String)startPeriodNum) && BgPeriodNVariableHelper.checkCanConvert((String)startPeriodNum)) {
                try {
                    objs[5] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)endPeriodNum) || !BgPeriodNVariableHelper.checkCanConvert((String)endPeriodNum)) continue;
            try {
                objs[6] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)endPeriodNum, (int)this.getBgPeriodType()));
                continue;
            }
            catch (BgFormException e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void checkBgRefBgTemplateParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 7) continue;
            String orgNum = null;
            String schemeNum = null;
            String PeriodNum = null;
            String currencyNumber = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                PeriodNum = (String)((Variant)objs[3]).getValue();
                currencyNumber = (String)((Variant)objs[4]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (!StringUtils.isEmpty((String)PeriodNum) && BgPeriodNVariableHelper.checkCanConvert((String)PeriodNum)) {
                try {
                    objs[3] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)PeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((String)currencyNumber)) continue;
            objs[4] = new Variant((Object)this.getCurrCurrencyNumber());
        }
    }

    private void checkBgRefBgFormParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 4) continue;
            String orgNum = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (!StringUtils.isEmpty((String)orgNum)) continue;
            objs[0] = new Variant((Object)this.getBgOrgNumber());
        }
    }

    private void checkBgActualExtaram(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 8) continue;
            String orgNum = null;
            String schemeNum = null;
            String currencyNum = null;
            String startPeriodNum = null;
            String endPeriodNum = null;
            String periodtype = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                currencyNum = (String)((Variant)objs[4]).getValue();
                startPeriodNum = (String)((Variant)objs[5]).getValue();
                endPeriodNum = (String)((Variant)objs[6]).getValue();
                periodtype = (String)((Variant)objs[7]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[4] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (!StringUtils.isEmpty((String)startPeriodNum) && BgPeriodNVariableHelper.checkCanConvert((String)startPeriodNum)) {
                try {
                    objs[5] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((String)endPeriodNum) && BgPeriodNVariableHelper.checkCanConvert((String)endPeriodNum)) {
                try {
                    objs[6] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)endPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((String)periodtype)) continue;
            objs[7] = "MONTH";
        }
    }

    private void checkBgDifferenceParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 8) continue;
            String orgNum = null;
            String schemeNum = (String)((Variant)objs[1]).getValue();
            String currencyNum = (String)((Variant)objs[4]).getValue();
            String startPeriodNum = (String)((Variant)objs[5]).getValue();
            String endPeriodNum = (String)((Variant)objs[6]).getValue();
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                currencyNum = (String)((Variant)objs[4]).getValue();
                startPeriodNum = (String)((Variant)objs[5]).getValue();
                endPeriodNum = (String)((Variant)objs[6]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[4] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (!StringUtils.isEmpty((String)startPeriodNum) && BgPeriodNVariableHelper.checkCanConvert((String)startPeriodNum)) {
                try {
                    objs[5] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)endPeriodNum) || !BgPeriodNVariableHelper.checkCanConvert((String)endPeriodNum)) continue;
            try {
                objs[6] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)endPeriodNum, (int)this.getBgPeriodType()));
                continue;
            }
            catch (BgFormException e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void checkBgGetDimeDataParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 9) continue;
            String orgNum = null;
            String schemeNum = null;
            String currencyNum = null;
            String startPeriodNum = null;
            String endPeriodNum = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                currencyNum = (String)((Variant)objs[5]).getValue();
                startPeriodNum = (String)((Variant)objs[6]).getValue();
                endPeriodNum = (String)((Variant)objs[7]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[5] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (!StringUtils.isEmpty((String)startPeriodNum)) {
                if (BgPeriodNVariableHelper.checkCanConvert((String)startPeriodNum)) {
                    try {
                        objs[6] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                    }
                    catch (BgFormException e) {
                        this.logger.error((Object)"", (Throwable)e);
                    }
                }
            } else {
                objs[6] = new Variant((Object)this.getCurrPeriodNumber());
            }
            if (!StringUtils.isEmpty((String)endPeriodNum)) {
                if (!BgPeriodNVariableHelper.checkCanConvert((String)endPeriodNum)) continue;
                try {
                    objs[7] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)endPeriodNum, (int)this.getBgPeriodType()));
                }
                catch (BgFormException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
                continue;
            }
            objs[7] = new Variant((Object)this.getCurrPeriodNumber());
        }
    }

    private void checkBgAvlBalFormulaParam(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Object[] objs = null;
        this.initCheckParameter();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            if (objs.length != 6) continue;
            String orgNum = null;
            String schemeNum = null;
            String currencyNum = null;
            String startPeriodNum = null;
            try {
                orgNum = (String)((Variant)objs[0]).getValue();
                schemeNum = (String)((Variant)objs[1]).getValue();
                currencyNum = (String)((Variant)objs[4]).getValue();
                startPeriodNum = (String)((Variant)objs[5]).getValue();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)orgNum)) {
                objs[0] = new Variant((Object)this.getBgOrgNumber());
            }
            if (StringUtils.isEmpty((String)schemeNum)) {
                objs[1] = new Variant((Object)this.getBgSchemeNumber());
            }
            if (StringUtils.isEmpty((String)currencyNum)) {
                objs[4] = new Variant((Object)this.getCurrCurrencyNumber());
            }
            if (StringUtils.isEmpty((String)startPeriodNum) || !BgPeriodNVariableHelper.checkCanConvert((String)startPeriodNum)) continue;
            try {
                objs[5] = new Variant((Object)BgPeriodNVariableHelper.getBgPeriodByN((String)this.getCurrPeriodNumber(), (String)startPeriodNum, (int)this.getBgPeriodType()));
                continue;
            }
            catch (BgFormException e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void checkParamaterCalculatorBefore() {
        String expreType = this.getMethodName();
        if (expreType.equalsIgnoreCase(bgFormulaStr) || expreType.equalsIgnoreCase(bgActualsStr) || expreType.equalsIgnoreCase(bgAdjustStr) || expreType.equalsIgnoreCase(bgBalanceStr)) {
            this.checkBgFormulaParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgAvlBalanceStr)) {
            this.checkBgAvlBalFormulaParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgRefBgFormStr)) {
            this.checkBgRefBgFormParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgRefBgTemplateStr)) {
            this.checkBgRefBgTemplateParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgActualExtStr)) {
            this.checkBgActualExtaram(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgDifferenceStr)) {
            this.checkBgDifferenceParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgGetDimeData)) {
            this.checkBgGetDimeDataParam(this.getParams());
        } else if (expreType.equalsIgnoreCase(bgCdStr)) {
            this.checkBgCdParam(this.getParams());
        }
    }

    @Override
    public void process() {
        this.checkParamaterCalculatorBefore();
        if (this.getMethodName().equalsIgnoreCase(bgFormulaStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgFormulaCalculator calculator = new BgFormulaCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgActualsStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgActualCalculator calculator = new BgActualCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgAdjustStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgAdjustCalculator calculator = new BgAdjustCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgBalanceStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgBalanceCalculator calculator = new BgBalanceCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgAvlBalanceStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgAvlBalCalculator calculator = new BgAvlBalCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgRefBgFormStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgRefFormCalculator calculator = new BgRefFormCalculator(this.getProvider(), this.getContext());
            calculator.execute(this.getParams());
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgRefBgTemplateStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgRefTemplateCalculator calculator = new BgRefTemplateCalculator(this.getProvider(), this.getContext());
            calculator.execute(this.getParams());
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgNAvlBalanceStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgNAvlBalCalculator calculator = new BgNAvlBalCalculator(this.getProvider(), this.getContext());
            int batchNum = 10000;
            int size = this.getParams().size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            SortedParameterArray parameColl = null;
            SortedParameterArray tmpParameColl = new SortedParameterArray();
            for (int index = 0; index < count; ++index) {
                parameColl = new SortedParameterArray();
                for (int k = 0; k < batchNum && pos < size; ++k, ++pos) {
                    parameColl.append((Object)this.getParams().getParameter(pos));
                }
                calculator.execute(parameColl);
                tmpParameColl.appendAll((ObjectArray)parameColl);
            }
            this.getParams().clear();
            this.getParams().appendAll((ObjectArray)tmpParameColl);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgExecuteAnalyseStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgExecuteAnalyseCalculator calculator = new BgExecuteAnalyseCalculator(this.getProvider(), this.getContext());
            calculator.execute(this.getParams());
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(getOrgAttr)) {
            SortedParameterArray badParameter = this.checkParamesOfTypeVal();
            BgGetOrgAttrCalculator calculator = new BgGetOrgAttrCalculator(this.getProvider(), this.getContext());
            calculator.execute(this.getParams());
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgActualExtStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgActualExt calculator = new BgActualExt(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgDifferenceStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgDifferenceCalculator calculator = new BgDifferenceCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgGetDimeData)) {
            SortedParameterArray badParameter = this.checkParames();
            BgGetDimeDataCalculator calculator = new BgGetDimeDataCalculator(this.getProvider(), this.getContext());
            HashMap<Parameter, List<Parameter>> sumExpMap = new HashMap<Parameter, List<Parameter>>();
            SortedParameterArray tempParams = BgNFSHelper.checkParameter(this.getParams(), sumExpMap);
            calculator.execute(tempParams);
            BgNFSHelper.gatherResult(sumExpMap);
            this.getParams().appendAll((ObjectArray)badParameter);
        } else if (this.getMethodName().equalsIgnoreCase(bgCdStr)) {
            SortedParameterArray badParameter = this.checkParames();
            BgCdCalculator calculator = new BgCdCalculator(this.getProvider(), this.getContext());
            calculator.execute(this.getParams());
            this.getParams().appendAll((ObjectArray)badParameter);
        } else {
            String string = _BAD_FUNCTION_ + this.getMethodName();
            for (int i = 0; i < this.getParams().size(); ++i) {
                this.getParams().getParameter(i).setValue((Object)string);
            }
        }
    }

    public int getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    public int getCurrYear() {
        return this.currYear;
    }

    public void setCurrYear(int currYear) {
        this.currYear = currYear;
    }

    public int getCurrPeriod() {
        return this.currPeriod;
    }

    public void setCurrPeriod(int currPeriod) {
        this.currPeriod = currPeriod;
    }

    public String getCurrOrgUnitNumber() {
        return this.currOrgUnitNumber;
    }

    public void setCurrOrgUnitNumber(String currOrgUnitNumber) {
        this.currOrgUnitNumber = currOrgUnitNumber;
    }

    public String getCurrCurrencyNumber() {
        return this.currCurrencyNumber;
    }

    public void setCurrCurrencyNumber(String currCurrencyNumber) {
        this.currCurrencyNumber = currCurrencyNumber;
    }

    public String getCurrPeriodNumber() {
        return this.currPeriodNumber;
    }

    public void setCurrPeriodNumber(String currPeriodNumber) {
        this.currPeriodNumber = currPeriodNumber;
    }

    public String getBgSchemeNumber() {
        return this.bgSchemeNumber;
    }

    public void setBgSchemeNumber(String bgSchemeNumber) {
        this.bgSchemeNumber = bgSchemeNumber;
    }

    public String getBgOrgNumber() {
        if (StringUtils.isEmpty((String)this.bgOrgNumber)) {
            return this.currOrgUnitNumber;
        }
        return this.bgOrgNumber;
    }

    public void setBgOrgNumber(String bgOrgNumber) {
        this.bgOrgNumber = bgOrgNumber;
    }

    private SortedParameterArray checkParames() {
        int j;
        int i;
        SortedParameterArray badParameter = new SortedParameterArray();
        Parameter parameter = null;
        Parameter oldParameter = null;
        Object[] args = null;
        Object value = null;
        for (i = 0; i < this.getParams().size(); ++i) {
            parameter = this.getParams().getParameter(i);
            args = parameter.getArgs();
            try {
                for (j = 0; j < args.length; ++j) {
                    if (((Variant)args[j]).getValue() instanceof String || ((Variant)args[j]).getValue() instanceof BigDecimal) continue;
                    throw new Exception("");
                }
                continue;
            }
            catch (Exception e) {
                SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)e);
                parameter.setValue((Object)exception);
                badParameter.append((Object)parameter);
            }
        }
        for (i = 0; i < badParameter.size(); ++i) {
            parameter = badParameter.getParameter(i);
            if (parameter.getUID() == null) continue;
            for (j = 0; j < this.getParams().size(); ++j) {
                oldParameter = this.getParams().getParameter(j);
                if (parameter.getUID().intValue() != oldParameter.getUID().intValue()) continue;
                this.getParams().removeByPos(j);
            }
        }
        return badParameter;
    }

    private SortedParameterArray checkParamesOfTypeVal() {
        int j;
        int i;
        SortedParameterArray badParameter = new SortedParameterArray();
        Parameter parameter = null;
        Parameter oldParameter = null;
        Object[] args = null;
        Object value = null;
        for (i = 0; i < this.getParams().size(); ++i) {
            parameter = this.getParams().getParameter(i);
            args = parameter.getArgs();
            try {
                for (j = 0; j < args.length; ++j) {
                    if (((Variant)args[j]).getValue() instanceof String || ((Variant)args[j]).getValue() instanceof BigDecimal || ((Variant)args[j]).getValue() instanceof Boolean) continue;
                    throw new Exception("");
                }
                continue;
            }
            catch (Exception e) {
                SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)e);
                parameter.setValue((Object)exception);
                badParameter.append((Object)parameter);
            }
        }
        for (i = 0; i < badParameter.size(); ++i) {
            parameter = badParameter.getParameter(i);
            if (parameter.getUID() == null) continue;
            for (j = 0; j < this.getParams().size(); ++j) {
                oldParameter = this.getParams().getParameter(j);
                if (parameter.getUID().intValue() != oldParameter.getUID().intValue()) continue;
                this.getParams().removeByPos(j);
            }
        }
        return badParameter;
    }
}

