/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlFormulaInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseCalculator;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgExecuteAnalyseAvlAddupCalculator
extends BgExecuteAnalyseAvlCalculator {
    private static Logger logger = Logger.getLogger(BgExecuteAnalyseAvlAddupCalculator.class);
    private List budgetValueList = new ArrayList();
    private List actualValueList = new ArrayList();

    public BgExecuteAnalyseAvlAddupCalculator(BgExecuteAnalyseCalculator calculator) {
        super(calculator);
    }

    public List getBudgetValueList() {
        return this.budgetValueList;
    }

    public List getActualValueList() {
        return this.actualValueList;
    }

    @Override
    public void calculator() throws Exception {
        this.calculatorByBudgetValue();
        this.calculatorByActualValue();
        this.calculatorBalanceValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getBudgetValueList().clear();
        this.getActualValueList().clear();
    }

    protected void calculatorByBudgetValue() throws Exception {
        this.getBudgetValueList().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgAclAddupInfo bgAclAddupInfo = null;
        BigDecimal _value = null;
        int _bgPeriodType = 0;
        String _bgItemNumber = null;
        String _bgPeriodNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FBgValue, i.FKey, p.FNumber, p.FPeriodType, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FBeginDate >= ? and FEndDate <= ?)or (FBeginDate <= ? and FEndDate >= ?)or (FBeginDate <= ? and FEndDate >= ?) ) ").append("and d.FBgValue <> 0 and f.FState IN (?, ?, ?)");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        java.util.Date _beginDate = bgSchemeInfo.getDateFrom();
        java.util.Date _endDate = bgSchemeInfo.getDateTo();
        Date beginDate = new Date(_beginDate.getTime());
        Date endDate = new Date(_endDate.getTime());
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setDate(3, beginDate);
            pstmt.setDate(4, endDate);
            pstmt.setDate(5, beginDate);
            pstmt.setDate(6, beginDate);
            pstmt.setDate(7, endDate);
            pstmt.setDate(8, endDate);
            pstmt.setInt(9, 2);
            pstmt.setInt(10, 20);
            pstmt.setInt(11, 43);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodNumber = rst.getString(3);
                _bgPeriodType = rst.getInt(4);
                _bgElementNumber = rst.getString(5);
                _currencyNumber = rst.getString(6);
                bgAclAddupInfo = new BgAclAddupInfo();
                bgAclAddupInfo.setBgItemNumber(_bgItemNumber);
                bgAclAddupInfo.setBgPeriodNumber(_bgPeriodNumber);
                bgAclAddupInfo.setBgPeriodType(_bgPeriodType);
                bgAclAddupInfo.setBgElementNumber(_bgElementNumber);
                bgAclAddupInfo.setCurrencyNumber(_currencyNumber);
                bgAclAddupInfo.setValue(_value);
                this.getBudgetValueList().add(bgAclAddupInfo);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorByActualValue() throws Exception {
        this.getActualValueList().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgAclAddupInfo bgAclAddupInfo = null;
        int _bgPeriodType = 0;
        BigDecimal _value = null;
        String _bgItemNumber = null;
        String _bgPeriodNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FBizActual, i.FKey, p.FNumber, p.FPeriodType, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FBeginDate >= ? and FEndDate <= ?)or (FBeginDate <= ? and FEndDate >= ?)or (FBeginDate <= ? and FEndDate >= ?) ) ").append("and d.FBizActual <> 0 and f.FState IN (?, ?, ?)");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        java.util.Date _beginDate = bgSchemeInfo.getDateFrom();
        java.util.Date _endDate = bgSchemeInfo.getDateTo();
        Date beginDate = new Date(_beginDate.getTime());
        Date endDate = new Date(_endDate.getTime());
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setDate(3, beginDate);
            pstmt.setDate(4, endDate);
            pstmt.setDate(5, beginDate);
            pstmt.setDate(6, beginDate);
            pstmt.setDate(7, endDate);
            pstmt.setDate(8, endDate);
            pstmt.setInt(9, 2);
            pstmt.setInt(10, 20);
            pstmt.setInt(11, 43);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodNumber = rst.getString(3);
                _bgPeriodType = rst.getInt(4);
                _bgElementNumber = rst.getString(5);
                _currencyNumber = rst.getString(6);
                bgAclAddupInfo = new BgAclAddupInfo();
                bgAclAddupInfo.setBgItemNumber(_bgItemNumber);
                bgAclAddupInfo.setBgPeriodNumber(_bgPeriodNumber);
                bgAclAddupInfo.setBgPeriodType(_bgPeriodType);
                bgAclAddupInfo.setBgElementNumber(_bgElementNumber);
                bgAclAddupInfo.setCurrencyNumber(_currencyNumber);
                bgAclAddupInfo.setValue(_value);
                this.getActualValueList().add(bgAclAddupInfo);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorBalanceValue() throws Exception {
        Map.Entry _entry2 = null;
        BgExecuteAnalyseAvlFormulaInfo formula = null;
        BgAclAddupInfo info = null;
        HashMap formulaMap = new HashMap();
        int bgPeriodType = 0;
        String formulaStr = null;
        String _key = null;
        String[] parameter = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        for (Map.Entry _entry2 : this.getFormulaMap().entrySet()) {
            int i;
            _bValue = BgNConstants.ZERO;
            _aValue = BgNConstants.ZERO;
            formulaStr = (String)_entry2.getKey();
            formula = (BgExecuteAnalyseAvlFormulaInfo)_entry2.getValue();
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
            if (parameter == null) continue;
            bgPeriodType = BgNPeriodHelper.parserBgPeriodType(parameter[1]);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            int in = this.getBudgetValueList().size();
            for (i = 0; i < in; ++i) {
                info = (BgAclAddupInfo)this.getBudgetValueList().get(i);
                if (info.getBgPeriodType() != bgPeriodType || !info.getKey().equals(_key) || info.getBgPeriodNumber().compareTo(parameter[1]) > 0) continue;
                _bValue = _bValue.add(info.getValue());
            }
            formula.setBudgetValue(_bValue);
            in = this.getActualValueList().size();
            for (i = 0; i < in; ++i) {
                info = (BgAclAddupInfo)this.getActualValueList().get(i);
                if (info.getBgPeriodType() != bgPeriodType || !info.getKey().equals(_key) || info.getBgPeriodNumber().compareTo(parameter[1]) > 0) continue;
                _aValue = _aValue.add(info.getValue());
            }
            formula.setActualValue(_aValue);
            formula.calculator();
        }
    }

    private class BgAclAddupInfo {
        private String key = null;
        private String bgItemNumber = null;
        private String bgPeriodNumber = null;
        private int bgPeriodType = 0;
        private String bgElementNumber = null;
        private String currencyNumber = null;
        private BigDecimal value = null;

        private BgAclAddupInfo() {
        }

        public void setBgItemNumber(String bgItemNumber) {
            this.bgItemNumber = bgItemNumber;
        }

        public String getBgItemNumber() {
            return this.bgItemNumber;
        }

        public void setBgPeriodNumber(String bgPeriodNumber) {
            this.bgPeriodNumber = bgPeriodNumber;
        }

        public String getBgPeriodNumber() {
            return this.bgPeriodNumber;
        }

        public void setBgPeriodType(int bgPeriodType) {
            this.bgPeriodType = bgPeriodType;
        }

        public int getBgPeriodType() {
            return this.bgPeriodType;
        }

        public void setBgElementNumber(String bgElementNumber) {
            this.bgElementNumber = bgElementNumber;
        }

        public String getBgElementNumber() {
            return this.bgElementNumber;
        }

        public void setCurrencyNumber(String currencyNumber) {
            this.currencyNumber = currencyNumber;
        }

        public String getCurrencyNumber() {
            return this.currencyNumber;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String getKey() {
            if (this.key == null) {
                this.key = new StringBuffer(this.bgItemNumber).append("!").append(this.bgElementNumber).append("!").append(this.currencyNumber).toString();
            }
            return this.key;
        }
    }
}

