/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlFormulaInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseCalculator;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgExecuteAnalyseAvlCurrYearCalculator
extends BgExecuteAnalyseAvlCalculator {
    private static Logger logger = Logger.getLogger(BgExecuteAnalyseAvlCurrYearCalculator.class);
    private Map budgetValueMap = new HashMap();
    private List actualValueList = new ArrayList();

    public BgExecuteAnalyseAvlCurrYearCalculator(BgExecuteAnalyseCalculator calculator) {
        super(calculator);
    }

    public Map getBudgetValueMap() {
        return this.budgetValueMap;
    }

    public List getActualValueList() {
        return this.actualValueList;
    }

    @Override
    public void calculator() throws Exception {
        this.calculatorByBudgetValue();
        this.calculatorByActualValue();
        this.calculatorBalanceValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getBudgetValueMap().clear();
        this.getActualValueList().clear();
    }

    protected void calculatorByBudgetValue() throws Exception {
        this.getBudgetValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        int _bgPeriodType = 0;
        int _year = 0;
        String _bgItemNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(d.FBgValue), i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FYear >= ? and FYear <= ?)) ").append("and d.FBgValue <> 0 and f.FState IN (?, ?, ?) ").append("group by i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        Date _beginDate = bgSchemeInfo.getDateFrom();
        Date _endDate = bgSchemeInfo.getDateTo();
        int beginYear = this.getCalendar().getCurrentlyYear(_beginDate);
        int endYear = this.getCalendar().getCurrentlyYear(_endDate);
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setInt(3, beginYear);
            pstmt.setInt(4, endYear);
            pstmt.setInt(5, 2);
            pstmt.setInt(6, 20);
            pstmt.setInt(7, 43);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodType = rst.getInt(3);
                _year = rst.getInt(4);
                _bgElementNumber = rst.getString(5);
                _currencyNumber = rst.getString(6);
                _key = new StringBuffer(_bgItemNumber).append("!").append(_bgPeriodType).append("!").append(_year).append("!").append(_bgElementNumber).append("!").append(_currencyNumber).toString();
                this.getBudgetValueMap().put(_key, _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorByActualValue() throws Exception {
        this.getActualValueList().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgAclCurrYearInfo currYearInfo = null;
        int _bgPeriodType = 0;
        int _year = 0;
        BigDecimal _value = null;
        String _bgItemNumber = null;
        String _bgPeriodNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FBizActual, i.FKey, p.FNumber, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FYear >= ? and FYear <= ?)) ").append("and d.FBizActual <> 0 and f.FState IN (?, ?, ?)");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        Date _beginDate = bgSchemeInfo.getDateFrom();
        Date _endDate = bgSchemeInfo.getDateTo();
        int beginYear = this.getCalendar().getCurrentlyYear(_beginDate);
        int endYear = this.getCalendar().getCurrentlyYear(_endDate);
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setInt(3, beginYear);
            pstmt.setInt(4, endYear);
            pstmt.setInt(5, 2);
            pstmt.setInt(6, 20);
            pstmt.setInt(7, 43);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodNumber = rst.getString(3);
                _bgPeriodType = rst.getInt(4);
                _year = rst.getInt(5);
                _bgElementNumber = rst.getString(6);
                _currencyNumber = rst.getString(7);
                currYearInfo = new BgAclCurrYearInfo();
                currYearInfo.setBgItemNumber(_bgItemNumber);
                currYearInfo.setBgPeriodNumber(_bgPeriodNumber);
                currYearInfo.setBgPeriodType(_bgPeriodType);
                currYearInfo.setYear(_year);
                currYearInfo.setBgElementNumber(_bgElementNumber);
                currYearInfo.setCurrencyNumber(_currencyNumber);
                currYearInfo.setValue(_value);
                this.getActualValueList().add(currYearInfo);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorBalanceValue() throws Exception {
        Map.Entry _entry2 = null;
        BgAclCurrYearInfo info = null;
        BgExecuteAnalyseAvlFormulaInfo formula = null;
        HashMap formulaMap = new HashMap();
        int bgPeriodType = 0;
        int year = 0;
        String formulaStr = null;
        String _key = null;
        String[] parameter = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        for (Map.Entry _entry2 : this.getFormulaMap().entrySet()) {
            _bValue = BgNConstants.ZERO;
            _aValue = BgNConstants.ZERO;
            formulaStr = (String)_entry2.getKey();
            formula = (BgExecuteAnalyseAvlFormulaInfo)_entry2.getValue();
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
            if (parameter == null) continue;
            bgPeriodType = BgNPeriodHelper.parserBgPeriodType(parameter[1]);
            year = BgNPeriodHelper.parserBgPeriodYear(parameter[1]);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(bgPeriodType).append("!").append(year).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            if (this.getBudgetValueMap().containsKey(_key)) {
                _bValue = (BigDecimal)this.getBudgetValueMap().get(_key);
            }
            formula.setBudgetValue(_bValue);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            int in = this.getActualValueList().size();
            for (int i = 0; i < in; ++i) {
                info = (BgAclCurrYearInfo)this.getActualValueList().get(i);
                if (info.getBgPeriodType() != bgPeriodType || !info.getKey().equals(_key) || info.getBgPeriodNumber().compareTo(parameter[1]) > 0 || info.getYear() != year) continue;
                _aValue = _aValue.add(info.getValue());
            }
            formula.setActualValue(_aValue);
            formula.calculator();
        }
    }

    private class BgAclCurrYearInfo {
        private String key = null;
        private String bgItemNumber = null;
        private String bgPeriodNumber = null;
        private int bgPeriodType = 0;
        private int year = 0;
        private String bgElementNumber = null;
        private String currencyNumber = null;
        private BigDecimal value = null;

        private BgAclCurrYearInfo() {
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public void setBgItemNumber(String bgItemNumber) {
            this.bgItemNumber = bgItemNumber;
        }

        public String getBgItemNumber() {
            return this.bgItemNumber;
        }

        public void setBgPeriodNumber(String bgPeriodNumber) {
            this.bgPeriodNumber = bgPeriodNumber;
        }

        public String getBgPeriodNumber() {
            return this.bgPeriodNumber;
        }

        public void setBgPeriodType(int bgPeriodType) {
            this.bgPeriodType = bgPeriodType;
        }

        public int getBgPeriodType() {
            return this.bgPeriodType;
        }

        public void setBgElementNumber(String bgElementNumber) {
            this.bgElementNumber = bgElementNumber;
        }

        public String getBgElementNumber() {
            return this.bgElementNumber;
        }

        public void setCurrencyNumber(String currencyNumber) {
            this.currencyNumber = currencyNumber;
        }

        public String getCurrencyNumber() {
            return this.currencyNumber;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String getKey() {
            if (this.key == null) {
                this.key = new StringBuffer(this.bgItemNumber).append("!").append(this.bgElementNumber).append("!").append(this.currencyNumber).toString();
            }
            return this.key;
        }
    }
}

