/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlAddupCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlCurrPeriodCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlCurrYearCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlFormulaInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgExecuteAnalyseAvlGrossCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.IBgCalculator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgExecuteAnalyseCalculator
implements IBgCalculator {
    private static final Logger logger = Logger.getLogger(BgExecuteAnalyseCalculator.class);
    private CalendarHelper calendar = new CalendarHelper();
    private ICalculateContextProvider provider;
    private Context ctx = null;
    private List bgFormulaList = new ArrayList();
    private Map expressMap = new HashMap();
    private Map orgUnitMap = new HashMap();
    private Map bgSchemeMap = new HashMap();
    private Map bgSchemeKeyMap = new HashMap();
    private Map bgPeriodCacheMap = new HashMap();
    private Map bgDataGroupNoMap = new HashMap();
    private Map formulaMap = new HashMap();
    private static final int batchSize = 250;
    public static final String _BAD_FUNCTION_ = "#BAD FUNCTION ";

    public BgExecuteAnalyseCalculator() {
    }

    public BgExecuteAnalyseCalculator(ICalculateContextProvider provider, Context ctx) {
        this.setProvider(provider);
        this.setCtx(ctx);
    }

    public CalendarHelper getCalendar() {
        return this.calendar;
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    public ICalculateContextProvider getProvider() {
        return this.provider;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public List getBgFormulaList() {
        return this.bgFormulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map getBgSchemeMap() {
        return this.bgSchemeMap;
    }

    public Map getBgSchemeKeyMap() {
        return this.bgSchemeKeyMap;
    }

    public Map getBgPeriodCacheMap() {
        return this.bgPeriodCacheMap;
    }

    public Map getBgDataGroupNoMap() {
        return this.bgDataGroupNoMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public static int getBatchSize() {
        return 250;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgAvlBalance start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initCtrlInfo();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize ctrl info succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgAvlBalance finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _bgPeriodNumber = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Map<String, BgExecuteAnalyseAvlFormulaInfo> _bgFormulaMap = null;
        BgExecuteAnalyseAvlFormulaInfo _bgFormula = null;
        BgSchemeInfo bgSchemeInfo = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            if (_parmeter.getValue() != null && _parmeter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _bgPeriodNumber = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_bgPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgExecuteAnalyseAvlFormulaInfo(this, _parmeter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getBgFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getBgFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgExecuteAnalyseAvlFormulaInfo)this.getBgFormulaList().get(j);
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            bgSchemeInfo = (BgSchemeInfo)this.getBgSchemeKeyMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgSchemeId = bgSchemeInfo.getId().toString();
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaMap = (Map)this.getExpressMap().get(_key);
            } else {
                _bgFormulaMap = new HashMap();
                this.getExpressMap().put(_key, _bgFormulaMap);
            }
            _bgFormulaMap.put(_bgFormula.getBgFormula(), _bgFormula);
        }
    }

    protected void getOrgUnitInfo(Set orgUnitNumberSet) throws Exception {
        if (orgUnitNumberSet == null || orgUnitNumberSet.isEmpty()) {
            return;
        }
        ArrayList _orgUnitNumberList = new ArrayList();
        _orgUnitNumberList.addAll(orgUnitNumberSet);
        int size = _orgUnitNumberList.size();
        int count = (size - 1) / BgExecuteAnalyseCalculator.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fnumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FNumber FROM T_ORG_CostCenter WHERE FNumber IN (");
        for (int i = 1; i < BgExecuteAnalyseCalculator.getBatchSize(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= BgExecuteAnalyseCalculator.getBatchSize()) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_orgUnitNumberList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fnumber = rst.getString("FNumber");
                    this.getOrgUnitMap().put(_fnumber, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _orgUnitNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _orgUnitNumberList.clear();
    }

    protected void getBgSchemeInfo(Set bgSchemeNumberSet) throws Exception {
        if (bgSchemeNumberSet == null || bgSchemeNumberSet.isEmpty()) {
            return;
        }
        ArrayList _bgSchemeNumberList = new ArrayList();
        _bgSchemeNumberList.addAll(bgSchemeNumberSet);
        int batchSize = 25;
        int tmp = 0;
        int size = _bgSchemeNumberList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fOrgNumber = null;
        String _fBgSchemeNumber = null;
        String _key = null;
        String[] _tmpStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT S.FID, S.FNumber, S.FOrgUnitId, B.FNumber FOrgUnitNumber, S.FDateFrom, S.FDateTo FROM T_BG_BgScheme S LEFT JOIN T_ORG_CostCenter B ON S.FOrgUnitId = B.FID WHERE ");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("(B.FNumber = ? and S.FNumber = ?) or ");
        }
        sql.append("(B.FNumber = ? and S.FNumber = ?)");
        BgSchemeInfo bgSchemeInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    tmp = x * 2;
                    if (pos < size) {
                        _key = (String)_bgSchemeNumberList.get(pos);
                        _tmpStr = _key.split("!");
                        pstmt.setString(tmp - 1, _tmpStr[0]);
                        pstmt.setString(tmp, _tmpStr[1]);
                    } else {
                        pstmt.setString(tmp - 1, "#");
                        pstmt.setString(tmp, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fOrgNumber = rst.getString("FOrgUnitNumber");
                    _fBgSchemeNumber = rst.getString("FNumber");
                    _key = _fOrgNumber + "!" + _fBgSchemeNumber;
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)_fid));
                    bgSchemeInfo.setNumber(_fBgSchemeNumber);
                    bgSchemeInfo.setDateFrom((Date)rst.getDate("FDateFrom"));
                    bgSchemeInfo.setDateTo((Date)rst.getDate("FDateTo"));
                    this.getBgSchemeMap().put(_fid, bgSchemeInfo);
                    this.getBgSchemeKeyMap().put(_key, bgSchemeInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgSchemeNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _bgSchemeNumberList.clear();
    }

    protected void initCtrlInfo() throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstCtrl = null;
        ResultSet rst = null;
        Map _bgFormulaMap = null;
        Set _bgDataGroupNoSet = null;
        ArrayList<String> _bgFormulaList = new ArrayList<String>();
        ArrayList<String> _bgDataGroupNoList = new ArrayList<String>();
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        Map.Entry _entry2 = null;
        Map.Entry _fEntry2 = null;
        boolean isControl = false;
        boolean isGroupCtrl = false;
        String bgDataGroupCtrlNo = null;
        int ctrlType = 10;
        boolean isFlexible = false;
        BigDecimal flexibleParam = null;
        boolean hasGroupCtrl = false;
        int size = 0;
        int count = 0;
        int pos = 0;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String _osIdKey = null;
        String _osCtrlKey = null;
        String[] _keyStr = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer ctrl = new StringBuffer();
        sql.append("SELECT FFormula, FBgValue, FBizActual, ").append("FIsControl, FIsGroupCtrl, FGroupNo, FCtrlType, FIsFlexible, FFlexParam FROM T_BG_BgData a inner join t_BG_BgForm b on a.fbgformid = b.fid ").append("WHERE  b.FState <> 1 and a.FOrgUnitId = ? AND a.FBgSchemeId = ? AND FFormula IN (");
        ctrl.append("SELECT FFormula, FBgValue, FBizActual, ").append("FIsControl, FIsGroupCtrl, FGroupNo, FCtrlType, FIsFlexible, FFlexParam FROM T_BG_BgData a inner join t_BG_BgForm b on a.fbgformid = b.fid ").append("WHERE  b.FState <> 1 and a.FOrgUnitId = ? AND a.FBgSchemeId = ? AND FIsGroupCtrl = 1 AND FGroupNo IN (");
        for (int i = 1; i < BgExecuteAnalyseCalculator.getBatchSize(); ++i) {
            sql.append("?, ");
            ctrl.append("?, ");
        }
        sql.append("?)");
        ctrl.append("?)");
        BgExecuteAnalyseAvlFormulaInfo _bgFormula = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstCtrl = conn.prepareStatement(ctrl.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _osIdKey = (String)_entry2.getKey();
                _bgFormulaMap = (Map)_entry2.getValue();
                _bgFormulaList.clear();
                for (Map.Entry _fEntry2 : _bgFormulaMap.entrySet()) {
                    _formulaStr = (String)_fEntry2.getKey();
                    _bgFormula = (BgExecuteAnalyseAvlFormulaInfo)_fEntry2.getValue();
                    _bgFormulaList.add(_formulaStr);
                }
                hasGroupCtrl = false;
                _bgDataGroupNoList.clear();
                _keyStr = _osIdKey.split("!");
                _orgUnitId = _keyStr[0];
                _bgSchemeId = _keyStr[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / BgExecuteAnalyseCalculator.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < BgExecuteAnalyseCalculator.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _formulaStr = rst.getString("FFormula");
                        bValue = rst.getBigDecimal("FBgValue");
                        aValue = rst.getBigDecimal("FBizActual");
                        isControl = rst.getBoolean("FIsControl");
                        isGroupCtrl = rst.getBoolean("FIsGroupCtrl");
                        bgDataGroupCtrlNo = rst.getString("FGroupNo");
                        ctrlType = rst.getInt("FCtrlType");
                        isFlexible = rst.getBoolean("FIsFlexible");
                        flexibleParam = rst.getBigDecimal("FFlexParam");
                        if (isGroupCtrl) {
                            hasGroupCtrl = true;
                            _osCtrlKey = _osIdKey + "!" + bgDataGroupCtrlNo;
                            if (!this.getBgDataGroupNoMap().containsKey(_osCtrlKey)) {
                                this.getBgDataGroupNoMap().put(_osCtrlKey, new HashSet());
                                _bgDataGroupNoList.add(bgDataGroupCtrlNo);
                            }
                        }
                        _bgFormula = (BgExecuteAnalyseAvlFormulaInfo)_bgFormulaMap.get(_formulaStr);
                        _bgFormula.setBudgetValue(bValue);
                        _bgFormula.setActualValue(aValue);
                        _bgFormula.setControl(isControl);
                        _bgFormula.setGroupCtrl(isGroupCtrl);
                        _bgFormula.setBgDataGroupCtrlNo(bgDataGroupCtrlNo);
                        _bgFormula.setCtrlType(ctrlType);
                        _bgFormula.setFlexible(isFlexible);
                        _bgFormula.setFlexibleParam(flexibleParam);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (!hasGroupCtrl) continue;
                    pos = 0;
                    size = _bgDataGroupNoList.size();
                    count = (size - 1) / BgExecuteAnalyseCalculator.getBatchSize() + 1;
                    for (int _index = 0; _index < count; ++_index) {
                        pstCtrl.setString(1, _orgUnitId);
                        pstCtrl.setString(2, _bgSchemeId);
                        int x2 = 3;
                        while (x2 < BgExecuteAnalyseCalculator.getBatchSize() + 3) {
                            if (pos < size) {
                                pstCtrl.setString(x2, (String)_bgDataGroupNoList.get(pos));
                            } else {
                                pstCtrl.setString(x2, "#");
                            }
                            ++x2;
                            ++pos;
                        }
                        rst = pstCtrl.executeQuery();
                        while (rst.next()) {
                            _formulaStr = rst.getString("FFormula");
                            bValue = rst.getBigDecimal("FBgValue");
                            aValue = rst.getBigDecimal("FBizActual");
                            isControl = rst.getBoolean("FIsControl");
                            isGroupCtrl = rst.getBoolean("FIsGroupCtrl");
                            bgDataGroupCtrlNo = rst.getString("FGroupNo");
                            ctrlType = rst.getInt("FCtrlType");
                            isFlexible = rst.getBoolean("FIsFlexible");
                            flexibleParam = rst.getBigDecimal("FFlexParam");
                            _bgFormula = new BgExecuteAnalyseAvlFormulaInfo(this, null);
                            _bgFormula.setOrgUnitId(_orgUnitId);
                            _bgFormula.setBgSchemeId(_bgSchemeId);
                            _bgFormula.setBgFormula(_formulaStr);
                            _bgFormula.setBudgetValue(bValue);
                            _bgFormula.setActualValue(aValue);
                            _bgFormula.setControl(isControl);
                            _bgFormula.setGroupCtrl(isGroupCtrl);
                            _bgFormula.setBgDataGroupCtrlNo(bgDataGroupCtrlNo);
                            _bgFormula.setCtrlType(ctrlType);
                            _bgFormula.setFlexible(isFlexible);
                            _bgFormula.setFlexibleParam(flexibleParam);
                            _osCtrlKey = _osIdKey + "!" + bgDataGroupCtrlNo;
                            _bgDataGroupNoSet = (Set)this.getBgDataGroupNoMap().get(_osCtrlKey);
                            _bgDataGroupNoSet.add(_bgFormula);
                            if (_bgFormulaMap.containsKey(_formulaStr)) continue;
                            _bgFormulaMap.put(_formulaStr, _bgFormula);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculate() throws Exception {
        String osIdKey = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String formulaStr = null;
        String[] _tmpStrs = null;
        Map.Entry _entry2 = null;
        Map.Entry _fEntry2 = null;
        Map bgFormulaMap = null;
        HashMap<String, BgExecuteAnalyseAvlFormulaInfo> addupMap = new HashMap<String, BgExecuteAnalyseAvlFormulaInfo>();
        HashMap<String, BgExecuteAnalyseAvlFormulaInfo> grossMap = new HashMap<String, BgExecuteAnalyseAvlFormulaInfo>();
        HashMap<String, BgExecuteAnalyseAvlFormulaInfo> currYearMap = new HashMap<String, BgExecuteAnalyseAvlFormulaInfo>();
        HashMap<String, BgExecuteAnalyseAvlFormulaInfo> currPeriodMap = new HashMap<String, BgExecuteAnalyseAvlFormulaInfo>();
        BgExecuteAnalyseAvlFormulaInfo formula = null;
        BgExecuteAnalyseAvlAddupCalculator addupCalculator = new BgExecuteAnalyseAvlAddupCalculator(this);
        BgExecuteAnalyseAvlCurrPeriodCalculator currPeriodCalculator = new BgExecuteAnalyseAvlCurrPeriodCalculator(this);
        BgExecuteAnalyseAvlCurrYearCalculator currYearCalculator = new BgExecuteAnalyseAvlCurrYearCalculator(this);
        BgExecuteAnalyseAvlGrossCalculator grossCalculator = new BgExecuteAnalyseAvlGrossCalculator(this);
        for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
            osIdKey = (String)_entry2.getKey();
            bgFormulaMap = (Map)_entry2.getValue();
            _tmpStrs = osIdKey.split("!");
            orgUnitId = _tmpStrs[0];
            bgSchemeId = _tmpStrs[1];
            addupMap.clear();
            currPeriodMap.clear();
            currYearMap.clear();
            grossMap.clear();
            for (Map.Entry _fEntry2 : bgFormulaMap.entrySet()) {
                formulaStr = (String)_fEntry2.getKey();
                formula = (BgExecuteAnalyseAvlFormulaInfo)_fEntry2.getValue();
                int bgPeriodType = BgNPeriodHelper.parserBgPeriodType(formula.getBgPeriodNumber());
                if (bgPeriodType == 8) {
                    currPeriodMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 11) {
                    addupMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 10) {
                    currPeriodMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 20) {
                    currYearMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() == 12) {
                    grossMap.put(formulaStr, formula);
                    continue;
                }
                if (formula.getCtrlType() != -1) continue;
                currPeriodMap.put(formulaStr, formula);
            }
            if (!addupMap.isEmpty()) {
                addupCalculator.setOrgUnitId(orgUnitId);
                addupCalculator.setBgSchemeId(bgSchemeId);
                addupCalculator.setFormulaMap(addupMap);
                try {
                    ((BgExecuteAnalyseAvlCalculator)addupCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    addupMap.clear();
                }
            }
            if (!currPeriodMap.isEmpty()) {
                currPeriodCalculator.setOrgUnitId(orgUnitId);
                currPeriodCalculator.setBgSchemeId(bgSchemeId);
                currPeriodCalculator.setFormulaMap(currPeriodMap);
                try {
                    ((BgExecuteAnalyseAvlCalculator)currPeriodCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    currPeriodMap.clear();
                }
            }
            if (!currYearMap.isEmpty()) {
                currYearCalculator.setOrgUnitId(orgUnitId);
                currYearCalculator.setBgSchemeId(bgSchemeId);
                currYearCalculator.setFormulaMap(currYearMap);
                try {
                    ((BgExecuteAnalyseAvlCalculator)currYearCalculator).calculator();
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    currYearMap.clear();
                }
            }
            if (grossMap.isEmpty()) continue;
            grossCalculator.setOrgUnitId(orgUnitId);
            grossCalculator.setBgSchemeId(bgSchemeId);
            grossCalculator.setFormulaMap(grossMap);
            try {
                ((BgExecuteAnalyseAvlCalculator)grossCalculator).calculator();
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            finally {
                grossMap.clear();
            }
        }
    }

    protected void fillValue() {
        BigDecimal _value = null;
        String osIdKey = null;
        String ctrlKey = null;
        Map bgFormulaMap = null;
        Set bgFormulaSet = null;
        BgExecuteAnalyseAvlFormulaInfo _bgFormula = null;
        int size = this.getBgFormulaList().size();
        for (int index = 0; index < size; ++index) {
            _bgFormula = (BgExecuteAnalyseAvlFormulaInfo)this.getBgFormulaList().get(index);
            _value = _bgFormula.getBalance();
            if (_bgFormula.isGroupCtrl()) {
                osIdKey = _bgFormula.getOrgAndBgSchemeIdKey();
                ctrlKey = osIdKey + "!" + _bgFormula.getBgDataGroupCtrlNo();
                if (this.getBgDataGroupNoMap().containsKey(ctrlKey)) {
                    bgFormulaSet = (Set)this.getBgDataGroupNoMap().get(ctrlKey);
                    bgFormulaMap = (Map)this.getExpressMap().get(osIdKey);
                    _value = this.addGroupNoNumerial(_bgFormula, bgFormulaSet, bgFormulaMap);
                }
            }
            if (_bgFormula.getParameter().getValue() != null && _bgFormula.getParameter().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParameter().setValue((Object)_value);
        }
    }

    protected BigDecimal addGroupNoNumerial(BgExecuteAnalyseAvlFormulaInfo bgFormula, Set bgFormulaSet, Map bgFormulaMap) {
        if (bgFormula == null || bgFormulaSet == null || bgFormulaSet.isEmpty()) {
            return BgNConstants.ZERO;
        }
        String[] parameter = null;
        BigDecimal value = null;
        BgExecuteAnalyseAvlFormulaInfo tmpFormula2 = null;
        value = bgFormula.getBalance();
        for (BgExecuteAnalyseAvlFormulaInfo tmpFormula2 : bgFormulaSet) {
            if (bgFormula.getBgFormula().equals(tmpFormula2.getBgFormula())) continue;
            if (bgFormulaMap != null && bgFormulaMap.containsKey(tmpFormula2.getBgFormula())) {
                tmpFormula2 = (BgExecuteAnalyseAvlFormulaInfo)bgFormulaMap.get(tmpFormula2.getBgFormula());
            }
            if (StringUtils.isEmpty((String)tmpFormula2.getBgPeriodNumber()) && (parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), tmpFormula2.getBgFormula())) != null) {
                tmpFormula2.setBgPeriodNumber(parameter[1]);
            }
            if (!bgFormula.getBgPeriodNumber().equals(tmpFormula2.getBgPeriodNumber())) continue;
            value = value.add(tmpFormula2.getBalance());
        }
        if (bgFormula.getCtrlType() == 11 || bgFormula.getCtrlType() == 10 || bgFormula.getCtrlType() == 20 || bgFormula.getCtrlType() == 12 || bgFormula.getCtrlType() == -1) {
            // empty if block
        }
        return value;
    }

    protected void clear() {
        this.getBgFormulaList().clear();
        this.getExpressMap().clear();
        this.getOrgUnitMap().clear();
        this.getBgSchemeMap().clear();
        this.getBgSchemeKeyMap().clear();
        this.getBgPeriodCacheMap().clear();
        this.getBgDataGroupNoMap().clear();
        this.getFormulaMap().clear();
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }
}

