/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgFormulaCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgFormulaCalculator.class);
    private boolean checkformual = false;
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgFormulaCalculator() {
    }

    public BgFormulaCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgFormula start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            ReportVariables reportVariables;
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            Parameter param = params.getParameter(0);
            String sheetName = param.getSheetName();
            if (!StringUtils.isEmpty((String)sheetName) && (reportVariables = this.getProvider().getReportVariables()) != null) {
                this.checkformual = reportVariables.getBoolValue("checkFormState", sheetName, false);
            }
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate(false);
            if (!this.checkformual) {
                this.calculate(true);
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgFormula finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        String[] _formulas = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgFormulaSet = null;
        BgFormulaInfo _bgFormula = null;
        Parameter _parameter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            if (_parameter.getValue() != null && _parameter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parameter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parameter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parameter.getArgs()[2]).getValue();
            _bgItemNumber = ((Variant)_parameter.getArgs()[3]).getValue() instanceof BigDecimal ? String.valueOf(((Variant)_parameter.getArgs()[3]).getValue()) : (String)((Variant)_parameter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parameter.getArgs()[4]).getValue();
            _beginPeriodNumber = (String)((Variant)_parameter.getArgs()[5]).getValue();
            _endPeriodNumber = (String)((Variant)_parameter.getArgs()[6]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parameter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgFormulaInfo(this, _parameter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                this.getExpressMap().put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x]);
            }
        }
    }

    protected void calculate(boolean calTmpData) throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        boolean param = Boolean.valueOf(ParamManager.getParamValue((Context)this.getCtx(), null, (String)"BG064"));
        sql.append("SELECT FBgValue, FFormula ");
        if (param) {
            if (calTmpData) {
                sql.append("FROM T_Bg_BgTmpData bg");
            } else {
                sql.append("FROM T_Bg_BgData bg");
                if (this.checkformual) {
                    sql.append(" inner join t_bg_bgform bf on bg.fbgformid =bf.fid and bf.fstate in (2) ");
                } else {
                    sql.append(" inner join t_bg_bgform bf on bg.fbgformid =bf.fid and bf.fstate in (1,2,3,4,20,35,43,102,103) ");
                }
            }
        } else {
            sql.append("FROM T_Bg_BgData bg \n");
            if (this.checkformual) {
                sql.append(" inner join t_bg_bgform bf on bg.fbgformid =bf.fid and bf.fstate in (2) ");
            } else {
                sql.append(" inner join t_bg_bgform bf on bg.fbgformid =bf.fid and bf.fstate in (1,2) ");
            }
        }
        sql.append(" WHERE bg.FOrgUnitId = ? AND bg.FBgSchemeId = ? AND bg.FFormula IN (");
        for (int index = 1; index < this.getBatchSize(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < this.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        _formulaStr = rst.getString(2);
                        _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).toString();
                        if (calTmpData) {
                            this.getBgAdjDataMap().put(_tmpKey, _value);
                            continue;
                        }
                        this.getBgDataMap().put(_tmpKey, _value);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            this.updateBgAdjDataMap();
            this.updateBgDataMap();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void fillValue() {
        String _key = null;
        String _orgKey = null;
        String _formulaStr2 = null;
        String[] _formulas = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        BgFormulaInfo _bgFormula = null;
        for (Map.Entry _entry2 : this.getBgAdjDataMap().entrySet()) {
            _key = (String)_entry2.getKey();
            _value = (BigDecimal)_entry2.getValue();
            this.getBgDataMap().put(_key, _value);
        }
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(i);
            _value = BgNConstants.ZERO;
            if (_bgFormula.isCalculator()) {
                _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
                _formulas = _bgFormula.getFormulas();
                if (_formulas != null) {
                    for (String _formulaStr2 : _formulas) {
                        _key = new StringBuffer(_orgKey).append("!").append(_formulaStr2).toString();
                        if (!this.getBgDataMap().containsKey(_key)) continue;
                        _value = _value.add((BigDecimal)this.getBgDataMap().get(_key));
                    }
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }
}

