/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgGetDimeDataCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgFormulaCalculator.class);
    private boolean checkformual = false;
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();
    private Map bgItemGroupDimMap = new HashMap();
    private Map bgItemDimMap = new HashMap();
    private Map<String, Set<String>> bgItemGroupToItem = new HashMap<String, Set<String>>();
    private Map<String, String> bgItemGroupRef = new HashMap<String, String>();

    public BgGetDimeDataCalculator() {
    }

    public BgGetDimeDataCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgFormula start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            ReportVariables reportVariables;
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            Parameter param = params.getParameter(0);
            String sheetName = param.getSheetName();
            if (!StringUtils.isEmpty((String)sheetName) && (reportVariables = this.getProvider().getReportVariables()) != null) {
                this.checkformual = reportVariables.getBoolValue("checkFormState", sheetName, false);
            }
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate(false);
            if (!this.checkformual) {
                this.calculate(true);
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgFormula finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgItemGroupNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        String _dataType = null;
        String[] _formulas = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgFormulaSet = null;
        BgFormulaInfo _bgFormula = null;
        Parameter _parameter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            if (_parameter.getValue() != null && _parameter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parameter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parameter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parameter.getArgs()[2]).getValue();
            _bgItemGroupNumber = (String)((Variant)_parameter.getArgs()[3]).getValue();
            _bgItemNumber = (String)((Variant)_parameter.getArgs()[4]).getValue();
            _currencyNumber = (String)((Variant)_parameter.getArgs()[5]).getValue();
            _beginPeriodNumber = (String)((Variant)_parameter.getArgs()[6]).getValue();
            _endPeriodNumber = (String)((Variant)_parameter.getArgs()[7]).getValue();
            _dataType = _parameter.getArgs().length == 8 ? "BudgetValue" : (String)((Variant)_parameter.getArgs()[8]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemGroupNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parameter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgFormulaInfo(this, _parameter, _orgUnitNumber, _bgSchemeNumber, _bgElementNumber, _bgItemGroupNumber, _bgItemNumber, _currencyNumber, _beginPeriodNumber, _endPeriodNumber, _dataType);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getFormulaList().add(_bgFormula);
            this.fullValueToGroupItem(_bgItemGroupNumber);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _dataType = _bgFormula.getDataType();
            String itemGroupNumber = _bgFormula.getBgItemGroupNumber();
            _key = _bgFormula.getOrgAndBgSchemeIdKey() + "!" + itemGroupNumber;
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                this.getExpressMap().put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x] + "!" + _dataType);
                this.bgItemGroupDimMap.put(_formulas[x] + "!" + itemGroupNumber, _bgFormula.getBgItemGroupNumber());
                this.bgItemDimMap.put(_formulas[x] + "!" + itemGroupNumber, _bgFormula.getBgItemNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullValueToGroupItem(String bgItemGroupNumber) throws Exception {
        if (StringUtils.isEmpty((String)bgItemGroupNumber)) {
            return;
        }
        String[] groupNumbers = bgItemGroupNumber.split(",");
        String sql = "SELECT FNUMBER FROM T_BG_BGITEM WHERE FBGITEMGROUPID=(SELECT FID FROM T_BG_BGITEMGROUP WHERE FNUMBER=?)";
        StringBuffer sqlGroup = new StringBuffer();
        sqlGroup.append("SELECT FNUMBER,FREFFIELD FROM T_BG_BGITEMGROUP WHERE FNUMBER IN  (");
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pmst = conn.prepareStatement(sql);
            boolean isHasQuery = false;
            for (String groupN : groupNumbers) {
                if (this.bgItemGroupToItem.containsKey(groupN)) continue;
                isHasQuery = true;
                HashSet<String> nSet = new HashSet<String>();
                pmst.setString(1, groupN);
                rs = pmst.executeQuery();
                while (rs.next()) {
                    nSet.add(rs.getString("FNUMBER"));
                }
                this.bgItemGroupToItem.put(groupN, nSet);
                sqlGroup.append("'").append(groupN).append("',");
            }
            sqlGroup.deleteCharAt(sqlGroup.length() - 1);
            sqlGroup.append(")");
            if (isHasQuery) {
                pmst = conn.prepareStatement(sqlGroup.toString());
                rs = pmst.executeQuery();
                while (rs.next()) {
                    this.bgItemGroupRef.put(rs.getString("FREFFIELD"), rs.getString("FNUMBER"));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pmst, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(rs, (Statement)pmst, (Connection)conn);
    }

    protected void calculate(boolean calTmpData) throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        boolean param = Boolean.valueOf(ParamManager.getParamValue((Context)this.getCtx(), null, (String)"BG064"));
        sql.append("SELECT FBgValue,FBizActual,FFormula ");
        if (param) {
            if (calTmpData) {
                sql.append("FROM T_Bg_BgTmpData bg");
            } else {
                sql.append("FROM T_Bg_BgData bg");
                if (this.checkformual) {
                    sql.append(" inner join t_bg_bgform bf on bg.fbgformid =bf.fid and bf.fstate in (2,3,4,20,35,43) ");
                }
            }
        } else {
            sql.append("FROM T_Bg_BgData bg \n");
        }
        sql.append(" WHERE bg.FOrgUnitId = ? AND bg.FBgSchemeId = ? AND bg.FFormula like ?");
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _bgItemGroupNumber = null;
        String _bgItemNumber = null;
        String bgItemNumbers = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        String _bgFormulaStr = null;
        String _tmpBgFormulaStr = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        String[] itemParams = null;
        HashMap<String, BigDecimal> datas = null;
        List valus = null;
        BigDecimal sumValue = null;
        String[] formulas = null;
        String[] bgItemGroupNumber = null;
        String formula = null;
        String[] params = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String BgGetDimeDataType = null;
        String BgFormulaStr = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                if (_key.length != 3) continue;
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                _bgItemGroupNumber = _key[2];
                for (int i = 0; i < _bgFormulaList.size(); ++i) {
                    int j;
                    datas = new HashMap<String, BigDecimal>();
                    _bgFormulaStr = (String)_bgFormulaList.get(i);
                    BgFormulaStr = _bgFormulaStr.substring(0, _bgFormulaStr.lastIndexOf("!"));
                    BgGetDimeDataType = _bgFormulaStr.substring(_bgFormulaStr.lastIndexOf("!") + 1);
                    bgItemGroupNumber = _bgItemGroupNumber.split(",");
                    if (!this.checkBgFormulaByDimensionality(_orgUnitId, BgFormulaStr, _bgItemGroupNumber)) continue;
                    itemParams = BgNFSHelper.parseFormulaPara(BgFormulaStr);
                    formulas = itemParams[0].split(",");
                    for (j = 0; j < formulas.length; ++j) {
                        itemParams[0] = "%" + formulas[j] + "%";
                        _tmpBgFormulaStr = BgNFSHelper.getFormulaFromParam(itemParams);
                        pstmt.setString(1, _orgUnitId);
                        pstmt.setString(2, _bgSchemeId);
                        pstmt.setString(3, _tmpBgFormulaStr);
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            formula = rst.getString("FFormula");
                            params = BgNFSHelper.parseFormulaPara(formula);
                            bgItemNumbers = params[0];
                            if (bgItemGroupNumber.length != bgItemNumbers.split(",").length || !this.isNeedCalc(bgItemGroupNumber, bgItemNumbers.split(","))) continue;
                            if ("BudgetValue".equals(BgGetDimeDataType.trim())) {
                                datas.put(formula, rst.getBigDecimal("FBgValue"));
                                continue;
                            }
                            if (!"ActualValue".equals(BgGetDimeDataType.trim())) continue;
                            datas.put(formula, rst.getBigDecimal("FBizActual"));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    if (datas.size() == 0) continue;
                    _bgItemNumber = (String)this.bgItemDimMap.get(BgFormulaStr + "!" + _bgItemGroupNumber);
                    valus = this.filterBgData(datas, _bgItemNumber);
                    sumValue = BigDecimal.ZERO;
                    for (j = 0; j < valus.size(); ++j) {
                        _value = (BigDecimal)valus.get(j);
                        if (_value == null) continue;
                        sumValue = sumValue.add(_value);
                    }
                    _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_bgFormulaStr).append("!").append(_bgItemGroupNumber).toString();
                    if (calTmpData) {
                        this.getBgAdjDataMap().put(_tmpKey, sumValue);
                        continue;
                    }
                    this.getBgDataMap().put(_tmpKey, sumValue);
                }
            }
            this.updateBgAdjDataMap();
            this.updateBgDataMap();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    private boolean isNeedCalc(String[] bgItemGroupNumbers, String[] itemNumbers) {
        if (this.bgItemGroupToItem.isEmpty() || this.bgItemGroupRef.isEmpty()) {
            return false;
        }
        bgItemGroupNumbers = this.sortItemGroupNumber(bgItemGroupNumbers);
        int size = bgItemGroupNumbers.length;
        for (int index = 0; index < size; ++index) {
            String groupNumber = bgItemGroupNumbers[index];
            if (!this.bgItemGroupToItem.containsKey(groupNumber)) {
                return false;
            }
            Set<String> set = this.bgItemGroupToItem.get(groupNumber);
            if (set == null || set.isEmpty()) {
                return false;
            }
            String itemNumber = itemNumbers[index];
            if (set.contains(itemNumber)) continue;
            return false;
        }
        return true;
    }

    private String[] sortItemGroupNumber(String[] bgItemGroupNumbers) {
        String[] newNumbers = new String[bgItemGroupNumbers.length];
        ArrayList<String> numbers = new ArrayList<String>();
        for (int index = 0; index < bgItemGroupNumbers.length; ++index) {
            numbers.add(bgItemGroupNumbers[index]);
        }
        Set<String> keys = this.bgItemGroupRef.keySet();
        ArrayList<String> ks = new ArrayList<String>();
        ks.addAll(keys);
        Collections.sort(ks, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i2;
                if (StringUtils.isEmpty((String)o2) || StringUtils.isEmpty((String)o2)) {
                    return 0;
                }
                if (!o1.startsWith("F") || !o2.startsWith("F")) {
                    return 0;
                }
                int i1 = Integer.valueOf(o1.substring(1));
                if (i1 > (i2 = Integer.valueOf(o2.substring(1)).intValue())) {
                    return 1;
                }
                if (i1 < i2) {
                    return -1;
                }
                return 0;
            }
        });
        int i = 0;
        for (int index = 0; index < ks.size(); ++index) {
            if (!this.bgItemGroupRef.containsKey(ks.get(index)) || !numbers.contains(this.bgItemGroupRef.get(ks.get(index)))) continue;
            newNumbers[i] = this.bgItemGroupRef.get(ks.get(index));
            ++i;
        }
        return newNumbers;
    }

    private List filterBgData(Map datas, String _bgItemNumber) {
        ArrayList<BigDecimal> newDatas = new ArrayList<BigDecimal>();
        HashMap bgItemDimMap = new HashMap();
        if (datas == null || _bgItemNumber == null) {
            return newDatas;
        }
        String[] bgItemDim = _bgItemNumber.split(",");
        for (int i = 0; i < bgItemDim.length; ++i) {
            bgItemDimMap.put(bgItemDim[i], null);
        }
        int size = bgItemDimMap.size();
        int existSize = 0;
        BigDecimal value = null;
        String formula = null;
        String[] tmpItemNumber = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : datas.entrySet()) {
            existSize = 0;
            formula = (String)entry2.getKey();
            value = (BigDecimal)entry2.getValue();
            tmpItemNumber = BgNFSHelper.parseFormulaPara(formula)[0].split(",");
            for (int j = 0; j < tmpItemNumber.length; ++j) {
                if (!bgItemDimMap.containsKey(tmpItemNumber[j])) continue;
                ++existSize;
            }
            if (existSize != size) continue;
            newDatas.add(value);
        }
        return newDatas;
    }

    private boolean checkBgFormulaByDimensionality(String orgUnitID, String _formulaStr, String _bgItemGroupNumber) throws BOSException {
        String[] params = BgNFSHelper.parseFormulaPara(_formulaStr);
        String bgItem = params[0];
        String[] bgItemNumber = bgItem.split(",");
        HashMap bgItemGroupMap = new HashMap();
        HashSet<String> bgItemList = new HashSet<String>();
        String[] bgItemGroupNumber = _bgItemGroupNumber.split(",");
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select FRefField from t_bg_bgitemgroup where fnumber in (");
        for (int i = 0; i < bgItemGroupNumber.length; ++i) {
            if (i != bgItemGroupNumber.length - 1) {
                sql1.append("'").append(bgItemGroupNumber[i]).append("'").append(",");
                continue;
            }
            sql1.append("'").append(bgItemGroupNumber[i]).append("'");
        }
        sql1.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql1.toString());
            while (rs.next()) {
                bgItemGroupMap.put(rs.getString(1), null);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        HashMap bgItemMap = new HashMap();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select FRefField from t_bg_bgitem where fnumber in (");
        for (int i = 0; i < bgItemNumber.length; ++i) {
            if (i != bgItemNumber.length - 1) {
                sql2.append("'").append(bgItemNumber[i]).append("'").append(",");
                continue;
            }
            sql2.append("'").append(bgItemNumber[i]).append("'");
        }
        sql2.append(")");
        IRowSet rs1 = null;
        try {
            rs1 = DbUtil.executeQuery((Context)this.getCtx(), (String)sql2.toString());
            while (rs1.next()) {
                bgItemList.add(rs1.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs1);
        if (bgItemList.size() == 0) {
            return false;
        }
        String tmpBgItem2 = null;
        for (String tmpBgItem2 : bgItemList) {
            if (bgItemGroupMap.containsKey(tmpBgItem2)) continue;
            return false;
        }
        return true;
    }

    protected void fillValue() {
        String _key = null;
        String _orgKey = null;
        String _formulaStr2 = null;
        String[] _formulas = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        BgFormulaInfo _bgFormula = null;
        for (Map.Entry _entry2 : this.getBgAdjDataMap().entrySet()) {
            _key = (String)_entry2.getKey();
            _value = (BigDecimal)_entry2.getValue();
            this.getBgDataMap().put(_key, _value);
        }
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(i);
            _value = BgNConstants.ZERO;
            if (_bgFormula.isCalculator()) {
                _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
                _formulas = _bgFormula.getFormulas();
                String itemGourpNumber = _bgFormula.getBgItemGroupNumber();
                if (_formulas != null) {
                    for (String _formulaStr2 : _formulas) {
                        _key = new StringBuffer(_orgKey).append("!").append(_formulaStr2).append("!").append(_bgFormula.getDataType()).append("!").append(itemGourpNumber).toString();
                        if (!this.getBgDataMap().containsKey(_key)) continue;
                        _value = _value.add((BigDecimal)this.getBgDataMap().get(_key));
                    }
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }
}

