/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgParamException;

public class BudgetParamCheck
implements IParamCheck {
    private static final String BG022 = "BG022";
    private static final String BG039 = "BG039";
    private static final String BG053 = "BG053";
    private static final String BG055 = "BG055";
    private static final String BG043 = "BG043";
    private static final String BG02201 = "BG02201";
    private static final String BG068 = "BG068";

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String paramNumber = model.getKeyID().getNumber();
        if (BG022.equalsIgnoreCase(paramNumber)) {
            if (BgNConstants.FALSE_STR.equalsIgnoreCase(model.getValue()) && BgSHelper.isBgSheetPermissionUsed((Context)ctx)) {
                throw new BgParamException(BgParamException.BG039USED);
            }
            return;
        }
        if (BG068.equalsIgnoreCase(paramNumber) && BgNConstants.FALSE_STR.equalsIgnoreCase(model.getValue())) {
            throw new BgParamException(BgParamException.BG068USED);
        }
        if (!BgNConstants.TRUE_STE.equalsIgnoreCase(model.getValue())) {
            return;
        }
        if (BG053.equals(paramNumber)) {
            if (BgNSHelper.isStepByStepReport(ctx)) {
                throw new BgParamException(BgParamException.BG055USED);
            }
        } else if (BG055.equals(paramNumber)) {
            if (!BgNSHelper.isStartBasisApproved(ctx)) {
                throw new BgParamException(BgParamException.BG035NOUSE);
            }
            if (BgNSHelper.isAntiAuditToFormerState(ctx)) {
                throw new BgParamException(BgParamException.BG053USED);
            }
            if (BgNSHelper.isCanEditWithBgCourse(ctx)) {
                throw new BgParamException(BgParamException.BG043USED);
            }
        } else if (BG039.equals(paramNumber)) {
            if (!BgSHelper.isBgPermissionUsed((Context)ctx)) {
                throw new BgParamException(BgParamException.BG022NOUSE);
            }
        } else if (BG043.equals(paramNumber)) {
            if (!BgNSHelper.isStartBasisApproved(ctx)) {
                throw new BgParamException(BgParamException.BG035NOUSE4BG043);
            }
            if (BgNSHelper.isStepByStepReport(ctx)) {
                throw new BgParamException(BgParamException.BG055USED);
            }
        } else if (BG02201.equals(paramNumber) && !BgSHelper.isBgPermissionUsed((Context)ctx)) {
            throw new BgParamException(BgParamException.BG022NOUSE);
        }
    }
}

