/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.range;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Fill;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsDel;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import java.util.HashMap;

public class BgRange
extends Range {
    private static final long serialVersionUID = 181844737695379605L;

    public BgRange(Book book, Sheet sheet, CellBlock block) {
        super(book, sheet, block);
    }

    public BgRange(Book book, Sheet sheet, Object[] array) {
        super(book, sheet, array);
    }

    public BgRange(Book book, SortedSheetArray sheets, CellBlock cb) {
        super(book, sheets, cb);
    }

    public BgRange(Book book, SortedSheetArray sheets, Object[] array) {
        super(book, sheets, array);
    }

    public boolean fill(CellBlock dst, FillType type, FillType resultType, String[] userKeys) {
        if (this._sheets.size() == 0) {
            return this.fill(this._book.getActiveSheet(), dst, type, resultType, userKeys);
        }
        boolean flag = true;
        for (int i = 0; i < this._sheets.size(); ++i) {
            flag = flag && this.fill(this._sheets.getSheet(i), dst, type, resultType, userKeys);
        }
        return flag;
    }

    private boolean fill(Sheet sheet, CellBlock dst, FillType type, FillType resultType, String[] userKeys) {
        boolean ret;
        SortedCellBlockArray mergeBlocks;
        CellBlock src = this.getBlock(0);
        CellBlock pureDst = this.getBlock(0);
        boolean fill = dst.contains(src);
        boolean clear = src.contains(dst);
        CellBlock bound = fill ? dst : src;
        SortedCellBlockArray srcMergeBlocks = null;
        boolean merge = false;
        boolean unmerge = false;
        boolean checked = !(!fill && !clear || !dst.equalsRow(src) && !dst.equalsCol(src));
        boolean isProtected = false;
        if (checked) {
            MergeBlocks merger = sheet.getMerger(false);
            if (merger != null && (mergeBlocks = merger.getTouchedBlocks(bound)) != null) {
                checked = bound.contains(mergeBlocks.getBounds());
            }
            if (checked) {
                if (clear) {
                    pureDst = dst;
                } else {
                    SortedCellBlockArray sa = new SortedCellBlockArray();
                    src.split(dst, sa);
                    pureDst = sa.getBlock(0);
                }
                Range dstRange = sheet.getRange(pureDst);
                isProtected = this.isProtected(dstRange.getEditProtectState());
                if (isProtected) {
                    checked = false;
                } else if (merger != null) {
                    srcMergeBlocks = merger.getTouchedBlocks(src);
                    merge = srcMergeBlocks != null;
                    boolean bl = unmerge = merger.getTouchedBlocks(pureDst) != null;
                }
            }
        }
        if (!checked) {
            if (!isProtected) {
                new SheetAction_Fill((Range)this, dst, type, resultType, userKeys).run();
            }
            return false;
        }
        if (merge || unmerge) {
            this._book.getUndoManager().startGroup();
            if (unmerge) {
                sheet.getRange(pureDst).merge();
            }
        }
        if (clear) {
            ret = new Range(this._book, this._book.getActiveSheet(), dst).clear(true, true, true, false);
        } else {
            ret = new SheetAction_Fill((Range)this, dst, type, resultType, userKeys).run();
            if (merge) {
                mergeBlocks = new SortedCellBlockArray();
                mergeBlocks.copyFrom(srcMergeBlocks);
                int mergeCount = mergeBlocks.size();
                int dr = -src.getRow();
                int dc = -src.getCol();
                for (int m = 0; m < mergeCount; ++m) {
                    mergeBlocks.getBlock(m).offset(dr, dc);
                }
                int dstRow = pureDst.getRow();
                int dstCol = pureDst.getCol();
                int dstRow2 = pureDst.getRow2();
                int dstCol2 = pureDst.getCol2();
                if (dst.equalsCol(src)) {
                    boolean positive = pureDst.getRow() > src.getRow();
                    int step = src.getHeight();
                    int end = (int)Math.ceil((double)pureDst.getHeight() / (double)step);
                    int row = positive ? pureDst.getRow() - step : pureDst.getRow2() + 1;
                    int col = pureDst.getCol();
                    block1: for (int m = 0; m < mergeCount; ++m) {
                        CellBlock cb = CellBlock.getNewCellBlock((CellBlock)mergeBlocks.getBlock(m));
                        cb.offset(row, col);
                        for (int i = 0; i < end; ++i) {
                            cb.offset((positive ? 1 : -1) * step, 0);
                            if ((positive ? cb.limitRowCol2(dstRow2, dstCol2) : cb.limitRowCol(dstRow, dstCol)) && cb.isRowColReversed()) continue block1;
                        }
                    }
                } else {
                    boolean positive = pureDst.getCol() > src.getCol();
                    int step = src.getWidth();
                    int end = (int)Math.ceil((double)pureDst.getWidth() / (double)step);
                    int col = positive ? pureDst.getCol() - step : pureDst.getCol2() + 1;
                    int row = pureDst.getRow();
                    block3: for (int m = 0; m < mergeCount; ++m) {
                        CellBlock cb = CellBlock.getNewCellBlock((CellBlock)mergeBlocks.getBlock(m));
                        cb.offset(row, col);
                        for (int i = 0; i < end; ++i) {
                            cb.offset(0, (positive ? 1 : -1) * step);
                            if ((positive ? cb.limitRowCol2(dstRow2, dstCol2) : cb.limitRowCol(dstRow, dstCol)) && cb.isRowColReversed()) continue block3;
                        }
                    }
                }
            }
        }
        if (merge || unmerge) {
            this._book.getUndoManager().endGroup();
        }
        return ret;
    }

    private boolean isBreakMergeBlocks(boolean yDir) {
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock block = this.getBlock(i);
                if (!this.isBreakMergeBlocks(sheet, block, yDir)) continue;
                HashMap<String, Object> state = new HashMap<String, Object>();
                state.put("OtherCause", "OtherCause_MergeLimit");
                state.put("Sheet", sheet);
                state.put("Range", (Object)this);
                this.actionBreak(Sheet.WARNNING, state);
                return true;
            }
        }
        return false;
    }

    private boolean isExceedRowColLimit(boolean yDir) {
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock block = this.getBlock(i);
                if (!this.isExceedRowColLimit(sheet, block, yDir)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isExceedRowColLimit(Sheet sheet, CellBlock cb, boolean yDir) {
        int offset = yDir ? cb.getHeight() : cb.getWidth();
        Sheet.RowsIterator ri = sheet.getRowsIterator(cb.getRow(), cb.getRow2(), true);
        while (ri.hasNext()) {
            Row row = ri.next();
            if (row.size() <= 0) continue;
            if (yDir) {
                if (row.getIntMark() + offset <= 1048575) continue;
                Sheet.ICellsIterator ci = row.getCellsIterator(cb.getCol(), cb.getCol2(), false, false);
                if (!ci.hasNext()) continue;
                return true;
            }
            if (row.getMaxIntMark() + offset <= 16383) continue;
            return true;
        }
        return false;
    }

    boolean isBreakMergeBlocks(Sheet sheet, CellBlock cb, boolean yDir) {
        if (cb.isRow() || cb.isCol()) {
            return false;
        }
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        MergeBlocks mg = sheet.getMerger(false);
        if (mg == null) {
            return false;
        }
        for (int i = mg.size() - 1; i >= 0; --i) {
            CellBlock mb = mg.getBlock(i);
            if (!(yDir ? mb.getRow2() >= row && (mb.containsCol(col) || mb.containsCol(col2)) : mb.getCol2() >= col && (mb.containsRow(row) || mb.containsRow(row2)))) continue;
            return true;
        }
        return false;
    }

    public boolean insert(boolean yDir, InsertType insType) {
        boolean fill;
        if (this.isProtected(this.getInsertProtectState())) {
            return false;
        }
        if (this.isExceedRowColLimit(yDir)) {
            // empty if block
        }
        if (this.isBreakMergeBlocks(yDir)) {
            return false;
        }
        boolean bl = fill = insType != InsertType.NOSTYLE;
        if (fill) {
            this._book.getUndoManager().startGroup();
        }
        boolean ret = new SheetAction_InsDel((Range)this, true, yDir).run();
        if (fill) {
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock dst;
                CellBlock src;
                CellBlock cb = this.getBlock(i);
                if (yDir) {
                    if (insType == InsertType.FLLOW_UP_STYLE) {
                        if (cb.getRow() <= 0) continue;
                        src = (CellBlock)cb.clone();
                        dst = (CellBlock)cb.clone();
                        src.offset(-1, 0);
                        src.setRow2(src.getRow());
                        dst.setRow(src.getRow());
                        ret |= new BgRange(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                        continue;
                    }
                    if (cb.getRow2() >= 1048575) continue;
                    src = (CellBlock)cb.clone();
                    dst = (CellBlock)cb.clone();
                    src.offset(1, 0);
                    src.setRow(src.getRow2());
                    dst.setRow2(src.getRow());
                    ret |= new BgRange(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                    continue;
                }
                if (insType == InsertType.FLLOW_UP_STYLE) {
                    if (cb.getCol() <= 0) continue;
                    src = (CellBlock)cb.clone();
                    dst = (CellBlock)cb.clone();
                    src.offset(0, -1);
                    src.setCol2(src.getCol());
                    dst.setCol(src.getCol());
                    ret |= new BgRange(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                    continue;
                }
                if (cb.getCol2() >= 16383) continue;
                src = (CellBlock)cb.clone();
                dst = (CellBlock)cb.clone();
                src.offset(0, 1);
                src.setCol(src.getCol2());
                dst.setCol2(src.getCol());
                ret |= new BgRange(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
            }
            this._book.getUndoManager().endGroup();
        }
        return ret;
    }
}

