/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormEntryInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.view.AbstractBgRollImpl;
import com.kingdee.eas.ma.view.BgRollHelper;
import com.kingdee.eas.ma.view.BgRollRuleInfo;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgSeriateRollImpl
extends AbstractBgRollImpl {
    private Set<String> historyPeriodNumberSet = new HashSet<String>();
    private Set<String> repeatPeriodNumberSet = new HashSet<String>();
    private Set<String> noRepeatPeriodNumberSet = new HashSet<String>();

    public BgSeriateRollImpl() {
    }

    public BgSeriateRollImpl(BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        this(BgRollHelper.loadFormEntry(bgFormInfo), bgFormInfo);
    }

    public BgSeriateRollImpl(IBgDimensionManager dimensionManager, BgFormInfo bgFormInfo) {
        this(dimensionManager, null, bgFormInfo);
    }

    public BgSeriateRollImpl(Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        this(null, displayAllPeriodNum, bgFormInfo);
    }

    public BgSeriateRollImpl(IBgDimensionManager dimensionManager, Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        HashSet<String> allPeriodNumSet = new HashSet<String>();
        if (displayAllPeriodNum == null) {
            if (dimensionManager == null) {
                return;
            }
            List allListDimension = dimensionManager.getDimension();
            for (int i = 0; i < allListDimension.size(); ++i) {
                BgDimensionInfo bgDimensionInfo = (BgDimensionInfo)allListDimension.get(i);
                if (!bgDimensionInfo.getType().equalsIgnoreCase("BGPERIOD")) continue;
                for (Object o : bgDimensionInfo.getMember()) {
                    allPeriodNumSet.add(((BgDimensionMember)o).getNumber());
                }
                break;
            }
        } else {
            allPeriodNumSet.addAll(displayAllPeriodNum);
        }
        this.setOrgIds(bgFormInfo.getOrgUnit().getId().toString());
        this.setHasRoll(BgViewHelper.checkHasRoll(bgFormInfo));
        this.setBgFormId(bgFormInfo.getId().toString());
        this.setFormState(bgFormInfo.getState());
        this.partitionPeriod(allPeriodNumSet, bgFormInfo);
    }

    @Override
    public String getPeriodFromRSTmp(BgRollRuleInfo rollRuleInfo) {
        String value = "";
        BgPeriodEnum peroidType = rollRuleInfo.getRollType();
        int rollLength = rollRuleInfo.getRollLength();
        String periodType = BgRollHelper.getPeriodTypeCode(peroidType);
        value = value + "N!" + periodType;
        for (int i = 1; i < rollLength; ++i) {
            value = value + "|N+" + i + "!" + periodType;
        }
        return value;
    }

    @Override
    public void partitionPeriod(Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        this.getHistoryPeriodNumberSet().clear();
        this.getRepeatPeriodNumberSet().clear();
        this.getNoRepeatPeriodNumberSet().clear();
        BgPeriodInfo bgPeriod = null;
        BgPeriodInfo bgRollPeriod = null;
        String bgRollPeriodNum = null;
        String bgPeriodNum = null;
        String currPeriodNum = null;
        bgPeriod = bgFormInfo.getBgPeriod();
        bgRollPeriod = bgFormInfo.getBgRollPeriod();
        bgRollPeriodNum = bgRollPeriod.getNumber();
        bgPeriodNum = bgPeriod.getNumber();
        if (this.isHasRoll()) {
            int i;
            currPeriodNum = bgPeriodNum;
            while (!currPeriodNum.equalsIgnoreCase(bgRollPeriodNum)) {
                this.getHistoryPeriodNumberSet().add(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
            currPeriodNum = bgRollPeriodNum;
            for (i = 0; i < bgFormInfo.getEntries().get(0).getRollLength() - bgFormInfo.getEntries().get(0).getRollStep(); ++i) {
                this.getRepeatPeriodNumberSet().add(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
            for (i = 0; i < bgFormInfo.getEntries().get(0).getRollStep(); ++i) {
                this.getNoRepeatPeriodNumberSet().add(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
        } else {
            currPeriodNum = bgRollPeriodNum;
            for (int i = 0; i < bgFormInfo.getEntries().get(0).getRollLength(); ++i) {
                this.getNoRepeatPeriodNumberSet().add(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
        }
    }

    @Override
    public void diffDisplayPeriod(Map<String, Set> lockActualPeriodNum, Map<String, Set> lockBudgetPeriodNum, Map<String, Set> adjustCoverPeriodNum) {
        this.addToSet(lockActualPeriodNum, this.orgIds, this.getHistoryPeriodNumberSet());
        this.addToSet(adjustCoverPeriodNum, this.orgIds, this.getRepeatPeriodNumberSet());
        this.addToSet(adjustCoverPeriodNum, this.orgIds, this.getNoRepeatPeriodNumberSet());
    }

    @Override
    public void pickAdjustFormula(Map _formulaMap, Map resultMap) {
        Map map = null;
        map = resultMap.get(this.orgIds) != null ? (Map)resultMap.get(this.orgIds) : new HashMap();
        Map formulaMap = null;
        String formulaStr = null;
        HashSet<String> adjustCoverPeriodNum = new HashSet<String>();
        adjustCoverPeriodNum.addAll(this.getRepeatPeriodNumberSet());
        adjustCoverPeriodNum.addAll(this.getNoRepeatPeriodNumberSet());
        formulaMap = (Map)_formulaMap.get(this.orgIds);
        if (formulaMap == null || formulaMap.size() <= 0) {
            return;
        }
        for (Object oo : formulaMap.keySet()) {
            formulaStr = (String)oo;
            if (!adjustCoverPeriodNum.contains(BgRollHelper.getPeriodNum(formulaStr))) continue;
            map.put(formulaStr, null);
        }
        if (map.size() > 0) {
            resultMap.put(this.orgIds, map);
        }
    }

    @Override
    public Set<String> getLegalPeriodSet() {
        HashSet<String> legalPeriodNumSet = new HashSet<String>();
        legalPeriodNumSet.addAll(this.getRepeatPeriodNumberSet());
        legalPeriodNumSet.addAll(this.getNoRepeatPeriodNumberSet());
        return legalPeriodNumSet;
    }

    @Override
    public List getNewRollPeriod(BgFormEntryInfo entry, String rollPeriodNum, List curPeriodNum) {
        ArrayList newPeriodNum = new ArrayList();
        newPeriodNum.addAll(curPeriodNum);
        ArrayList<String> historyPeriodList = new ArrayList<String>();
        String currentNum = rollPeriodNum;
        for (int i = 0; i < entry.getRollStep(); ++i) {
            historyPeriodList.add(currentNum);
            currentNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currentNum, (int)1);
        }
        newPeriodNum.removeAll(historyPeriodList);
        ArrayList<String> newPeriodList = new ArrayList<String>();
        currentNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)curPeriodNum.get(curPeriodNum.size() - 1).toString(), (int)1);
        for (int i = 0; i < entry.getRollStep(); ++i) {
            newPeriodList.add(currentNum);
            currentNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currentNum, (int)1);
        }
        newPeriodNum.addAll(newPeriodList);
        return newPeriodNum;
    }

    @Override
    public int getRollMethod() {
        return 1;
    }

    public Set<String> getHistoryPeriodNumberSet() {
        return this.historyPeriodNumberSet;
    }

    public Set<String> getRepeatPeriodNumberSet() {
        return this.repeatPeriodNumberSet;
    }

    public Set<String> getNoRepeatPeriodNumberSet() {
        return this.noRepeatPeriodNumberSet;
    }
}

