/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BudgetDisplayValueProvider;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.GregorianCalendar;
import java.util.Map;

public class RollBudgetDisplayValueProvider
extends BudgetDisplayValueProvider {
    private boolean isActual = true;

    public RollBudgetDisplayValueProvider(Component component) {
        super(component);
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            StyleAttributes sa = Styles.getEmptySA();
            cell.getSheet().getRange(cell).getStyle(sa);
            if (sa.isHided()) {
                return "";
            }
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        Object objDataType = cell.getUserObjectValue("BgRollDataType");
                        Object obj = cell.getValue().getValue();
                        if (this.isActual() && objDataType != null && 1 == (Integer)objDataType) {
                            obj = cell.getUserObjectValue("BG_ROLL_BGACTUAL_VALUE");
                        }
                        if (BgNFSHelper.checkHasPercentage((Cell)cell)) {
                            return cell.getText();
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell((Cell)cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell((Cell)cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasExpression((Cell)cell)) {
                            return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, obj);
                    }
                }
            } else if (viewMode == 1) {
                if (cell.hasFormula()) {
                    return cell.getFormula();
                }
                if (!BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
                    Object obj = cell.getValue().getValue();
                    Object objDataType = cell.getUserObjectValue("BgRollDataType");
                    if (this.isActual() && objDataType != null && 1 == (Integer)objDataType) {
                        obj = cell.getUserObjectValue("BG_ROLL_BGACTUAL_VALUE");
                    }
                    if (obj != null) {
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell((Cell)cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell((Cell)cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, obj);
                    }
                }
            } else if (viewMode == 10) {
                if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                    return BgNFSHelper.getDisplayFormula((String)BgNFSHelper.getFormulaOfCell((Cell)cell), (Map)this.getFormulaMap());
                }
                if (!BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
                    Object obj = cell.getValue().getValue();
                    if (BgNFSHelper.checkHasExpression((Cell)cell)) {
                        return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, obj);
                }
            }
        }
        return null;
    }

    public boolean isActual() {
        return this.isActual;
    }

    public void setActual(boolean isActual) {
        this.isActual = isActual;
    }
}

