/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.budget.BgDataStateEnum;
import com.kingdee.eas.ma.budget.BgDataSynStateBizHelper;
import com.kingdee.eas.ma.budget.BgFormEntryFactory;
import com.kingdee.eas.ma.budget.BgFormEntryInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPastDataInfo;
import com.kingdee.eas.ma.budget.BgPastRecordInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgFormEntry;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.IResultReader;
import com.kingdee.eas.ma.view.BgBillIntegrateFormCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateFormInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRecordInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.app.AbstractBgBillIntegrateSchemeFacadeControllerBean;
import com.kingdee.eas.ma.view.app.BgBillIntegrateServerHelper;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.AbstractBgBillIntegrate;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgBillIntegrateConstants;
import com.kingdee.eas.ma.view.common.BgBillIntegrateData;
import com.kingdee.eas.ma.view.common.BgBillIntegrateDataInfo;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.BizBillMetaBriefInfo;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBuildSaveDataInterface;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgBillIntegrateSchemeFacadeControllerBean
extends AbstractBgBillIntegrateSchemeFacadeControllerBean {
    private static final long serialVersionUID = 2283570331068559053L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.view.app.BgBillIntegrateSchemeFacadeControllerBean");

    @Override
    protected boolean _hasBillIngegrate(Context ctx) throws BOSException, EASBizException {
        Boolean result = BgViewCommonHelper.hasBillIntegrate();
        if (result == null) {
            // empty if block
        }
        return result;
    }

    @Override
    protected Map _initData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        resMap.put("SUB_SYS_BILL", this.initSubSystem(ctx));
        return resMap;
    }

    private Map initSubSystem(Context ctx) throws BOSException, EASBizException {
        Map supportBill = BgBillIntegrateConstants.getSupportBill();
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((Context)ctx, (String)"com_kingdee_eas_base_botp", (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY})));
        return this.traceLeafNode(null, root, supportBill);
    }

    private Map traceLeafNode(Map subSys, DefaultKingdeeTreeNode node, Map supportBill) throws BOSException, EASBizException {
        if (subSys == null) {
            subSys = new HashMap();
        }
        if (node == null) {
            return subSys;
        }
        BizBillMetaBriefInfo billInfo = new BizBillMetaBriefInfo((MetaDataBriefInfo)node.getUserObject());
        if (billInfo.getMetaDatatype().equals((Object)MetaDataTypeList.ENTITY)) {
            List<BizBillMetaBriefInfo> bizBillList;
            if (supportBill == null || !supportBill.containsKey(billInfo.getFullName())) {
                return subSys;
            }
            MetaDataBriefInfo subSysMetaInfo = (MetaDataBriefInfo)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
            BizBillMetaBriefInfo subSysInfo = new BizBillMetaBriefInfo(subSysMetaInfo);
            if (subSys.get(subSysInfo) instanceof List) {
                bizBillList = (List)subSys.get(subSysInfo);
            } else {
                bizBillList = new ArrayList();
                subSys.put(subSysInfo, bizBillList);
            }
            bizBillList.add(billInfo);
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.traceLeafNode(subSys, childNode, supportBill);
            }
        }
        return subSys;
    }

    @Override
    protected void _batchExtractData(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        Map schemeMap = this.queryBgFormInfo(ctx, bgFormIds);
        Map dimensionMap = this.fillDimension(ctx, schemeMap);
        Map bgDataMap = this.parseBgItem(schemeMap, dimensionMap);
        Map orgMap = this.buildOrgMap(schemeMap);
        Map queryMap = BgBillIntegrateServerHelper.extractData(ctx, schemeMap, bgDataMap, orgMap);
        this.saveBudget(ctx, schemeMap, queryMap, bgDataMap);
    }

    private Map buildOrgMap(Map schemeMap) {
        if (schemeMap == null || schemeMap.isEmpty()) {
            return null;
        }
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        for (Map subMap : schemeMap.values()) {
            if (subMap == null || subMap.isEmpty()) continue;
            Iterator itF = subMap.values().iterator();
            while (itF.hasNext()) {
                FullOrgUnitInfo org = ((BgFormEntryInfo)itF.next()).getBgForm().getOrgUnit();
                orgMap.put(org.getNumber(), org);
            }
        }
        return orgMap;
    }

    private void saveBudget(Context ctx, Map schemeMap, Map queryMap, Map bgDataMap) throws BOSException, EASBizException {
        if (ctx == null || schemeMap == null || schemeMap.isEmpty() || queryMap == null || queryMap.isEmpty() || bgDataMap == null || bgDataMap.isEmpty()) {
            return;
        }
        Map queryBgDataMap = this.queryOldBgData(ctx, queryMap, bgDataMap, schemeMap);
        IBuildSaveDataInterface saveData = new IBuildSaveDataInterface(){

            @Override
            public boolean saveData(BgNViewDataInfo bgData, BgBillIntegrateData value, BgFormStateEnum state) {
                if (bgData != null && value != null && bgData.getState() == 1) {
                    bgData.setBudgetValue(value.getValue());
                    return true;
                }
                return false;
            }
        };
        Map saveMap = this.buildSaveDataMap(queryMap, bgDataMap, schemeMap, queryBgDataMap, saveData);
        this.saveMap(ctx, saveMap, schemeMap);
    }

    private void updateBudget(Context ctx, Map updateResult, Map schemeMap, Map queryMap, Map bgDataMap, boolean isThrowException, boolean isCreateHistory) throws BOSException, EASBizException {
        if (ctx == null || schemeMap == null || schemeMap.isEmpty() || queryMap == null || queryMap.isEmpty() || bgDataMap == null || bgDataMap.isEmpty() || updateResult == null) {
            return;
        }
        this.updateResult(ctx, updateResult, schemeMap, queryMap, bgDataMap);
        Map queryBgDataMap = this.queryOldBgData(ctx, queryMap, bgDataMap, schemeMap);
        IBuildSaveDataInterface saveData = new IBuildSaveDataInterface(){

            @Override
            public boolean saveData(BgNViewDataInfo bgData, BgBillIntegrateData value, BgFormStateEnum state) {
                if (bgData != null && value != null && (BgFormStateEnum.Edited.equals((Object)state) && bgData.getState() != 9 || BgFormStateEnum.RollEdited.equals((Object)state))) {
                    bgData.setBudgetValue(value.getValue());
                    return true;
                }
                return false;
            }
        };
        Map saveMap = this.buildSaveDataMap(queryMap, bgDataMap, schemeMap, queryBgDataMap, saveData);
        this.updateMap(ctx, updateResult, saveMap, schemeMap, isThrowException, isCreateHistory);
    }

    private void updateResult(Context ctx, Map updateResult, Map schemeMap, Map queryMap, Map bgDataMap) throws BOSException, EASBizException {
        if (queryMap == null || bgDataMap == null) {
            return;
        }
        for (String orgId : queryMap.keySet()) {
            Map temQueryMap1 = (Map)queryMap.get(orgId);
            Map temDataMap = (Map)bgDataMap.get(orgId);
            if (temQueryMap1 == null || temQueryMap1.isEmpty() || temDataMap == null || temDataMap.isEmpty()) continue;
            for (String formula : temQueryMap1.keySet()) {
                Map temQueryMap2 = (Map)temQueryMap1.get(formula);
                List bgFormIds = (List)temDataMap.get(formula);
                if (temQueryMap2 == null || temQueryMap2.isEmpty() || bgFormIds == null || bgFormIds.isEmpty()) continue;
                for (String billSchemeId : temQueryMap2.keySet()) {
                    Map temSchemeMap = (Map)schemeMap.get(billSchemeId);
                    for (String bgFormId : bgFormIds) {
                        if (!temSchemeMap.containsKey(bgFormId)) continue;
                        BgFormInfo bgForm = ((BgFormEntryInfo)temSchemeMap.get(bgFormId)).getBgForm();
                        BgViewCommonHelper.getSubMap(updateResult, bgForm.getOrgUnit().getNumber(), true).put(bgForm.getNumber(), "updateDetailSuccess");
                    }
                }
            }
        }
    }

    private void updateMap(Context ctx, Map updateResult, Map saveMap, Map schemeMap, boolean isThrowException, boolean isCreateHistory) throws EASBizException, BOSException {
        if (saveMap == null || schemeMap == null) {
            return;
        }
        HashMap bgFormMap = new HashMap();
        for (Map temMap1 : schemeMap.values()) {
            if (temMap1 == null || temMap1.isEmpty()) continue;
            for (BgFormEntryInfo entry : temMap1.values()) {
                String key = BgBillIntegrateCommonHelper.getBgFormKey(entry.getBgForm().getBgScheme().getRootId().toString(), entry.getBgForm().getCurrency().getId().toString(), entry.getBgForm().getBgPeriod().getId().toString(), entry.getBgForm().getBgTemplate().getRootId().toString());
                BgViewCommonHelper.getSubMap(bgFormMap, key, true).put(entry.getBgForm().getOrgUnit().getId().toString(), entry.getBgForm());
            }
        }
        ArrayList<String> updateIds = new ArrayList<String>();
        ArrayList<Object[]> updateFormList = new ArrayList<Object[]>();
        String sql = "update t_bg_bgform set fstate = ?, FDataSource = 14" + (isCreateHistory ? ", FVersionNo = FVersionNo + 0.1" : "") + ", FLastUpdateTime = ?, FLastUpdateUserId = ? where fid  = ? and FState = " + 101;
        String sqlDataState = "update T_Bg_bgData set FDataState = 1 where FDataState = 3 AND FID in (Select FBgDataId from t_bg_bgdataentry where fbgformid = ?)";
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            for (String key : saveMap.keySet()) {
                BgFormInfo bgForm = (BgFormInfo)saveMap.get(key);
                Map temSaveMap = (Map)bgForm.get("BGDATA");
                HashMap saveBudgetMap = new HashMap();
                Map temFormMap = (Map)bgFormMap.get(key);
                Object[] orgIds = temSaveMap.keySet().toArray();
                for (int i = 0; i < orgIds.length; ++i) {
                    String orgId = (String)orgIds[i];
                    BgFormInfo form = (BgFormInfo)temFormMap.get(orgId);
                    boolean isRoll = bgForm.getBgRollPeriod() != null && !bgForm.getBgRollPeriod().getId().equals((Object)bgForm.getBgPeriod().getId());
                    boolean isSuccess = true;
                    if (isRoll) {
                        String msg = BgBillIntegrateServerHelper.saveAdjustMap(ctx, conn, bgForm, (Map)temSaveMap.get(orgId), isThrowException);
                        if (msg != null) {
                            isSuccess = false;
                            BgViewCommonHelper.getSubMap(updateResult, bgForm.getOrgUnit().getNumber(), true).put(bgForm.getNumber(), "updateDetailFail");
                        }
                    } else {
                        saveBudgetMap.put(orgId, temSaveMap.get(orgId));
                    }
                    if (!isSuccess) continue;
                    updateIds.add(form.getId().toString());
                    Object[] ps = new Object[]{isRoll ? 6 : 1, now, userId, form.getId().toString()};
                    updateFormList.add(ps);
                }
                if (saveBudgetMap.isEmpty()) continue;
                BgViewServerHelper.saveBudget(ctx, bgForm, temSaveMap, null, (Map)bgFormMap.get(key), false, false, BgDataStateEnum.Edited, "FDataState <> 9");
            }
            if (isCreateHistory) {
                BgViewServerHelper.copyHistory(conn, updateIds);
            }
            BgNSQLHelper.executeBatch((Connection)conn, (String)sql, updateFormList);
            BgNSQLHelper.executeBatch((Connection)conn, (String)sqlDataState, updateIds);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.savePastRecord(ctx, saveMap, bgFormMap);
        this.saveExtractRecord(ctx, saveMap, bgFormMap);
    }

    private void saveMap(Context ctx, Map saveMap, Map schemeMap) throws EASBizException, BOSException {
        if (saveMap == null || schemeMap == null) {
            return;
        }
        HashMap bgFormMap = new HashMap();
        for (Map temMap1 : schemeMap.values()) {
            if (temMap1 == null || temMap1.isEmpty()) continue;
            for (BgFormEntryInfo entry : temMap1.values()) {
                String key = BgBillIntegrateCommonHelper.getBgFormKey(entry.getBgForm().getBgScheme().getRootId().toString(), entry.getBgForm().getCurrency().getId().toString(), entry.getBgForm().getBgPeriod().getId().toString(), entry.getBgForm().getBgTemplate().getRootId().toString());
                BgViewCommonHelper.getSubMap(bgFormMap, key, true).put(entry.getBgForm().getOrgUnit().getId().toString(), entry.getBgForm());
            }
        }
        for (String key : saveMap.keySet()) {
            BgFormInfo bgForm = (BgFormInfo)saveMap.get(key);
            Map temSaveMap = (Map)bgForm.get("BGDATA");
            Map temMap = (Map)bgFormMap.get(key);
            BgViewServerHelper.saveBudget(ctx, bgForm, temSaveMap, null, temMap, false, false, BgDataStateEnum.Edited, "FDataState = 1");
        }
        this.saveExtractRecord(ctx, saveMap, bgFormMap);
    }

    protected void saveExtractRecord(Context ctx, Map saveMap, Map bgFormMap) throws BOSException, EASBizException {
        if (saveMap == null || saveMap.isEmpty()) {
            return;
        }
        BOSObjectType type = new BgBillIntegrateRecordInfo().getBOSType();
        StringBuffer clearSql = new StringBuffer();
        clearSql.append("delete T_Bg_BgBillIntegrateRecord where FBgDataId IN (Select fid From T_Bg_BgData where ForgUnitId = ? and FBgSchemeId in (Select FID From T_Bg_BgScheme where FOrgUnitId = ? and FRootId = ?) and FFormula = ?)");
        ArrayList<Object[]> clearParams = new ArrayList<Object[]>();
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert T_Bg_BgBillIntegrateRecord(FID, FBgDataId, FBoName, FBillId, FEntryField, FEntryId, FAmountField, FAmount) Select ?, FID, ?, ?, ?, ?, ? ,? FROM T_Bg_BgData WHERE ForgUnitId = ? and FBgSchemeId in (Select FID From T_Bg_BgScheme where FOrgUnitId = ? and FRootId = ?) and FFormula = ?");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        for (String key : saveMap.keySet()) {
            BgFormInfo bgForm = (BgFormInfo)saveMap.get(key);
            String bgSchemeRootId = bgForm.getBgScheme().getRootId().toString();
            Map temSaveMap = (Map)bgForm.get("BGDATA");
            for (String orgId : temSaveMap.keySet()) {
                Map formulaMap = (Map)temSaveMap.get(orgId);
                if (formulaMap == null || formulaMap.isEmpty()) continue;
                for (String formula : formulaMap.keySet()) {
                    BgBillIntegrateDataInfo data = (BgBillIntegrateDataInfo)((Object)formulaMap.get(formula));
                    Object[] params = new Object[]{orgId, orgId, bgSchemeRootId, formula};
                    clearParams.add(params);
                    for (int i = 0; i < data.getParamSize(); ++i) {
                        if (StringUtils.isEmpty((String)data.get((int)i).billId) || StringUtils.isEmpty((String)data.get((int)i).entryId)) continue;
                        params = new Object[]{BOSUuid.create((BOSObjectType)type).toString(), data.get((int)i).boName, data.get((int)i).billId, data.get((int)i).entryField, data.get((int)i).entryId, data.get((int)i).amountField, data.get((int)i).value, orgId, orgId, bgSchemeRootId, formula};
                        insertParams.add(params);
                    }
                }
            }
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (!clearParams.isEmpty()) {
                BgNSQLHelper.executeBatch((Connection)conn, (String)clearSql.toString(), clearParams);
            }
            if (!insertParams.isEmpty()) {
                BgNSQLHelper.executeBatch((Connection)conn, (String)insertSql.toString(), insertParams);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void savePastRecord(Context ctx, Map saveMap, Map bgFormMap) throws BOSException, EASBizException {
        if (ctx == null || saveMap == null || saveMap.isEmpty() || bgFormMap == null || bgFormMap.isEmpty()) {
            return;
        }
        String record = "INSERT INTO T_Bg_BgPastRecord (FID, FPastSource, FBgFormId, FVersionNo, FCreateTime, FCreatorId, FLastUpdateUserId, FLastUpdateTime, FControlUnitId) Select ?, 11, bgForm.FID, bgForm.FVersionNo, ?, ?, ?, ?, bgForm.FControlUnitId FROM T_Bg_BgForm bgForm Where bgForm.FID = ? AND bgForm.FState <>15";
        String recordData = "INSERT INTO T_Bg_BgPastData (FID, FPastRecordId, FBalance, FPastValue, FFormula, FBgDataId, FAdjustorId, FAdjustTime, FAdjValue) Select ?, ?, ?, ?, bgData.FFormula, bgDataEntry.FBgDataId, ?, ?, ? From T_Bg_BgDataEntry bgDataEntry Inner Join T_Bg_BgData bgData on bgData.FID = bgDataEntry.FBgDataId Where bgDataEntry.FBgFormId = ? And bgData.FFormula = ?";
        ArrayList<Object[]> recordList = new ArrayList<Object[]>();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        BOSObjectType recordType = new BgPastRecordInfo().getBOSType();
        BOSObjectType dataType = new BgPastDataInfo().getBOSType();
        for (BgFormInfo bgFormMain : saveMap.values()) {
            Map temFormMap;
            Map temMap = (Map)bgFormMain.get("BGDATA");
            if (temMap == null || temMap.isEmpty() || (temFormMap = (Map)bgFormMap.get(BgBillIntegrateCommonHelper.getBgFormKey(bgFormMain.getBgScheme().getRootId().toString(), bgFormMain.getCurrency().getId().toString(), bgFormMain.getBgPeriod().getId().toString(), bgFormMain.getBgTemplate().getRootId().toString()))) == null || temFormMap.isEmpty()) continue;
            for (String orgId : temMap.keySet()) {
                BgFormInfo bgForm;
                Map bgDataMap = (Map)temMap.get(orgId);
                if (bgDataMap == null || bgDataMap.isEmpty() || (bgForm = (BgFormInfo)temFormMap.get(orgId)) == null) continue;
                Object[] recordParam = null;
                for (String formula : bgDataMap.keySet()) {
                    BigDecimal newValue;
                    BgNViewDataInfo bgData = (BgNViewDataInfo)((Object)bgDataMap.get(formula));
                    if (bgData == null) continue;
                    BigDecimal oldValue = bgData.getOldValue();
                    if (oldValue == null) {
                        oldValue = BgNConstants.ZERO;
                    }
                    if (oldValue.compareTo(newValue = bgData.getBudgetValue()) == 0) continue;
                    if (recordParam == null) {
                        recordParam = new Object[]{BOSUuid.create((BOSObjectType)recordType).toString(), now, userId, userId, now, bgForm.getId().toString()};
                    }
                    Object[] dataParam = new Object[]{BOSUuid.create((BOSObjectType)dataType).toString(), recordParam[0], oldValue, newValue.subtract(oldValue), userId, now, BgNConstants.ZERO, bgForm.getId().toString(), bgData.getFormula()};
                    dataList.add(dataParam);
                }
                if (recordParam == null) continue;
                recordList.add(recordParam);
            }
        }
        if (!dataList.isEmpty() && !recordList.isEmpty()) {
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                BgNSQLHelper.executeBatch((Connection)conn, (String)record, recordList);
                BgNSQLHelper.executeBatch((Connection)conn, (String)recordData, dataList);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private Map buildSaveDataMap(Map queryMap, Map bgDataMap, Map schemeMap, Map queryBgDataMap, IBuildSaveDataInterface saveData) {
        if (queryMap == null || bgDataMap == null || queryBgDataMap == null || saveData == null) {
            return null;
        }
        HashMap<String, BgFormInfo> saveMap = new HashMap<String, BgFormInfo>();
        for (String orgId : queryMap.keySet()) {
            Map temQueryMap1 = (Map)queryMap.get(orgId);
            Map temDataMap = (Map)bgDataMap.get(orgId);
            if (temQueryMap1 == null || temQueryMap1.isEmpty() || temDataMap == null || temDataMap.isEmpty()) continue;
            for (String formula : temQueryMap1.keySet()) {
                Map temQueryMap2 = (Map)temQueryMap1.get(formula);
                List bgFormIds = (List)temDataMap.get(formula);
                if (temQueryMap2 == null || temQueryMap2.isEmpty() || bgFormIds == null || bgFormIds.isEmpty()) continue;
                for (String billSchemeId : temQueryMap2.keySet()) {
                    Map temSchemeMap = (Map)schemeMap.get(billSchemeId);
                    BgBillIntegrateData value = (BgBillIntegrateData)temQueryMap2.get(billSchemeId);
                    for (String bgFormId : bgFormIds) {
                        Map temSaveMap;
                        String key;
                        BgBillIntegrateDataInfo bgData;
                        if (!temSchemeMap.containsKey(bgFormId)) continue;
                        BgFormEntryInfo bgFormEntry = (BgFormEntryInfo)temSchemeMap.get(bgFormId);
                        BgFormInfo bgForm = bgFormEntry.getBgForm();
                        BgFormStateEnum state = this.getState(bgForm);
                        int level = 1;
                        int seq = 1;
                        for (int ss = 0; ss < bgFormEntry.getSchemes().size(); ++ss) {
                            if (!billSchemeId.equals(bgFormEntry.getSchemes().get(ss).getScheme().getId().toString())) continue;
                            level = bgFormEntry.getSchemes().get(ss).getLevel();
                            seq = bgFormEntry.getSchemes().get(ss).getSeq();
                            break;
                        }
                        String schemeRootId = bgForm.getBgScheme().getRootId().toString();
                        Map temQdMap = BgViewCommonHelper.getSubMap(queryBgDataMap, schemeRootId, true);
                        if ((temQdMap = BgViewCommonHelper.getSubMap(temQdMap, orgId, true)).get(formula) instanceof BgBillIntegrateDataInfo) {
                            bgData = (BgBillIntegrateDataInfo)((Object)temQdMap.get(formula));
                        } else if (temQdMap.get(formula) instanceof BgNViewDataInfo) {
                            bgData = new BgBillIntegrateDataInfo((BgNViewDataInfo)((Object)temQdMap.get(formula)));
                            temQdMap.put(formula, bgData);
                        } else {
                            bgData = new BgBillIntegrateDataInfo((BigDecimal)null);
                            bgData.setFormula(formula);
                            bgData.splitFormula();
                            temQdMap.put(formula, bgData);
                        }
                        if ((bgData.getRow() == 0 || bgData.getRow() > level || bgData.getRow() == level && bgData.getCol() > seq) && saveData.saveData(bgData, value, state)) {
                            bgData.setRow(level);
                            bgData.setCol(seq);
                            bgData.addData(value);
                        }
                        if (saveMap.containsKey(key = BgBillIntegrateCommonHelper.getBgFormKey(schemeRootId, bgForm.getCurrency().getId().toString(), bgForm.getBgPeriod().getId().toString(), bgForm.getBgTemplate().getRootId().toString()))) {
                            temSaveMap = (Map)((BgFormInfo)saveMap.get(key)).get("BGDATA");
                        } else {
                            temSaveMap = new HashMap();
                            bgForm.put("BGDATA", temSaveMap);
                            saveMap.put(key, bgForm);
                        }
                        BgViewCommonHelper.getSubMap(temSaveMap, orgId, true).put(formula, bgData);
                    }
                }
            }
        }
        return saveMap;
    }

    private Map queryOldBgData(Context ctx, Map queryMap, Map bgDataMap, Map schemeMap) throws BOSException {
        String schemeRootId;
        if (queryMap == null || bgDataMap == null) {
            return null;
        }
        HashMap<String, Map> queryBgDataMap = new HashMap<String, Map>();
        for (String orgId : queryMap.keySet()) {
            Map temQueryMap1 = (Map)queryMap.get(orgId);
            Map temDataMap = (Map)bgDataMap.get(orgId);
            if (temQueryMap1 == null || temQueryMap1.isEmpty() || temDataMap == null || temDataMap.isEmpty()) continue;
            for (String formula : temQueryMap1.keySet()) {
                Map temQueryMap2 = (Map)temQueryMap1.get(formula);
                List bgFormIds = (List)temDataMap.get(formula);
                if (temQueryMap2 == null || temQueryMap2.isEmpty() || bgFormIds == null || bgFormIds.isEmpty()) continue;
                for (String billSchemeId : temQueryMap2.keySet()) {
                    Map temSchemeMap = (Map)schemeMap.get(billSchemeId);
                    for (String bgFormId : bgFormIds) {
                        if (!temSchemeMap.containsKey(bgFormId)) continue;
                        BgFormInfo bgForm = ((BgFormEntryInfo)temSchemeMap.get(bgFormId)).getBgForm();
                        schemeRootId = bgForm.getBgScheme().getRootId().toString();
                        BgViewCommonHelper.getSubMap(BgViewCommonHelper.getSubMap(queryBgDataMap, schemeRootId, true), orgId, true).put(formula, formula);
                    }
                }
            }
        }
        Object[] schemeRootIds = queryBgDataMap.keySet().toArray();
        for (int i = 0; i < schemeRootIds.length; ++i) {
            schemeRootId = (String)schemeRootIds[i];
            Map temQdMap = (Map)queryBgDataMap.get(schemeRootId);
            temQdMap = BgViewServerHelper.queryBgDataInfo(ctx, temQdMap, schemeRootId);
            queryBgDataMap.put(schemeRootId, temQdMap);
        }
        return queryBgDataMap;
    }

    private Map parseBgItem(Map schemeMap, Map dimensionMap) {
        if (dimensionMap == null || dimensionMap.isEmpty() || schemeMap == null || schemeMap.isEmpty()) {
            return null;
        }
        HashMap bgDataMap = new HashMap();
        for (String bgFormId : dimensionMap.keySet()) {
            IBgDimensionManager bm = (IBgDimensionManager)dimensionMap.get(bgFormId);
            Map formulaMap = BgViewCommonHelper.buildItemFormula(null, bm.getDimension(), null);
            if (formulaMap == null || formulaMap.isEmpty()) continue;
            for (String orgId : formulaMap.keySet()) {
                Map subSource = (Map)formulaMap.get(orgId);
                if (subSource == null || subSource.isEmpty()) continue;
                Map subTarget = BgViewCommonHelper.getSubMap(bgDataMap, orgId, true);
                for (String formula : subSource.keySet()) {
                    if (!subTarget.containsKey(formula)) {
                        subTarget.put(formula, new ArrayList());
                    }
                    ((List)subTarget.get(formula)).add(bgFormId);
                }
            }
        }
        return bgDataMap;
    }

    private Map fillDimension(Context ctx, Map schemeMap) throws BOSException, EASBizException {
        HashMap<String, BgDimensionManagerImpl> dimensionMap = new HashMap<String, BgDimensionManagerImpl>();
        HashMap<BgDimensionManagerImpl, BgFormInfo> dimen_formMap = new HashMap<BgDimensionManagerImpl, BgFormInfo>();
        try {
            BudgetViewLoaderImpl load = new BudgetViewLoaderImpl();
            for (Map subMap : schemeMap.values()) {
                for (BgFormEntryInfo entry : subMap.values()) {
                    BgDimensionManagerImpl dm = new BgDimensionManagerImpl();
                    load.load(dm, entry.getDimensionData());
                    dimensionMap.put(entry.getBgForm().getId().toString(), dm);
                    dimen_formMap.put(dm, entry.getBgForm());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Map bgPeriodMap = this.queryBgViewBgPeriod(ctx, dimen_formMap);
        boolean isBg063 = BgSHelper.isBgItemIsolate((Context)ctx);
        Map bgItemMap = this.queryBgItemInfo(ctx, dimen_formMap, isBg063);
        this.fillDimensionMember(dimen_formMap, bgPeriodMap, bgItemMap, isBg063);
        return dimensionMap;
    }

    private void fillDimensionMember(Map dimenFormMap, Map bgPeriodMap, Map bgItemMap, boolean isBg063) throws EASBizException {
        if (dimenFormMap == null || dimenFormMap.isEmpty() || bgPeriodMap == null || bgItemMap == null) {
            return;
        }
        HashMap<String, Map> fillMap = new HashMap<String, Map>();
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        fillMap.put("ORGUNIT", orgMap);
        fillMap.put("BGITEM", bgItemMap);
        fillMap.put("BGPERIOD", bgPeriodMap);
        for (IBgDimensionManager bm : dimenFormMap.keySet()) {
            BgFormInfo bgForm = (BgFormInfo)dimenFormMap.get(bm);
            orgMap.clear();
            orgMap.put(bgForm.getOrgUnit().getId().toString(), bgForm.getOrgUnit());
            BgViewCommonHelper.fillDimensionMember(bm, fillMap, isBg063, bgForm.getOrgUnit().getId().toString(), bgForm.getBgPeriod(), bgForm.getCurrency(), false);
        }
    }

    protected Map queryBgViewBgPeriod(Context ctx, Map dimen_formMap) throws EASBizException, BOSException {
        if (ctx == null || dimen_formMap == null || dimen_formMap.isEmpty()) {
            return null;
        }
        this.parseRollPeriodNumber(dimen_formMap);
        return BgViewServerHelper.queryBgViewBgPeriod(ctx, dimen_formMap);
    }

    protected Map queryBgItemInfo(Context ctx, Map dimen_formMap, boolean isBg063) throws BOSException {
        if (ctx == null || dimen_formMap == null || dimen_formMap.isEmpty()) {
            return null;
        }
        HashMap temMap = new HashMap();
        for (Object key : dimen_formMap.keySet()) {
            BgFormInfo bgForm = (BgFormInfo)dimen_formMap.get(key);
            temMap.put(key, bgForm.getOrgUnit().getId().toString());
        }
        return BgViewServerHelper.queryBgViewBgItem(ctx, temMap, isBg063);
    }

    protected void parseRollPeriodNumber(Map temMap) {
    }

    private Map queryBgFormInfo(Context ctx, List bgFormIds) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgForm.id");
        sic.add("bgForm.number");
        sic.add("bgForm.name");
        sic.add("bgForm.adjust.id");
        sic.add("bgForm.bgRollPeriod.number");
        sic.add("bgForm.bgRollPeriod.id");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.longNumber");
        sic.add("bgForm.orgUnit.level");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.bgPeriod.name");
        sic.add("bgForm.bgPeriod.level");
        sic.add("bgForm.bgPeriod.showLevel");
        sic.add("bgForm.bgPeriod.periodType");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.number");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.rootId");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.rootId");
        sic.add("dimensionData");
        sic.add("rollMethod");
        sic.add("rollType");
        sic.add("rollStep");
        sic.add("rollLength");
        sic.add("overFlow");
        sic.add("schemes.id");
        sic.add("schemes.bgFormState");
        sic.add("schemes.scheme.id");
        sic.add("schemes.level");
        sic.add("schemes.seq");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        HashSet<String> ids = new HashSet<String>();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgForm.id", ids, CompareType.INCLUDE));
        HashMap schemeMap = new HashMap();
        int batch = 1000;
        int count = BgNSQLHelper.getBatchCount((int)bgFormIds.size(), (int)batch);
        IBgFormEntry bfe = BgFormEntryFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < count; ++i) {
            ids.clear();
            for (int b = 0; b < batch; ++b) {
                int index = i * batch + b;
                if (index >= bgFormIds.size()) continue;
                ids.add(String.valueOf(bgFormIds.get(index)));
            }
            CoreBaseCollection col = bfe.getCollection(evi);
            if (col == null || col.isEmpty()) continue;
            for (int e = 0; e < col.size(); ++e) {
                BgFormEntryInfo entry = (BgFormEntryInfo)col.getObject(e);
                BgFormStateEnum state = this.getState(entry.getBgForm());
                for (int s = entry.getSchemes().size() - 1; s >= 0; --s) {
                    if (entry.getSchemes().get(s).getBgFormState().equals((Object)state)) {
                        String formId;
                        Map subMap = BgViewCommonHelper.getSubMap(schemeMap, entry.getSchemes().get(s).getScheme().getId().toString(), true);
                        if (subMap.containsKey(formId = entry.getBgForm().getId().toString())) continue;
                        subMap.put(formId, entry);
                        continue;
                    }
                    entry.getSchemes().removeObject(s);
                }
            }
        }
        return schemeMap;
    }

    protected BgFormStateEnum getState(BgFormInfo bgForm) {
        BgFormStateEnum state = BgFormStateEnum.Edited;
        if (bgForm.getBgRollPeriod() != null && !bgForm.getBgRollPeriod().getId().equals((Object)bgForm.getBgPeriod().getId())) {
            state = BgFormStateEnum.RollEdited;
        }
        return state;
    }

    @Override
    protected Set _getCommonBgForm(Context ctx, Set orgIds, BgFormInfo bgForm) throws BOSException, EASBizException {
        Map bgFormMap = this.queryBgFormMap(ctx, bgForm, orgIds);
        if (bgFormMap == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        for (Map sub : bgFormMap.values()) {
            if (sub == null || sub.isEmpty()) continue;
            Iterator it2 = sub.values().iterator();
            while (it2.hasNext()) {
                ids.add(((BgFormInfo)it2.next()).getId().toString());
            }
        }
        return ids;
    }

    @Override
    protected Map _backPlan(Context ctx, Map bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return null;
        }
        return this.backPlan(ctx, this.queryBgFormMap(ctx, new HashSet(bgFormIds.keySet())), bgFormIds);
    }

    private Map queryBgFormMap(Context ctx, BgFormInfo bgFormInfo, Set orgUnitIds) throws BOSException {
        StringBuffer sql = this.getBackPlanSelectSql(ctx);
        sql.append(" WHERE bgForm.FState <> ").append(15).append(" AND bgTemplate.FRootId = ? AND bgScheme.FRootID = ? AND bgForm.FCurrencyId = ? AND bgForm.FBgPeriodId = ? AND bgForm.FOrgUnitId in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
        String bgTemplateRootId = bgFormInfo.getBgTemplate().getRootId().toString();
        String bgSchemeRootId = bgFormInfo.getBgScheme().getRootId().toString();
        String currencyId = bgFormInfo.getCurrency().getId().toString();
        String bgPeriodId = bgFormInfo.getBgPeriod().getId().toString();
        Object[] params = orgUnitIds.toArray();
        int batchCount = BgNSQLHelper.getBatchCount((Object[])params);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] subParam = null;
        for (int i = 0; i < batchCount; ++i) {
            subParam = new Object[204];
            subParam[0] = bgTemplateRootId;
            subParam[1] = bgSchemeRootId;
            subParam[2] = currencyId;
            subParam[3] = bgPeriodId;
            BgNSQLHelper.setBatchParams((Object[])params, (Object[])subParam, (int)4, (int)i);
            paramList.add(subParam);
        }
        return this.queryBgFormMap(ctx, sql.toString(), paramList);
    }

    private Map queryBgFormMap(Context ctx, Set bgFormIds) throws BOSException {
        StringBuffer sql = this.getBackPlanSelectSql(ctx);
        sql.append(" WHERE bgForm.FID in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] sourceParams = bgFormIds.toArray();
        int batchCount = BgNSQLHelper.getBatchCount((Object[])sourceParams);
        for (int i = 0; i < batchCount; ++i) {
            Object[] targetParams = new Object[200];
            BgNSQLHelper.setBatchParams((Object[])sourceParams, (Object[])targetParams, (int)0, (int)i);
            paramList.add(targetParams);
        }
        return this.queryBgFormMap(ctx, sql.toString(), paramList);
    }

    private Map queryBgFormMap(Context ctx, String sql, List paramList) throws BOSException {
        if (sql == null || paramList == null || paramList.isEmpty()) {
            return null;
        }
        final HashMap bgFormMap = new HashMap();
        final HashMap entryId = new HashMap();
        Object reader = new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                BgFormInfo bgForm = BgBillIntegrateSchemeFacadeControllerBean.this.buildBgFormInfo(res);
                if (bgForm.getEntries() != null && !bgForm.getEntries().isEmpty()) {
                    entryId.put(bgForm.getEntries().get(0).getId().toString(), null);
                }
                Map subMap = BgViewCommonHelper.getSubMap(bgFormMap, bgForm.getOrgUnit().getNumber(), true);
                subMap.put(bgForm.getNumber(), bgForm);
            }
        };
        BgNSQLHelper.executeBatchQuery((Context)ctx, (String)sql, (List)paramList, (IResultReader)reader);
        if (bgFormMap.isEmpty()) {
            return null;
        }
        if (entryId.isEmpty()) {
            return bgFormMap;
        }
        StringBuffer dataSql = new StringBuffer("Select schemes.FID schemes_FID, schemes.FEntryId schemes_FEntryId, schemes.FBgFormState schemes_FBgFormState, schemes.FLevel schemes_FLevel, schemes.FSeq schemes_FSeq, scheme.FID scheme_FID, scheme.FName_" + ctx.getLocale() + " scheme_FName, scheme.FBoName scheme_FBoName, scheme.FBoAlias_" + ctx.getLocale() + " scheme_FBoAlias FROM T_Bg_BgBillIntegrateForm schemes LEFT JOIN T_Bg_BgBillIntegrateScheme scheme on schemes.FSchemeId = scheme.FID ");
        dataSql.append("WHERE FEntryId IN(");
        BgNSQLHelper.addPlaceHolder((StringBuffer)dataSql).append(")");
        Object[] ids = entryId.keySet().toArray();
        ArrayList<Object[]> dataParams = new ArrayList<Object[]>();
        int batchCount = BgNSQLHelper.getBatchCount((Object[])ids);
        for (int i = 0; i < batchCount; ++i) {
            Object[] ps = new Object[200];
            BgNSQLHelper.setBatchParams((Object[])ids, (Object[])ps, (int)0, (int)i);
            dataParams.add(ps);
        }
        reader = new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                BgBillIntegrateFormInfo f = new BgBillIntegrateFormInfo();
                String id = res.getString("schemes_FEntryId");
                f.setId(BOSUuid.read((String)res.getString("schemes_FID")));
                f.setBgFormState(BgFormStateEnum.getEnum((int)res.getInt("schemes_FBgFormState")));
                f.setLevel(res.getInt("schemes_FLevel"));
                f.setSeq(res.getInt("schemes_FSeq"));
                f.setScheme(new BgBillIntegrateSchemeInfo());
                f.getScheme().setId(BOSUuid.read((String)res.getString("scheme_FID")));
                f.getScheme().setName(res.getString("scheme_FName"));
                f.getScheme().setBoName(res.getString("scheme_FBoName"));
                f.getScheme().setBoAlias(res.getString("scheme_FBoAlias"));
                if (!(entryId.get(id) instanceof BgBillIntegrateFormCollection)) {
                    entryId.put(id, new BgBillIntegrateFormCollection());
                }
                ((BgBillIntegrateFormCollection)((Object)entryId.get(id))).add(f);
            }
        };
        BgNSQLHelper.executeBatchQuery((Context)ctx, (String)dataSql.toString(), dataParams, (IResultReader)reader);
        for (Map subMap : bgFormMap.values()) {
            if (subMap == null || subMap.isEmpty()) continue;
            for (BgFormInfo f : subMap.values()) {
                if (f == null || f.getEntries() == null || f.getEntries().isEmpty()) continue;
                for (int e = 0; e < f.getEntries().size(); ++e) {
                    BgBillIntegrateFormCollection col = (BgBillIntegrateFormCollection)((Object)entryId.get(f.getEntries().get(e).getId().toString()));
                    if (col == null || col.isEmpty()) continue;
                    f.getEntries().get(e).getSchemes().addCollection(col);
                }
            }
        }
        return bgFormMap;
    }

    @Override
    protected Map _updatePlan(Context ctx, Set bgFormIds, BgFormStateEnum stateCheck, boolean isThrowException, boolean isCreateHistory) throws BOSException, EASBizException {
        return this.updatePlan(ctx, this.queryBgFormMap(ctx, bgFormIds), stateCheck, isThrowException, isCreateHistory);
    }

    private Map updatePlan(Context ctx, Map bgFormMap, BgFormStateEnum stateCheck, boolean isThrowException, boolean isCreateHistory) throws BOSException, EASBizException {
        if (bgFormMap == null) {
            return null;
        }
        ArrayList<String> updateIds = new ArrayList<String>();
        HashMap updateResult = new HashMap();
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        for (String orgNum : bgFormMap.keySet()) {
            Map subMap = (Map)bgFormMap.get(orgNum);
            if (subMap == null || subMap.isEmpty()) continue;
            block1: for (BgFormInfo bgForm : subMap.values()) {
                if (!orgMap.containsKey(bgForm.getOrgUnit().getNumber())) {
                    orgMap.put(bgForm.getOrgUnit().getNumber(), bgForm.getOrgUnit());
                }
                BgFormStateEnum state = this.getState(bgForm);
                BgViewCommonHelper.getSubMap(updateResult, orgNum, true).put(bgForm.getNumber(), "updateDetailFail");
                if (!stateCheck.equals((Object)bgForm.getState()) || bgForm.getEntries().isEmpty() || bgForm.getEntries().get(0).getSchemes().isEmpty()) continue;
                for (int s = 0; s < bgForm.getEntries().get(0).getSchemes().size(); ++s) {
                    if (!state.equals((Object)bgForm.getEntries().get(0).getSchemes().get(s).getBgFormState())) continue;
                    updateIds.add(bgForm.getId().toString());
                    continue block1;
                }
            }
        }
        this.updatePlan(ctx, updateResult, updateIds, isThrowException, isCreateHistory);
        String dun = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"dun", (Locale)ctx.getLocale());
        String dot = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"dot", (Locale)ctx.getLocale());
        String semicolon = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"semicolon", (Locale)ctx.getLocale());
        String colon = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"colon", (Locale)ctx.getLocale());
        String org = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"org", (Locale)ctx.getLocale());
        String updateDetailSuccess = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"updateDetailSuccess", (Locale)ctx.getLocale());
        String updateDetailFail = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"updateDetailFail", (Locale)ctx.getLocale());
        Object[] orgNums = updateResult.keySet().toArray();
        Arrays.sort(orgNums);
        boolean hasSuccess = false;
        StringBuffer message = new StringBuffer();
        for (int o = 0; o < orgNums.length; ++o) {
            String orgName = ((FullOrgUnitInfo)orgMap.get(orgNums[o])).getName();
            Map subMap = (Map)updateResult.get(orgNums[o]);
            if (subMap == null || subMap.isEmpty()) continue;
            StringBuffer success = new StringBuffer();
            StringBuffer fail = new StringBuffer();
            StringBuffer tem = null;
            Object[] formNums = subMap.keySet().toArray();
            Arrays.sort(formNums);
            for (int f = 0; f < formNums.length; ++f) {
                if ("updateDetailSuccess".equals(subMap.get(formNums[f]))) {
                    tem = success;
                    hasSuccess = true;
                } else {
                    tem = fail;
                }
                if (tem.length() > 0) {
                    tem.append(dun);
                }
                tem.append(formNums[f]);
            }
            int index = 1;
            message.append(orgName).append(org).append(colon).append("\n");
            index = this.addMessage(message, success.toString(), index, updateDetailSuccess, dun, semicolon);
            index = this.addMessage(message, fail.toString(), index, updateDetailFail, dun, semicolon);
            message.append(dot).append("\n").append("\n");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", hasSuccess);
        result.put("message", message.toString());
        return result;
    }

    private void updatePlan(Context ctx, Map updateResult, List updateIds, boolean isThrowException, boolean isCreateHistory) throws BOSException, EASBizException {
        if (updateIds == null || updateIds.isEmpty() || updateResult == null) {
            return;
        }
        Map schemeMap = this.queryBgFormInfo(ctx, updateIds);
        Map dimensionMap = this.fillDimension(ctx, schemeMap);
        Map bgDataMap = this.parseBgItem(schemeMap, dimensionMap);
        Map orgMap = this.buildOrgMap(schemeMap);
        Map queryMap = BgBillIntegrateServerHelper.updateData(ctx, schemeMap, bgDataMap, orgMap);
        this.updateBudget(ctx, updateResult, schemeMap, queryMap, bgDataMap, isThrowException, isCreateHistory);
    }

    private Map backPlan(Context ctx, Map bgFormMap, Map idea) throws BOSException, EASBizException {
        String SUCCESS = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"detailSuccess", (Locale)ctx.getLocale());
        String NOEDIT = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"detailNoEdit", (Locale)ctx.getLocale());
        String NOSCHEME = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"detailNoScheme", (Locale)ctx.getLocale());
        String dun = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"dun", (Locale)ctx.getLocale());
        String dot = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"dot", (Locale)ctx.getLocale());
        String semicolon = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"semicolon", (Locale)ctx.getLocale());
        String colon = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"colon", (Locale)ctx.getLocale());
        String org = ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"org", (Locale)ctx.getLocale());
        StringBuffer message = new StringBuffer();
        ArrayList<BgFormInfo> backList = new ArrayList<BgFormInfo>();
        Object[] orgNums = bgFormMap.keySet().toArray();
        Arrays.sort(orgNums);
        for (int i = 0; i < orgNums.length; ++i) {
            Map subMap = (Map)bgFormMap.get(orgNums[i]);
            if (subMap == null || subMap.isEmpty()) continue;
            StringBuffer success = new StringBuffer();
            StringBuffer noEdit = new StringBuffer();
            StringBuffer noScheme = new StringBuffer();
            StringBuffer tem = null;
            String orgName = null;
            Object[] formNums = subMap.keySet().toArray();
            Arrays.sort(formNums);
            for (int o = 0; o < formNums.length; ++o) {
                BgFormInfo bgForm = (BgFormInfo)subMap.get(formNums[o]);
                BgFormStateEnum state = this.getState(bgForm);
                if (orgName == null) {
                    orgName = bgForm.getOrgUnit().getName();
                }
                if (!state.equals((Object)bgForm.getState())) {
                    tem = noEdit;
                } else {
                    boolean hasBack = false;
                    if (!bgForm.getEntries().isEmpty()) {
                        for (int s = 0; s < bgForm.getEntries().get(0).getSchemes().size(); ++s) {
                            if (!state.equals((Object)bgForm.getEntries().get(0).getSchemes().get(s).getBgFormState())) continue;
                            hasBack = true;
                            break;
                        }
                    }
                    if (hasBack) {
                        tem = success;
                        backList.add(bgForm);
                    } else {
                        tem = noScheme;
                    }
                }
                if (tem.length() > 0) {
                    tem.append(dun);
                }
                tem.append(bgForm.getNumber());
            }
            int index = 1;
            message.append(orgName).append(org).append(colon).append("\n");
            index = this.addMessage(message, success.toString(), index, SUCCESS, dun, semicolon);
            index = this.addMessage(message, noEdit.toString(), index, NOEDIT, dun, semicolon);
            index = this.addMessage(message, noScheme.toString(), index, NOSCHEME, dun, semicolon);
            message.append(dot).append("\n").append("\n");
        }
        if (!backList.isEmpty()) {
            ArrayList<String> backParam = new ArrayList<String>();
            Iterator it = backList.iterator();
            while (it.hasNext()) {
                backParam.add(((BgFormInfo)it.next()).getId().toString());
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                BgNSQLHelper.executeBatch((Connection)conn, (String)"Update T_Bg_BgForm set FState = 101 Where FID = ?", backParam);
                BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, backParam, (BgDataStateEnum)BgDataStateEnum.UnEditeable, (boolean)true, (String)"OPERATOR_BACK_PLAN");
                BgBillIntegrateServerHelper.backPlanToBill(ctx, backParam, idea);
                BgNSQLHelper.executeBatch((Connection)conn, (String)"delete T_Bg_BgBillIntegrateRecord Where FBgDataId in(Select FBgDataId From T_Bg_BgDataEntry where FBgFormId = ?)", backParam);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", !backList.isEmpty());
        result.put("message", message.toString());
        return result;
    }

    private int addMessage(StringBuffer target, String numbers, int index, String msgTemp, String dun, String semicolon) {
        if (target == null || numbers.length() <= 0 || msgTemp == null) {
            return index;
        }
        if (index > 1) {
            target.append(semicolon).append("\n");
        }
        target.append(index).append(dun);
        target.append(MessageFormat.format(msgTemp, numbers));
        return index + 1;
    }

    private StringBuffer getBackPlanSelectSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select bgForm.FID bgForm_FID, bgForm.FNumber bgForm_FNumber, bgForm.FName bgForm_FName, bgForm.FState bgForm_FState, bgForm.FBgPeriodId bgForm_FBgPeriodId, bgForm.FBgRollPeriodId bgForm_FBgRollPeriodId, ").append("org.FID org_FID, org.FNumber org_FNumber, org.FName_").append(ctx.getLocale()).append(" org_FName, ").append("entries.FID entries_FID ");
        sql.append("From T_Bg_BgForm bgForm ").append("Inner Join T_Org_CostCenter org On org.FID = bgForm.FOrgUnitId ").append("Left Join T_Bg_BgFormEntry entries On entries.FBgFormId = bgForm.FID ").append("Left Join T_Bg_BgScheme bgScheme On bgScheme.FID = bgForm.FBgSchemeId ").append("Left Join T_Bg_BgTemplate bgTemplate On bgTemplate.FID = bgForm.FBgTemplateId ");
        return sql;
    }

    private BgFormInfo buildBgFormInfo(ResultSet res) throws SQLException {
        BgFormInfo bgForm = new BgFormInfo();
        bgForm.setId(BOSUuid.read((String)res.getString("bgForm_FID")));
        bgForm.setNumber(res.getString("bgForm_FNumber"));
        bgForm.setName(res.getString("bgForm_FName"));
        bgForm.setState(BgFormStateEnum.getEnum((int)res.getInt("bgForm_FState")));
        bgForm.setOrgUnit(new FullOrgUnitInfo());
        bgForm.getOrgUnit().setId(BOSUuid.read((String)res.getString("org_FID")));
        bgForm.getOrgUnit().setNumber(res.getString("org_FNumber"));
        bgForm.getOrgUnit().setName(res.getString("org_FName"));
        bgForm.setBgPeriod(new BgPeriodInfo());
        bgForm.getBgPeriod().setId(BOSUuid.read((String)res.getString("bgForm_FBgPeriodId")));
        if (!StringUtils.isEmpty((String)res.getString("bgForm_FBgRollPeriodId"))) {
            bgForm.setBgRollPeriod(new BgPeriodInfo());
            bgForm.getBgRollPeriod().setId(BOSUuid.read((String)res.getString("bgForm_FBgRollPeriodId")));
        }
        if (!StringUtils.isEmpty((String)res.getString("entries_FID"))) {
            BgFormEntryInfo entry = new BgFormEntryInfo();
            bgForm.getEntries().add(entry);
            entry.setId(BOSUuid.read((String)res.getString("entries_FID")));
        }
        return bgForm;
    }

    @Override
    protected void _synBillState(Context ctx, Collection bgFormIds, String operator) throws BOSException, EASBizException {
        if (ctx == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        logger.error((Object)("Start SynBillState(" + operator + "):" + bgFormIds));
        if (!"OPERATOR_APPROVED".equals(operator) && !"OPERATOT_UNAPPROVED".equals(operator)) {
            return;
        }
        Map record = BgBillIntegrateServerHelper.queryBgBillIntegrateRecord(ctx, bgFormIds);
        if ((record = BgBillIntegrateServerHelper.splitRecord(record)) != null) {
            for (String boName : record.keySet()) {
                List list = (List)record.get(boName);
                AbstractBgBillIntegrate.getInterface(boName).synPlan(ctx, operator, list);
            }
        }
    }
}

