/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.ma.budget.BgElementCollObject;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.util.BgItemViewObject;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BgDimensionInfo
implements Serializable {
    private static final long serialVersionUID = -7474751634701106168L;
    public static final String DISPLAY_NAME = "NAME";
    public static final String DISPLAY_NUMBER = "NUMBER";
    public static final String DISPLAY_NUMBER_NAME = "NAMEANDNUMBER";
    private String type = null;
    private String value = null;
    private String attribute = null;
    private String layout = null;
    private String showType = "NAME";
    private final List member = new ArrayList();

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        if (!StringUtils.isEmpty((String)showType)) {
            this.showType = showType;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public List getMember() {
        return this.member;
    }

    public String getAttributeNumber() {
        if (!StringUtils.isEmpty((String)this.attribute)) {
            if (this.attribute.indexOf(",") > 0) {
                return this.attribute.split(",")[0];
            }
            return this.attribute;
        }
        if ("ORGUNIT".equals(this.getType())) {
            return "ORGUNIT";
        }
        return null;
    }

    public String getAttributeName() {
        if (!StringUtils.isEmpty((String)this.attribute) && "BGITEM".equals(this.getType()) && this.attribute.indexOf(",") > 1) {
            return this.attribute.split(",")[1];
        }
        return "";
    }

    public BgDimensionInfo cloneValue() {
        BgDimensionInfo cloneInfo = new BgDimensionInfo();
        cloneInfo.setType(this.getType());
        cloneInfo.setValue(this.getValue());
        cloneInfo.setAttribute(this.getAttribute());
        cloneInfo.setLayout(this.getLayout());
        return cloneInfo;
    }

    public void parse() {
        String[] members;
        this.getMember().clear();
        if (!StringUtils.isEmpty((String)this.getValue()) && (members = this.getValue().split("\\|")) != null) {
            String _tmpStr2 = null;
            BgDimensionMember member = null;
            for (String _tmpStr2 : members) {
                if (StringUtils.isEmpty((String)_tmpStr2)) continue;
                String[] _tmp = _tmpStr2.split(",");
                member = new BgDimensionMember(this.getType(), this.getAttribute(), null, null);
                member.setType(this.getType());
                member.setAttribute(this.getAttribute());
                if (_tmp.length == 1 && "BGPERIOD".equals(this.getType()) && this.getValue().contains("!")) {
                    member.setNumber(_tmp[0]);
                    member.setName(_tmp[0]);
                } else {
                    member.setNumber(_tmp[0]);
                    member.setName(_tmp[1]);
                }
                if (_tmp.length >= 3 && Integer.parseInt(_tmp[2]) == 1) {
                    member.setAllowEdit(true);
                }
                if (_tmp.length >= 4) {
                    member.setVersion(new BigDecimal(_tmp[3]));
                }
                this.getMember().add(member);
            }
        }
        if (!"BGPERIOD".equalsIgnoreCase(this.getType())) {
            this.sortMember();
        }
    }

    public void unParseMember() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getMember().size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)this.getMember().get(i);
            builder.append(member.getNumber());
            builder.append(",");
            builder.append(member.getName());
            if (member.isAllowEdit()) {
                builder.append(",1");
            } else {
                builder.append(",0");
            }
            builder.append(",");
            builder.append(member.getVersion());
            builder.append("|");
        }
        builder.deleteCharAt(builder.length() - 1);
        this.setValue(builder.toString());
    }

    public void unParseBgPeriod() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getMember().size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)this.getMember().get(i);
            builder.append(member.getNumber());
            builder.append(",");
            builder.append(member.getName());
            builder.append("|");
        }
        builder.deleteCharAt(builder.length() - 1);
        this.setValue(builder.toString());
    }

    public void sortMember() {
        Collections.sort(this.getMember());
    }

    public Object unParse() {
        if (StringUtils.isEmpty((String)this.getValue())) {
            return null;
        }
        String[] values = this.getValue().split("\\|");
        String type = this.getType();
        if ("BGITEM".equals(type)) {
            BgItemCollection itemConn = new BgItemCollection();
            for (int n = 0; n < values.length; ++n) {
                String[] child = values[n].split(",");
                BgItemInfo itemInfo = new BgItemInfo();
                itemInfo.setNumber(child[0]);
                itemInfo.setName(child[1]);
                itemConn.add(itemInfo);
            }
            return new BgItemViewObject(itemConn);
        }
        if ("BGELEMENT".equals(type)) {
            BgElementCollection bgEleColl = new BgElementCollection();
            for (int n = 0; n < values.length; ++n) {
                String[] child = values[n].split(",");
                BgElementInfo info = new BgElementInfo();
                info.setNumber(child[0]);
                info.setName(child[1]);
                bgEleColl.add(info);
            }
            return new BgElementCollObject(bgEleColl);
        }
        if ("BGPERIOD".equals(type)) {
            if (this.getValue().contains("!")) {
                ArrayList<String> list = new ArrayList<String>();
                for (int n = 0; n < values.length; ++n) {
                    list.add(values[n]);
                }
                return list;
            }
            BgPeriodInfo[] period = new BgPeriodInfo[values.length];
            for (int index = 0; index < values.length; ++index) {
                String[] child = values[index].split(",");
                BgPeriodInfo periodInfo = new BgPeriodInfo();
                periodInfo.setNumber(child[0]);
                periodInfo.setName(child[1]);
                period[index] = periodInfo;
            }
            return period;
        }
        if (!"ORGUNIT".equals(type) && "CURRENCY".equals(type)) {
            String[] child = values[0].split(",");
            CurrencyInfo info = new CurrencyInfo();
            info.setNumber(child[0]);
            info.setName(child[1]);
            return info;
        }
        return null;
    }

    public String toString() {
        return "type=" + this.type + ", value=" + this.value + ", attribute=" + this.attribute;
    }
}

