/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgDimensionManagerImpl
implements IBgDimensionManager,
Serializable {
    private static final long serialVersionUID = 2854352488725571049L;
    private boolean isVerify = false;
    private List dimension = new ArrayList();
    private List pageDimension = new ArrayList();
    private List rowDimension = new ArrayList();
    private List colDimension = new ArrayList();
    private Map config = new HashMap();
    private List pageDisplayDimension = new ArrayList();
    private List rowDisplayDimension = new ArrayList();
    private List colDisplayDimension = new ArrayList();
    private MeasureUnitInfo defaultMeasureUnit = null;
    private Map measureMap = new HashMap();
    private Map currencyMap = new HashMap();
    private List oldPageDisplayDimension = new ArrayList();
    private List oldRowDisplayDimension = new ArrayList();
    private List oldColDisplayDimension = new ArrayList();
    private List oldAllowEditDimension = new ArrayList();
    private List bookOperation = null;
    private List sheetOperation = BgViewCommonHelper.getViewOperation();
    private boolean isLockSheet = false;
    private String oprtState = null;

    @Override
    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    @Override
    public boolean isRowAddMember() {
        return this.getBoolean("rowAddMember");
    }

    @Override
    public void setRowAddMember(boolean rowAddMember) {
        this.setBoolean("rowAddMember", rowAddMember);
    }

    @Override
    public boolean isRowShowLevel() {
        return this.getBoolean("rowShowLevel");
    }

    @Override
    public void setRowShowLevel(boolean rowShowLevel) {
        this.setBoolean("rowShowLevel", rowShowLevel);
    }

    private boolean getBoolean(String key) {
        return Boolean.TRUE.toString().equalsIgnoreCase(String.valueOf(this.config.get(key)));
    }

    private void setBoolean(String key, boolean bool) {
        if (bool) {
            this.config.put(key, Boolean.TRUE.toString());
        } else {
            this.config.remove(key);
        }
    }

    @Override
    public List getDimension() {
        return this.dimension;
    }

    @Override
    public List getPageDimension() {
        return this.pageDimension;
    }

    @Override
    public List getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public List getColDimension() {
        return this.colDimension;
    }

    @Override
    public void addDimensionInfo(BgDimensionInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return;
        }
        this.getDimension().add(dimensionInfo);
        if ("page".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getPageDimension().add(dimensionInfo);
        } else if ("row".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getRowDimension().add(dimensionInfo);
        } else if ("col".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getColDimension().add(dimensionInfo);
        }
    }

    @Override
    public void verifyData() throws Exception {
        BgDimensionInfo dimensionInfo = null;
        int in = this.getDimension().size();
        for (int i = 0; i < in; ++i) {
            dimensionInfo = (BgDimensionInfo)this.getDimension().get(i);
            if (StringUtils.isEmpty((String)dimensionInfo.getAttribute())) {
                dimensionInfo.setAttribute(dimensionInfo.getType());
            }
            dimensionInfo.parse();
        }
        this.isVerify = !this.getDimension().isEmpty();
    }

    @Override
    public boolean isVerify() {
        return this.isVerify;
    }

    @Override
    public void clear() {
        this.getDimension().clear();
        this.getPageDimension().clear();
        this.getRowDimension().clear();
        this.getColDimension().clear();
    }

    @Override
    public void clearStyle() {
        this.getColDisplayDimension().clear();
        this.getPageDisplayDimension().clear();
        this.getRowDisplayDimension().clear();
    }

    @Override
    public void synchStyle() {
        ArrayList colStyle = new ArrayList(this.getColDisplayDimension());
        ArrayList pageStyle = new ArrayList(this.getPageDisplayDimension());
        ArrayList rowStyle = new ArrayList(this.getRowDisplayDimension());
        HashMap<String, BgDimensionInfo> dimens = new HashMap<String, BgDimensionInfo>();
        for (int i = 0; i < this.getDimension().size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)this.getDimension().get(i);
            dimens.put(this.getDimenKey(dimen), dimen);
        }
        this.clearStyle();
        this.synchStyle(colStyle, this.getColDisplayDimension(), dimens);
        this.synchStyle(pageStyle, this.getPageDisplayDimension(), dimens);
        this.synchStyle(rowStyle, this.getRowDisplayDimension(), dimens);
    }

    private void synchStyle(List styleOld, List styleNew, Map dimens) {
        if (styleOld == null || styleNew == null || dimens == null || dimens.isEmpty()) {
            return;
        }
        for (int i = 0; i < styleOld.size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)styleOld.get(i);
            String key = this.getDimenKey(dimen);
            if (!dimens.containsKey(key)) continue;
            styleNew.add(dimens.get(key));
        }
    }

    private String getDimenKey(BgDimensionInfo dimen) {
        if (dimen != null) {
            if ("BGITEM".equalsIgnoreCase(dimen.getType())) {
                return dimen.getType() + "_" + dimen.getAttributeNumber();
            }
            return dimen.getType();
        }
        return null;
    }

    @Override
    public MeasureUnitInfo getDefaultMeasureUnit() {
        return this.defaultMeasureUnit;
    }

    @Override
    public Map getMeasureMap() {
        return this.measureMap;
    }

    @Override
    public void setDefaultMeasureUnit(MeasureUnitInfo mu) {
        this.defaultMeasureUnit = mu;
    }

    @Override
    public List getColDisplayDimension() {
        return this.colDisplayDimension;
    }

    @Override
    public List getPageDisplayDimension() {
        return this.pageDisplayDimension;
    }

    @Override
    public List getRowDisplayDimension() {
        return this.rowDisplayDimension;
    }

    @Override
    public void copyAllowEditDimension() {
        this.oldAllowEditDimension.clear();
        for (Object obj : this.rowDimension) {
            BgDimensionInfo dimensionInfo = (BgDimensionInfo)obj;
            if (!"BGITEM".equalsIgnoreCase(dimensionInfo.getType())) continue;
            this.oldAllowEditDimension.add(dimensionInfo.cloneValue());
        }
    }

    @Override
    public void copyStyleToOld() {
        this.oldPageDisplayDimension.clear();
        this.oldPageDisplayDimension.addAll(this.getPageDisplayDimension());
        this.oldRowDisplayDimension.clear();
        this.oldRowDisplayDimension.addAll(this.getRowDisplayDimension());
        this.oldColDisplayDimension.clear();
        this.oldColDisplayDimension.addAll(this.getColDisplayDimension());
    }

    @Override
    public boolean isModifyMembers() {
        ArrayList<BgDimensionInfo> allowEditDimension = new ArrayList<BgDimensionInfo>();
        for (Object obj : this.rowDimension) {
            BgDimensionInfo dimensionInfo = (BgDimensionInfo)obj;
            if (!"BGITEM".equalsIgnoreCase(dimensionInfo.getType())) continue;
            allowEditDimension.add(dimensionInfo);
        }
        if (this.oldAllowEditDimension == null || this.oldAllowEditDimension.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.oldAllowEditDimension.size(); ++i) {
            BgDimensionInfo oldDimensionInfo = (BgDimensionInfo)this.oldAllowEditDimension.get(i);
            BgDimensionInfo newDimensionInfo = (BgDimensionInfo)allowEditDimension.get(i);
            if (oldDimensionInfo.getValue().equals(newDimensionInfo.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModifyStyle() {
        return this.isModifyStyle(this.oldPageDisplayDimension, this.getPageDisplayDimension()) || this.isModifyStyle(this.oldRowDisplayDimension, this.getRowDisplayDimension()) || this.isModifyStyle(this.oldColDisplayDimension, this.getColDisplayDimension());
    }

    private boolean isModifyStyle(List dimen1, List dimen2) {
        if (dimen1 == null || dimen1.isEmpty()) {
            return dimen2 != null && !dimen2.isEmpty();
        }
        if (dimen2 == null || dimen2.isEmpty()) {
            return dimen1 != null && !dimen1.isEmpty();
        }
        if (dimen1.size() != dimen2.size()) {
            return true;
        }
        for (int i = 0; i < dimen1.size(); ++i) {
            BgDimensionInfo d1 = (BgDimensionInfo)dimen1.get(i);
            BgDimensionInfo d2 = (BgDimensionInfo)dimen2.get(i);
            if (!("BGITEM".equalsIgnoreCase(d1.getType()) ? !d1.getType().equalsIgnoreCase(d2.getType()) || !d1.getAttributeNumber().equals(d2.getAttributeNumber()) : !d1.getType().equalsIgnoreCase(d2.getType()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getBookOperation() {
        return this.bookOperation;
    }

    @Override
    public List getSheetOperation() {
        return this.sheetOperation;
    }

    @Override
    public boolean isLockSheet() {
        return this.isLockSheet;
    }

    @Override
    public void setBookOperation(List prop) {
        this.bookOperation = prop;
    }

    @Override
    public void setLockSheet(boolean isLocked) {
        this.isLockSheet = isLocked;
    }

    @Override
    public void setSheetOperation(List prop) {
        this.sheetOperation = prop;
    }

    @Override
    public String getOprtState() {
        return this.oprtState;
    }

    @Override
    public void setOprtState(String oprtState) {
        this.oprtState = oprtState;
    }
}

