/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgItemHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.view.BgBillIntegrateCommonException;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.common.AbstractBgBillIntegrate;
import com.kingdee.eas.ma.view.common.BgBillIntegrateParam;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FDCBgBillDefaultIntegrate
extends AbstractBgBillIntegrate {
    private static Logger logger = Logger.getLogger((String)FDCBgBillDefaultIntegrate.class.getName());
    public static final String SYN_CLASS_NAME = "com.kingdee.eas.fdc.finance.app.bg.SynchronizeBizData";
    public static final String DEP_CON_PAY_BILL = "com.kingdee.eas.fdc.finance.app.FDCDepConPayPlanBill";
    public static final String PRO_DEP_CON_PAY = "com.kingdee.eas.fdc.finance.app.FDCProDepConPayPlan";
    public static final String PRO_DEP_SPLIT = "com.kingdee.eas.fdc.finance.app.FDCProDepSplit";
    public static final String PRO_INV_PLAN = "com.kingdee.eas.fdc.finance.app.ProjectInvestPlan";

    @Override
    public FilterInfo buildDefaultFilter(Context ctx, IObjectValue scheme, IObjectValue rule) throws BOSException, EASBizException {
        String boName = ((BgBillIntegrateSchemeInfo)scheme).getBoName();
        FilterInfo filter = new FilterInfo();
        if (DEP_CON_PAY_BILL.equals(boName) || PRO_DEP_CON_PAY.equals(boName) || PRO_INV_PLAN.equals(boName)) {
            filter.appendFilterItem("state", (Object)"10PUBLISH");
        } else if (PRO_DEP_SPLIT.equals(boName)) {
            filter.appendFilterItem("state", (Object)"4AUDITTED");
        }
        return filter;
    }

    @Override
    protected IDataProvider getDataProvider(Context ctx, String boName) throws BOSException, EASBizException {
        if (DEP_CON_PAY_BILL.equals(boName)) {
            return QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fdc.finance.app.FDCDepConPayPlanQuery"));
        }
        if (PRO_DEP_CON_PAY.equals(boName)) {
            return QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fdc.finance.app.FDCProDepConPayPlanQuery"));
        }
        if (PRO_DEP_SPLIT.equals(boName)) {
            return QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fdc.finance.app.FDCProDepSplitQuery"));
        }
        if (PRO_INV_PLAN.equals(boName)) {
            return QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fdc.finance.app.ProjectInvestPlanQuery"));
        }
        return super.getDataProvider(ctx, boName);
    }

    @Override
    protected String convertBgItemNumber(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, String billNumber) {
        if (StringUtils.isEmpty((String)billNumber)) {
            return billNumber;
        }
        return "FDC" + BgItemHelper.changeNumber((String)billNumber);
    }

    @Override
    protected String convertCurrencyNumber(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, String currencyNumber) {
        if (StringUtils.isEmpty((String)currencyNumber) && scheme.getBoName().equals(PRO_INV_PLAN)) {
            return ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency().getNumber();
        }
        return currencyNumber;
    }

    @Override
    public void checkBeforeExtract(Context ctx, BgBillIntegrateSchemeInfo scheme, Map bgPeriodMap, Map bgDataMap, Map orgMap) throws BOSException, EASBizException {
        super.checkBeforeExtract(ctx, scheme, bgPeriodMap, bgDataMap, orgMap);
    }

    @Override
    public void checkAfterExtract(Context ctx, BgBillIntegrateSchemeInfo scheme, List params) throws BOSException, EASBizException {
        if (params == null || params.isEmpty()) {
            throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.PLAYNOTREPORT, new Object[]{scheme.getBoAlias()});
        }
    }

    @Override
    public void synPlan(Context ctx, String operator, List<BgBillIntegrateParam> params) throws BOSException, EASBizException {
        try {
            Class<?> c = Class.forName(SYN_CLASS_NAME);
            Object obj = c.newInstance();
            Method m = c.getMethod("synPlan", Context.class, String.class, List.class);
            m.invoke(obj, ctx, operator, params);
        }
        catch (InstantiationException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"FDCBgBillDefaultIntegrate.synPlan:", (Throwable)e);
        }
    }

    @Override
    public boolean isNeedExtractData(Context ctx, BgBillIntegrateSchemeInfo scheme, BgPeriodEnum bgPeriod) throws BOSException, EASBizException {
        return bgPeriod == null || bgPeriod.getValue() == 8 || bgPeriod.getValue() <= 4;
    }

    @Override
    public String getEntryIdField(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule) throws BOSException, EASBizException {
        String[] oqlRequestTemp = rule.getOqlRequest().split("\\|");
        String oqlRequestField = oqlRequestTemp[0];
        if (oqlRequestField.indexOf(".") > 0) {
            return oqlRequestField.substring(0, oqlRequestField.lastIndexOf(".") + 1) + "id";
        }
        return "id";
    }
}

