/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.BatchExecuteParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.HashMap;

public class BOTPProcessActionProxy
extends ActionProxy {
    private String srcBillType = null;
    private String targetType = null;
    private static final long serialVersionUID = -893611097308760357L;
    private static final Class[] PARAM_TYPE = new Class[]{BOTMappingInfo.class, IObjectPK.class};
    private BOTMappingInfo mappingInfo;

    public BOTPProcessActionProxy(ItemAction action, String actionMethod, ActionLevelEnum level, BatchActionEnum bizAction) {
        super(action, actionMethod, level, bizAction);
    }

    public BOTPProcessActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        super(action, actionMethod, bizAction);
    }

    protected boolean beforeAction() {
        SCMBillBaseInfo editData;
        int billBaseStatusValue;
        boolean ret = true;
        if (this.uiObj instanceof EditUI && ((billBaseStatusValue = (editData = (SCMBillBaseInfo)this.uiObj.getDataObject()).getBaseStatus().getValue()) == 0 || billBaseStatusValue == 1 || billBaseStatusValue == 2 || billBaseStatusValue == 6 || billBaseStatusValue == -2 || billBaseStatusValue == 3)) {
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}");
            String message = format.format(new Object[]{editData.getBaseStatus().getAlias(), EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BASESTATUS_CANNOT_BOTP")});
            MsgBox.showInfo((String)message);
            return false;
        }
        if (!this.getActionManager().getTableSelectionHelper().hasSelectedRows(this.getLevel())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return false;
        }
        if (ret) {
            try {
                this.mappingInfo = this.getBOTMapping();
                if (this.mappingInfo == null) {
                    ret = false;
                }
            }
            catch (EASBizException e) {
                MsgBox.showWarning((String)e.getMessage());
                ret = false;
            }
            catch (BOSException e) {
                MsgBox.showWarning((String)e.getMessage());
                ret = false;
            }
        }
        return ret;
    }

    protected BOTMappingInfo getBOTMapping() throws BOSException, EASBizException {
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingInfo botMappingInfo = null;
        BOTMappingCollection botMappingCol = iBOTMapping.getMappingCollectionForSelect(this.srcBillType, this.targetType, DefineSysEnum.BTP);
        if (botMappingCol.size() == 0) {
            throw new BTPException(BTPException.MAPPINGINFONULLERROR);
        }
        if (botMappingCol.size() > 1) {
            HashMap<String, BOTPProcessActionProxy> uiContext = new HashMap<String, BOTPProcessActionProxy>();
            uiContext.put("Owner", this);
            uiContext.put("BOTMappings", (BOTPProcessActionProxy)botMappingCol);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(BOTMappingSelectUI.class.getName(), uiContext, null);
            window.show();
            if (((BOTMappingSelectUI)window.getUIObject()).isCanceled() || ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                return null;
            }
            botMappingInfo = ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
        } else {
            botMappingInfo = botMappingCol.get(0);
        }
        return botMappingInfo;
    }

    protected BatchExecuteParams initBatchExecuteParams(IBizCtrl iBizInterface, BatchSelectionEntries selectionEntry) {
        boolean isHead = this.getLevel().equals((Object)ActionLevelEnum.HEAD);
        BatchExecuteParams batchParams = new BatchExecuteParams(this.getBizAction(), this.getActionManager().getClzIBizFactory(this.getLevel()), this.getActionMethod(), PARAM_TYPE, selectionEntry, this.getActionManager().getContextType(), iBizInterface.getType());
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
            if (entry.getResult() == ActionResultEnum.ERROR) continue;
            batchParams.newParamsEntry(new Object[]{this.mappingInfo, new ObjectUuidPK(BOSUuid.read((String)(isHead ? entry.getId() : entry.getEntryId())))});
        }
        return batchParams;
    }

    public String getSrcBillType() {
        return this.srcBillType;
    }

    public void setSrcBillType(String srcBillType) {
        this.srcBillType = srcBillType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public BOTMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }
}

