/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;

public class BillUpdater {
    protected Context ctx;
    protected String sourceDataTable;
    protected String targetTable;
    protected boolean isUpdateHead = false;
    protected String unBaseQtyExpression = null;
    protected String[] baseQtyFields = null;
    protected String[] baseQtyOperation = null;
    protected String[] qtyFields = null;
    protected String[] qtyOperation = null;
    protected boolean isAuditAction = true;
    protected boolean isTransfUnit = true;
    protected boolean isReleaseTempTable = true;
    protected BatchActionResults batchResults;
    protected boolean isThrowException = true;
    protected EASBizException throwExcpetion;
    protected boolean isDeleteTempData = true;

    public BillUpdater() {
    }

    public BillUpdater(Context ctx) {
        this.ctx = ctx;
    }

    protected String getFID() {
        return this.isUpdateHead ? "FSourceBillID" : "FSourceBillEntryId";
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean ret = true;
        String expr = this.compileExpr(this.unBaseQtyExpression);
        StringBuffer sqlBuf = new StringBuffer();
        if (this.isThrowException()) {
            sqlBuf.append("select top 1 * from ");
        } else {
            sqlBuf.append("select distinct FBillID from ");
        }
        sqlBuf.append(this.sourceDataTable).append(" t0 ").append("left outer join (").append("select t1.FID ").append("from ").append(this.targetTable).append(" t1  ").append("inner join (select tt.").append(this.getFID()).append(" FSRCID,sum(tt.FBaseQty) sum_baseqty ").append("from ").append(this.sourceDataTable).append(" tt ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID and ").append(expr).append(" >= t2.sum_baseqty ").append(") t20 on t0.").append(this.getFID()).append(" = t20.FID ").append("where t20.FID is null and t0.").append(this.getFID()).append(" is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (this.isThrowException()) {
                if (rs != null && rs.next()) {
                    ret = false;
                }
            } else {
                sqlBuf.setLength(0);
                sqlBuf.append("delete ").append(this.sourceDataTable).append(" where FBillID in (");
                int i = 0;
                HashMap<String, String> errMap = new HashMap<String, String>();
                while (rs != null && rs.next()) {
                    String billID = rs.getString("FBillID");
                    if (errMap.containsKey(billID)) continue;
                    this.batchResults.addError(billID, (Exception)((Object)this.throwExcpetion));
                    errMap.put(billID, "1");
                    sqlBuf.append(i > 0 ? "," : " ").append("?");
                    ++i;
                }
                sqlBuf.append(")");
                if (i > 0 && this.isDeleteTempData) {
                    DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString(), (Object[])errMap.keySet().toArray());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private String compileExpr(String expr) {
        char[] expChars = expr.toCharArray();
        StringBuffer expBuf = new StringBuffer();
        for (int i = 0; i < expChars.length; ++i) {
            if ((expChars[i] >= 'a' && expChars[i] <= 'z' || expChars[i] >= 'A' && expChars[i] <= 'Z') && (i == 0 || i > 0 && (expChars[i - 1] == '+' || expChars[i - 1] == '-' || expChars[i - 1] == ' ' || expChars[i - 1] == '('))) {
                expBuf.append("t1.");
            }
            expBuf.append(expChars[i]);
        }
        return expBuf.toString();
    }

    public void writeBack() throws BOSException, EASBizException {
        int i;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update ").append(this.targetTable).append(" as a ").append("set (");
        for (i = 0; i < this.baseQtyFields.length; ++i) {
            sqlBuffer.append(i > 0 ? "," : " ").append(this.baseQtyFields[i]);
        }
        for (i = 0; i < this.qtyFields.length; ++i) {
            sqlBuffer.append(this.baseQtyFields.length > 0 || i > 0 ? "," : " ").append(this.qtyFields[i]);
        }
        sqlBuffer.append(") = (select ");
        for (i = 0; i < this.baseQtyFields.length; ++i) {
            sqlBuffer.append(i > 0 ? "," : " ").append("a.").append(this.baseQtyFields[i]).append(this.baseQtyOperation[i]).append(" t.FBaseQty ");
        }
        for (i = 0; i < this.qtyFields.length; ++i) {
            sqlBuffer.append(this.baseQtyFields.length > 0 || i > 0 ? "," : " ").append("a.").append(this.qtyFields[i]).append(this.qtyOperation[i]);
            if (this.isTransfUnit) {
                sqlBuffer.append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision) ");
                continue;
            }
            sqlBuffer.append(" t.FQty ");
        }
        sqlBuffer.append(" from  (").append("select decimal(sum(FBaseQty),21,8) FBaseQty,decimal(sum(FQty),21,8) FQty,").append(this.getFID()).append(" FSRCID ").append("from ").append(this.sourceDataTable).append(" ").append("group by ").append(this.getFID()).append(") t ");
        if (this.isTransfUnit) {
            sqlBuffer.append(",t_bd_multimeasureunit  b ").append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ").append("and ").append(this.getConnectStr());
        } else {
            sqlBuffer.append("WHERE ").append(this.getConnectStr());
        }
        sqlBuffer.append(") ");
        sqlBuffer.append(" where a.fid in ( select ").append(this.getFID()).append(" from ").append(this.sourceDataTable).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sqlBuffer.toString());
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        return true;
    }

    protected String getConnectStr() {
        return " a.fid = t.FSRCID ";
    }

    protected void afterExecute() throws BOSException, EASBizException {
        if (this.isReleaseTempTable) {
            this.releaseTemptable(this.sourceDataTable);
        }
    }

    public void releaseTemptable(String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        pool.releaseTable(tableName);
    }

    public void execute() throws BOSException, EASBizException {
        boolean isContinue = this.beforeExecute();
        if (isContinue) {
            if (this.isAuditAction && !this.qtyCheck()) {
                throw this.throwExcpetion != null ? this.throwExcpetion : new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY);
            }
            this.writeBack();
            this.afterExecute();
        }
    }

    public String getSourceDataTable() {
        return this.sourceDataTable;
    }

    public void setSourceDataTable(String sourceDataTable) {
        this.sourceDataTable = sourceDataTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public boolean isUpdateHead() {
        return this.isUpdateHead;
    }

    public void setUpdateHead(boolean isUpdateHead) {
        this.isUpdateHead = isUpdateHead;
    }

    public String getUnBaseQtyExpression() {
        return this.unBaseQtyExpression;
    }

    public void setUnBaseQtyExpression(String unBaseQtyExpression) {
        this.unBaseQtyExpression = unBaseQtyExpression;
    }

    public String[] getBaseQtyFields() {
        return this.baseQtyFields;
    }

    public void setBaseQtyFields(String[] baseQtyFields) {
        this.baseQtyFields = baseQtyFields;
    }

    public String[] getQtyFields() {
        return this.qtyFields;
    }

    public void setQtyFields(String[] qtyFields) {
        this.qtyFields = qtyFields;
    }

    public boolean isAuditAction() {
        return this.isAuditAction;
    }

    public void setAuditAction(boolean isAuditAction) {
        this.isAuditAction = isAuditAction;
    }

    public boolean isTransfUnit() {
        return this.isTransfUnit;
    }

    public void setTransfUnit(boolean isTransfUnit) {
        this.isTransfUnit = isTransfUnit;
    }

    public boolean isReleaseTempTable() {
        return this.isReleaseTempTable;
    }

    public void setReleaseTempTable(boolean isReleaseTempTable) {
        this.isReleaseTempTable = isReleaseTempTable;
    }

    public String[] getBaseQtyOperation() {
        return this.baseQtyOperation;
    }

    public void setBaseQtyOperation(String[] baseQtyOperation) {
        this.baseQtyOperation = baseQtyOperation;
    }

    public String[] getQtyOperation() {
        return this.qtyOperation;
    }

    public void setQtyOperation(String[] qtyOperation) {
        this.qtyOperation = qtyOperation;
    }

    public BatchActionResults getBatchResults() {
        return this.batchResults;
    }

    public void setBatchResults(BatchActionResults batchResults) {
        this.batchResults = batchResults;
    }

    public boolean isThrowException() {
        return this.isThrowException;
    }

    public void setThrowException(boolean isThrowException) {
        this.isThrowException = isThrowException;
    }

    public EASBizException getThrowExcpetion() {
        return this.throwExcpetion;
    }

    public void setThrowExcpetion(EASBizException throwExcpetion) {
        this.throwExcpetion = throwExcpetion;
    }
}

