/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLLogParam;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BizCommand {
    protected static final Logger logger = MMLogger.getLogger();
    protected Context ctx;
    protected Date beginTime;
    protected int sqlCount = 0;

    public BizCommand(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    protected void logBegin() {
        this.beginTime = new Date();
        this.sqlCount = 0;
    }

    protected void logEnd() {
        if (SQLLogParam.getInstance().isOpen()) {
            String exeClassName = this.getClass().toString();
            logger.info((Object)(exeClassName + ".doing(),execute time(s)," + String.valueOf(this.countExeTime()) + ",SQL count," + String.valueOf(this.sqlCount)));
        }
    }

    private BigDecimal countExeTime() {
        Date endTime = new Date();
        BigDecimal e = new BigDecimal(String.valueOf(endTime.getTime()));
        BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
        BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
        return runSecs;
    }

    public Object execute(Object inParam) throws BOSException, EASBizException {
        this.logBegin();
        Object ret = this.doing(inParam);
        this.logEnd();
        return ret;
    }

    protected abstract Object doing(Object var1) throws BOSException, EASBizException;

    protected int execute(String sql) throws BOSException {
        DbUtil.execute((Context)this.ctx, (String)sql);
        ++this.sqlCount;
        return 0;
    }

    protected int execute(String sql, Object[] params) throws BOSException {
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])params);
        ++this.sqlCount;
        return 0;
    }

    protected IRowSet executeQuery(String sql) throws BOSException {
        IRowSet rs = SQLUtils.executeQuery(this.ctx, sql);
        ++this.sqlCount;
        return rs;
    }

    protected IRowSet executeQuery(String sql, Object[] params) throws BOSException {
        IRowSet rs = SQLUtils.executeQuery(this.ctx, sql, params);
        ++this.sqlCount;
        return rs;
    }

    protected int[] executeBatch(String sql, List paramsList) throws BOSException {
        int[] resultNum = SQLUtils.executeBatch(this.ctx, sql, paramsList);
        ++this.sqlCount;
        return resultNum;
    }

    protected int[] executeBatch(String[] sqls) throws BOSException {
        int[] resultNum = SQLUtils.executeBatch(this.ctx, sqls);
        this.sqlCount += sqls.length;
        return resultNum;
    }

    protected void cleanup(Connection cn) {
        this.cleanup(null, null, cn);
    }

    protected void cleanup(Statement stmt) {
        this.cleanup(null, stmt, null);
    }

    protected void cleanup(Statement stmt, Connection cn) {
        this.cleanup(null, stmt, cn);
    }

    protected void cleanup(ResultSet rs) {
        this.cleanup(rs, null, null);
    }

    protected void cleanup(ResultSet rs, Statement stmt) {
        this.cleanup(rs, stmt, null);
    }

    protected void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        SQLUtils.cleanup(rs, stmt, cn);
    }
}

