/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DBBatchUtil {
    private static Logger logger = Logger.getLogger(DBBatchUtil.class);

    private static Connection getConnection(Context ctx) throws SQLException {
        Connection conn = null;
        conn = EJBFactory.getConnection((Context)ctx);
        return conn;
    }

    public static void executeBatch(Context ctx, List sqls) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        StringBuffer src = new StringBuffer();
        try {
            conn = DBBatchUtil.getConnection(ctx);
            stmt = conn.createStatement();
            for (String sql : sqls) {
                stmt.addBatch(sql);
                src.append(sql + ";\n");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sqls is:" + src.toString()), (Throwable)e);
                throw new BOSException("Sql1 execute exception : " + src.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static void executeBatch(Context ctx, String paramSql, List params) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        StringBuffer src = new StringBuffer();
        src.append(paramSql + ";\n");
        try {
            conn = DBBatchUtil.getConnection(ctx);
            stmt = conn.prepareStatement(paramSql);
            for (Object[] row : params) {
                src.append("[");
                for (int i = 0; i < row.length; ++i) {
                    stmt.setObject(i + 1, row[i]);
                    src.append(row[i] + ",");
                }
                stmt.addBatch();
                src.append("]\n");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql info : " + src.toString()), (Throwable)e);
                throw new BOSException("Sql execute exception : " + src.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }
}

