/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.mm.common.MMBaseInfo;
import com.kingdee.eas.mm.common.app.AbstractMMBaseControllerBean;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class MMBaseControllerBean
extends AbstractMMBaseControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 8620072816312008351L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.common.app.MMBaseControllerBean");

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            this.refCheck(ctx, batchResults);
            this.deleteCheck(ctx, batchResults);
        }
    }

    protected void refCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            BizReference ref = null;
            String RESOURCE_PATH = "com.kingdee.eas.mm.common.MMResource";
            Locale locale = ctx.getLocale();
            for (int i = 0; i < batchResults.getToDoIdsArray().length; ++i) {
                String id = batchResults.getToDoIdsArray()[i];
                ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)id));
                if (ref == null) continue;
                String refEntityAlias = ref.getRefEntityAlias(locale);
                String msg = ResourceUtils.getMessageForServer(RESOURCE_PATH, "be_referenced", new String[]{refEntityAlias});
                batchResults.addError(id, msg);
            }
        }
    }

    protected abstract String getDeleteTableName();

    private void deleteCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            String idStr = SQLUtil.arrayToString(batchResults.getToDoIdsArray());
            String sql = "select FID from " + this.getDeleteTableName() + " where FID in(" + idStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String[] ids = new String[rs.size()];
            int idIndex = 0;
            while (rs.next()) {
                ids[idIndex] = rs.getString("FID");
                ++idIndex;
            }
            for (int i = 0; i < batchResults.getToDoIdsArray().length; ++i) {
                String originId = batchResults.getToDoIdsArray()[i];
                boolean isExist = false;
                for (int j = 0; j < ids.length; ++j) {
                    if (isExist || !ids[j].equalsIgnoreCase(originId)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                batchResults.addError(originId, (Exception)((Object)new MMBaseException(MMBaseException.RECORD_NOT_EXIST)));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            String idStr = SQLUtil.arrayToString(batchResults.getToDoIdsArray());
            String billSql = this.getRecycleNumberSQL(idStr);
            CommonUtils.batchRecycleNumber(ctx, billSql, this.getBillInstance());
            this.delete(ctx, batchResults);
        }
    }

    protected abstract IObjectValue getBillInstance();

    protected abstract String getRecycleNumberSQL(String var1);

    protected abstract void delete(Context var1, BatchActionResults var2) throws BOSException, EASBizException;

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, (Object[])entries);
        executeContext.setXmlFileName(this.getXmlFileName(batchActionEnum));
        executeContext.setBillTypeID(this.getBillTypeId());
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common((ExecuteContext)executeContext);
        return DynamicBusinessProcessHelper.batchExecute((Context)ctx, (BizController)this, (IBusinessProcessorBuilder)builder, (BatchExecuteParamsEntry[])entries, (String)this.getXmlFileName(batchActionEnum));
    }

    protected abstract String getBillTypeId();

    protected abstract String getXmlFileName(BatchActionEnum var1);

    protected abstract ICoreBase getBizInterface(Context var1) throws BOSException, EASBizException;

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchEnable(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("ENABLE"));
    }

    public BatchActionResults batchDisable(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("DISABLE"));
    }

    protected BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    public BatchActionResults batchSubmit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchSubmitRelations(ctx, entries);
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        MMBaseInfo objValue;
        boolean isFromEditUI = false;
        if (entries != null && entries.length == 1 && (objValue = (MMBaseInfo)entries[0].get(0)).getStorageOrgUnit() != null) {
            isFromEditUI = true;
        }
        if (!isFromEditUI) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                IObjectValue objValue2 = (IObjectValue)entries[i].get(0);
                keys.add(objValue2.getString("id"));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(this.getSubmitSelectors());
            CoreBaseCollection billCol = this.getCollection(ctx, viewInfo);
            int size2 = entries.length;
            for (int i = 0; i < size2; ++i) {
                IObjectValue objValue3 = (IObjectValue)entries[i].get(0);
                entries[i].set(0, (Object)billCol.get((Object)BOSUuid.read((String)objValue3.getString("id"))));
            }
        }
        return this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected SelectorItemCollection getSubmitSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public BatchActionResults batchSaveRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.SAVE);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumber(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumber(ctx, model);
        return super._submit(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MMBaseInfo prjInfo = (MMBaseInfo)model;
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("storageOrgUnit");
        codeHelper.checkNumber(ctx, this.getBizInterface(ctx), model, (OrgUnitInfo)prjInfo.getStorageOrgUnit());
    }

    @Override
    protected IObjectPK _submitInBatch(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        return iBTPManager.submitRelations((CoreBillBaseInfo)model, (BOTRelationCollection)relations);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDelete(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchAudit(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnAudit(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchEnable(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDisable(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }
}

