/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLLogParam;
import com.kingdee.eas.mm.common.app.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SQLLogUtil {
    private static final int MAX_SQL_LENGTH = 3000;

    private static boolean isLogOpen() {
        return SQLLogParam.getInstance().isOpen();
    }

    public static final void writeLog(Context ctx, long timeFrom, long timeTo, String[] sqls, Object[] params, int[] numbers) throws BOSException {
        if (!SQLLogUtil.isLogOpen()) {
            return;
        }
        if (sqls == null || sqls.length == 0) {
            return;
        }
        StackTraceElement[] traces = new Throwable().getStackTrace();
        String methodName = null;
        String className = null;
        for (int i = 0; i < traces.length - 1; ++i) {
            StackTraceElement trace = traces[i];
            className = trace.getClassName();
            if (!className.equalsIgnoreCase(SQLUtils.class.getName()) || i + 1 >= traces.length) continue;
            methodName = traces[i + 1].getClassName() + "." + traces[i + 1].getMethodName();
            break;
        }
        Logger logger = MMLogger.getLogger();
        logger.info((Object)("thread:" + Thread.currentThread().getName()));
        logger.info((Object)("function name :" + SQLLogParam.getInstance().getFuncType()));
        logger.info((Object)("method name :" + methodName));
        StringBuffer sqlBuf = new StringBuffer();
        for (int i = 0; i < sqls.length; ++i) {
            if (i == sqls.length - 1) {
                sqlBuf.append(sqls[i]);
                continue;
            }
            sqlBuf.append(sqls[i] + "\r\n");
        }
        logger.info((Object)("SQL: " + sqlBuf.toString()));
        logger.info((Object)("SQL Parameters:" + SQLLogUtil.getParamsString(params)));
        logger.info((Object)("execute start time :" + new Timestamp(timeFrom)));
        logger.info((Object)("execute time :" + String.valueOf(timeTo - timeFrom) + "ms"));
        int number = 0;
        for (int i = 0; numbers != null && i < numbers.length; ++i) {
            number += numbers[i];
        }
        logger.info((Object)("return record count:" + String.valueOf(number)));
    }

    public static final void writeLog2DB(Context ctx, long timeFrom, long timeTo, String[] sqls, Object[] params, int[] numbers) throws BOSException {
        if (!SQLLogUtil.isLogOpen()) {
            return;
        }
        if (sqls == null || sqls.length == 0) {
            return;
        }
        StackTraceElement[] traces = new Throwable().getStackTrace();
        String fileName = null;
        String exeMethodName = null;
        for (int i = 0; i < traces.length - 1; ++i) {
            StackTraceElement trace = traces[i];
            fileName = trace.getClassName();
            if (!fileName.equalsIgnoreCase(SQLUtils.class.getName())) continue;
            exeMethodName = traces[i + 1].getMethodName();
            break;
        }
        Connection con = null;
        PreparedStatement statement = null;
        StringBuffer sqlLog = new StringBuffer();
        sqlLog.append("INSERT INTO T_MM_SQLLOG(FID,FType,");
        sqlLog.append("FMethod,FGroup,FSQL,FParams,");
        sqlLog.append("FStartTime,FTimeOffset,FResultNum) ");
        sqlLog.append("VALUES (?,?,?,?,?,?,?,?,?)");
        try {
            con = EJBFactory.getConnection((Context)ctx);
            statement = con.prepareStatement(sqlLog.toString());
            statement.setString(1, BOSUuid.create((String)"5D4E00FD").toString());
            statement.setString(2, SQLLogParam.getInstance().getFuncType());
            statement.setString(3, exeMethodName);
            statement.setString(4, Thread.currentThread().getName());
            statement.setString(5, SQLLogUtil.getSQL(sqls));
            statement.setString(6, SQLLogUtil.getParamsString(params));
            statement.setTimestamp(7, new Timestamp(timeFrom));
            statement.setInt(8, (int)(timeTo - timeFrom));
            int number = 0;
            for (int i = 0; numbers != null && i < numbers.length; ++i) {
                number += numbers[i];
            }
            statement.setInt(9, number);
            statement.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private static String getSQL(String[] sqls) {
        StringBuffer sqlBuffer = new StringBuffer();
        String result = null;
        for (int i = 0; i < sqls.length; ++i) {
            if (sqls[i].trim().toLowerCase().startsWith("select")) {
                int index = sqls[i].toLowerCase().indexOf("from");
                sqls[i] = sqls[i].substring(index);
            }
            sqlBuffer.append(sqls[i]);
        }
        result = sqlBuffer.length() > 3000 ? sqlBuffer.substring(0, 3000) : sqlBuffer.toString();
        return result;
    }

    private static String getParamsString(Object[] params) {
        String result = null;
        if (params != null && params.length != 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Object[]) {
                    Object[] temp = (Object[])params[i];
                    for (int j = 0; j < temp.length; ++j) {
                        param.append(temp[j]);
                        param.append(",");
                    }
                    continue;
                }
                param.append(params[i]);
                param.append(",");
            }
            result = param.toString().length() > 3000 ? param.toString().substring(0, 3000) : param.toString();
        }
        return result;
    }

    public static final void writeLog(Context ctx, long timeFrom, long timeTo, String sql, Object[] params, int number) throws BOSException {
        SQLLogUtil.writeLog(ctx, timeFrom, timeTo, new String[]{sql}, params, new int[]{number});
    }

    public static final int[] arraycopy(int[] resultNum, int[] result) {
        int[] temp = null;
        if (resultNum != null && result != null) {
            temp = new int[result.length + resultNum.length];
            System.arraycopy(resultNum, 0, temp, 0, resultNum.length);
            System.arraycopy(result, 0, temp, resultNum.length, result.length);
        }
        return temp;
    }
}

