/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.IMMBatchExecutor;
import com.kingdee.eas.mm.common.app.bizprocess.processorbuilder.MMBusinessProcessorBuilder;
import com.kingdee.eas.util.ResourceBase;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractMMBatchExecutor
implements IMMBatchExecutor {
    protected BatchActionEnum batchAction;
    protected BOSObjectType bosType;
    protected String billTypeID;

    public AbstractMMBatchExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        this.bosType = type;
        this.batchAction = action;
        this.billTypeID = typeID;
    }

    @Override
    public BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, true);
    }

    @Override
    public BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, boolean isBatchLoadForced) throws EASBizException, BOSException {
        IBusinessProcessor processor = this.buildProcessor(ctx);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        if (isBatchLoadForced) {
            this.batchLoadBizObjects(ctx, batchResults);
        }
        if (processor != null && this instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)this);
        }
        return processor.execute(batchResults);
    }

    protected IBusinessProcessor buildProcessor(Context ctx) throws BOSException, EASBizException {
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.bosType, this.batchAction, null, new Object[0]);
        executeContext.setXmlFileName(this.getXmlFileName(this.batchAction));
        MMBusinessProcessorBuilder builder = new MMBusinessProcessorBuilder((ExecuteContext)executeContext);
        return builder.buildProcessor(ctx);
    }

    protected void batchLoadBizObjects(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            Set idSet = batchResults.getToDoIdsSet();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(this.getAddedSelector());
            IObjectCollection collection = this.loadObjectCollection(ctx, this.bosType, view);
            batchResults.setObjCollection(collection);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectCollection loadObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo view) throws BOSException, EASBizException {
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)bosType);
        Method mGetCollection = BusinessProcessUtil.getCollectionMethod((Context)ctx, (BOSObjectType)bosType);
        return (IObjectCollection)BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBiz, (Method)mGetCollection, (Object[])new Object[]{view});
    }

    protected String getString(Context ctx, String resourceName) {
        String strTemp = ResourceBase.getString((String)this.getResourcePath(), (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    protected BigDecimal dealNullQty(BigDecimal qty, BigDecimal blankVlaue) {
        return qty != null ? qty : blankVlaue;
    }

    protected abstract SelectorItemCollection getAddedSelector();

    protected abstract String getXmlFileName(BatchActionEnum var1);

    protected abstract String getResourcePath();
}

