/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.mm.common.app.verify.IMMXmlParse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public final class MMXmlParseFactory
implements IMMXmlParse {
    private static MMXmlParseFactory theInstance = new MMXmlParseFactory();
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String DOT_XML = ".xml";
    private Map xmlMap = new HashMap();

    private MMXmlParseFactory() {
    }

    public static MMXmlParseFactory getInstance() {
        return theInstance;
    }

    @Override
    public List parse(String XmlFileName, String verifyManagerName) throws BOSException {
        Element root = null;
        root = this.xmlMap.containsKey(XmlFileName) ? (Element)this.xmlMap.get(XmlFileName) : this.parseRootXml(XmlFileName);
        if (root == null) {
            return new ArrayList();
        }
        return this.getVerifyItems(root, verifyManagerName);
    }

    private List getVerifyItems(Element root, String verifyManagerName) {
        ArrayList<String> Items = new ArrayList<String>();
        List managerList = root.getChildren();
        if (managerList == null || managerList.size() == 0) {
            return Items;
        }
        for (int i = 0; i < managerList.size(); ++i) {
            Element manager = (Element)managerList.get(i);
            if (!verifyManagerName.equals(manager.getAttributeValue(ATTRIBUTE_NAME))) continue;
            Element verifyItems = (Element)manager.getChildren().get(0);
            if (verifyItems == null || verifyItems.getChildren() == null || verifyItems.getChildren().size() == 0) {
                return Items;
            }
            List itemList = verifyItems.getChildren();
            for (int j = 0; j < itemList.size(); ++j) {
                Element item = (Element)itemList.get(j);
                String className = item.getAttributeValue(ATTRIBUTE_CLASS_NAME);
                if (StringUtil.isEmptyString((String)className) || Items.contains(className)) continue;
                Items.add(className);
            }
            break;
        }
        return Items;
    }

    private Element parseRootXml(String XmlFileName) throws BOSException {
        Element root = null;
        InputStream is = null;
        String trueXmlFileName = null;
        try {
            if (XmlFileName.endsWith(DOT_XML)) {
                XmlFileName = XmlFileName.substring(0, XmlFileName.lastIndexOf(DOT_XML));
                trueXmlFileName = XmlFileName.replaceAll("\\.", "/") + DOT_XML;
            } else {
                trueXmlFileName = XmlFileName.replaceAll("\\.", "/") + DOT_XML;
            }
            is = this.getClass().getClassLoader().getResourceAsStream(trueXmlFileName);
            if (is == null) {
                Element element = null;
                return element;
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
            if (root != null) {
                this.xmlMap.put(XmlFileName, root);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return root;
    }
}

