/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.backFlush.BatchBackFlushResults;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import java.util.List;

public abstract class AbstractBFProcessor {
    protected Context ctx;
    protected boolean isAutoBackFlush;

    public void run(BFCalcParam runParam) throws BOSException, EASBizException {
        this.ctx = runParam.getContext();
        this.isAutoBackFlush = runParam.isAutoBackFlush();
        if (WfEventListenerStateManager.getInstance().isEnable()) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        try {
            List stepList = this.getStepList();
            for (int i = 0; i < stepList.size(); ++i) {
                if (!this.isContinue(runParam)) continue;
                ((IBFStep)stepList.get(i)).execute(runParam);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.finallyHandle(runParam);
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    protected void finallyHandle(BFCalcParam runParam) throws BOSException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        mutex.batchReleaseObjIDForUpdate((List)runParam.getObject("BFBillIdList"));
    }

    private boolean isContinue(BFCalcParam runParam) {
        BatchBackFlushResults results = runParam.getBackFlushResults();
        List toDoIdList = (List)runParam.getObject("ReqBillToDoIdList");
        return results.getToDoIdsList().size() > 0 || toDoIdList != null && toDoIdList.size() > 0;
    }

    protected abstract List getStepList() throws EASBizException, BOSException;
}

