/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.backFlush.BatchBackFlushResults;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class AbstractBFStep
implements IBFStep {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.common.app.backFlush.AbstractBFStep");
    protected Context ctx;
    protected String bfBillBosType;
    protected BatchBackFlushResults backFlushResults;
    private long start;
    private long end;

    protected void loggingBefore() {
        this.start = System.currentTimeMillis();
        logger.info((Object)(this.getLogDesc() + " start at: " + this.start));
    }

    protected void loggingAfter() {
        this.end = System.currentTimeMillis();
        logger.info((Object)(this.getLogDesc() + " end at: " + this.end));
        logger.info((Object)(this.getLogDesc() + " spend " + (this.end - this.start) + " MS "));
    }

    @Override
    public void execute(BFCalcParam runParam) throws EASBizException, BOSException {
        this.ctx = runParam.getContext();
        this.bfBillBosType = runParam.getBFBillBOSType();
        this.backFlushResults = runParam.getBackFlushResults();
        this.loggingBefore();
        try {
            this.innerExecute(runParam);
        }
        catch (EASBizException e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.loggingAfter();
        }
    }

    protected abstract void innerExecute(BFCalcParam var1) throws EASBizException, BOSException;

    private String getLogDesc() {
        String str = this.getClass().getName();
        int i = str.lastIndexOf(".");
        str = str.substring(i + 1, str.length());
        str = "thread is: " + Thread.currentThread().getName() + " Step is: " + str + " ";
        return str;
    }

    protected void handleErrorResults(String billId, BOTRelationCollection relations, String failinfo, String message) {
        BOTRelationInfo relationInfo = null;
        Iterator ite = relations.iterator();
        while (ite.hasNext()) {
            relationInfo = (BOTRelationInfo)ite.next();
            if (relationInfo.getDestObjectID().equals(billId)) {
                ite.remove();
            }
            if (!relationInfo.getSrcEntityID().equals(this.bfBillBosType) || !relationInfo.getDestObjectID().equals(billId)) continue;
            this.setError(relationInfo.getSrcObjectID(), failinfo, message);
        }
        this.setFail(billId, message);
    }

    protected void setFail(String id, String message) {
        this.backFlushResults.addFail(id);
    }

    protected void setError(String id, String failInfo, String errorMassege) {
        this.backFlushResults.addError(id, failInfo);
        logger.info((Object)(this.getLogDesc() + ", BACKFLUSH FAIL: " + failInfo + ", ERROR: " + errorMassege + "\u3002"));
    }
}

