/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordFactory;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordInfo;
import com.kingdee.eas.mm.common.backFlush.app.BFBillHandleFactory;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.IBFBillHandle;
import com.kingdee.eas.mm.common.backFlush.app.step.AbstractBFStep;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BFRecordUpdateStep
extends AbstractBFStep
implements IBFStep {
    private static final String FAILINFO = BackFlushUtil.getString("BACKFLUSH_NOBFMATERIAL");

    @Override
    protected void innerExecute(BFCalcParam runParam) throws EASBizException, BOSException {
        List bfBillIdList = (List)runParam.getObject("BFBillIdList");
        List bfBillEntryIdList = (List)runParam.getObject("BFBillEntryIdList");
        BackFlushRecordCollection updateCol = new BackFlushRecordCollection();
        BackFlushRecordCollection addCol = new BackFlushRecordCollection();
        ArrayList<ObjectUuidPK> deletePkList = new ArrayList<ObjectUuidPK>();
        BackFlushRecordCollection dbCol = BackFlushUtil.getBFRecordsFromDBBySrcBillIds(this.ctx, bfBillIdList);
        BackFlushRecordCollection col = this.buildBFRecordsByBFbill(bfBillEntryIdList);
        String bfBillId2 = null;
        BackFlushRecordInfo info = null;
        for (String bfBillId2 : bfBillIdList) {
            boolean hasBFData = false;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                info = (BackFlushRecordInfo)iter.next();
                if (!bfBillId2.equalsIgnoreCase(info.getSrcBillId())) continue;
                hasBFData = true;
                break;
            }
            if (hasBFData) continue;
            this.setError(bfBillId2, FAILINFO, FAILINFO);
        }
        BackFlushRecordInfo dbInfo = null;
        Iterator ite = dbCol.iterator();
        while (ite.hasNext()) {
            dbInfo = (BackFlushRecordInfo)ite.next();
            boolean hasSameRecord = false;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                info = (BackFlushRecordInfo)iter.next();
                if (!this.isSameRecord(dbInfo, info)) continue;
                if (this.isUpdate(dbInfo, info)) {
                    dbInfo.setPlanBFQty(info.getPlanBFQty());
                    dbInfo.setBasePlanBFQty(info.getBasePlanBFQty());
                    updateCol.add(dbInfo);
                }
                iter.remove();
                hasSameRecord = true;
                break;
            }
            if (hasSameRecord || null == info) continue;
            deletePkList.add(new ObjectUuidPK(info.getId()));
        }
        ArrayList<String> idList = new ArrayList<String>();
        if (updateCol.size() > 0) {
            IObjectPK[] pks = BackFlushRecordFactory.getLocalInstance(this.ctx).batchUpdateData(updateCol);
            this.putAllToList(pks, idList);
        }
        if (col.size() > 0) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                addCol.add((BackFlushRecordInfo)iter.next());
            }
            IObjectPK[] pks = BackFlushRecordFactory.getLocalInstance(this.ctx).batchAddNewData(addCol);
            this.putAllToList(pks, idList);
        }
        if (deletePkList.size() > 0) {
            IObjectPK[] pkArray = new IObjectPK[deletePkList.size()];
            int n = deletePkList.size();
            for (int i = 0; i < n; ++i) {
                pkArray[i] = (ObjectUuidPK)deletePkList.get(i);
            }
            BackFlushRecordFactory.getLocalInstance(this.ctx).batchDeleteData(pkArray);
        }
        if (idList.size() > 0) {
            BackFlushRecordFactory.getLocalInstance(this.ctx).updatePrecision(idList);
        }
    }

    private void putAllToList(IObjectPK[] pks, List<String> idList) {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            idList.add(pks[i].toString());
        }
    }

    private boolean isSameRecord(BackFlushRecordInfo dbInfo, BackFlushRecordInfo info) {
        return dbInfo.getSrcBillEntryId().equals(info.getSrcBillEntryId()) && dbInfo.getOrderEntryId().equals(info.getOrderEntryId());
    }

    private boolean isUpdate(BackFlushRecordInfo dbInfo, BackFlushRecordInfo info) {
        return !dbInfo.isIsBackFlushed() && dbInfo.getPlanBFQty().compareTo(info.getPlanBFQty()) != 0 && dbInfo.getBasePlanBFQty().compareTo(info.getBasePlanBFQty()) != 0;
    }

    private BackFlushRecordCollection buildBFRecordsByBFbill(List idList) throws BOSException, EASBizException {
        return this.getBFBillHandle().buildBFRecords(idList);
    }

    private IBFBillHandle getBFBillHandle() throws BOSException {
        return BFBillHandleFactory.getHandleInstance(this.ctx, this.bfBillBosType);
    }
}

