/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordFactory;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordInfo;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.BFDataParserFactory;
import com.kingdee.eas.mm.common.backFlush.app.IBFDataParser;
import com.kingdee.eas.mm.common.backFlush.app.step.AbstractBFStep;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class GenMaterialReqStep
extends AbstractBFStep
implements IBFStep {
    private static final String BACKFLUSH_BOTOPID = "WtTwD1wKSIitu4TVnLY3LgRRIsQ=";
    private static final String MATERIALREQ_BOSTYPE = "500AB75E";
    private static final String BOTRELATION_BOSTYPE = "59302EC6";

    @Override
    protected void innerExecute(BFCalcParam runParam) throws EASBizException, BOSException {
        List bfBillIdList = runParam.getBackFlushResults().getToDoIdsList();
        BackFlushRecordCollection dbCol = this.getBFRecordsFromDB(this.ctx, bfBillIdList);
        CoreBillBaseCollection orderCol = this.getBFDataParser().parseData(dbCol);
        BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BACKFLUSH_BOTOPID));
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)this.ctx).transform(orderCol, mappingInfo);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection relations = btpResult.getBOTRelationCollection();
        this.handleAfterTransform(this.ctx, "SAVE", destBillCols);
        BOTRelationCollection bfRelation = this.createBFBillRelation(destBillCols, dbCol);
        relations.addCollection(bfRelation);
        runParam.setObject("ReqBillColletion", destBillCols);
        runParam.setObject("RelationColletion", relations);
    }

    private BackFlushRecordCollection getBFRecordsFromDB(Context ctx, List bfBillIdList) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillId", (Object)BackFlushUtil.listToSet(bfBillIdList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBackFlushed", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        return BackFlushRecordFactory.getLocalInstance(ctx).getBackFlushRecordCollection(view);
    }

    private BOTRelationCollection createBFBillRelation(IObjectCollection destBillCols, BackFlushRecordCollection dbCol) {
        BOTRelationCollection bfRelation = new BOTRelationCollection();
        HashSet<String> tempSet = new HashSet<String>();
        MaterialReqBillInfo reqBill = null;
        MaterialReqBillEntryCollection reqBillEntryCol = null;
        MaterialReqBillEntryInfo reqBillEntry = null;
        BackFlushRecordInfo bfRecord = null;
        String key = null;
        int n = destBillCols.size();
        for (int i = 0; i < n; ++i) {
            reqBill = (MaterialReqBillInfo)destBillCols.getObject(i);
            reqBillEntryCol = reqBill.getEntry();
            int m = reqBillEntryCol.size();
            for (int j = 0; j < m; ++j) {
                reqBillEntry = reqBillEntryCol.get(j);
                int t = dbCol.size();
                for (int k = 0; k < t; ++k) {
                    bfRecord = dbCol.get(k);
                    if (!reqBillEntry.getString("backFlushBillEntryId").equals(bfRecord.getSrcBillEntryId()) || tempSet.contains(key = reqBill.getId().toString() + reqBillEntry.getString("backFlushBillId"))) continue;
                    bfRelation.add(this.createBOTRelation(bfRecord.getSrcBillId(), reqBill.getId().toString()));
                    tempSet.add(key);
                }
            }
        }
        return bfRelation;
    }

    private BOTRelationInfo createBOTRelation(String srcBillId, String destBillId) {
        BOTRelationInfo relation = new BOTRelationInfo();
        relation.setId(BOSUuid.create((String)BOTRELATION_BOSTYPE));
        relation.setSrcEntityID(this.bfBillBosType);
        relation.setDestEntityID(MATERIALREQ_BOSTYPE);
        relation.setSrcObjectID(srcBillId);
        relation.setDestObjectID(destBillId);
        relation.setDate(new Date());
        relation.setOperatorID(this.ctx.getCaller().toString());
        relation.setIsEffected(true);
        relation.setBOTMappingID(null);
        relation.setType(0);
        return relation;
    }

    private IBFDataParser getBFDataParser() throws BOSException {
        return BFDataParserFactory.getParserInstance(this.ctx, this.bfBillBosType);
    }

    private void handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        CoreBillBaseInfo baseinfo = (CoreBillBaseInfo)collection.getObject(0);
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)baseinfo.getBOSType());
        ICoreBillBase iBillBase = (ICoreBillBase)obj;
        iBillBase.handleAfterTransform(action, collection);
    }
}

