/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.step.AbstractBFStep;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SaveMaterialReqStep
extends AbstractBFStep
implements IBFStep {
    private static final String FAILINFO_MATCHLOT = BackFlushUtil.getString("BACKFLUSH_REQBILLMATCHLOTFAIL");
    private static final String FAILINFO_SUBMIT = BackFlushUtil.getString("BACKFLUSH_REQBILLSUBMITFAIL");
    private CoreBaseCollection billCol = new CoreBaseCollection();
    private BOTRelationCollection botRelations = new BOTRelationCollection();

    @Override
    protected void innerExecute(BFCalcParam runParam) throws EASBizException, BOSException {
        IObjectCollection destBillCols = (IObjectCollection)runParam.getObject("ReqBillColletion");
        BOTRelationCollection relations = (BOTRelationCollection)runParam.getObject("RelationColletion");
        IObjectCollection bills = this.batchMatchLot(this.ctx, destBillCols, relations);
        List idList = this.innerSave(this.ctx, bills, relations);
        this.saveFailBill();
        List toDoIdList = BackFlushUtil.filterIdByStatus(this.ctx, idList, 2);
        runParam.setObject("ReqBillToDoIdList", toDoIdList);
    }

    private List innerSave(Context ctx, IObjectCollection destBillCols, BOTRelationCollection relations) throws BOSException, EASBizException {
        ArrayList<String> toDoIdList = new ArrayList<String>();
        if (destBillCols == null || destBillCols.size() == 0) {
            return toDoIdList;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[destBillCols.size()];
        Class[] parameTypes = new Class[]{IObjectValue.class, IObjectCollection.class};
        MaterialReqBillInfo reqBill = null;
        int n = destBillCols.size();
        for (int i = 0; i < n; ++i) {
            reqBill = (MaterialReqBillInfo)destBillCols.getObject(i);
            if (reqBill != null) {
                MaterialReqBillEntryCollection mrbeCol = reqBill.getEntry();
                for (int j = 0; mrbeCol != null && j < mrbeCol.size(); ++j) {
                    MaterialReqBillEntryInfo mrbeInfo = mrbeCol.get(j);
                    if (mrbeInfo == null || mrbeInfo.getUnit() == null || mrbeInfo.getBaseUnit() == null) continue;
                    if (mrbeInfo.getUnit().getId().toString().equals(mrbeInfo.getBaseUnit().getId().toString()) && mrbeInfo.getQty().compareTo(mrbeInfo.getBaseQty()) != 0) {
                        mrbeInfo.setBaseQty(mrbeInfo.getQty());
                    }
                    if (mrbeInfo.getQty() == null || SysConstant.BIGZERO.compareTo(mrbeInfo.getQty()) == 0 || mrbeInfo.getBaseQty() != null && mrbeInfo.getBaseQty().compareTo(SysConstant.BIGZERO) != 0) continue;
                    try {
                        mrbeInfo.setBaseQty(this.getUnitQty(mrbeInfo.getUnit(), mrbeInfo.getMaterial(), mrbeInfo.getQty()));
                        continue;
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                    }
                }
            }
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add((Object)reqBill);
            entries[i].add((Object)this.getBOTRelations(reqBill.getId().toString(), relations));
        }
        try {
            BatchExecuteResult result = BackFlushUtil.getMaterialReqBillInterface(ctx).batchExecute("submitInBatch", parameTypes, entries);
            int n2 = entries.length;
            for (int i = 0; i < n2; ++i) {
                reqBill = (MaterialReqBillInfo)entries[i].get(0);
                if (result.getException(i) != null) {
                    this.billCol.add((CoreBaseInfo)reqBill);
                    this.botRelations.addCollection((BOTRelationCollection)entries[i].get(1));
                    this.handleErrorResults(reqBill.getId().toString(), relations, FAILINFO_SUBMIT, result.getException(i).getMessage());
                    continue;
                }
                toDoIdList.add(reqBill.getId().toString());
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        return toDoIdList;
    }

    private IObjectCollection batchMatchLot(Context ctx, IObjectCollection destBillCols, BOTRelationCollection relations) throws BOSException, EASBizException {
        CoreBaseCollection returnBillCol = new CoreBaseCollection();
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[destBillCols.size()];
        Class[] parameTypes = new Class[]{InvBillBaseInfo.class};
        MaterialReqBillInfo reqBill = null;
        int n = destBillCols.size();
        for (int i = 0; i < n; ++i) {
            reqBill = (MaterialReqBillInfo)destBillCols.getObject(i);
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add((Object)reqBill);
        }
        try {
            BatchExecuteResult result = BackFlushUtil.getMaterialReqBillInterface(ctx).batchExecute("matchLotInfo", parameTypes, entries);
            int n2 = entries.length;
            for (int i = 0; i < n2; ++i) {
                if (result.getReturnValue(i) != null) {
                    returnBillCol.add((CoreBaseInfo)result.getReturnValue(i));
                    continue;
                }
                reqBill = (MaterialReqBillInfo)entries[i].get(0);
                this.billCol.add((CoreBaseInfo)reqBill);
                this.botRelations.addCollection(this.getBOTRelations(reqBill.getId().toString(), relations));
                this.handleErrorResults(reqBill.getId().toString(), relations, FAILINFO_MATCHLOT, result.getException(i).getMessage());
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        return returnBillCol;
    }

    private void saveFailBill() throws EASBizException, BOSException {
        if (this.billCol != null && this.botRelations != null && this.billCol.size() > 0 && this.botRelations.size() > 0) {
            MaterialReqBillInfo reqBill2 = null;
            for (MaterialReqBillInfo reqBill2 : this.billCol) {
                reqBill2.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                this.setBillNumber(this.ctx, reqBill2);
            }
            IObjectPK[] pks = BackFlushUtil.getMaterialReqBillInterface(this.ctx).addnewBatchData(this.billCol);
            BackFlushUtil.insertBOTRelation(this.ctx, this.botRelations);
        }
    }

    private BOTRelationCollection getBOTRelations(String destBillId, BOTRelationCollection relations) {
        BOTRelationCollection botRelations = new BOTRelationCollection();
        BOTRelationInfo botRelation2 = null;
        for (BOTRelationInfo botRelation2 : relations) {
            if (!botRelation2.getDestObjectID().equalsIgnoreCase(destBillId)) continue;
            botRelations.add(botRelation2);
        }
        return botRelations;
    }

    private void setBillNumber(Context ctx, MaterialReqBillInfo reqBill) throws EASBizException, BOSException {
        OrgUnitInfo org = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)reqBill);
        String number = MaterialReqBillFactory.getLocalInstance((Context)ctx).getNewNumber((IObjectValue)reqBill, org.getId().toString(), "");
        reqBill.setNumber(number);
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)OrgType.Storage);
    }

    private BigDecimal getUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00");
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(mui, mi);
        if (mulUnit != null && mi.getBaseUnit() != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mi.getBaseUnit().getQtyPrecision();
            if (coefficient != null) {
                baseQty = qty.multiply(coefficient).setScale(precision, 4);
            }
        }
        return baseQty;
    }

    private MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }
}

