/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.step.AbstractBFStep;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.List;

public class SubmitMaterialReqStep
extends AbstractBFStep
implements IBFStep {
    private static final String FAILINFO_MATCHLOT = BackFlushUtil.getString("BACKFLUSH_REQBILLMATCHLOTFAIL");
    private static final String FAILINFO_SUBMIT = BackFlushUtil.getString("BACKFLUSH_REQBILLSUBMITFAIL");

    @Override
    protected void innerExecute(BFCalcParam runParam) throws EASBizException, BOSException {
        IObjectCollection destBillCols = (IObjectCollection)runParam.getObject("ReqBillColletion");
        BOTRelationCollection relations = (BOTRelationCollection)runParam.getObject("RelationColletion");
        IObjectCollection bills = this.batchMatchLot(this.ctx, destBillCols, relations);
        List idList = this.innerSave(this.ctx, bills, relations);
        List toDoIdList = BackFlushUtil.filterIdByStatus(this.ctx, idList, 2);
        runParam.setObject("ReqBillToDoIdList", toDoIdList);
    }

    private List innerSave(Context ctx, IObjectCollection destBillCols, BOTRelationCollection relations) throws BOSException, EASBizException {
        ArrayList<String> toDoIdList = new ArrayList<String>();
        if (destBillCols == null || destBillCols.size() == 0) {
            return toDoIdList;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[destBillCols.size()];
        Class[] parameTypes = new Class[]{IObjectValue.class, IObjectCollection.class};
        MaterialReqBillInfo reqBill = null;
        int n = destBillCols.size();
        for (int i = 0; i < n; ++i) {
            reqBill = (MaterialReqBillInfo)destBillCols.getObject(i);
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add((Object)reqBill);
            entries[i].add((Object)this.getBOTRelations(reqBill.getId().toString(), relations));
        }
        try {
            ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
            BatchExecuteResult result = BackFlushUtil.getMaterialReqBillInterface(ctx).batchExecute("submitInBatch", parameTypes, entries);
            int n2 = entries.length;
            for (int i = 0; i < n2; ++i) {
                reqBill = (MaterialReqBillInfo)entries[i].get(0);
                if (result.getException(i) != null) {
                    this.handleErrorResults(reqBill.getId().toString(), relations, FAILINFO_SUBMIT, result.getException(i).getMessage());
                    continue;
                }
                toDoIdList.add(reqBill.getId().toString());
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        }
        return toDoIdList;
    }

    private IObjectCollection batchMatchLot(Context ctx, IObjectCollection destBillCols, BOTRelationCollection relations) throws BOSException, EASBizException {
        CoreBaseCollection returnBillCol = new CoreBaseCollection();
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[destBillCols.size()];
        Class[] parameTypes = new Class[]{InvBillBaseInfo.class};
        MaterialReqBillInfo reqBill = null;
        int n = destBillCols.size();
        for (int i = 0; i < n; ++i) {
            reqBill = (MaterialReqBillInfo)destBillCols.getObject(i);
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add((Object)reqBill);
        }
        try {
            BatchExecuteResult result = BackFlushUtil.getMaterialReqBillInterface(ctx).batchExecute("matchLotInfo", parameTypes, entries);
            int n2 = entries.length;
            for (int i = 0; i < n2; ++i) {
                if (result.getReturnValue(i) != null) {
                    returnBillCol.add((CoreBaseInfo)result.getReturnValue(i));
                    continue;
                }
                reqBill = (MaterialReqBillInfo)entries[i].get(0);
                this.handleErrorResults(reqBill.getId().toString(), relations, FAILINFO_MATCHLOT, result.getException(i).getMessage());
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        return returnBillCol;
    }

    private BOTRelationCollection getBOTRelations(String destBillId, BOTRelationCollection relations) {
        BOTRelationCollection botRelations = new BOTRelationCollection();
        BOTRelationInfo botRelation2 = null;
        for (BOTRelationInfo botRelation2 : relations) {
            if (!botRelation2.getDestObjectID().equalsIgnoreCase(destBillId) || botRelation2.getSrcEntityID().equalsIgnoreCase(this.bfBillBosType)) continue;
            botRelations.add(botRelation2);
        }
        return botRelations;
    }
}

